/*
 * Decompiled with CFR 0.152.
 */
package emu.fmgen;

import emu.fmgen.Channel4;
import emu.fmgen.OPNBase;

public class OPN
extends OPNBase {
    static final int FM_ISHIFT = 3;
    private int rcnt;
    private int[][] rbuf = new int[3][512];
    private int[] fnum = new int[3];
    private int[] fnum3 = new int[3];
    private int[] fnum2 = new int[6];
    private boolean interpolation;
    private String path;
    private Channel4[] ch = new Channel4[]{new Channel4(), new Channel4(), new Channel4()};

    public OPN() {
        this.SetVolumeFM(0);
        this.SetVolumePSG(0);
        this.csmch = this.ch[2];
        int i = 0;
        while (i < 3) {
            this.ch[i].SetChip(this.chip);
            this.ch[i].SetType(0);
            ++i;
        }
    }

    public boolean Init(int c, int r, boolean ip, String path) {
        this.path = path;
        if (!this.SetRate(c, r, ip)) {
            return false;
        }
        this.Reset();
        this.SetVolumeFM(0);
        this.SetVolumePSG(0);
        this.SetChannelMask(0);
        return true;
    }

    public boolean SetRate(int c, int r, boolean ip) {
        super.Init(c, r);
        this.interpolation = ip;
        this.RebuildTimeTable();
        return true;
    }

    @Override
    public void Reset() {
        int i = 32;
        while (i < 40) {
            this.SetReg(i, 0);
            ++i;
        }
        i = 48;
        while (i < 192) {
            this.SetReg(i, 0);
            ++i;
        }
        super.Reset();
        this.ch[0].Reset();
        this.ch[1].Reset();
        this.ch[2].Reset();
    }

    public int GetReg(int addr) {
        if (addr < 16) {
            return this.psg.GetReg(addr);
        }
        return 0;
    }

    public void SetReg(int addr, int data) {
        if (addr >= 256) {
            return;
        }
        int c = addr & 3;
        switch (addr) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                this.psg.SetReg(addr, data);
                break;
            }
            case 36: 
            case 37: {
                this.SetTimerA(addr, data);
                break;
            }
            case 38: {
                this.SetTimerB(data);
                break;
            }
            case 39: {
                this.SetTimerControl(data);
                break;
            }
            case 40: {
                if ((data & 3) >= 3) break;
                this.ch[data & 3].KeyControl(data >>> 4);
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                this.SetPrescaler(addr - 45);
                break;
            }
            case 160: 
            case 161: 
            case 162: {
                this.fnum[c] = data + this.fnum2[c] * 256;
                break;
            }
            case 164: 
            case 165: 
            case 166: {
                this.fnum2[c] = data;
                break;
            }
            case 168: 
            case 169: 
            case 170: {
                this.fnum3[c] = data + this.fnum2[c + 3] * 256;
                break;
            }
            case 172: 
            case 173: 
            case 174: {
                this.fnum2[c + 3] = data;
                break;
            }
            case 176: 
            case 177: 
            case 178: {
                this.ch[c].SetFB(data >>> 3 & 7);
                this.ch[c].SetAlgorithm(data & 7);
                break;
            }
            case 255: {
                this.TimerA();
                break;
            }
            default: {
                if (c >= 3) break;
                if ((addr & 0xF0) == 96) {
                    data &= 0x1F;
                }
                super.SetParameter(this.ch[c], addr, data);
            }
        }
    }

    @Override
    void SetStatus(int bits) {
        if ((this.status & bits) == 0) {
            this.status |= bits;
        }
    }

    @Override
    void ResetStatus(int bit) {
        this.status &= ~bit;
    }

    private void SetChannelMask(int mask) {
        int i = 0;
        while (i < 3) {
            this.ch[i].Mute((mask & 1 << i) != 0);
            ++i;
        }
        this.psg.SetChannelMask(mask >>> 6);
    }

    private int IStoSample(int s) {
        return (s > Short.MAX_VALUE ? Short.MAX_VALUE : (s < Short.MIN_VALUE ? Short.MIN_VALUE : s)) * this.fmvolume >> 14;
    }

    private void StoreSample(int[] dest, int didx, int data) {
        int value = dest[didx] + data;
        dest[didx] = value > Short.MAX_VALUE ? Short.MAX_VALUE : (value < Short.MIN_VALUE ? Short.MIN_VALUE : value);
    }

    public void Mix(int[] buffer, int nsamples) {
        this.psg.Mix(buffer, nsamples);
        this.ch[0].SetFNum(this.fnum[0]);
        this.ch[1].SetFNum(this.fnum[1]);
        if ((this.regtc & 0xC0) == 0) {
            this.ch[2].SetFNum(this.fnum[2]);
        } else {
            this.ch[2].op[0].SetFNum(this.fnum3[1]);
            this.ch[2].op[1].SetFNum(this.fnum3[2]);
            this.ch[2].op[2].SetFNum(this.fnum3[0]);
            this.ch[2].op[3].SetFNum(this.fnum[2]);
        }
        int actch = (this.ch[2].Prepare() << 2 | this.ch[1].Prepare()) << 2 | this.ch[0].Prepare();
        if ((actch & 0x15) != 0) {
            int limit = nsamples;
            int dest = 0;
            while (dest < limit) {
                int s = 0;
                int x = 0;
                int y = 0;
                int z = 0;
                if ((actch & 1) != 0) {
                    x = this.ch[0].Calc();
                }
                if ((actch & 4) != 0) {
                    y = this.ch[1].Calc();
                }
                if ((actch & 0x10) != 0) {
                    z = this.ch[2].Calc();
                }
                s = x + y + z;
                s = this.IStoSample(s);
                this.StoreSample(buffer, dest, s);
                this.rcnt = this.rcnt + 1 & 0x1FF;
                this.rbuf[0][this.rcnt] = x << 6;
                this.rbuf[1][this.rcnt] = y << 6;
                this.rbuf[2][this.rcnt] = z << 6;
                ++dest;
            }
        }
    }

    public void Mix2(int[] buffer, int nsamples, int vol_l, int vol_r) {
        this.psg.Mix2(buffer, nsamples, vol_l, vol_r);
        this.ch[0].SetFNum(this.fnum[0]);
        this.ch[1].SetFNum(this.fnum[1]);
        if ((this.regtc & 0xC0) == 0) {
            this.ch[2].SetFNum(this.fnum[2]);
        } else {
            this.ch[2].op[0].SetFNum(this.fnum3[1]);
            this.ch[2].op[1].SetFNum(this.fnum3[2]);
            this.ch[2].op[2].SetFNum(this.fnum3[0]);
            this.ch[2].op[3].SetFNum(this.fnum[2]);
        }
        int actch = (this.ch[2].Prepare() << 2 | this.ch[1].Prepare()) << 2 | this.ch[0].Prepare();
        if ((actch & 0x15) != 0) {
            int limit = nsamples * 2;
            int dest = 0;
            while (dest < limit) {
                int s = 0;
                int x = 0;
                int y = 0;
                int z = 0;
                if ((actch & 1) != 0) {
                    x = this.ch[0].Calc();
                }
                if ((actch & 4) != 0) {
                    y = this.ch[1].Calc();
                }
                if ((actch & 0x10) != 0) {
                    z = this.ch[2].Calc();
                }
                s = x + y + z;
                s = this.IStoSample(s);
                this.StoreSample(buffer, dest, s * vol_l >> 4);
                this.StoreSample(buffer, dest + 1, s * vol_r >> 4);
                this.rcnt = this.rcnt + 1 & 0x1FF;
                this.rbuf[0][this.rcnt] = x << 6;
                this.rbuf[1][this.rcnt] = y << 6;
                this.rbuf[2][this.rcnt] = z << 6;
                dest += 2;
            }
        }
    }

    public int[] rbuf(int ch) {
        return this.rbuf[ch];
    }
}

