/*
 * Decompiled with CFR 0.152.
 */
package emu.fmgen;

import emu.fmgen.Channel4;
import emu.fmgen.Chip;
import emu.fmgen.Operator;
import emu.fmgen.PSG;
import emu.fmgen.Timer;

abstract class OPNBase
extends Timer {
    int fmvolume;
    private int clock;
    private int rate;
    private int psgrate;
    int status;
    Channel4 csmch;
    private int[] lfotable = new int[8];
    private int prescale;
    Chip chip = new Chip();
    public PSG psg = new PSG();
    private final int[] slottable;
    private final int[] sltable;
    private final char[][] table;
    private final int[] table2;

    OPNBase() {
        int[] nArray = new int[4];
        nArray[1] = 2;
        nArray[2] = 1;
        nArray[3] = 3;
        this.slottable = nArray;
        int[] nArray2 = new int[16];
        nArray2[1] = 4;
        nArray2[2] = 8;
        nArray2[3] = 12;
        nArray2[4] = 16;
        nArray2[5] = 20;
        nArray2[6] = 24;
        nArray2[7] = 28;
        nArray2[8] = 32;
        nArray2[9] = 36;
        nArray2[10] = 40;
        nArray2[11] = 44;
        nArray2[12] = 48;
        nArray2[13] = 52;
        nArray2[14] = 56;
        nArray2[15] = 124;
        this.sltable = nArray2;
        this.table = new char[][]{{'\u0006', '\u0004'}, {'\u0003', '\u0002'}, {'\u0002', '\u0001'}};
        this.table2 = new int[]{108, 77, 71, 67, 62, 44, 8, 5};
        this.prescale = 0;
    }

    void SetParameter(Channel4 ch, int addr, int data) {
        if ((addr & 3) < 3) {
            int slot = this.slottable[addr >>> 2 & 3];
            Operator op = ch.op[slot];
            switch (addr >>> 4 & 0xF) {
                case 3: {
                    op.SetDT(data >>> 4 & 7);
                    op.SetMULTI(data & 0xF);
                    break;
                }
                case 4: {
                    op.SetTL(data & 0x7F, (this.regtc & 0x80) != 0 && this.csmch == ch);
                    break;
                }
                case 5: {
                    op.SetKS(data >>> 6 & 3);
                    op.SetAR((data & 0x1F) * 2);
                    break;
                }
                case 6: {
                    op.SetDR((data & 0x1F) * 2);
                    op.SetAMON((data & 0x80) != 0);
                    break;
                }
                case 7: {
                    op.SetSR((data & 0x1F) * 2);
                    break;
                }
                case 8: {
                    op.SetSL(this.sltable[data >>> 4 & 0xF]);
                    op.SetRR((data & 0xF) * 4 + 2);
                    break;
                }
                case 9: {
                    op.SetSSGEC(data & 0xF);
                }
            }
        }
    }

    @Override
    void Reset() {
        this.status = 0;
        this.SetPrescaler(0);
        super.Reset();
        this.psg.Reset();
    }

    void SetPrescaler(int p) {
        if (this.prescale != p) {
            this.prescale = p;
            int fmclock = this.clock / this.table[p][0] / 12;
            this.rate = this.psgrate;
            int ratio = ((fmclock << 7) + this.rate / 2) / this.rate;
            this.SetTimerBase(fmclock);
            this.chip.SetRatio(ratio);
            this.psg.SetClock(this.clock / this.table[p][1], this.psgrate);
            int i = 0;
            while (i < 8) {
                this.lfotable[i] = (ratio << 9) / this.table2[i];
                ++i;
            }
        }
    }

    boolean Init(int c, int r) {
        this.clock = c;
        this.psgrate = r;
        return true;
    }

    void SetVolumeFM(int db) {
        this.fmvolume = (db = Math.min(db, 20)) > -192 ? (int)(16384.0 * Math.pow(10.0, (double)db / 40.0)) : 0;
    }

    @Override
    void TimerA() {
        if ((this.regtc & 0x80) != 0) {
            this.csmch.KeyControl(0);
            this.csmch.KeyControl(15);
        }
    }

    void RebuildTimeTable() {
        int p = this.prescale;
        this.prescale = -1;
        this.SetPrescaler(p);
    }

    void SetVolumePSG(int db) {
        this.psg.SetVolume(db);
    }
}

