/*
 * Decompiled with CFR 0.152.
 */
package emu.fmgen;

abstract class Timer {
    int regtc;
    private int[] regta = new int[2];
    private int timera;
    private int timera_count;
    private int timerb;
    private int timerb_count;
    private int timer_step;

    Timer() {
    }

    void Reset() {
        this.timera_count = 0;
        this.timerb_count = 0;
    }

    void SetTimerControl(int data) {
        int tmp = this.regtc ^ data;
        this.regtc = data;
        if ((data & 0x10) != 0) {
            this.ResetStatus(1);
        }
        if ((data & 0x20) != 0) {
            this.ResetStatus(2);
        }
        if ((tmp & 1) != 0) {
            int n = this.timera_count = (data & 1) != 0 ? this.timera : 0;
        }
        if ((tmp & 2) != 0) {
            this.timerb_count = (data & 2) != 0 ? this.timerb : 0;
        }
    }

    void SetTimerA(int addr, int data) {
        this.regta[addr & 1] = data;
        int tmp = (this.regta[0] << 2) + (this.regta[1] & 3);
        this.timera = (1024 - tmp) * this.timer_step;
    }

    void SetTimerB(int data) {
        this.timerb = (256 - data) * this.timer_step;
    }

    void SetTimerBase(int clock) {
        this.timer_step = (int)(6.5536E10 / (double)clock);
    }

    abstract void SetStatus(int var1);

    abstract void ResetStatus(int var1);

    abstract void TimerA();
}

