/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.Sys_util;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class File {
    public static final boolean load(String fname, int[] buf, int size) {
        return File.load(fname, buf, 0, size);
    }

    public static final boolean load(String fname, byte[] buf, int size) {
        return File.load(fname, buf, 0, size);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean load(String fname, int[] buf, int offset, int size) {
        boolean ret = true;
        java.io.File infile = null;
        FileInputStream in = null;
        try {
            infile = new java.io.File(String.valueOf(Sys_util.ROM) + Sys_util.SEP + fname);
            if (!infile.exists() && !(infile = new java.io.File(String.valueOf(Sys_util.ROM) + Sys_util.SEP + fname.toLowerCase())).exists()) {
                return false;
            }
            in = new FileInputStream(infile);
            boolean flag = true;
            int i = 0;
            while (flag) {
                if (i >= size) {
                    return ret;
                }
                int b = in.read();
                if (b != -1) {
                    buf[offset + i] = b;
                    ++i;
                    continue;
                }
                flag = false;
            }
            return ret;
        }
        catch (FileNotFoundException e) {
            ret = false;
            return ret;
        }
        catch (IOException e) {
            ret = false;
            return ret;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean load(String fname, byte[] buf, int offset, int size) {
        boolean ret = true;
        java.io.File infile = null;
        FileInputStream in = null;
        try {
            infile = new java.io.File(String.valueOf(Sys_util.ROM) + Sys_util.SEP + fname);
            if (!infile.exists() && !(infile = new java.io.File(String.valueOf(Sys_util.ROM) + Sys_util.SEP + fname.toLowerCase())).exists()) {
                return false;
            }
            in = new FileInputStream(infile);
            boolean flag = true;
            int i = 0;
            while (flag) {
                if (i >= size) {
                    return ret;
                }
                int b = in.read();
                if (b != -1) {
                    buf[offset + i] = (byte)b;
                    ++i;
                    continue;
                }
                flag = false;
            }
            return ret;
        }
        catch (FileNotFoundException e) {
            ret = false;
            return ret;
        }
        catch (IOException e) {
            ret = false;
            return ret;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static final boolean save(String fname, int[] buf, int size) {
        boolean ret = true;
        FileOutputStream in = null;
        try {
            try {
                in = new FileOutputStream(String.valueOf(Sys_util.ROM) + Sys_util.SEP + fname);
                int i = 0;
                while (i < size) {
                    in.write(buf[i]);
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                ret = false;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                ret = false;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static final boolean save(String fname, byte[] buf, int size) {
        boolean ret = true;
        FileOutputStream in = null;
        try {
            try {
                in = new FileOutputStream(String.valueOf(Sys_util.ROM) + Sys_util.SEP + fname);
                int i = 0;
                while (i < size) {
                    in.write(buf[i] & 0xFF);
                    ++i;
                }
            }
            catch (FileNotFoundException e) {
                ret = false;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
            catch (IOException e) {
                ret = false;
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }

    public static final RandomAccessFile open(String fname, int mode) {
        return File.open(fname, mode, false);
    }

    public static final RandomAccessFile open(String fname, int mode, boolean newflag) {
        RandomAccessFile rf = null;
        try {
            switch (mode) {
                case 1: {
                    return new RandomAccessFile(fname, "r");
                }
                case 2: 
                case 3: {
                    rf = new RandomAccessFile(fname, "rw");
                    if (newflag) {
                        File.setsize(rf, 0L);
                    }
                    return rf;
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public static final void close(RandomAccessFile handle) {
        try {
            handle.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final int getsize(RandomAccessFile handle) {
        try {
            return (int)handle.length();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public static final void setsize(RandomAccessFile handle, long size) {
        try {
            handle.setLength(size);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final boolean seek(RandomAccessFile handle, int offset) {
        block3: {
            try {
                if (offset >= 0 && (long)offset < handle.length()) break block3;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        handle.seek(offset);
        return true;
    }

    public static final byte readByte(RandomAccessFile handle) throws IOException {
        byte dat = handle.readByte();
        return dat;
    }

    public static final void writeByte(RandomAccessFile handle, byte dat) throws IOException {
        handle.writeByte(dat);
    }

    public static final boolean read(RandomAccessFile handle, byte[] dat, int size) {
        return File.read(handle, dat, 0, size);
    }

    public static final boolean read(RandomAccessFile handle, byte[] dat, int offset, int size) {
        byte tmp = 0;
        try {
            int i = 0;
            while (i < size) {
                dat[i + offset] = tmp = File.readByte(handle);
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean read(RandomAccessFile handle, int[] dat, int size) {
        return File.read(handle, dat, 0, size);
    }

    public static final boolean read(RandomAccessFile handle, int[] dat, int offset, int size) {
        byte tmp = 0;
        try {
            int i = 0;
            while (i < size) {
                tmp = File.readByte(handle);
                dat[i + offset] = tmp & 0xFF;
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean write(RandomAccessFile handle, byte[] dat, int size) {
        return File.write(handle, dat, 0, size);
    }

    public static final boolean write(RandomAccessFile handle, byte[] dat, int offset, int size) {
        try {
            int i = 0;
            while (i < size) {
                File.writeByte(handle, dat[i + offset]);
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean write(RandomAccessFile handle, int dat) {
        return File.byte_write(handle, dat);
    }

    public static final boolean write(RandomAccessFile handle, int[] dat, int size) {
        return File.write(handle, dat, 0, size);
    }

    public static final boolean write(RandomAccessFile handle, int[] dat, int offset, int size) {
        try {
            int i = 0;
            while (i < size) {
                File.writeByte(handle, (byte)dat[i + offset]);
                ++i;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static final boolean byte_read(RandomAccessFile fileh, int[] dat) {
        try {
            dat[0] = File.readByte(fileh);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final int byte_read(RandomAccessFile fileh) throws IOException {
        return File.readByte(fileh);
    }

    public static final int word_read(RandomAccessFile fileh) throws IOException {
        byte msb = File.readByte(fileh);
        byte lsb = File.readByte(fileh);
        return msb << 8 & 0xFF00 | lsb & 0xFF;
    }

    public static final int word_read_le(RandomAccessFile fileh) throws IOException {
        byte lsb = File.readByte(fileh);
        byte msb = File.readByte(fileh);
        return msb << 8 & 0xFF00 | lsb & 0xFF;
    }

    public static final int dword_read(RandomAccessFile fileh) throws IOException {
        byte tmp = File.readByte(fileh);
        int dat = tmp & 0xFF;
        tmp = File.readByte(fileh);
        dat = dat << 8 & 0xFF00;
        dat |= tmp & 0xFF;
        tmp = File.readByte(fileh);
        dat = dat << 8 & 0xFFFF00;
        dat |= tmp & 0xFF;
        tmp = File.readByte(fileh);
        dat = dat << 8 & 0xFFFFFF00;
        return dat |= tmp & 0xFF;
    }

    public static final int dword_read_le(RandomAccessFile fileh) throws IOException {
        byte tmp = File.readByte(fileh);
        int dat = tmp & 0xFF;
        tmp = File.readByte(fileh);
        dat |= tmp << 8 & 0xFF00;
        tmp = File.readByte(fileh);
        dat |= tmp << 16 & 0xFF0000;
        tmp = File.readByte(fileh);
        return dat |= tmp << 24 & 0xFF000000;
    }

    public static final boolean bool_read(RandomAccessFile fileh) throws IOException {
        byte tmp = File.readByte(fileh);
        switch (tmp & 0xFF) {
            case 0: {
                return false;
            }
            case 255: {
                return true;
            }
        }
        return false;
    }

    public static final boolean byte_write(RandomAccessFile fileh, int dat) {
        try {
            File.writeByte(fileh, (byte)(dat & 0xFF));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final boolean word_write(RandomAccessFile fileh, int dat) {
        try {
            File.writeByte(fileh, (byte)(dat >> 8));
            File.writeByte(fileh, (byte)(dat & 0xFF));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final boolean word_write_le(RandomAccessFile fileh, int dat) {
        try {
            File.writeByte(fileh, (byte)(dat & 0xFF));
            File.writeByte(fileh, (byte)(dat >> 8));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final boolean dword_write(RandomAccessFile fileh, int dat) {
        try {
            File.writeByte(fileh, (byte)(dat >> 24));
            File.writeByte(fileh, (byte)(dat >> 16));
            File.writeByte(fileh, (byte)(dat >> 8));
            File.writeByte(fileh, (byte)(dat & 0xFF));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final boolean dword_write_le(RandomAccessFile fileh, int dat) {
        try {
            File.writeByte(fileh, (byte)(dat & 0xFF));
            File.writeByte(fileh, (byte)(dat >> 8));
            File.writeByte(fileh, (byte)(dat >> 16));
            File.writeByte(fileh, (byte)(dat >> 24));
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static final boolean bool_write(RandomAccessFile fileh, boolean dat) {
        try {
            if (dat) {
                File.writeByte(fileh, (byte)-1);
            } else {
                File.writeByte(fileh, (byte)0);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

