/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.LowLbl;
import emu.xm7.sys.Sys_main;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class FlpInd
extends LowLbl
implements DropTargetListener {
    private static final long serialVersionUID = 1L;
    private Sys_main sysmain;
    private int drive;
    private int fdc_access;
    private FlpIcon icon = new FlpIcon();
    private final String EMPTY = "";

    FlpInd(Sys_main sysmain, int drive) {
        super("", Color.black, Color.lightGray);
        this.sysmain = sysmain;
        this.drive = drive;
        this.setIcon(this.icon);
        this.setDropTarget(new DropTarget(this, this));
        this.addMouseListener(new IndicatorListener());
        this.setPreferredSize(new Dimension(144, 16));
        this.setHorizontalAlignment(2);
    }

    void updateInd() {
        if (this.fdc_access != this.sysmain.vm.fdc.fdc_access[this.drive]) {
            this.repaint();
            this.fdc_access = this.sysmain.vm.fdc.fdc_access[this.drive];
        }
    }

    void setFlp() {
        String medianame = null;
        if (this.sysmain.vm.fdc.fdc_ready[this.drive] == 2) {
            medianame = this.sysmain.vm.fdc.fdc_name[this.drive][this.sysmain.vm.fdc.fdc_media[this.drive]];
        }
        if (this.sysmain.vm.fdc.fdc_ready[this.drive] == 1) {
            medianame = "2D DISK";
        }
        if (this.sysmain.vm.fdc.fdc_ready[this.drive] == 3) {
            medianame = "VFD DISK";
        }
        if (medianame != null) {
            this.setText(medianame);
        } else {
            this.setText("");
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            try {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                File f = (File)files.get(0);
                this.sysmain.vm.fdc.fdc_setdisk(this.drive, f.getAbsolutePath());
                this.sysmain.sys_cmd.resetDriveMenu(this.drive);
                e.dropComplete(true);
            }
            catch (Exception ex) {
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private class FlpIcon
    implements Icon {
        ImageIcon imgBlank = null;
        ImageIcon imgInsert = null;
        int width = 0;
        int height = 0;

        FlpIcon() {
            URL url = null;
            url = ClassLoader.getSystemClassLoader().getResource("emu/xm7/sys/FLP_EMP.gif");
            if (url != null) {
                this.imgBlank = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
            }
            if ((url = ClassLoader.getSystemClassLoader().getResource("emu/xm7/sys/FLP_INS.gif")) != null) {
                this.imgInsert = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
            }
            if (this.imgInsert != null) {
                this.width = this.imgInsert.getIconWidth();
                this.height = this.imgInsert.getIconHeight();
            }
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (((FlpInd)FlpInd.this).sysmain.vm.fdc.fdc_ready[FlpInd.this.drive] != 0) {
                this.imgInsert.paintIcon(c, g, x, y);
            } else {
                this.imgBlank.paintIcon(c, g, x, y);
            }
            if (((FlpInd)FlpInd.this).sysmain.vm.fdc.fdc_access[FlpInd.this.drive] != 0) {
                g.setColor(Color.red);
            } else {
                g.setColor(Color.darkGray);
            }
            g.fillRect(x + 10, y + 12, 6, 2);
        }
    }

    private class IndicatorListener
    implements MouseListener {
        private IndicatorListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ((FlpInd)FlpInd.this).sysmain.sys_cmd.onDisk(FlpInd.this.drive);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }
}

