/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.Sys_main;
import emu.xm7.vm.System;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class OpnDisp
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JFrame window = null;
    private int nOPNDisp;
    private int[] knOPNDisp = new int[18];
    private int[] ktOPNDisp = new int[18];
    private String[][] cnOPNDisp = new String[4][18];
    private String[][] ctOPNDisp = new String[4][18];
    private int[] lnOPNDisp = new int[18];
    private int[] ltOPNDisp = new int[18];
    private final Font fntOONDisp = new Font("monospaced", 0, 9);
    private Sys_main sysmain;
    private System vm;
    private Image bImage = null;
    private final Color[] rgbOPNDisp = new Color[]{new Color(0, 0, 0), new Color(0, 0, 255), new Color(255, 0, 0), new Color(255, 0, 255), new Color(0, 255, 0), new Color(0, 255, 255), new Color(255, 255, 0), new Color(255, 255, 255), new Color(63, 63, 63), new Color(0, 191, 255), new Color(255, 223, 0), new Color(127, 175, 0), new Color(255, 159, 191), new Color(63, 255, 159), new Color(191, 191, 0), new Color(207, 207, 207)};
    private final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final int[] x_table;
    private final int[] type_table;
    private final int[] cx_table;
    private final double[] pitch_table;

    public static OpnDisp createWindow(Sys_main sysmain, System vm) {
        Image image;
        JFrame window = new JFrame("FM\u97f3\u6e90\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4");
        URL url = ClassLoader.getSystemClassLoader().getResource("emu/xm7/sys/XM7.gif");
        if (url != null && (image = Toolkit.getDefaultToolkit().getImage(url)) != null) {
            window.setIconImage(image);
        }
        window.setBackground(Color.black);
        window.setForeground(Color.white);
        OpnDisp opnd = new OpnDisp(sysmain, vm);
        window.getContentPane().add(opnd);
        window.setVisible(true);
        window.pack();
        opnd.init();
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        window.setLocation((d.width - window.getWidth()) / 2, (d.height - window.getHeight()) / 2);
        opnd.window = window;
        return opnd;
    }

    private OpnDisp(Sys_main sysmain, System vm) {
        int[] nArray = new int[12];
        nArray[1] = 4;
        nArray[2] = 6;
        nArray[3] = 10;
        nArray[4] = 12;
        nArray[5] = 18;
        nArray[6] = 22;
        nArray[7] = 24;
        nArray[8] = 28;
        nArray[9] = 30;
        nArray[10] = 34;
        nArray[11] = 36;
        this.x_table = nArray;
        int[] nArray2 = new int[12];
        nArray2[1] = 3;
        nArray2[2] = 1;
        nArray2[3] = 3;
        nArray2[4] = 2;
        nArray2[6] = 3;
        nArray2[7] = 1;
        nArray2[8] = 3;
        nArray2[9] = 1;
        nArray2[10] = 3;
        nArray2[11] = 2;
        this.type_table = nArray2;
        int[] nArray3 = new int[5];
        nArray3[1] = 48;
        nArray3[2] = 112;
        nArray3[3] = 160;
        nArray3[4] = 236;
        this.cx_table = nArray3;
        this.pitch_table = new double[]{31.772, 33.661, 35.663, 37.784, 40.03, 42.411, 44.933, 47.605, 50.435, 53.434, 56.612, 59.978, 63.544, 67.323, 71.326, 75.567, 80.061, 84.822, 89.865, 95.209, 100.87, 106.869, 113.223, 119.956, 127.089, 134.646, 142.652, 151.135, 160.122, 169.643, 179.731, 190.418, 201.741, 213.737, 226.446, 239.912, 254.178, 269.292, 285.305, 302.27, 320.244, 339.287, 359.461, 380.836, 403.482, 427.474, 452.893, 479.823, 508.356, 538.584, 570.61, 604.54, 640.488, 678.573, 718.923, 761.672, 806.964, 854.948, 905.786, 959.647, 1016.711, 1077.168, 1141.22, 1209.08, 1280.975, 1357.146, 1437.846, 1523.345, 1613.927, 1709.896, 1811.572, 1919.293, 2033.422, 2154.336, 2282.439, 2418.16, 2561.951, 2714.292, 2875.692, 3046.689, 3227.855, 3419.792, 3623.144, 3838.587, 4066.845, 4308.672, 4564.878, 4836.319, 5123.901, 5428.584, 5751.384, 6093.378, 6455.709, 6839.585, 7246.287, 7677.173, 8133.681};
        this.sysmain = sysmain;
        this.vm = vm;
        this.setBackground(Color.black);
        this.setForeground(Color.white);
        this.setPreferredSize(new Dimension(336, this.getPreferredHeight()));
    }

    public void resize() {
        if (this.getHeight() != this.getPreferredHeight()) {
            this.init();
            this.revalidate();
            this.window.pack();
        }
    }

    private int getPreferredHeight() {
        int uMode = 0;
        int n = 6;
        if (this.vm.whg.whg_use) {
            uMode = 1;
            n = 12;
        }
        if (this.vm.thg.thg_use) {
            uMode = 2;
            n = 18;
        }
        if (uMode < 2 && this.vm.fm7_ver == 1) {
            uMode |= 8;
            n += 3;
        }
        this.nOPNDisp = uMode;
        int ys = (this.nOPNDisp & 7) == 2 ? 21 : 25;
        return ys * n;
    }

    private String toHexStr(int value, int figure, boolean zero) {
        char[] buf = new char[5];
        int charPos = 5;
        buf[--charPos] = this.digits[value & 0xF];
        value >>>= 4;
        --figure;
        do {
            buf[--charPos] = this.digits[value & 0xF];
            if (!zero && value == 0) {
                buf[charPos] = 32;
            }
            value >>>= 4;
        } while (--figure > 0);
        return new String(buf, charPos, 5 - charPos);
    }

    private String toDecStr(int value, int figure, boolean zero) {
        char[] buf = new char[4];
        int charPos = 4;
        buf[--charPos] = this.digits[value % 10];
        value /= 10;
        --figure;
        do {
            buf[--charPos] = this.digits[value % 10];
            if (!zero && value == 0) {
                buf[charPos] = 32;
            }
            value /= 10;
        } while (--figure > 0);
        return new String(buf, charPos, 4 - charPos);
    }

    private void LineOPNDisp(Graphics g, int x, int y, int width, int height, int color) {
        g.setColor(this.rgbOPNDisp[color]);
        g.drawLine(x, y, x + width, y + height);
    }

    private void BfOPNDisp(Graphics g, int x, int y, int cx, int cy, int color) {
        g.setColor(this.rgbOPNDisp[color]);
        g.fillRect(x, y, cx, cy);
    }

    private void StrOPNDisp(Graphics g, String s, int x, int y, int color) {
        char[] c = s.toCharArray();
        int i = 0;
        while (i < c.length) {
            this.ChrOPNDisp(g, c[i], x + i * 8, y, color);
            ++i;
        }
    }

    private void ChrOPNDisp(Graphics g, char c, int x, int y, int color) {
        byte[] pa = this.vm.submem.subrom_c;
        int pi = c * 8;
        int i = 0;
        while (i < 8) {
            byte dat = pa[pi];
            ++pi;
            int j = 0;
            while (j < 8) {
                if ((dat & 0x80) != 0) {
                    g.setColor(this.rgbOPNDisp[color]);
                } else {
                    g.setColor(this.rgbOPNDisp[0]);
                }
                g.drawLine(x, y, x, y);
                dat = (byte)(dat << 1);
                ++x;
                ++j;
            }
            x -= 8;
            ++y;
            ++i;
        }
    }

    private void KbdOPNDisp(Graphics g, int code, int x, int y, int color) {
        int ys = (this.nOPNDisp & 7) == 2 ? 6 : 8;
        x = (code >> 4) * 42;
        x += this.x_table[code &= 0xF];
        if (color < 0) {
            color = this.type_table[code] < 3 ? 15 : 8;
        }
        switch (this.type_table[code]) {
            case 0: {
                this.LineOPNDisp(g, x, y, 0, ys * 2 - 1, 0);
                this.BfOPNDisp(g, x + 1, y, 3, ys, color);
                this.BfOPNDisp(g, x + 1, y + ys, 5, ys, color);
                break;
            }
            case 1: {
                this.LineOPNDisp(g, x, y + ys, 0, ys - 1, 0);
                this.BfOPNDisp(g, x + 3, y, 1, ys, color);
                this.BfOPNDisp(g, x + 1, y + ys, 5, ys, color);
                break;
            }
            case 2: {
                this.LineOPNDisp(g, x, y + ys, 0, ys - 1, 0);
                this.BfOPNDisp(g, x + 3, y, 3, ys, color);
                this.BfOPNDisp(g, x + 1, y + ys, 5, ys, color);
                break;
            }
            case 3: {
                this.BfOPNDisp(g, x, y, 5, ys, color);
            }
        }
    }

    private void AllKbdOPNDisp(Graphics g, int x, int y) {
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 12) {
                this.KbdOPNDisp(g, i * 16 + j, x, y, -1);
                ++j;
            }
            ++i;
        }
    }

    private void SetupOPNDisp(Graphics g) {
        int j;
        int n = ((this.nOPNDisp & 7) + 1) * 6;
        if ((this.nOPNDisp & 8) != 0) {
            n += 3;
        }
        int ys = (this.nOPNDisp & 7) == 2 ? 21 : 25;
        int y = 0;
        int i = 0;
        while (i < n) {
            j = 0;
            while (j < 4) {
                if (!this.ctOPNDisp[j][i].equals(this.cnOPNDisp[j][i])) {
                    int color = 12;
                    if (j == 0) {
                        color = 7;
                    }
                    this.StrOPNDisp(g, this.ctOPNDisp[j][i], this.cx_table[j], y, color);
                    this.cnOPNDisp[j][i] = this.ctOPNDisp[j][i];
                }
                ++j;
            }
            y += ys;
            ++i;
        }
        y = 8;
        i = 0;
        while (i < n) {
            if (this.knOPNDisp[i] == -2) {
                this.AllKbdOPNDisp(g, 0, y);
                this.knOPNDisp[i] = -1;
            }
            if (this.knOPNDisp[i] != this.ktOPNDisp[i]) {
                if (this.knOPNDisp[i] >= 0) {
                    this.KbdOPNDisp(g, this.knOPNDisp[i], 0, y, -1);
                }
                if (this.ktOPNDisp[i] >= 0) {
                    if ((this.nOPNDisp & 8) != 0 && i >= ((this.nOPNDisp & 7) + 1) * 6) {
                        this.KbdOPNDisp(g, this.ktOPNDisp[i], 0, y, 13);
                    } else if (i % 6 < 3) {
                        this.KbdOPNDisp(g, this.ktOPNDisp[i], 0, y, 10);
                    } else {
                        this.KbdOPNDisp(g, this.ktOPNDisp[i], 0, y, 9);
                    }
                }
                this.knOPNDisp[i] = this.ktOPNDisp[i];
            }
            y += ys;
            ++i;
        }
        y = 0;
        i = 0;
        while (i < n) {
            if (this.lnOPNDisp[i] != this.ltOPNDisp[i]) {
                if (this.ltOPNDisp[i] >= 500) {
                    this.ltOPNDisp[i] = 499;
                } else if (this.ltOPNDisp[i] < 0) {
                    this.ltOPNDisp[i] = 0;
                }
                j = 100 * this.ltOPNDisp[i];
                this.BfOPNDisp(g, 236, y, j /= 500, 7, 11);
                this.BfOPNDisp(g, 236 + j, y, 100 - j, 7, 0);
                this.lnOPNDisp[i] = this.ltOPNDisp[i];
            }
            y += ys;
            ++i;
        }
    }

    private int ConvOPNDisp(double freq) {
        if (freq < this.pitch_table[0]) {
            return -1;
        }
        if (this.pitch_table[96] <= freq) {
            return -1;
        }
        int ret = -1;
        int i = 0;
        while (i < 96) {
            if (this.pitch_table[i] <= freq && freq < this.pitch_table[i + 1]) {
                ret = i / 12;
                ret <<= 4;
                ret += i % 12;
                break;
            }
            ++i;
        }
        return ret;
    }

    private int FMConvOPNDisp(int a4, int a0, int scale) {
        int oct = a4;
        oct >>= 3;
        int fnum = a4;
        fnum &= 7;
        fnum <<= 8;
        fnum |= a0;
        double freq = 1.2288;
        freq *= 1000000.0;
        while (oct != 0) {
            freq *= 2.0;
            --oct;
        }
        freq *= (double)fnum;
        double d = 1048576.0;
        d *= 12.0;
        return this.ConvOPNDisp(freq /= (d *= (double)scale));
    }

    private int PSGConvOPNDisp(int low, int high, int scale) {
        int pitch = high;
        pitch &= 0xF;
        pitch <<= 8;
        double freq = 1.2288;
        freq *= 1000000.0;
        double d = 8.0;
        d *= (double)(pitch |= low);
        switch (scale) {
            case 3: {
                d *= 2.0;
                break;
            }
            case 6: {
                d *= 4.0;
                break;
            }
            case 2: {
                d *= 1.0;
            }
        }
        freq = d == 0.0 ? 0.0 : (freq /= d);
        return this.ConvOPNDisp(freq);
    }

    private void StatKbdOPNDisp() {
        int tmp = this.nOPNDisp == 8 ? 6 : (this.nOPNDisp == 9 ? 12 : (this.nOPNDisp == 2 ? 15 : 0));
        int i = 0;
        while (i < 3) {
            this.ktOPNDisp[i + 0] = !this.vm.opn.opn_key[i] ? -1 : this.FMConvOPNDisp(this.vm.opn.opn_reg[164 + i], this.vm.opn.opn_reg[160 + i], this.vm.opn.opn_scale);
            if ((this.nOPNDisp & 7) >= 1) {
                this.ktOPNDisp[i + 6] = !this.vm.whg.whg_key[i] ? -1 : this.FMConvOPNDisp(this.vm.whg.whg_reg[164 + i], this.vm.whg.whg_reg[160 + i], this.vm.whg.whg_scale);
            }
            if ((this.nOPNDisp & 7) >= 2) {
                this.ktOPNDisp[i + 12] = !this.vm.thg.thg_key[i] ? -1 : this.FMConvOPNDisp(this.vm.thg.thg_reg[164 + i], this.vm.thg.thg_reg[160 + i], this.vm.thg.thg_scale);
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            this.ktOPNDisp[i + 3] = this.ltOPNDisp[i + 3] > 0 ? this.PSGConvOPNDisp(this.vm.opn.opn_reg[i * 2 + 0], this.vm.opn.opn_reg[i * 2 + 1], this.vm.opn.opn_scale) : -1;
            if ((this.nOPNDisp & 7) >= 1) {
                this.ktOPNDisp[i + 9] = this.ltOPNDisp[i + 9] > 0 ? this.PSGConvOPNDisp(this.vm.whg.whg_reg[i * 2 + 0], this.vm.whg.whg_reg[i * 2 + 1], this.vm.whg.whg_scale) : -1;
            }
            if (tmp > 0) {
                this.ktOPNDisp[i + tmp] = this.ltOPNDisp[i + tmp] > 0 ? this.PSGConvOPNDisp(this.vm.thg.thg_reg[i * 2 + 0], this.vm.thg.thg_reg[i * 2 + 1], this.vm.thg.thg_scale) : -1;
            }
            ++i;
        }
    }

    private void StatLevOPNDisp() {
        block10: {
            int i;
            block9: {
                i = 0;
                while (i < 18) {
                    this.ltOPNDisp[i] = this.sysmain.sys_snd.GetLevelSnd(i);
                    ++i;
                }
                int m = this.vm.opn.opn_reg[7];
                int p = 9;
                i = 0;
                while (i < 3) {
                    if ((m & p) == p) {
                        this.ltOPNDisp[i + 0 + 3] = 0;
                    }
                    p <<= 1;
                    ++i;
                }
                m = this.vm.whg.whg_reg[7];
                p = 9;
                i = 0;
                while (i < 3) {
                    if ((m & p) == p) {
                        this.ltOPNDisp[i + 6 + 3] = 0;
                    }
                    p <<= 1;
                    ++i;
                }
                m = this.vm.thg.thg_reg[7];
                p = 9;
                i = 0;
                while (i < 3) {
                    if ((m & p) == p) {
                        this.ltOPNDisp[i + 12 + 3] = 0;
                    }
                    p <<= 1;
                    ++i;
                }
                if (this.nOPNDisp != 8) break block9;
                i = 0;
                while (i < 3) {
                    this.ltOPNDisp[i + 6] = this.ltOPNDisp[i + 15];
                    ++i;
                }
                break block10;
            }
            if (this.nOPNDisp != 9) break block10;
            i = 0;
            while (i < 3) {
                this.ltOPNDisp[i + 12] = this.ltOPNDisp[i + 15];
                ++i;
            }
        }
    }

    private void StrOPNDisp(String string, int x, int y) {
        this.ctOPNDisp[x][y] = string;
    }

    private void StatChrOPNDisp() {
        int[] cslot = new int[]{2, 3, 3, 4};
        int n = ((this.nOPNDisp & 7) + 1) * 6;
        if ((this.nOPNDisp & 8) != 0) {
            n += 3;
        }
        int[] reg = this.vm.opn.opn_reg;
        boolean[] key = this.vm.opn.opn_key;
        int i = 0;
        while (i < n) {
            int j;
            String string;
            if (i == 6 && this.nOPNDisp != 8) {
                reg = this.vm.whg.whg_reg;
                key = this.vm.whg.whg_key;
            }
            if (i == 12 || this.nOPNDisp == 8 && i == 6) {
                reg = this.vm.thg.thg_reg;
                key = this.vm.thg.thg_key;
            }
            boolean fm_flag = i % 6 < 3;
            if (i < 6) {
                string = "OPN" + (i % 6 + 1);
            } else {
                string = i < 12 ? "WHG" + (i % 6 + 1) : "THG" + (i % 6 + 1);
                if ((this.nOPNDisp & 8) != 0 && i >= ((this.nOPNDisp & 7) + 1) * 6) {
                    fm_flag = false;
                    string = "PSG" + (i % 6 + 1);
                }
            }
            this.StrOPNDisp(string, 0, i);
            if (fm_flag) {
                j = reg[164 + i % 3];
                j <<= 8;
                string = "F:$" + this.toHexStr(j |= reg[160 + i % 3], 4, true);
            } else {
                j = reg[i % 3 * 2 + 1];
                j &= 0xF;
                j <<= 8;
                string = "P:$" + this.toHexStr(j |= reg[i % 3 * 2 + 0], 4, true);
            }
            this.StrOPNDisp(string, 1, i);
            if (fm_flag) {
                int vols;
                int alg = reg[176 + i % 3] & 7;
                if (alg >= 4) {
                    alg -= 4;
                    vols = 127;
                    j = 0;
                    while (j < cslot[alg]) {
                        int tl = reg[76 - (j << 2) + i % 3] & 0x7F;
                        if (vols > tl) {
                            vols = tl;
                        }
                        ++j;
                    }
                } else {
                    vols = reg[76 + i % 3];
                }
                string = "V:" + this.toDecStr(127 - (vols &= 0x7F), 3, true);
            } else {
                j = reg[8 + i % 3];
                if ((j &= 0x1F) >= 16) {
                    j = 16;
                }
                string = "V:" + this.toDecStr(j, 3, true);
            }
            this.StrOPNDisp(string, 2, i);
            if (fm_flag) {
                string = key[i % 3] ? "KEYON   " : "        ";
            } else {
                j = reg[7];
                if (i % 3 == 1) {
                    j >>= 1;
                }
                if (i % 3 == 2) {
                    j >>= 2;
                }
                switch (j &= 9) {
                    case 0: {
                        string = "T + N:" + this.toDecStr(reg[6] & 0x1F, 2, false);
                        break;
                    }
                    case 1: {
                        string = "NOISE:" + this.toDecStr(reg[6] & 0x1F, 2, false);
                        break;
                    }
                    case 8: {
                        string = "TONE    ";
                        break;
                    }
                    case 9: {
                        string = "        ";
                    }
                }
            }
            this.StrOPNDisp(string, 3, i);
            ++i;
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        this.StatLevOPNDisp();
        this.StatKbdOPNDisp();
        this.StatChrOPNDisp();
        if (this.bImage != null) {
            Graphics bg = this.bImage.getGraphics();
            bg.setFont(this.fntOONDisp);
            this.SetupOPNDisp(bg);
            bg.dispose();
            g.drawImage(this.bImage, 0, 0, this);
        }
    }

    private void init() {
        this.setPreferredSize(new Dimension(336, this.getPreferredHeight()));
        this.bImage = this.createImage(336, this.getPreferredHeight());
        int i = 0;
        while (i < 18) {
            this.knOPNDisp[i] = -2;
            this.ktOPNDisp[i] = -1;
            this.lnOPNDisp[i] = -1;
            this.ltOPNDisp[i] = 0;
            int j = 0;
            while (j < 4) {
                this.cnOPNDisp[j][i] = "";
                this.ctOPNDisp[j][i] = "";
                ++j;
            }
            ++i;
        }
    }
}

