/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.OpnDisp;
import emu.xm7.sys.Sys_main;
import emu.xm7.vm.Tools;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.filechooser.FileFilter;

public class Sys_cmd
implements ActionListener,
ItemListener,
MenuListener {
    public JMenuBar mb;
    private JMenu mFile;
    private JMenu[] mDrive = new JMenu[2];
    private JMenu mTape;
    private JMenu mView;
    private JMenu mDebug;
    private JMenu mTool;
    private JMenu mHelp;
    private JMenuItem miLoad;
    private JMenuItem miSave;
    private JMenuItem miSaveAs;
    private JMenuItem miPrint;
    private JMenuItem miReset;
    private JMenuItem miHotReset;
    private JMenuItem miExit;
    private JCheckBoxMenuItem miDosMode;
    private JCheckBoxMenuItem miBasicMode;
    private JMenuItem[] miOpen = new JMenuItem[2];
    private JMenuItem[] miOpenBoth = new JMenuItem[2];
    private JMenuItem[] miEject = new JMenuItem[2];
    private JCheckBoxMenuItem[] miEjecttmp = new JCheckBoxMenuItem[2];
    private JCheckBoxMenuItem[] miWriteProtect = new JCheckBoxMenuItem[2];
    private JCheckBoxMenuItem[][] miMedia = new JCheckBoxMenuItem[4][16];
    private JMenuItem miOpenTape;
    private JMenuItem miEjectTape;
    private JMenuItem miRewTape;
    private JMenuItem miFsfTape;
    private JCheckBoxMenuItem miRecordTape;
    private JMenuItem miRun;
    private JMenuItem miStop;
    private JMenuItem miOpnDisp;
    private JMenu mPropertie;
    private JMenuItem miGeneral;
    private JMenuItem miSound;
    private JMenuItem miKeyboard;
    private JMenuItem miScreen;
    private JMenuItem miPrinter;
    private JMenuItem miOption;
    private JMenuItem miMosMode;
    private JMenuItem miTimeAdjust;
    private JMenuItem miScrCapt;
    private JMenuItem miScrCaptS;
    private JMenuItem miNewD77;
    private JMenuItem miNewT77;
    private JMenuItem miVFD2D77;
    private JMenuItem mi2D2D77;
    private JMenuItem miVTP2T77;
    private JCheckBoxMenuItem miWavCapture;
    private JMenuItem miVersion;
    private String statefile = null;
    private Sys_main sysmain;
    private emu.xm7.vm.System vm;

    Sys_cmd(Sys_main sysmain, emu.xm7.vm.System vm) {
        this.sysmain = sysmain;
        this.vm = vm;
        this.statefile = null;
        this.initMenu();
        this.initFileMenu();
        this.initDriveMenu(1);
        this.initDriveMenu(0);
        this.initTapeMenu();
        this.initViewMenu();
        this.initDebugMenu();
        this.initToolMenu();
        this.initVersionMenu();
    }

    void initMenu() {
        this.mb = new JMenuBar();
        this.mFile = new JMenu("\u30d5\u30a1\u30a4\u30eb");
        this.mb.add(this.mFile);
        this.mDrive[1] = new JMenu("\u30c9\u30e9\u30a4\u30d61");
        this.mb.add(this.mDrive[1]);
        this.mDrive[0] = new JMenu("\u30c9\u30e9\u30a4\u30d60");
        this.mb.add(this.mDrive[0]);
        this.mTape = new JMenu("\u30c6\u30fc\u30d7");
        this.mb.add(this.mTape);
        this.mView = new JMenu("\u8868\u793a");
        this.mb.add(this.mView);
        this.mDebug = new JMenu("\u30c7\u30d0\u30c3\u30b0");
        this.mb.add(this.mDebug);
        this.mTool = new JMenu("\u30c4\u30fc\u30eb");
        this.mb.add(this.mTool);
        this.mHelp = new JMenu("\u30d8\u30eb\u30d7");
        this.mb.add(this.mHelp);
        this.sysmain.setJMenuBar(this.mb);
    }

    private void initFileMenu() {
        this.miLoad = new JMenuItem("\u958b\u304f");
        this.mFile.add(this.miLoad);
        this.miSave = new JMenuItem("\u4e0a\u66f8\u304d\u4fdd\u5b58");
        this.mFile.add(this.miSave);
        this.miSaveAs = new JMenuItem("\u540d\u524d\u3092\u4ed8\u3051\u3066\u4fdd\u5b58");
        this.mFile.add(this.miSaveAs);
        this.mFile.addSeparator();
        this.miPrint = new JMenuItem("\u5370\u5237");
        this.mFile.add(this.miPrint);
        this.mFile.addSeparator();
        this.miReset = new JMenuItem("\u30ea\u30bb\u30c3\u30c8");
        this.mFile.add(this.miReset);
        this.miHotReset = new JMenuItem("\u30db\u30c3\u30c8\u30ea\u30bb\u30c3\u30c8");
        this.mFile.add(this.miHotReset);
        this.mFile.addSeparator();
        this.miBasicMode = new JCheckBoxMenuItem("BASIC\u30e2\u30fc\u30c9");
        this.mFile.add(this.miBasicMode);
        this.miBasicMode.setState(true);
        this.miDosMode = new JCheckBoxMenuItem("DOS\u30e2\u30fc\u30c9");
        this.mFile.add(this.miDosMode);
        this.miDosMode.setState(false);
        this.miExit = new JMenuItem("\u7d42\u4e86");
        this.mFile.add(this.miExit);
        this.mFile.addMenuListener(this);
        this.miLoad.addActionListener(this);
        this.miSave.addActionListener(this);
        this.miSaveAs.addActionListener(this);
        this.miPrint.addActionListener(this);
        this.miReset.addActionListener(this);
        this.miHotReset.addActionListener(this);
        this.miBasicMode.addItemListener(this);
        this.miDosMode.addItemListener(this);
        this.miExit.addActionListener(this);
    }

    private void initDriveMenu(int n) {
        this.mDrive[n].addActionListener(this);
        this.miOpen[n] = new JMenuItem("\u958b\u304f");
        this.miOpenBoth[n] = new JMenuItem("\u4e21\u30c9\u30e9\u30a4\u30d6\u3067\u958b\u304f");
        this.miEject[n] = new JMenuItem("\u53d6\u308a\u5916\u3059");
        this.miEjecttmp[n] = new JCheckBoxMenuItem("\u4e00\u6642\u53d6\u308a\u51fa\u3057");
        this.miWriteProtect[n] = new JCheckBoxMenuItem("\u66f8\u304d\u8fbc\u307f\u7981\u6b62");
        this.miOpen[n].addActionListener(this);
        this.miOpenBoth[n].addActionListener(this);
        this.miEject[n].addActionListener(this);
        this.miEjecttmp[n].addItemListener(this);
        this.miWriteProtect[n].addItemListener(this);
        this.mDrive[n].add(this.miOpen[n]);
        this.mDrive[n].add(this.miOpenBoth[n]);
        int i = 0;
        while (i < 16) {
            this.miMedia[n][i] = new JCheckBoxMenuItem();
            this.miMedia[n][i].addItemListener(this);
            ++i;
        }
    }

    public void resetDriveMenu(int n) {
        this.sysmain.flpind[n].setFlp();
        this.mDrive[n].removeAll();
        this.mDrive[n].add(this.miOpen[n]);
        this.mDrive[n].add(this.miOpenBoth[n]);
        if (this.vm.fdc.fdc_ready[n] == 0) {
            return;
        }
        this.miEjecttmp[n].removeItemListener(this);
        this.miWriteProtect[n].removeItemListener(this);
        this.mDrive[n].add(this.miEject[n]);
        this.mDrive[n].addSeparator();
        this.mDrive[n].add(this.miEjecttmp[n]);
        this.mDrive[n].add(this.miWriteProtect[n]);
        this.miEjecttmp[n].setState(this.vm.fdc.fdc_teject[n]);
        if (this.vm.fdc.fdc_fwritep[n]) {
            this.miWriteProtect[n].setState(false);
        } else {
            this.miWriteProtect[n].setState(true);
            this.miWriteProtect[n].setState(this.vm.fdc.fdc_writep[n]);
        }
        this.mDrive[n].addSeparator();
        int i = 0;
        while (i < this.vm.fdc.fdc_medias[n]) {
            JCheckBoxMenuItem Media = this.miMedia[n][i];
            Media.removeItemListener(this);
            if (this.vm.fdc.fdc_media[n] == i) {
                Media.setState(true);
            } else {
                Media.setState(false);
            }
            Media.setText(this.vm.fdc.fdc_name[n][i]);
            this.mDrive[n].add(Media);
            Media.addItemListener(this);
            ++i;
        }
        this.miEjecttmp[n].addItemListener(this);
        this.miWriteProtect[n].addItemListener(this);
    }

    private void initTapeMenu() {
        this.miOpenTape = new JMenuItem("\u958b\u304f");
        this.miEjectTape = new JMenuItem("\u53d6\u308a\u5916\u3059");
        this.miRewTape = new JMenuItem("\u5dfb\u304d\u623b\u3059");
        this.miFsfTape = new JMenuItem("\u65e9\u9001\u308a");
        this.miRecordTape = new JCheckBoxMenuItem("\u9332\u97f3");
        this.miOpenTape.addActionListener(this);
        this.miEjectTape.addActionListener(this);
        this.miRewTape.addActionListener(this);
        this.miFsfTape.addActionListener(this);
        this.miRecordTape.addItemListener(this);
        this.mTape.add(this.miOpenTape);
    }

    public void resetTapeMenu() {
        this.mTape.removeAll();
        this.mTape.add(this.miOpenTape);
        if (this.vm.tapelp.tape_fileh == null) {
            return;
        }
        this.mTape.add(this.miEjectTape);
        this.mTape.addSeparator();
        this.mTape.add(this.miRewTape);
        this.mTape.add(this.miFsfTape);
        this.mTape.addSeparator();
        this.mTape.add(this.miRecordTape);
        this.miRecordTape.removeItemListener(this);
        if (this.vm.tapelp.tape_writep) {
            this.miRecordTape.setState(false);
        } else {
            this.miRecordTape.setState(true);
            this.miRecordTape.setState(this.vm.tapelp.tape_rec);
        }
        this.miRecordTape.addItemListener(this);
    }

    private void initViewMenu() {
        this.miOpnDisp = new JMenuItem("FM\u97f3\u6e90\u30c7\u30a3\u30b9\u30d7\u30ec\u30a4");
        this.miOpnDisp.addActionListener(this);
        this.mView.add(this.miOpnDisp);
    }

    private void initDebugMenu() {
        this.miRun = new JMenuItem("\u5b9f\u884c");
        this.miStop = new JMenuItem("\u505c\u6b62");
        this.miRun.addActionListener(this);
        this.miStop.addActionListener(this);
        this.mDebug.add(this.miRun);
        this.miRun.setEnabled(false);
        this.mDebug.add(this.miStop);
        this.miStop.setEnabled(true);
    }

    private void resetDebugMenu() {
        if (!this.vm.schedule.stopreq_flag) {
            this.miRun.setEnabled(false);
            this.miStop.setEnabled(true);
        } else {
            this.miRun.setEnabled(true);
            this.miStop.setEnabled(false);
        }
    }

    private void initToolMenu() {
        this.mPropertie = new JMenu("\u8a2d\u5b9a");
        this.mTool.add(this.mPropertie);
        this.miGeneral = new JMenuItem("\u5168\u822c");
        this.mPropertie.add(this.miGeneral);
        this.miSound = new JMenuItem("\u30b5\u30a6\u30f3\u30c9");
        this.mPropertie.add(this.miSound);
        this.miKeyboard = new JMenuItem("\u30ad\u30fc\u30dc\u30fc\u30c9");
        this.mPropertie.add(this.miKeyboard);
        this.miScreen = new JMenuItem("\u753b\u9762");
        this.mPropertie.add(this.miScreen);
        this.miPrinter = new JMenuItem("\u30d7\u30ea\u30f3\u30bf");
        this.mPropertie.add(this.miPrinter);
        this.miOption = new JMenuItem("\u30aa\u30d7\u30b7\u30e7\u30f3");
        this.mPropertie.add(this.miOption);
        this.mTool.addSeparator();
        this.miMosMode = new JMenuItem("\u30de\u30a6\u30b9\u30e2\u30fc\u30c9");
        this.mTool.add(this.miMosMode);
        this.miTimeAdjust = new JMenuItem("\u6642\u523b\u30a2\u30b8\u30e3\u30b9\u30c8");
        this.mTool.add(this.miTimeAdjust);
        this.mTool.addSeparator();
        this.miScrCapt = new JMenuItem("\u753b\u9762\u30ad\u30e3\u30d7\u30c1\u30e3");
        this.mTool.add(this.miScrCapt);
        this.miScrCaptS = new JMenuItem("\u7e2e\u5c0f\u753b\u50cf\u30ad\u30e3\u30d7\u30c1\u30e3");
        this.mTool.add(this.miScrCaptS);
        this.miWavCapture = new JCheckBoxMenuItem("\uff37\uff21\uff36\u30ad\u30e3\u30d7\u30c1\u30e3");
        this.mTool.add(this.miWavCapture);
        this.miWavCapture.setState(false);
        this.mTool.addSeparator();
        this.miNewD77 = new JMenuItem("\u65b0\u898f\u30c7\u30a3\u30b9\u30af\u4f5c\u6210");
        this.mTool.add(this.miNewD77);
        this.miNewT77 = new JMenuItem("\u65b0\u898f\u30c6\u30fc\u30d7\u4f5c\u6210");
        this.mTool.add(this.miNewT77);
        this.miVFD2D77 = new JMenuItem("VFD\u2192D77\u5909\u63db");
        this.mTool.add(this.miVFD2D77);
        this.mi2D2D77 = new JMenuItem("2D\u2192D77\u5909\u63db");
        this.mTool.add(this.mi2D2D77);
        this.miVTP2T77 = new JMenuItem("VTP\u2192T77\u5909\u63db");
        this.mTool.add(this.miVTP2T77);
        this.miGeneral.addActionListener(this);
        this.miSound.addActionListener(this);
        this.miKeyboard.addActionListener(this);
        this.miScreen.addActionListener(this);
        this.miPrinter.addActionListener(this);
        this.miOption.addActionListener(this);
        this.miMosMode.addActionListener(this);
        this.miTimeAdjust.addActionListener(this);
        this.miScrCapt.addActionListener(this);
        this.miScrCaptS.addActionListener(this);
        this.miWavCapture.addItemListener(this);
        this.miNewD77.addActionListener(this);
        this.miNewT77.addActionListener(this);
        this.miVFD2D77.addActionListener(this);
        this.mi2D2D77.addActionListener(this);
        this.miVTP2T77.addActionListener(this);
    }

    private void initVersionMenu() {
        this.miVersion = new JMenuItem("\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831");
        this.mHelp.add(this.miVersion);
        this.miVersion.addActionListener(this);
    }

    private void onLoad() {
        FileDialogEx fd = new FileDialogEx("\u30b9\u30c6\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.StateFileDir);
        fd.addExtension("XM7", "XM7\u30b9\u30c6\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb");
        fd.showOpenDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.StateFileDir = fd.getCurrentDirectory().toString();
            this.statefile = fd.getSelectedFilePath();
            this.sysmain.sys_sch.SuspendVM();
            this.sysmain.sys_snd.StopSnd();
            this.vm.load(this.statefile);
            this.sysmain.sys_snd.PlaySnd();
            this.sysmain.sys_sch.ReleaseVM();
            this.resetDriveMenu(0);
            this.resetDriveMenu(1);
            this.resetTapeMenu();
            switch (this.vm.fm7_ver) {
                case 1: {
                    this.sysmain.setWindowIcon("emu/xm7/sys/Tamori.gif");
                    break;
                }
                case 2: {
                    this.sysmain.setWindowIcon("emu/xm7/sys/APP_AV.gif");
                    break;
                }
                case 3: {
                    this.sysmain.setWindowIcon("emu/xm7/sys/APP_EX.gif");
                    break;
                }
            }
            boolean boot_basic = this.vm.boot_mode == 0;
            this.miBasicMode.removeItemListener(this);
            this.miDosMode.removeItemListener(this);
            this.miBasicMode.setState(boot_basic);
            this.miDosMode.setState(!boot_basic);
            this.miBasicMode.addItemListener(this);
            this.miDosMode.addItemListener(this);
            this.sysmain.sys_cfg.Version = this.vm.fm7_ver;
        }
    }

    private void onSave() {
        if (this.statefile == null) {
            FileDialogEx fd = new FileDialogEx("\u30b9\u30c6\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.StateFileDir);
            fd.addExtension("XM7", "XM7\u30b9\u30c6\u30fc\u30c8\u30d5\u30a1\u30a4\u30eb");
            fd.showSaveDialog(null);
            if (fd.getSelectedFilePath() != null) {
                this.sysmain.sys_cfg.StateFileDir = fd.getCurrentDirectory().toString();
                this.statefile = fd.getSelectedFilePath();
            }
        }
        if (this.statefile != null) {
            this.sysmain.sys_sch.SuspendVM();
            this.sysmain.sys_snd.StopSnd();
            if (!this.vm.save(this.statefile)) {
                this.statefile = null;
            }
            this.sysmain.sys_snd.PlaySnd();
            this.sysmain.sys_sch.ReleaseVM();
        }
    }

    private void onSaveAs() {
        this.statefile = null;
        this.onSave();
    }

    private void onPrint() {
        this.vm.tapelp.lp_print();
    }

    private void onReset() {
        this.vm.reset();
    }

    private void onHotReset() {
        this.vm.hotreset();
    }

    private void onBasic() {
        if (this.miBasicMode.getState()) {
            this.vm.boot_mode = 0;
            this.miDosMode.removeItemListener(this);
            this.miDosMode.setState(false);
            this.miDosMode.addItemListener(this);
        }
    }

    private void onDos() {
        if (this.miDosMode.getState()) {
            this.vm.boot_mode = 1;
            this.miBasicMode.removeItemListener(this);
            this.miBasicMode.setState(false);
            this.miBasicMode.addItemListener(this);
        }
    }

    private void onWavCapture() {
        if (this.miWavCapture.getState()) {
            FileDialogEx fd = new FileDialogEx("WAV\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.WAVFileDir);
            fd.addExtension("WAV", "WAV\u30d5\u30a1\u30a4\u30eb");
            fd.showSaveDialog(null);
            if (fd.getSelectedFilePath() != null) {
                this.sysmain.sys_cfg.WAVFileDir = fd.getCurrentDirectory().toString();
                this.sysmain.sys_snd.OpenCaptureSnd(fd.getSelectedFilePath());
            } else {
                this.miWavCapture.removeItemListener(this);
                this.miWavCapture.setState(false);
                this.miWavCapture.addItemListener(this);
            }
        } else {
            this.sysmain.sys_snd.CloseCaptureSnd();
        }
    }

    private void onExit() {
        this.sysmain.sys_sch.bCloseReq = true;
        while (this.sysmain.sys_sch.bCloseReq) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.sysmain.sys_cfg.save();
        this.vm.cleanup();
        System.exit(0);
    }

    public void onDisk(int n) {
        FileDialogEx fd = new FileDialogEx("\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.DiskImageDir);
        fd.addExtension("VFD", "EM-7\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.addExtension("2D", "320KB\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.addExtension("D77", "FM-7/77\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.addAllExtension("\u5bfe\u5fdc\u3057\u3066\u3044\u308b\u3059\u3079\u3066\u306e\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.showOpenDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.DiskImageDir = fd.getCurrentDirectory().toString();
            this.vm.fdc.fdc_setdisk(n, fd.getSelectedFilePath());
            this.resetDriveMenu(n);
        }
    }

    private void onDiskBoth() {
        FileDialogEx fd = new FileDialogEx("\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.DiskImageDir);
        fd.addExtension("VFD", "EM-7\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.addExtension("2D", "320KB\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.addExtension("D77", "FM-7/77\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.addAllExtension("\u5bfe\u5fdc\u3057\u3066\u3044\u308b\u3059\u3079\u3066\u306e\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.showOpenDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.DiskImageDir = fd.getCurrentDirectory().toString();
            String path = fd.getSelectedFilePath();
            this.vm.fdc.fdc_setdisk(0, path);
            this.vm.fdc.fdc_setdisk(1, null);
            if (this.vm.fdc.fdc_ready[0] != 0 && this.vm.fdc.fdc_medias[0] >= 2) {
                this.vm.fdc.fdc_setdisk(1, path);
                this.vm.fdc.fdc_setmedia(1, 1);
            }
            this.resetDriveMenu(0);
            this.resetDriveMenu(1);
        }
    }

    private void onDiskEject(int n) {
        this.vm.fdc.fdc_setdisk(n, null);
        this.resetDriveMenu(n);
    }

    private void onDiskEjectTmp(int n) {
        this.vm.fdc.fdc_teject[n] = !this.vm.fdc.fdc_teject[n];
        this.resetDriveMenu(n);
    }

    private void onDiskWriteProtect(int n) {
        if (this.vm.fdc.fdc_writep[n]) {
            this.vm.fdc.fdc_setwritep(n, false);
        } else {
            this.vm.fdc.fdc_setwritep(n, true);
        }
        this.resetDriveMenu(n);
    }

    private void onMediaChange(int drive, int media) {
        this.vm.fdc.fdc_setmedia(drive, media);
        this.resetDriveMenu(drive);
    }

    public void onOpenTape() {
        FileDialogEx fd = new FileDialogEx("\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.TapeImageDir);
        fd.addExtension("T77", "FM-7/77\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8");
        fd.showOpenDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.TapeImageDir = fd.getCurrentDirectory().toString();
            this.vm.tapelp.tape_setfile(fd.getSelectedFilePath());
            this.resetTapeMenu();
        }
    }

    private void onEjectTape() {
        this.vm.tapelp.tape_setfile(null);
        this.resetTapeMenu();
    }

    private void onRewTape() {
        this.vm.tapelp.tape_rew();
    }

    private void onFsfTape() {
        this.vm.tapelp.tape_ff();
    }

    private void onRecordTape() {
        if (this.vm.tapelp.tape_rec) {
            this.vm.tapelp.tape_setrec(false);
        } else {
            this.vm.tapelp.tape_setrec(true);
        }
        this.resetTapeMenu();
    }

    private void onOpnDisp() {
        if (this.sysmain.opd == null) {
            this.sysmain.opd = OpnDisp.createWindow(this.sysmain, this.vm);
        } else {
            this.sysmain.opd.window.setVisible(!this.sysmain.opd.window.isVisible());
        }
    }

    private void onRun() {
        this.vm.schedule.stopreq_flag = false;
        this.vm.schedule.run_flag = true;
        this.resetDebugMenu();
    }

    private void onBreak() {
        this.vm.schedule.stopreq_flag = true;
        this.resetDebugMenu();
    }

    private void onGeneral() {
        this.sysmain.sys_cfg.openGeneralDialog(this.sysmain);
    }

    private void onSound() {
        this.sysmain.sys_cfg.openSoundDialog(this.sysmain);
    }

    private void onKeyboard() {
        this.sysmain.sys_cfg.openKeyboardDialog(this.sysmain);
    }

    private void onScreen() {
        this.sysmain.sys_cfg.openScreenDialog(this.sysmain);
    }

    private void onPrinter() {
        this.sysmain.sys_cfg.openPrinterDialog(this.sysmain);
    }

    private void onOption() {
        this.sysmain.sys_cfg.openOptionDialog(this.sysmain);
    }

    private void onMosMode() {
        if (this.vm.mouse.mos_capture) {
            this.sysmain.sys_kbd.SetMouseCapture(true);
        }
    }

    private void onTimeAdjust() {
        this.vm.rtc.time_adjust();
        this.vm.rtc.reset();
    }

    private void onScrCapture() {
        FileDialogEx fd = new FileDialogEx("BMP\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.BMPFileDir);
        fd.addExtension("BMP", "BMP\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8");
        fd.showSaveDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.BMPFileDir = fd.getCurrentDirectory().toString();
            this.sysmain.sys_sch.SuspendVM();
            this.sysmain.sys_snd.StopSnd();
            Tools.capture_to_bmp(fd.getSelectedFilePath(), true);
            this.sysmain.sys_snd.PlaySnd();
            this.sysmain.sys_sch.ReleaseVM();
        }
    }

    private void onScrCaptureS() {
        FileDialogEx fd = new FileDialogEx("BMP\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.BMPFileDir);
        fd.addExtension("BMP", "BMP\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8");
        fd.showSaveDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.BMPFileDir = fd.getCurrentDirectory().toString();
            this.sysmain.sys_sch.SuspendVM();
            this.sysmain.sys_snd.StopSnd();
            Tools.capture_to_bmp2(fd.getSelectedFilePath());
            this.sysmain.sys_snd.PlaySnd();
            this.sysmain.sys_sch.ReleaseVM();
        }
    }

    private void onNewD77() {
        NewD77Dialog dd = new NewD77Dialog(this.sysmain);
        dd.setVisible(true);
        if (dd.disktitle != null) {
            FileDialogEx fd = new FileDialogEx("\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.DiskImageDir);
            fd.addExtension("D77", "FM-7/77\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
            fd.showSaveDialog(null);
            if (fd.getSelectedFilePath() != null) {
                this.sysmain.sys_cfg.DiskImageDir = fd.getCurrentDirectory().toString();
                if (dd.userdisk) {
                    Tools.make_new_userdisk(fd.getSelectedFilePath(), dd.disktitle, dd.mediatype2dd);
                } else {
                    Tools.make_new_d77(fd.getSelectedFilePath(), dd.disktitle, dd.mediatype2dd);
                }
            }
        }
    }

    private void onNewT77() {
        FileDialogEx fd = new FileDialogEx("\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.TapeImageDir);
        fd.addExtension("T77", "FM-7/77\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8");
        fd.showSaveDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.TapeImageDir = fd.getCurrentDirectory().toString();
            Tools.make_new_t77(fd.getSelectedFilePath());
        }
    }

    private void onVFD2D77() {
        FileDialogEx fd = null;
        String VFD = null;
        String D77 = null;
        fd = new FileDialogEx("VFD\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.DiskImageDir);
        fd.addExtension("VFD", "EM-7\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.showOpenDialog(null);
        if (fd.getSelectedFilePath() == null) {
            return;
        }
        this.sysmain.sys_cfg.DiskImageDir = fd.getCurrentDirectory().toString();
        VFD = new String(fd.getSelectedFilePath());
        D77NameDialog dd = new D77NameDialog(this.sysmain);
        dd.setVisible(true);
        if (dd.disktitle == null) {
            return;
        }
        fd = new FileDialogEx("D77\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.DiskImageDir);
        fd.addExtension("D77", "FM-7/77\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.showSaveDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.DiskImageDir = fd.getCurrentDirectory().toString();
            D77 = new String(fd.getSelectedFilePath());
        }
        if (VFD != null && D77 != null) {
            Tools.conv_vfd_to_d77(VFD, D77, dd.disktitle);
        }
    }

    private void on2D2D77() {
        FileDialogEx fd = null;
        String D2D = null;
        String D77 = null;
        fd = new FileDialogEx("2D\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.DiskImageDir);
        fd.addExtension("2D", "320KB\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.showOpenDialog(null);
        if (fd.getSelectedFilePath() == null) {
            return;
        }
        this.sysmain.sys_cfg.DiskImageDir = fd.getCurrentDirectory().toString();
        D2D = new String(fd.getSelectedFilePath());
        D77NameDialog dd = new D77NameDialog(this.sysmain);
        dd.setVisible(true);
        if (dd.disktitle == null) {
            return;
        }
        fd = new FileDialogEx("D77\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.DiskImageDir);
        fd.addExtension("D77", "FM-7/77\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8");
        fd.showSaveDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.DiskImageDir = fd.getCurrentDirectory().toString();
            D77 = new String(fd.getSelectedFilePath());
        }
        if (D2D != null && D77 != null) {
            Tools.conv_2d_to_d77(D2D, D77, dd.disktitle);
        }
    }

    private void onVTP2T77() {
        FileDialogEx fd = null;
        String VTP = null;
        String T77 = null;
        fd = new FileDialogEx("VTP\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.TapeImageDir);
        fd.addExtension("VTP", "EM-7\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8");
        fd.showOpenDialog(null);
        if (fd.getSelectedFilePath() == null) {
            return;
        }
        this.sysmain.sys_cfg.TapeImageDir = fd.getCurrentDirectory().toString();
        VTP = new String(fd.getSelectedFilePath());
        fd = new FileDialogEx("T77\u30d5\u30a1\u30a4\u30eb\u3092\u958b\u304f", this.sysmain.sys_cfg.TapeImageDir);
        fd.addExtension("T77", "FM-7/77\u30c6\u30fc\u30d7\u30a4\u30e1\u30fc\u30b8");
        fd.showSaveDialog(null);
        if (fd.getSelectedFilePath() != null) {
            this.sysmain.sys_cfg.TapeImageDir = fd.getCurrentDirectory().toString();
            T77 = new String(fd.getSelectedFilePath());
        }
        if (VTP != null && T77 != null) {
            Tools.conv_vtp_to_t77(VTP, T77);
        }
    }

    private void onVersion() {
        VersionDialog dd = new VersionDialog(this.sysmain);
        dd.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.miLoad) {
            this.onLoad();
            return;
        }
        if (e.getSource() == this.miSave) {
            this.onSave();
            return;
        }
        if (e.getSource() == this.miSaveAs) {
            this.onSaveAs();
            return;
        }
        if (e.getSource() == this.miPrint) {
            this.onPrint();
            return;
        }
        if (e.getSource() == this.miReset) {
            this.onReset();
            return;
        }
        if (e.getSource() == this.miHotReset) {
            this.onHotReset();
            return;
        }
        if (e.getSource() == this.miExit) {
            this.onExit();
            return;
        }
        if (e.getSource() == this.miOpen[0]) {
            this.onDisk(0);
            return;
        }
        if (e.getSource() == this.miOpenBoth[0]) {
            this.onDiskBoth();
            return;
        }
        if (e.getSource() == this.miEject[0]) {
            this.onDiskEject(0);
            return;
        }
        if (e.getSource() == this.miOpen[1]) {
            this.onDisk(1);
            return;
        }
        if (e.getSource() == this.miOpenBoth[1]) {
            this.onDiskBoth();
            return;
        }
        if (e.getSource() == this.miEject[1]) {
            this.onDiskEject(1);
            return;
        }
        if (e.getSource() == this.miOpenTape) {
            this.onOpenTape();
            return;
        }
        if (e.getSource() == this.miEjectTape) {
            this.onEjectTape();
            return;
        }
        if (e.getSource() == this.miRewTape) {
            this.onRewTape();
            return;
        }
        if (e.getSource() == this.miFsfTape) {
            this.onFsfTape();
            return;
        }
        if (e.getSource() == this.miOpnDisp) {
            this.onOpnDisp();
            return;
        }
        if (e.getSource() == this.miRun) {
            this.onRun();
            return;
        }
        if (e.getSource() == this.miStop) {
            this.onBreak();
            return;
        }
        if (e.getSource() == this.miGeneral) {
            this.onGeneral();
            return;
        }
        if (e.getSource() == this.miSound) {
            this.onSound();
            return;
        }
        if (e.getSource() == this.miKeyboard) {
            this.onKeyboard();
            return;
        }
        if (e.getSource() == this.miScreen) {
            this.onScreen();
            return;
        }
        if (e.getSource() == this.miPrinter) {
            this.onPrinter();
            return;
        }
        if (e.getSource() == this.miOption) {
            this.onOption();
            return;
        }
        if (e.getSource() == this.miMosMode) {
            this.onMosMode();
            return;
        }
        if (e.getSource() == this.miTimeAdjust) {
            this.onTimeAdjust();
            return;
        }
        if (e.getSource() == this.miScrCapt) {
            this.onScrCapture();
            return;
        }
        if (e.getSource() == this.miScrCaptS) {
            this.onScrCaptureS();
            return;
        }
        if (e.getSource() == this.miNewD77) {
            this.onNewD77();
            return;
        }
        if (e.getSource() == this.miNewT77) {
            this.onNewT77();
            return;
        }
        if (e.getSource() == this.miVFD2D77) {
            this.onVFD2D77();
            return;
        }
        if (e.getSource() == this.mi2D2D77) {
            this.on2D2D77();
            return;
        }
        if (e.getSource() == this.miVTP2T77) {
            this.onVTP2T77();
            return;
        }
        if (e.getSource() == this.miVersion) {
            this.onVersion();
            return;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.miWavCapture) {
            this.onWavCapture();
            return;
        }
        if (e.getSource() == this.miBasicMode) {
            this.onBasic();
            return;
        }
        if (e.getSource() == this.miDosMode) {
            this.onDos();
            return;
        }
        if (e.getSource() == this.miEjecttmp[0]) {
            this.onDiskEjectTmp(0);
            return;
        }
        if (e.getSource() == this.miWriteProtect[0]) {
            this.onDiskWriteProtect(0);
            return;
        }
        if (e.getSource() == this.miEjecttmp[1]) {
            this.onDiskEjectTmp(1);
            return;
        }
        if (e.getSource() == this.miWriteProtect[1]) {
            this.onDiskWriteProtect(1);
            return;
        }
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < 16) {
                if (e.getSource() == this.miMedia[i][j]) {
                    this.onMediaChange(i, j);
                    return;
                }
                ++j;
            }
            ++i;
        }
        if (e.getSource() == this.miRecordTape) {
            this.onRecordTape();
            return;
        }
    }

    @Override
    public void menuCanceled(MenuEvent e) {
    }

    @Override
    public void menuDeselected(MenuEvent e) {
    }

    @Override
    public void menuSelected(MenuEvent e) {
        if (e.getSource() == this.mFile) {
            this.miPrint.setEnabled(this.vm.tapelp.lp_use);
        }
    }

    private class D77NameDialog
    extends Dialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        String disktitle;
        Label LabelTitle;
        TextField TextTitle;
        Button ok;
        Button can;

        D77NameDialog(Frame fw) {
            super(fw, "\u30c7\u30a3\u30b9\u30af\u30bf\u30a4\u30c8\u30eb\u5165\u529b", true);
            this.disktitle = null;
            this.LabelTitle = new Label("\u30bf\u30a4\u30c8\u30eb\u300016\u6587\u5b57\u307e\u3067", 0);
            this.TextTitle = new TextField("Default", 16);
            this.ok = new Button("\u3000 \uff2f\uff2b\u3000 ");
            this.can = new Button("\u30ad\u30e3\u30f3\u30bb\u30eb");
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(layout);
            cons.anchor = 17;
            cons.insets = new Insets(2, 2, 2, 2);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.gridwidth = 2;
            cons.gridheight = 1;
            layout.setConstraints(this.LabelTitle, cons);
            this.add(this.LabelTitle);
            cons.gridx = 0;
            cons.gridy = 1;
            cons.gridwidth = 2;
            cons.gridheight = 1;
            layout.setConstraints(this.TextTitle, cons);
            this.add(this.TextTitle);
            cons.gridx = 2;
            cons.gridy = 0;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.fill = 1;
            layout.setConstraints(this.ok, cons);
            this.add(this.ok);
            cons.gridx = 2;
            cons.gridy = 1;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.fill = 1;
            layout.setConstraints(this.can, cons);
            this.add(this.can);
            this.ok.addActionListener(this);
            this.can.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    D77NameDialog.this.dispose();
                }
            });
            this.setResizable(false);
            this.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.ok) {
                this.disktitle = this.TextTitle.getText();
                this.dispose();
            } else if (e.getSource() == this.can) {
                this.disktitle = null;
                this.dispose();
            }
        }
    }

    private class FileDialogEx
    extends JFileChooser {
        private static final long serialVersionUID = 1L;
        Vector<String> exts = new Vector();

        FileDialogEx(String Title, String Dir) {
            this.setDialogTitle(Title);
            this.setCurrentDirectory(new File(Dir));
        }

        void addExtension(String ext, String msg) {
            this.addChoosableFileFilter(new FileFilterEx("." + ext, String.valueOf(msg) + "(*." + ext + ")"));
            this.exts.add(ext);
        }

        void addAllExtension(String msg) {
            this.addChoosableFileFilter(new FileFilterEx(this.exts, msg));
        }

        String getSelectedFilePath() {
            return this.getSelectedFile() != null ? this.getSelectedFile().getAbsolutePath() : null;
        }

        class FileFilterEx
        extends FileFilter {
            Vector<String> extensions = null;
            String extension;
            String msg;

            FileFilterEx(String extension, String msg) {
                this.extension = extension;
                this.msg = msg;
            }

            FileFilterEx(Vector<String> extensions, String msg) {
                this.extensions = extensions;
                this.msg = msg;
            }

            @Override
            public boolean accept(File f) {
                if (this.extensions != null && !this.extensions.isEmpty()) {
                    boolean t = false;
                    int i = 0;
                    while (i < this.extensions.size()) {
                        this.extension = this.extensions.elementAt(i);
                        t = f.getName().endsWith(this.extension.toUpperCase()) | f.getName().endsWith(this.extension.toLowerCase()) | f.isDirectory();
                        if (t) break;
                        ++i;
                    }
                    return t;
                }
                return f.getName().endsWith(this.extension.toUpperCase()) | f.getName().endsWith(this.extension.toLowerCase()) | f.isDirectory();
            }

            @Override
            public String getDescription() {
                return this.msg;
            }
        }
    }

    private class NewD77Dialog
    extends Dialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        String disktitle;
        boolean mediatype2dd;
        boolean userdisk;
        Label LabelTitle;
        TextField TextTitle;
        Label LabelMedia;
        CheckboxGroup grp;
        Checkbox CheckBox2D;
        Checkbox CheckBox2DD;
        Checkbox CheckBoxUser;
        Button ok;
        Button can;

        NewD77Dialog(Frame fw) {
            super(fw, "\u65b0\u898f\u30c7\u30a3\u30b9\u30af\u30a4\u30e1\u30fc\u30b8\u4f5c\u6210", true);
            this.disktitle = null;
            this.mediatype2dd = false;
            this.userdisk = false;
            this.LabelTitle = new Label("\u30bf\u30a4\u30c8\u30eb\u300016\u6587\u5b57\u307e\u3067", 0);
            this.TextTitle = new TextField("Default", 16);
            this.LabelMedia = new Label("\u30e1\u30c7\u30a3\u30a2\u30bf\u30a4\u30d7", 0);
            this.grp = new CheckboxGroup();
            this.CheckBox2D = new Checkbox("2D", this.grp, true);
            this.CheckBox2DD = new Checkbox("2DD", this.grp, false);
            this.CheckBoxUser = new Checkbox("F-BASIC\u306e\u30e6\u30fc\u30b6\u30c7\u30a3\u30b9\u30af\u3092\u4f5c\u6210\u3059\u308b", false);
            this.ok = new Button("\u3000 \uff2f\uff2b\u3000 ");
            this.can = new Button("\u30ad\u30e3\u30f3\u30bb\u30eb");
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.setLayout(layout);
            cons.anchor = 17;
            cons.insets = new Insets(2, 2, 2, 2);
            cons.gridx = 0;
            cons.gridy = 0;
            cons.gridwidth = 2;
            cons.gridheight = 1;
            layout.setConstraints(this.LabelTitle, cons);
            this.add(this.LabelTitle);
            cons.gridx = 0;
            cons.gridy = 1;
            cons.gridwidth = 2;
            cons.gridheight = 1;
            layout.setConstraints(this.TextTitle, cons);
            this.add(this.TextTitle);
            cons.gridx = 0;
            cons.gridy = 2;
            cons.gridwidth = 2;
            cons.gridheight = 1;
            layout.setConstraints(this.LabelMedia, cons);
            this.add(this.LabelMedia);
            cons.gridx = 0;
            cons.gridy = 3;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            layout.setConstraints(this.CheckBox2D, cons);
            this.add(this.CheckBox2D);
            cons.gridx = 1;
            cons.gridy = 3;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            layout.setConstraints(this.CheckBox2DD, cons);
            this.add(this.CheckBox2DD);
            cons.gridx = 0;
            cons.gridy = 4;
            cons.gridwidth = 3;
            cons.gridheight = 1;
            layout.setConstraints(this.CheckBoxUser, cons);
            this.add(this.CheckBoxUser);
            cons.gridx = 2;
            cons.gridy = 0;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.fill = 1;
            layout.setConstraints(this.ok, cons);
            this.add(this.ok);
            cons.gridx = 2;
            cons.gridy = 1;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            cons.fill = 1;
            layout.setConstraints(this.can, cons);
            this.add(this.can);
            this.ok.addActionListener(this);
            this.can.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    NewD77Dialog.this.dispose();
                }
            });
            this.setResizable(false);
            this.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.ok) {
                this.disktitle = this.TextTitle.getText();
                this.mediatype2dd = this.CheckBox2DD.getState();
                this.userdisk = this.CheckBoxUser.getState();
                this.dispose();
            } else if (e.getSource() == this.can) {
                this.disktitle = null;
                this.mediatype2dd = false;
                this.userdisk = false;
                this.dispose();
            }
        }
    }

    private class VersionDialog
    extends JDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        String[] Version;
        JButton ok;

        VersionDialog(Frame fw) {
            super(fw, "XM7\u306e\u30d0\u30fc\u30b8\u30e7\u30f3\u60c5\u5831", true);
            this.Version = new String[]{"XM7 for Java V1.1 L01 (2013/01/12)", "converted by GIMONS & Ben.JP.", "line printer support by Ben.JP", "http://motor.geocities.jp/a160_1930/FM-7/", "", "[Original Version Information]", "XM7 for Java V1.0 L05 (2004/10/09)", "Converted by GIMONS.", "FM-7 EMULATOR XM7", "V3.3 L31a (2003/10/23) - V3.4 L52a (2012/12/23)", "Copyright(C) 1999-2012 \uff30\uff29.", "http://www.ipc-tokai.or.jp/~ytanaka/", "Copyright(C) 2001-2012 Ryu Takegami", "http://retropc.net/~ryu/xm7/", "FM Sound Generator. PSG Implementation", "Technology from M88, 1998-2003 by cisc"};
            this.ok = new JButton("\u3000 \uff2f\uff2b\u3000 ");
            GridBagLayout layout = new GridBagLayout();
            GridBagConstraints cons = new GridBagConstraints();
            this.getContentPane().setLayout(layout);
            cons.anchor = 10;
            cons.insets = new Insets(0, 0, 0, 0);
            int i = 0;
            while (i < this.Version.length) {
                JLabel LabelVersion = new JLabel(this.Version[i]);
                cons.gridx = 0;
                cons.gridy = i++;
                cons.gridwidth = 1;
                cons.gridheight = 1;
                layout.setConstraints(LabelVersion, cons);
                this.getContentPane().add(LabelVersion);
            }
            cons.gridx = 0;
            cons.gridy = this.Version.length;
            cons.gridwidth = 1;
            cons.gridheight = 1;
            layout.setConstraints(this.ok, cons);
            this.getContentPane().add(this.ok);
            this.ok.addActionListener(this);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    VersionDialog.this.dispose();
                }
            });
            this.setResizable(false);
            this.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.ok) {
                this.dispose();
            }
        }
    }
}

