/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.CrtView;
import emu.xm7.sys.FlpInd;
import emu.xm7.sys.KeyInd;
import emu.xm7.sys.OpnDisp;
import emu.xm7.sys.Sys_cfg;
import emu.xm7.sys.Sys_cmd;
import emu.xm7.sys.Sys_dsp;
import emu.xm7.sys.Sys_kbd;
import emu.xm7.sys.Sys_lpr;
import emu.xm7.sys.Sys_sch;
import emu.xm7.sys.Sys_snd;
import emu.xm7.sys.Sys_util;
import emu.xm7.sys.TapeInd;
import emu.xm7.vm.Base;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Sys_main
extends JFrame {
    private static final long serialVersionUID = 1L;
    public emu.xm7.vm.System vm;
    public CrtView crtview;
    private JPanel statusbar;
    private JLabel statusmsg;
    public KeyInd keyind;
    public TapeInd tapeind;
    public FlpInd[] flpind = new FlpInd[2];
    public Sys_cmd sys_cmd;
    public Sys_dsp sys_dsp;
    public Sys_kbd sys_kbd;
    public Sys_snd sys_snd;
    public Sys_lpr sys_lpr;
    public Sys_sch sys_sch;
    public Sys_cfg sys_cfg;
    public OpnDisp opd = null;

    public Sys_main(String Title) {
        super(Title);
        Base.sysmain = this;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                Sys_main.this.sys_kbd.bActivate = true;
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                Sys_main.this.sys_kbd.bActivate = false;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                Sys_main.this.sys_sch.bCloseReq = true;
                Sys_main.this.sys_sch.CleanSch();
                if (!$assertionsDisabled && Sys_main.this.sys_sch.bCloseReq) {
                    throw new AssertionError();
                }
                Sys_main.this.sys_cfg.save();
                Sys_main.this.vm.cleanup();
                System.exit(0);
            }
        });
        this.addComponentListener(new ResizeAdapter());
    }

    void init(String[] args) {
        this.vm = new emu.xm7.vm.System();
        this.sys_dsp = new Sys_dsp(this, this.vm);
        this.sys_kbd = new Sys_kbd(this, this.vm);
        this.sys_snd = new Sys_snd(this, this.vm);
        this.sys_lpr = new Sys_lpr(this, this.vm);
        this.sys_sch = new Sys_sch(this, this.vm);
        this.sys_cfg = new Sys_cfg(this, this.vm);
        this.sys_cmd = new Sys_cmd(this, this.vm);
        if (!this.vm.init()) {
            Sys_util.alertDialog(this, "XM7\u521d\u671f\u5316\u30a8\u30e9\u30fc", "XM7\u3092\u6b63\u3057\u304f\u521d\u671f\u5316\u3067\u304d\u307e\u305b\u3093\u3067\u3057\u305f");
        }
        this.sys_snd.InitSnd();
        this.sys_sch.InitSch();
        this.sys_kbd.InitKbd();
        this.sys_cfg.load();
        this.sys_cfg.apply();
        Container pane = this.getContentPane();
        pane.setLayout(new BorderLayout(0, 0));
        this.crtview = new CrtView(this, this.sys_dsp);
        this.crtview.setFocusable(false);
        pane.add((Component)this.crtview, "Center");
        this.statusbar = new JPanel();
        this.statusbar.setBackground(Color.lightGray);
        pane.add((Component)this.statusbar, "South");
        this.statusbar.setLayout(new BorderLayout(0, 0));
        JPanel sbar_l = new JPanel();
        this.statusbar.add((Component)sbar_l, "West");
        sbar_l.setLayout(new FlowLayout(0, 1, 1));
        JPanel sbar_r = new JPanel();
        this.statusbar.add((Component)sbar_r, "Center");
        sbar_r.setLayout(new FlowLayout(2, 1, 1));
        this.statusmsg = new JLabel("V1.1L01");
        sbar_l.add(this.statusmsg);
        this.flpind[1] = new FlpInd(this, 1);
        sbar_r.add(this.flpind[1]);
        this.flpind[0] = new FlpInd(this, 0);
        sbar_r.add(this.flpind[0]);
        this.tapeind = new TapeInd(this);
        sbar_r.add(this.tapeind);
        this.keyind = new KeyInd(this);
        sbar_r.add(this.keyind.capsred);
        sbar_r.add(this.keyind.kanared);
        sbar_r.add(this.keyind.insred);
        if (Sys_util.OsType == 3) {
            sbar_r.add(new JLabel("\u3000\u3000"));
        }
        this.setFocusTraversalKeysEnabled(false);
        this.addKeyListener(this.sys_kbd);
        this.crtview.addMouseListener(this.sys_kbd);
        this.crtview.addMouseMotionListener(this.sys_kbd);
        this.requestFocus();
        if (args.length > 0) {
            this.setFlpDragFile(args[0]);
        }
        this.sys_cmd.resetDriveMenu(0);
        this.sys_cmd.resetDriveMenu(1);
        this.vm.reset();
    }

    void start() {
        Thread thread;
        this.vm.schedule.stopreq_flag = false;
        this.vm.schedule.run_flag = true;
        this.sys_sch.VMthread = thread = new Thread(this.sys_sch);
        thread.start();
    }

    void setStatusMsg(String msg) {
        this.statusmsg.setText(msg);
        this.validate();
    }

    void setFlpDragFile(String path) {
        String lowerPath = path.toLowerCase();
        if (path.endsWith(".xm7")) {
            this.vm.load(path);
        } else if (lowerPath.endsWith(".t77")) {
            this.vm.tapelp.tape_setfile(path);
            this.sys_cmd.resetTapeMenu();
        } else if (lowerPath.endsWith(".d77")) {
            this.vm.fdc.fdc_setdisk(0, path);
            this.vm.fdc.fdc_setdisk(1, null);
            if (this.vm.fdc.fdc_ready[0] != 0 && this.vm.fdc.fdc_medias[0] >= 2) {
                this.vm.fdc.fdc_setdisk(1, path);
                this.vm.fdc.fdc_setmedia(1, 1);
            }
            this.vm.reset();
        } else if (lowerPath.endsWith(".2d") || lowerPath.endsWith(".vfd")) {
            this.vm.fdc.fdc_setdisk(0, path);
            this.vm.reset();
        }
        this.sys_cmd.resetDriveMenu(0);
        this.sys_cmd.resetDriveMenu(1);
    }

    void setWindowIcon(String iconname) {
        Image image;
        URL url = ClassLoader.getSystemClassLoader().getResource(iconname);
        if (url != null && (image = Toolkit.getDefaultToolkit().getImage(url)) != null) {
            this.setIconImage(image);
        }
    }

    public static void main(String[] args) {
        System.setProperty("swing.plaf.metal.controlFont", "Dialog-12");
        Sys_main sys_main = new Sys_main("XM7");
        sys_main.init(args);
        sys_main.setVisible(true);
        sys_main.pack();
        sys_main.start();
    }

    private class ResizeAdapter
    extends ComponentAdapter {
        private ResizeAdapter() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            Sys_main.this.crtview.setPreferredSize(new Dimension(Sys_main.this.getWidth() - Sys_main.this.getInsets().left - Sys_main.this.getInsets().right, Sys_main.this.getHeight() - Sys_main.this.getInsets().top - Sys_main.this.getInsets().bottom - Sys_main.this.statusbar.getHeight() - Sys_main.this.sys_cmd.mb.getHeight()));
        }
    }
}

