/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.fmgen.OPN;
import emu.xm7.sys.File;
import emu.xm7.sys.Sys_main;
import emu.xm7.sys.Sys_util;
import emu.xm7.vm.System;
import java.io.IOException;
import java.io.RandomAccessFile;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class Sys_snd {
    int nSampleRate;
    int nSoundBuffer;
    int nStereoOut;
    private boolean bFMHQmode;
    private boolean bForceStereo;
    int nBeepFreq;
    boolean bTapeMon;
    private RandomAccessFile hWavCapture;
    private boolean bWavCapture;
    private int uSeekVolume;
    private int[] lpsbuf;
    private int uBufSize;
    private int uRate;
    private int uTick;
    private boolean bMode;
    private int nStereo;
    private int uBeep;
    private OPN[] pOPN = new OPN[3];
    private int[] nScale = new int[3];
    private int[] uCh3Mode = new int[3];
    private boolean bInitFlag;
    private int uChannels;
    private boolean bBeepFlag;
    private int[] pWavCapture;
    private int nWavCapture;
    private int dwWavCapture;
    private boolean bTapeFlag;
    private boolean bTapeFlag2;
    private int uTapeDelta;
    private boolean bLineFlag;
    private final double log10 = Math.log(10.0);
    private byte[] lpsStream;
    private SourceDataLine line;
    private int audioWrPtr;
    private int audioRdPtr;
    private boolean bRunning;
    _WAVDATA[] Wav = new _WAVDATA[3];
    _WAVPLAY[] WavP = new _WAVPLAY[20];
    String[] WavName = new String[]{"RELAY_ON.WAV", "RELAYOFF.WAV", "FDDSEEK.WAV"};
    private Sys_main sysmain;
    private System vm;

    Sys_snd(Sys_main sysmain, System vm) {
        this.sysmain = sysmain;
        this.vm = vm;
    }

    void InitSnd() {
        this.nSampleRate = 22050;
        this.nSoundBuffer = 100;
        this.bFMHQmode = false;
        this.nBeepFreq = 1200;
        this.nStereoOut = 0;
        this.bForceStereo = false;
        this.bTapeMon = true;
        this.hWavCapture = null;
        this.bWavCapture = false;
        this.pWavCapture = null;
        this.nWavCapture = 0;
        this.dwWavCapture = 0;
        this.lpsbuf = null;
        this.uBufSize = 0;
        this.uRate = 0;
        this.uBeep = 0;
        this.bMode = false;
        this.nStereo = 0;
        this.uChannels = 1;
        this.bBeepFlag = false;
        this.bTapeFlag = false;
        this.bTapeFlag2 = false;
        this.uTapeDelta = 0;
        this.pOPN[0] = null;
        this.pOPN[1] = null;
        this.pOPN[2] = null;
        this.nScale[0] = 0;
        this.nScale[1] = 0;
        this.nScale[2] = 0;
        int i = 0;
        while (i < this.uCh3Mode.length) {
            this.uCh3Mode[i] = 255;
            ++i;
        }
        this.bInitFlag = false;
        this.uSeekVolume = 128;
        this.bLineFlag = false;
        this.lpsStream = null;
        this.line = null;
        this.bRunning = false;
        this.InitFDDSnd();
        this.SelectSnd();
    }

    private void CleanSnd() {
        this.uRate = 0;
        this.StopSnd();
        int i = 0;
        while (i < 3) {
            if (this.pOPN[i] != null) {
                this.pOPN[i] = null;
            }
            ++i;
        }
        if (this.lpsbuf != null) {
            this.lpsbuf = null;
        }
        if (this.lpsStream != null) {
            this.lpsStream = null;
        }
        if (this.line != null && this.bLineFlag) {
            this.line.stop();
            this.line.flush();
            this.line.close();
            this.line = null;
        }
        if (this.hWavCapture != null) {
            this.CloseCaptureSnd();
        }
        if (this.pWavCapture != null) {
            this.pWavCapture = null;
        }
        this.hWavCapture = null;
        this.bWavCapture = false;
        this.CleanFDDSnd();
    }

    public void finalize() {
        this.CleanSnd();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean LoadWav(String fname, _WAVDATA wav) {
        byte[] buf = new byte[16];
        RandomAccessFile fileh = File.open(String.valueOf(Sys_util.ROM) + Sys_util.SEP + fname, 1);
        if (fileh == null) {
            return false;
        }
        try {
            File.read(fileh, buf, 4);
            int filSize = File.dword_read_le(fileh);
            String RIFFHEADER = new String(buf, 0, 4);
            if (!RIFFHEADER.equals("RIFF")) {
                File.close(fileh);
                return false;
            }
            filSize += 8;
            File.read(fileh, buf, 8);
            int hdrSize = File.dword_read_le(fileh);
            String WAVEHEADER = new String(buf, 0, 8);
            if (!WAVEHEADER.equals("WAVEfmt ")) {
                File.close(fileh);
                return false;
            }
            hdrSize += 20;
            if (File.word_read_le(fileh) != 1) {
                File.close(fileh);
                return false;
            }
            if (File.word_read_le(fileh) != 1) {
                File.close(fileh);
                return false;
            }
            int SamplesPerSec = File.dword_read_le(fileh);
            File.dword_read_le(fileh);
            File.word_read_le(fileh);
            if (File.word_read_le(fileh) != 16) {
                File.close(fileh);
                return false;
            }
            while (hdrSize < filSize) {
                File.seek(fileh, hdrSize);
                File.read(fileh, buf, 4);
                int datSize = File.dword_read_le(fileh);
                hdrSize += datSize + 8;
                String DATACHANK = new String(buf, 0, 4);
                if (!DATACHANK.equals("data")) continue;
                wav.size = datSize / 2;
                wav.freq = SamplesPerSec;
                wav.p = new int[datSize];
                if (wav.p == null) {
                    File.close(fileh);
                    return false;
                }
                int i = 0;
                while (true) {
                    if (i >= wav.size / 2) {
                        File.close(fileh);
                        return true;
                    }
                    wav.p[i] = File.word_read_le(fileh);
                    if (wav.p[i] > Short.MAX_VALUE) {
                        int n = i;
                        wav.p[n] = wav.p[n] | 0xFFFF0000;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            File.close(fileh);
            return false;
        }
        File.close(fileh);
        return false;
    }

    private void InitFDDSnd() {
        int i = 0;
        while (i < 20) {
            this.WavP[i] = new _WAVPLAY();
            ++i;
        }
        i = 0;
        while (i < this.Wav.length) {
            this.Wav[i] = new _WAVDATA();
            if (!this.LoadWav(this.WavName[i], this.Wav[i])) {
                this.Wav[i].size = 0;
                this.Wav[i].freq = 0;
            }
            ++i;
        }
    }

    private void CleanFDDSnd() {
        int i = 0;
        while (i < this.Wav.length) {
            if (this.Wav[i].p != null) {
                this.Wav[i].p = null;
            }
            ++i;
        }
    }

    private void SetReg(OPN pOPN, int[] reg) {
        int i = 0;
        while (i < 16) {
            pOPN.SetReg(i, reg[i]);
            ++i;
        }
        i = 0;
        while (i < 3) {
            pOPN.SetReg(40, i);
            ++i;
        }
        i = 48;
        while (i < 180) {
            pOPN.SetReg(i, reg[i]);
            ++i;
        }
        pOPN.SetReg(39, reg[39] & 0xC0);
    }

    private boolean SelectSnd() {
        this.bInitFlag = true;
        this.uRate = this.nSampleRate;
        this.uTick = this.nSoundBuffer;
        this.bMode = this.bFMHQmode;
        this.nStereo = this.nStereoOut;
        this.uTapeDelta = 0;
        this.uChannels = this.nStereo > 0 || this.bForceStereo ? 2 : 1;
        if (this.uRate == 0) {
            return true;
        }
        if (this.line != null) {
            this.line.stop();
            this.line.flush();
            this.line.close();
            this.line = null;
        }
        if (this.lpsStream != null) {
            this.lpsStream = null;
        }
        if (this.lpsbuf != null) {
            this.lpsbuf = null;
        }
        this.uBufSize = this.uRate * this.uChannels / 1000;
        this.uBufSize -= this.uBufSize % (this.uChannels << 2);
        this.lpsbuf = new int[this.uBufSize];
        int i = 0;
        while (i < this.lpsbuf.length) {
            this.lpsbuf[i] = 0;
            ++i;
        }
        this.lpsStream = new byte[this.uTick * this.uBufSize * 2];
        i = 0;
        while (i < this.lpsStream.length) {
            this.lpsStream[i] = 0;
            ++i;
        }
        this.audioRdPtr = 0;
        this.audioWrPtr = 0;
        this.bLineFlag = true;
        AudioFormat format = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, this.uRate, 16, this.uChannels, this.uChannels * 2, this.uRate, true);
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, format, this.uTick * this.uBufSize * 2);
        if (!AudioSystem.isLineSupported(info)) {
            this.bLineFlag = false;
            return false;
        }
        try {
            this.line = (SourceDataLine)AudioSystem.getLine(info);
            this.line.open();
        }
        catch (LineUnavailableException lue) {
            this.bLineFlag = false;
            return false;
        }
        this.pOPN[0] = new OPN();
        this.pOPN[0].Init(1228800, this.uRate, this.bMode, null);
        this.pOPN[0].Reset();
        this.pOPN[0].SetReg(39, 0);
        this.pOPN[1] = new OPN();
        this.pOPN[1].Init(1228800, this.uRate, this.bMode, null);
        this.pOPN[1].Reset();
        this.pOPN[1].SetReg(39, 0);
        this.pOPN[2] = new OPN();
        this.pOPN[2].Init(1228800, this.uRate, this.bMode, null);
        this.pOPN[2].Reset();
        this.pOPN[2].SetReg(39, 0);
        this.nScale[0] = 0;
        this.nScale[1] = 0;
        this.nScale[2] = 0;
        this.opn_notify(39, 0);
        this.whg_notify(39, 0);
        this.thg_notify(39, 0);
        this.SetReg(this.pOPN[0], this.vm.opn.opn_reg);
        this.SetReg(this.pOPN[1], this.vm.whg.whg_reg);
        this.SetReg(this.pOPN[2], this.vm.thg.thg_reg);
        if (this.pWavCapture == null) {
            this.pWavCapture = new int[65536];
        }
        this.PlaySnd();
        return true;
    }

    void ApplySnd() {
        if (!this.bInitFlag) {
            return;
        }
        if (this.uRate == this.nSampleRate && this.uTick == this.nSoundBuffer && this.bMode == this.bFMHQmode && this.nStereo == this.nStereoOut) {
            return;
        }
        if (this.uRate != 0) {
            this.CleanSnd();
        }
        this.SelectSnd();
    }

    void PlaySnd() {
        if (this.bRunning) {
            return;
        }
        if (this.line != null && this.bLineFlag) {
            this.line.start();
        }
    }

    void StopSnd() {
        if (!this.bRunning) {
            return;
        }
        this.bRunning = false;
        if (this.line != null && this.bLineFlag) {
            this.line.stop();
            this.line.flush();
        }
    }

    private void BeepSnd(int[] buf, int offset, int samples) {
        if (!this.bBeepFlag) {
            return;
        }
        int i = 0;
        while (i < samples) {
            int sf = this.uBeep * this.nBeepFreq * 2;
            sf /= this.uRate;
            if (this.uChannels == 1) {
                if ((sf & 1) != 0) {
                    int n = offset++;
                    buf[n] = buf[n] + 2048;
                } else {
                    int n = offset++;
                    buf[n] = buf[n] - 2048;
                }
            } else if ((sf & 1) != 0) {
                int n = offset++;
                buf[n] = buf[n] + 2048;
                int n2 = offset++;
                buf[n2] = buf[n2] + 2048;
            } else {
                int n = offset++;
                buf[n] = buf[n] - 2048;
                int n3 = offset++;
                buf[n3] = buf[n3] - 2048;
            }
            ++this.uBeep;
            if (this.uBeep >= this.uRate) {
                this.uBeep = 0;
            }
            ++i;
        }
    }

    private void TapeSnd(int[] buf, int offset, int samples) {
        if (!this.vm.tapelp.tape_motor || !this.bTapeMon) {
            return;
        }
        int tmp = this.uRate == 48000 || this.uRate == 96000 ? this.uRate * 5 / 48000 : this.uRate * 4 / 44100;
        if (this.bTapeFlag != this.bTapeFlag2) {
            this.uTapeDelta = this.uTapeDelta == 0 ? 1 : tmp - this.uTapeDelta + 1;
        }
        int i = 0;
        while (i < samples) {
            int dat;
            if (this.uTapeDelta != 0) {
                dat = 4096 / tmp * this.uTapeDelta;
                dat = this.bTapeFlag ? (dat -= 2049) : 2048 - dat;
                ++this.uTapeDelta;
                if (this.uTapeDelta > tmp) {
                    this.uTapeDelta = 0;
                }
            } else {
                dat = this.bTapeFlag ? 2047 : -2048;
            }
            int n = offset++;
            buf[n] = buf[n] + dat;
            if (this.uChannels == 2) {
                int n2 = offset++;
                buf[n2] = buf[n2] + dat;
            }
            ++i;
        }
        this.bTapeFlag2 = this.bTapeFlag;
    }

    private void WaveSnd(int[] buf, int offset, int samples) {
        int i = 0;
        while (i < samples) {
            int j = 0;
            while (j < 20) {
                if (this.WavP[j].bPlay) {
                    int dat = this.Wav[this.WavP[j].dwWaveNo].p[this.WavP[j].dwCount1];
                    dat = dat * this.uSeekVolume >> 8;
                    int n = offset;
                    buf[n] = buf[n] + dat;
                    if (this.uChannels == 2) {
                        int n2 = offset + 1;
                        buf[n2] = buf[n2] + dat;
                    }
                    this.WavP[j].dwCount2 += this.Wav[this.WavP[j].dwWaveNo].freq / this.uRate << 16;
                    if (this.WavP[j].dwCount2 > 65536) {
                        this.WavP[j].dwCount1 += this.WavP[j].dwCount2 >> 16;
                        this.WavP[j].dwCount2 &= 0xFFFF;
                        if (this.WavP[j].dwCount1 >= this.Wav[this.WavP[j].dwWaveNo].size) {
                            this.WavP[j].bPlay = false;
                        }
                    }
                    ++this.WavP[j].dwCount3;
                }
                ++j;
            }
            ++offset;
            if (this.uChannels == 2) {
                ++offset;
            }
            ++i;
        }
    }

    private void AddSnd(boolean bZero) {
        if (this.pOPN[2] == null) {
            return;
        }
        int samples = this.uBufSize / this.uChannels;
        int i = 0;
        while (i < this.lpsbuf.length) {
            this.lpsbuf[i] = 0;
            ++i;
        }
        if (!bZero) {
            if (this.uChannels == 1) {
                if (this.pOPN[0] != null) {
                    this.pOPN[0].Mix(this.lpsbuf, samples);
                }
                if (this.vm.whg.whg_use) {
                    this.pOPN[1].Mix(this.lpsbuf, samples);
                }
                if (this.vm.thg.thg_use) {
                    this.pOPN[2].Mix(this.lpsbuf, samples);
                }
            } else if (!this.vm.whg.whg_use && !this.vm.thg.thg_use) {
                this.pOPN[0].Mix2(this.lpsbuf, samples, 16, 16);
            } else {
                switch (this.nStereo) {
                    case 0: {
                        this.pOPN[0].Mix2(this.lpsbuf, samples, 16, 16);
                        if (this.vm.whg.whg_use) {
                            this.pOPN[1].Mix2(this.lpsbuf, samples, 16, 16);
                        }
                        if (!this.vm.thg.thg_use) break;
                        this.pOPN[2].Mix2(this.lpsbuf, samples, 16, 16);
                        break;
                    }
                    case 1: {
                        this.pOPN[0].Mix2(this.lpsbuf, samples, 23, 9);
                        if (this.vm.whg.whg_use) {
                            this.pOPN[1].Mix2(this.lpsbuf, samples, 9, 23);
                        }
                        if (!this.vm.thg.thg_use) break;
                        this.pOPN[2].Mix2(this.lpsbuf, samples, 16, 16);
                        break;
                    }
                    case 2: {
                        this.pOPN[0].Mix2(this.lpsbuf, samples, 9, 23);
                        if (this.vm.whg.whg_use) {
                            this.pOPN[1].Mix2(this.lpsbuf, samples, 23, 9);
                        }
                        if (!this.vm.thg.thg_use) break;
                        this.pOPN[2].Mix2(this.lpsbuf, samples, 16, 16);
                        break;
                    }
                    case 3: {
                        this.pOPN[0].Mix2(this.lpsbuf, samples, 16, 16);
                        if (this.vm.whg.whg_use) {
                            this.pOPN[1].Mix2(this.lpsbuf, samples, 9, 23);
                        }
                        if (!this.vm.thg.thg_use) break;
                        this.pOPN[2].Mix2(this.lpsbuf, samples, 23, 9);
                    }
                }
            }
            this.TapeSnd(this.lpsbuf, 0, samples);
            this.BeepSnd(this.lpsbuf, 0, samples);
            this.WaveSnd(this.lpsbuf, 0, samples);
        }
    }

    private void WavCapture() {
        if (this.hWavCapture == null) {
            return;
        }
        int p = 0;
        int nSize = this.uBufSize;
        if (!this.bWavCapture) {
            while (nSize > 0) {
                if (this.uChannels == 1) {
                    if (this.lpsbuf[p] != 0) break;
                    --nSize;
                    ++p;
                    continue;
                }
                if (this.lpsbuf[p] != 0 || this.lpsbuf[p + 1] != 0) break;
                nSize -= 2;
                p += 2;
            }
            if (nSize == 0) {
                return;
            }
        }
        if (this.nWavCapture + nSize >= 32768) {
            File.write(this.hWavCapture, this.pWavCapture, this.nWavCapture * 2);
            this.dwWavCapture += this.nWavCapture * 2;
            this.nWavCapture = 0;
        }
        int i = 0;
        while (i < nSize) {
            this.pWavCapture[i + this.nWavCapture << 1] = (byte)(this.lpsbuf[p + i] & 0xFF);
            this.pWavCapture[(i + this.nWavCapture << 1) + 1] = (byte)(this.lpsbuf[p + i] >> 8);
            ++i;
        }
        this.nWavCapture += nSize;
        this.bWavCapture = true;
    }

    void ProcessSnd(boolean bZero) {
        if (this.uRate == 0 || bZero) {
            return;
        }
        this.AddSnd(bZero);
        this.WavCapture();
        if (!this.bLineFlag) {
            return;
        }
        int i = 0;
        int j = 0;
        while (i < this.uBufSize) {
            int t = this.lpsbuf[i++];
            this.lpsStream[this.audioWrPtr + j++] = (byte)(t >> 8);
            this.lpsStream[this.audioWrPtr + j++] = (byte)(t & 0xFF);
        }
        int bytesToWrite = j;
        this.audioWrPtr += bytesToWrite;
        if (this.audioWrPtr >= this.lpsStream.length) {
            this.audioWrPtr = 0;
        }
        if (!this.bRunning) {
            int threshold;
            int bytesFilled = this.audioWrPtr - this.audioRdPtr;
            if (bytesFilled < 0) {
                bytesFilled += this.lpsStream.length;
            }
            if (bytesFilled < (threshold = this.lpsStream.length >> 1)) {
                return;
            }
            this.bRunning = true;
        }
        int bytesWritten = this.line.write(this.lpsStream, this.audioRdPtr, bytesToWrite);
        this.audioRdPtr += bytesWritten;
        if (this.audioRdPtr >= this.lpsStream.length) {
            this.audioRdPtr = 0;
        }
    }

    int GetLevelSnd(int ch) {
        double s;
        OPN p = null;
        if (ch < 6) {
            p = this.pOPN[0];
        }
        if (ch >= 6 && ch < 12) {
            p = this.pOPN[1];
            ch -= 6;
            if (!this.vm.whg.whg_enable || !this.vm.whg.whg_use) {
                return 0;
            }
        }
        if (ch >= 12 && ch < 18) {
            p = this.pOPN[2];
            ch -= 12;
            if (!this.vm.thg.thg_enable || !this.vm.thg.thg_use) {
                return 0;
            }
        }
        if (p == null) {
            return 0;
        }
        if (ch < 3) {
            int[] buf = p.rbuf(ch);
            s = 0.0;
            int i = 0;
            while (i < 512) {
                double t = buf[i];
                t *= t;
                s += t;
                ++i;
            }
            if ((s /= 512.0) == 0.0) {
                return 0;
            }
            s = Math.log(s) / this.log10;
            s *= 40.0;
        } else {
            int[] buf = p.psg.rbuf(ch - 3);
            s = 0.0;
            int i = 0;
            while (i < 512) {
                double t = buf[i];
                t *= t;
                s += t;
                ++i;
            }
            if ((s /= 512.0) == 0.0) {
                return 0;
            }
            s = Math.log(s) / this.log10;
            s *= 60.0;
        }
        return (int)s;
    }

    void OpenCaptureSnd(String fname) {
        byte[] RIFFHEADER = null;
        byte[] DATAHEADER = null;
        try {
            RIFFHEADER = "RIFF\u6ec5\u6bbaWAVEfmt ".getBytes("MS932");
            DATAHEADER = "data\u6ec5\u6bba".getBytes("MS932");
        }
        catch (Exception e) {
            return;
        }
        if (this.pOPN[2] == null) {
            return;
        }
        if (this.pWavCapture == null) {
            return;
        }
        if (this.uBufSize / 2 > 32768) {
            return;
        }
        RandomAccessFile fileh = File.open(fname, 2, true);
        if (fileh == null) {
            return;
        }
        if (!File.write(fileh, RIFFHEADER, 16)) {
            File.close(fileh);
            return;
        }
        int dwSize = 16;
        if (!File.dword_write_le(fileh, dwSize)) {
            File.close(fileh);
            return;
        }
        if (!File.word_write_le(fileh, 1)) {
            File.close(fileh);
            return;
        }
        if (!File.word_write_le(fileh, this.uChannels)) {
            File.close(fileh);
            return;
        }
        if (!File.dword_write_le(fileh, this.uRate)) {
            File.close(fileh);
            return;
        }
        if (!File.dword_write_le(fileh, this.uRate * this.uChannels * 2)) {
            File.close(fileh);
            return;
        }
        if (!File.word_write_le(fileh, this.uChannels * 2)) {
            File.close(fileh);
            return;
        }
        if (!File.word_write_le(fileh, 16)) {
            File.close(fileh);
            return;
        }
        if (!File.write(fileh, DATAHEADER, 8)) {
            File.close(fileh);
            return;
        }
        this.nWavCapture = 0;
        this.dwWavCapture = 0;
        this.bWavCapture = false;
        this.hWavCapture = fileh;
    }

    void CloseCaptureSnd() {
        File.write(this.hWavCapture, this.pWavCapture, this.nWavCapture * 2);
        this.dwWavCapture += this.nWavCapture * 2;
        this.nWavCapture = 0;
        File.seek(this.hWavCapture, 4);
        int dwLength = this.dwWavCapture + 16 + 20;
        File.dword_write_le(this.hWavCapture, dwLength);
        File.seek(this.hWavCapture, 40);
        File.dword_write_le(this.hWavCapture, this.dwWavCapture);
        File.close(this.hWavCapture);
        this.hWavCapture = null;
        this.bWavCapture = false;
    }

    public void opn_notify(int reg, int dat) {
        if (this.pOPN[0] == null) {
            return;
        }
        if (this.vm.opn.opn_scale != this.nScale[0]) {
            this.nScale[0] = this.vm.opn.opn_scale;
            switch (this.vm.opn.opn_scale) {
                case 2: {
                    this.pOPN[0].SetReg(47, 0);
                    break;
                }
                case 3: {
                    this.pOPN[0].SetReg(46, 0);
                    break;
                }
                case 6: {
                    this.pOPN[0].SetReg(45, 0);
                }
            }
        }
        if (reg == 39) {
            if (this.uCh3Mode[0] == dat) {
                return;
            }
            this.uCh3Mode[0] = dat;
        }
        if (reg == 255 && (this.vm.opn.opn_reg[39] & 0xC0) != 128) {
            return;
        }
        this.pOPN[0].SetReg(reg, dat);
    }

    public void whg_notify(int reg, int dat) {
        if (this.pOPN[1] == null) {
            return;
        }
        if (this.vm.whg.whg_scale != this.nScale[1]) {
            this.nScale[1] = this.vm.whg.whg_scale;
            switch (this.vm.whg.whg_scale) {
                case 2: {
                    this.pOPN[1].SetReg(47, 0);
                    break;
                }
                case 3: {
                    this.pOPN[1].SetReg(46, 0);
                    break;
                }
                case 6: {
                    this.pOPN[1].SetReg(45, 0);
                }
            }
        }
        if (reg == 39) {
            if (this.uCh3Mode[1] == dat) {
                return;
            }
            this.uCh3Mode[1] = dat;
        }
        if (reg == 255 && (this.vm.whg.whg_reg[39] & 0xC0) != 128) {
            return;
        }
        this.pOPN[1].SetReg(reg, dat);
    }

    public void thg_notify(int reg, int dat) {
        if (this.pOPN[2] == null) {
            return;
        }
        if (this.vm.thg.thg_scale != this.nScale[2]) {
            this.nScale[2] = this.vm.thg.thg_scale;
            switch (this.vm.thg.thg_scale) {
                case 2: {
                    this.pOPN[2].SetReg(47, 0);
                    break;
                }
                case 3: {
                    this.pOPN[2].SetReg(46, 0);
                    break;
                }
                case 6: {
                    this.pOPN[2].SetReg(45, 0);
                }
            }
        }
        if (reg == 39) {
            if (this.uCh3Mode[2] == dat) {
                return;
            }
            this.uCh3Mode[2] = dat;
        }
        if (reg == 255 && (this.vm.thg.thg_reg[39] & 0xC0) != 128) {
            return;
        }
        this.pOPN[2].SetReg(reg, dat);
    }

    public void beep_notify() {
        if (!(this.vm.mainetc.beep_flag & this.vm.mainetc.speaker_flag ^ this.bBeepFlag)) {
            return;
        }
        this.bBeepFlag = this.vm.mainetc.beep_flag && this.vm.mainetc.speaker_flag;
    }

    public void tape_notify(boolean flag) {
        if (this.bTapeFlag == flag) {
            return;
        }
        this.bTapeFlag = flag;
    }

    public void wav_notify(int no) {
        if (no == 255) {
            int i = 0;
            while (i < 20) {
                this.WavP[i].bPlay = false;
                ++i;
            }
        } else if (this.Wav[no].freq != 0) {
            int j = 0;
            int k = 0;
            int i = 0;
            while (i < 20) {
                if (!this.WavP[i].bPlay) {
                    j = i;
                    break;
                }
                if (k < this.WavP[i].dwCount3) {
                    k = this.WavP[i].dwCount3;
                    j = i;
                }
                ++i;
            }
            this.WavP[j].dwWaveNo = no;
            this.WavP[j].dwCount1 = 0;
            this.WavP[j].dwCount2 = 0;
            this.WavP[j].dwCount3 = 0;
            this.WavP[j].bPlay = true;
        }
    }

    private class _WAVDATA {
        int[] p = null;
        int size = 0;
        int freq = 0;

        private _WAVDATA() {
        }
    }

    private class _WAVPLAY {
        boolean bPlay = false;
        int dwWaveNo = 0;
        int dwCount1 = 0;
        int dwCount2 = 0;
        int dwCount3 = 0;

        private _WAVPLAY() {
        }
    }
}

