/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Display
extends Base
implements EventHandler {
    public boolean crt_flag;
    boolean vrama_flag;
    private int[] vram_offset = new int[2];
    private int[] crtc_offset = new int[2];
    private boolean vram_offset_flag;
    private boolean subnmi_flag;
    boolean vsync_flag;
    boolean blank_flag;
    int vram_active;
    byte[] vram_aptr_v;
    int vram_aptr_p;
    private int vram_display;
    public byte[] vram_dptr_v;
    public int vram_dptr_p;
    public int screen_mode;
    int subram_vrambank;
    private int sub_kanji_addr;
    private boolean sub_kanji_bank;
    public int window_x1;
    public int window_dx1;
    public int window_y1;
    public int window_dy1;
    public int window_x2;
    public int window_dx2;
    public int window_y2;
    public int window_dy2;
    private boolean window_open;
    private int block_active;
    byte[] vram_ablk_v;
    int vram_ablk_p;
    private int block_display;
    public byte[] vram_bdptr_v;
    public int vram_bdptr_p;
    private byte[] vram_buf;
    private int[] vram_offset_count = new int[2];
    private int blank_count;
    private final int subcpu_event = 1;
    private final int display_vsync = 2;
    private final int display_blank = 3;
    private final int mainetc_beep = 1;

    Display() {
    }

    boolean init() {
        this.vram_buf = Util.malloc(32768);
        return this.vram_buf != null;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        if (this.vram_buf != null) {
            Util.free(this.vram_buf);
        }
    }

    void reset() {
        this.crt_flag = false;
        this.vrama_flag = false;
        Util.memset(this.vram_offset, 0, Util.sizeof(this.vram_offset));
        Util.memset(this.crtc_offset, 0, Util.sizeof(this.crtc_offset));
        this.vram_offset_flag = false;
        Util.memset(this.vram_offset_count, 0, Util.sizeof(this.vram_offset_count));
        this.subnmi_flag = true;
        this.vsync_flag = false;
        this.blank_flag = true;
        this.vram_active = 0;
        this.vram_aptr_v = Display.submem.vram_c;
        this.vram_aptr_p = 0;
        this.vram_display = 0;
        this.vram_dptr_v = Display.submem.vram_c;
        this.vram_dptr_p = 0;
        this.subram_vrambank = 0;
        this.window_x2 = 0;
        this.window_x1 = 0;
        this.window_y2 = 0;
        this.window_y1 = 0;
        this.window_dx2 = 0;
        this.window_dx1 = 0;
        this.window_dy2 = 0;
        this.window_dy1 = 0;
        this.window_open = false;
        this.block_active = 0;
        this.block_display = 0;
        this.vram_ablk_v = Display.submem.vram_c;
        this.vram_ablk_p = 0;
        this.vram_bdptr_v = Display.submem.vram_c;
        this.vram_bdptr_p = 98304;
        this.sub_kanji_addr = 0;
        this.sub_kanji_bank = false;
        schedule.setevent(1, 20000, this, 1);
        this.setup();
    }

    @Override
    public boolean event(int callbackid) {
        if (callbackid == 3) {
            return this.blank();
        }
        if (callbackid == 2) {
            return this.vsync();
        }
        if (callbackid == 1) {
            return this.subcpu_event();
        }
        return true;
    }

    private boolean vsync() {
        if (!this.vsync_flag) {
            if ((this.blank_count & 0xFFF) > 0) {
                this.setup();
                return true;
            }
            this.vsync_flag = true;
            if ((this.blank_count & 0x1000) != 0) {
                schedule.setevent(6, 330, this, 2);
            } else {
                schedule.setevent(6, 510, this, 2);
            }
            if (Display.keyboard.digitize_enable && (Display.keyboard.digitize_keywait || Display.keyboard.simpose_mode == 3)) {
                Display.sysmain.sys_dsp.digitize_notify();
            }
        } else {
            this.vsync_flag = false;
            if ((this.blank_count & 0x1000) != 0) {
                schedule.setevent(6, 17380, this, 2);
            } else {
                schedule.setevent(6, 14610, this, 2);
            }
            Display.sysmain.sys_sch.vsync_notify();
        }
        return true;
    }

    private boolean blank() {
        if ((this.blank_count & 0xFFF) == 0 && this.blank_flag) {
            if ((this.blank_count & 0x1000) != 0) {
                schedule.setevent(7, 11, this, 3);
            } else {
                schedule.setevent(7, 24, this, 3);
            }
            ++this.blank_count;
            return true;
        }
        if (this.blank_flag) {
            this.blank_flag = false;
            if ((this.blank_count & 0x1000) != 0) {
                schedule.setevent(7, 30, this, 3);
            } else {
                schedule.setevent(7, 39 + (this.blank_count & 1), this, 3);
            }
            ++this.blank_count;
            return true;
        }
        this.blank_flag = true;
        if ((this.blank_count & 0x1000) != 0) {
            schedule.setevent(7, 11, this, 3);
        } else {
            schedule.setevent(7, 24, this, 3);
        }
        return true;
    }

    private void setup() {
        if (this.screen_mode == 2) {
            this.blank_count = 4096;
            schedule.setevent(6, 340, this, 2);
            schedule.setevent(7, 1650, this, 3);
        } else {
            this.blank_count = 0;
            schedule.setevent(6, 1520, this, 2);
            schedule.setevent(7, 3940, this, 3);
        }
        this.vsync_flag = false;
        this.blank_flag = true;
    }

    private boolean subcpu_event() {
        if (!this.subnmi_flag) {
            return false;
        }
        subcpu.nmi();
        return true;
    }

    void setpointer(boolean redraw) {
        this.screen_mode = Display.subctrl.mode400l ? 2 : (Display.subctrl.mode256k ? 3 : (Display.subctrl.mode320 ? 1 : 0));
        this.vram_aptr_v = Display.submem.vram_c;
        this.vram_aptr_p = 0;
        this.vram_ablk_v = Display.submem.vram_c;
        this.vram_ablk_p = 0;
        switch (this.screen_mode) {
            case 2: {
                this.vram_aptr_p += this.subram_vrambank * 32768;
                if (this.block_active == 0) break;
                this.vram_aptr_p += 98304;
                this.vram_ablk_p += 98304;
                break;
            }
            case 3: {
                switch (this.subram_vrambank) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        this.vram_aptr_p += 16384;
                        break;
                    }
                    case 2: {
                        this.vram_aptr_p += 98304;
                    }
                }
                break;
            }
            default: {
                if (this.vram_active != 0) {
                    this.vram_aptr_p += 16384;
                }
                if (this.block_active == 0) break;
                this.vram_aptr_p += 98304;
            }
        }
        this.vram_dptr_v = Display.submem.vram_c;
        this.vram_dptr_p = 0;
        if (this.screen_mode == 0 && this.vram_display != 0) {
            this.vram_dptr_p += 16384;
        }
        this.vram_bdptr_v = this.vram_dptr_v;
        this.vram_bdptr_p = this.vram_dptr_p;
        if (this.block_display != 0) {
            this.vram_dptr_p += 98304;
        } else {
            this.vram_bdptr_p += 98304;
        }
        if (redraw) {
            Display.sysmain.sys_dsp.display_notify();
        }
    }

    private void check_window_open() {
        if (this.window_x1 < this.window_x2 && this.window_y1 < this.window_y2) {
            this.window_open = true;
        } else {
            this.window_open = false;
            this.window_dx1 = 0;
            this.window_dx2 = 0;
            this.window_dy1 = 0;
            this.window_dy2 = 0;
        }
        Display.sysmain.sys_dsp.window_notify();
    }

    public void window_clip(int mode) {
        int[] max_x = new int[]{640, 320, 640, 320};
        int[] max_y = new int[]{200, 200, 400, 200};
        this.window_dx1 = this.window_x1;
        this.window_dx2 = this.window_x2;
        if (this.window_dx1 > max_x[mode]) {
            this.window_dx1 = max_x[mode];
        }
        if (this.window_dx2 > max_x[mode]) {
            this.window_dx2 = max_x[mode];
        }
        this.window_dy1 = this.window_y1;
        this.window_dy2 = this.window_y2;
        if (this.window_dy1 > max_y[mode]) {
            this.window_dy1 = max_y[mode];
        }
        if (this.window_dy2 > max_y[mode]) {
            this.window_dy2 = max_y[mode];
        }
    }

    private void vram_scroll_analog(int offset, int addr) {
        byte[] vram_c = Display.submem.vram_c;
        int i = 0;
        while (i < 3) {
            int vram = addr + 32768 * i;
            Util.memcpy(this.vram_buf, 0, vram_c, vram, offset);
            Util.memcpy(this.vram_buf, 8192, vram_c, vram + 8192, offset);
            Util.memcpy(vram_c, vram, vram_c, vram + offset, 16384 - offset);
            Util.memcpy(vram_c, vram + (8192 - offset), this.vram_buf, 0, offset);
            Util.memcpy(vram_c, vram + (16384 - offset), this.vram_buf, 8192, offset);
            ++i;
        }
    }

    private void memcpy400l(byte[] dest, int doff, byte[] src, int soff, int siz) {
        siz >>= 1;
        while (siz > 0) {
            dest[doff] = src[soff];
            doff += 2;
            soff += 2;
            --siz;
        }
    }

    private void vram_scroll(int offset) {
        byte[] vram_c = Display.submem.vram_c;
        if (this.screen_mode == 2) {
            offset &= 0x3FFF;
            offset <<= 1;
            int i = 0;
            while (i < 3) {
                int vram = 32768 * i + this.vram_active;
                this.memcpy400l(this.vram_buf, 0, vram_c, vram, offset);
                this.memcpy400l(vram_c, vram, vram_c, vram + offset, 32768 - offset);
                this.memcpy400l(vram_c, vram + (32768 - offset), this.vram_buf, 0, offset);
                ++i;
            }
            return;
        }
        if ((this.screen_mode & 1) != 0) {
            offset &= 0x1FFF;
            if (this.vram_active == 1) {
                this.vram_scroll_analog(offset, 16384);
            } else {
                this.vram_scroll_analog(offset, 0);
                if (this.screen_mode == 3) {
                    this.vram_scroll_analog(offset, 98304);
                }
            }
            return;
        }
        offset &= 0x3FFF;
        int i = 0;
        while (i < 3) {
            int vram = 32768 * i;
            if (this.vram_active != 0) {
                vram += 16384;
            }
            Util.memcpy(this.vram_buf, 0, vram_c, vram, offset);
            Util.memcpy(vram_c, vram, vram_c, vram + offset, 16384 - offset);
            Util.memcpy(vram_c, vram + (16384 - offset), this.vram_buf, 0, offset);
            ++i;
        }
    }

    boolean fix_vram_address() {
        byte[] vram_c = Display.submem.vram_c;
        int i = 0;
        while (i < 196608) {
            Util.memcpy(this.vram_buf, 0, vram_c, 16384 + i, 16384);
            Util.memcpy(this.vram_buf, 16384, vram_c, 65536 + i, 16384);
            Util.memcpy(vram_c, 16384 + i, vram_c, 32768 + i, 16384);
            Util.memcpy(vram_c, 65536 + i, vram_c, 49152 + i, 16384);
            Util.memcpy(vram_c, 32768 + i, this.vram_buf, 16384, 16384);
            Util.memcpy(vram_c, 49152 + i, this.vram_buf, 0, 16384);
            i += 98304;
        }
        return true;
    }

    boolean readb(int addr, IntHolder dat) {
        switch (addr) {
            case 54274: {
                Display.subctrl.subcancel_flag = false;
                Display.subctrl.subcancel_request = false;
                subcpu.irq();
                dat.value = 255;
                return true;
            }
            case 54275: {
                Display.mainetc.beep_flag = true;
                schedule.setevent(5, 205000, mainetc, 1);
                Display.sysmain.sys_snd.beep_notify();
                dat.value = 255;
                return true;
            }
            case 54276: {
                Display.subctrl.subattn_flag = true;
                maincpu.firq();
                dat.value = 255;
                return true;
            }
            case 54278: 
            case 54279: {
                if (Display.vm.fm7_ver >= 3) {
                    int offset = this.sub_kanji_addr << 1;
                    dat.value = this.sub_kanji_bank ? Display.kanji.kanji_rom[offset + (addr & 1) + 131072] & 0xFF : Display.kanji.kanji_rom[offset + (addr & 1)] & 0xFF;
                } else {
                    dat.value = 255;
                }
                return true;
            }
            case 54280: {
                if (!this.crt_flag) {
                    this.crt_flag = true;
                    Display.sysmain.sys_dsp.display_notify();
                }
                dat.value = 255;
                return true;
            }
            case 54281: {
                this.vrama_flag = true;
                dat.value = 255;
                return true;
            }
            case 54282: {
                Display.subctrl.subbusy_flag = false;
                dat.value = 255;
                return true;
            }
            case 54318: {
                dat.value = 255;
                return true;
            }
            case 54319: {
                dat.value = Display.vm.fm7_ver >= 3 ? 0xFC | this.subram_vrambank & 3 : 255;
                return true;
            }
            case 54320: {
                if (Display.vm.fm7_ver < 2) break;
                int ret = 255;
                if (this.blank_flag) {
                    ret &= 0xFFFFFF7F;
                }
                if (Display.aluline.line_busy) {
                    ret &= 0xFFFFFFEF;
                    if (Display.aluline.line_boost) {
                        Display.aluline.line_busy = false;
                        schedule.delevent(8);
                    }
                }
                if (!this.vsync_flag) {
                    ret &= 0xFFFFFFFB;
                }
                if (!Display.subctrl.subreset_flag) {
                    ret &= 0xFFFFFFFE;
                }
                dat.value = ret;
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        switch (addr) {
            case 54278: {
                if (Display.vm.fm7_ver >= 3) {
                    this.sub_kanji_addr &= 0xFF;
                    this.sub_kanji_addr |= dat << 8;
                }
                return true;
            }
            case 54279: {
                if (Display.vm.fm7_ver >= 3) {
                    this.sub_kanji_addr &= 0xFF00;
                    this.sub_kanji_addr |= dat;
                }
                return true;
            }
            case 54280: {
                if (this.crt_flag) {
                    this.crt_flag = false;
                    Display.sysmain.sys_dsp.display_notify();
                }
                this.crt_flag = false;
                return true;
            }
            case 54281: {
                this.vrama_flag = false;
                return true;
            }
            case 54282: {
                Display.vm.fetch_op = subcpu.getIr();
                if (Display.vm.fetch_op == 15 || Display.vm.fetch_op == 111 || Display.vm.fetch_op == 127) {
                    Display.subctrl.busy_CLR_flag = true;
                    Display.subctrl.subbusy_flag = false;
                } else {
                    Display.subctrl.subbusy_flag = true;
                }
                return true;
            }
            case 54286: 
            case 54287: {
                int offset;
                if (addr == 54286) {
                    offset = dat & 0x3F;
                    offset <<= 8;
                    offset |= this.vram_offset[this.vram_active] & 0xFF;
                } else {
                    if (!this.vram_offset_flag) {
                        dat &= 0xE0;
                    }
                    offset = this.vram_offset[this.vram_active] & 0x3F00;
                    offset |= dat;
                }
                this.vram_offset[this.vram_active] = offset;
                int n = this.vram_active;
                this.vram_offset_count[n] = this.vram_offset_count[n] + 1;
                if ((this.vram_offset_count[this.vram_active] & 1) == 0) {
                    this.vram_scroll(this.vram_offset[this.vram_active] - this.crtc_offset[this.vram_active]);
                    this.crtc_offset[this.vram_active] = this.vram_offset[this.vram_active];
                    Display.sysmain.sys_dsp.display_notify();
                }
                return true;
            }
            case 54318: {
                if (Display.vm.fm7_ver >= 3) {
                    Display.submem.cgram_bank = dat & 7;
                    Display.submem.consram_bank = dat >> 3 & 3;
                    if (Display.submem.consram_bank == 3) {
                        Display.submem.consram_bank = 0;
                    }
                    this.sub_kanji_bank = (dat & 0x80) != 0;
                }
                return true;
            }
            case 54319: {
                if (Display.vm.fm7_ver >= 3) {
                    this.subram_vrambank = dat & 3;
                    if (this.subram_vrambank == 3) {
                        this.subram_vrambank = 0;
                    }
                    this.setpointer(false);
                }
                return true;
            }
            case 54320: {
                if (Display.vm.fm7_ver >= 2) {
                    boolean redraw_flag = false;
                    if ((dat & 0x80) != 0) {
                        this.subnmi_flag = false;
                        schedule.set_flag(1, 2);
                        Display.subcpu.intr &= 0xFFFFFFFE;
                    } else {
                        this.subnmi_flag = true;
                        schedule.set_flag(1, 1);
                    }
                    this.vram_active = (dat & 0x20) != 0 ? 1 : 0;
                    if ((dat & 0x40) != 0) {
                        if (this.vram_display == 0) {
                            this.vram_display = 1;
                            if (this.screen_mode == 0) {
                                redraw_flag = true;
                            }
                        }
                    } else if (this.vram_display == 1) {
                        this.vram_display = 0;
                        if (this.screen_mode == 0) {
                            redraw_flag = true;
                        }
                    }
                    this.vram_offset_flag = (dat & 4) != 0;
                    Display.submem.cgrom_bank = dat & 3;
                    this.setpointer(redraw_flag);
                }
                return true;
            }
            case 54323: {
                if (Display.vm.fm7_ver >= 3) {
                    boolean redraw_flag = false;
                    this.block_active = (dat & 1) != 0 ? 1 : 0;
                    if ((dat & 0x10) != 0) {
                        if (this.block_display == 0) {
                            this.block_display = 1;
                            if (this.screen_mode != 3) {
                                redraw_flag = true;
                            }
                        }
                    } else if (this.block_display == 1) {
                        this.block_display = 0;
                        if (this.screen_mode != 3) {
                            redraw_flag = true;
                        }
                    }
                    this.setpointer(redraw_flag);
                }
                return true;
            }
            case 54328: 
            case 54329: 
            case 54330: 
            case 54331: 
            case 54332: 
            case 54333: 
            case 54334: 
            case 54335: {
                if (Display.vm.fm7_ver <= 2) {
                    return true;
                }
                switch (addr & 7) {
                    case 0: {
                        this.window_x1 &= 0xF8;
                        this.window_x1 |= (dat & 3) << 8;
                        break;
                    }
                    case 1: {
                        this.window_x1 &= 0x300;
                        this.window_x1 |= dat & 0xF8;
                        break;
                    }
                    case 2: {
                        this.window_x2 &= 0xF8;
                        this.window_x2 |= (dat & 3) << 8;
                        break;
                    }
                    case 3: {
                        this.window_x2 &= 0x300;
                        this.window_x2 |= dat & 0xF8;
                        break;
                    }
                    case 4: {
                        this.window_y1 &= 0xFF;
                        this.window_y1 |= (dat & 1) << 8;
                        break;
                    }
                    case 5: {
                        this.window_y1 &= 0x100;
                        this.window_y1 |= dat;
                        break;
                    }
                    case 6: {
                        this.window_y2 &= 0xFF;
                        this.window_y2 |= (dat & 1) << 8;
                        break;
                    }
                    case 7: {
                        this.window_y2 &= 0x100;
                        this.window_y2 |= dat;
                    }
                }
                this.check_window_open();
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.crt_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.vrama_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subnmi_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.vsync_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.blank_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.vram_offset_flag)) {
            return false;
        }
        if (!File.word_write(fileh, this.vram_offset[0])) {
            return false;
        }
        if (!File.word_write(fileh, this.vram_offset[1])) {
            return false;
        }
        if (!File.word_write(fileh, this.crtc_offset[0])) {
            return false;
        }
        if (!File.word_write(fileh, this.crtc_offset[1])) {
            return false;
        }
        if (!File.byte_write(fileh, this.vram_active)) {
            return false;
        }
        if (!File.byte_write(fileh, this.vram_display)) {
            return false;
        }
        if (!File.word_write(fileh, this.blank_count)) {
            return false;
        }
        if (!File.byte_write(fileh, this.subram_vrambank)) {
            return false;
        }
        if (!File.word_write(fileh, this.sub_kanji_addr)) {
            return false;
        }
        if (!File.bool_write(fileh, this.sub_kanji_bank)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_x1)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_dx1)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_y1)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_dy1)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_x2)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_dx2)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_y2)) {
            return false;
        }
        if (!File.word_write(fileh, this.window_dy2)) {
            return false;
        }
        if (!File.bool_write(fileh, this.window_open)) {
            return false;
        }
        if (!File.byte_write(fileh, this.block_active)) {
            return false;
        }
        return File.byte_write(fileh, this.block_display);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.crt_flag = File.bool_read(fileh);
            this.vrama_flag = File.bool_read(fileh);
            this.subnmi_flag = File.bool_read(fileh);
            this.vsync_flag = File.bool_read(fileh);
            this.blank_flag = File.bool_read(fileh);
            this.vram_offset_flag = File.bool_read(fileh);
            this.vram_offset[0] = File.word_read(fileh);
            this.vram_offset[1] = File.word_read(fileh);
            this.crtc_offset[0] = File.word_read(fileh);
            this.crtc_offset[1] = File.word_read(fileh);
            this.vram_active = File.byte_read(fileh);
            this.vram_display = File.byte_read(fileh);
            schedule.handle(1, this, 1);
            schedule.handle(6, this, 2);
            schedule.handle(7, this, 3);
            if (ver >= 600) {
                this.blank_count = File.word_read(fileh);
            }
            if (ver >= 800) {
                this.subram_vrambank = File.byte_read(fileh);
                this.sub_kanji_addr = File.word_read(fileh);
                this.sub_kanji_bank = File.bool_read(fileh);
                this.window_x1 = File.word_read(fileh);
                this.window_dx1 = File.word_read(fileh);
                this.window_y1 = File.word_read(fileh);
                this.window_dy1 = File.word_read(fileh);
                this.window_x2 = File.word_read(fileh);
                this.window_dx2 = File.word_read(fileh);
                this.window_y2 = File.word_read(fileh);
                this.window_dy2 = File.word_read(fileh);
                this.window_open = File.bool_read(fileh);
                this.block_active = File.byte_read(fileh);
                this.block_display = File.byte_read(fileh);
            } else {
                this.subram_vrambank = 0;
                this.sub_kanji_addr = 0;
                this.sub_kanji_bank = false;
                this.window_x1 = 0;
                this.window_dx1 = 0;
                this.window_x2 = 0;
                this.window_dx2 = 0;
                this.window_y1 = 0;
                this.window_dy1 = 0;
                this.window_y2 = 0;
                this.window_dy2 = 0;
                this.window_open = false;
                this.block_active = 0;
                this.block_display = 0;
            }
            this.setpointer(true);
            this.setup();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

