/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Kanji
extends Base {
    private int kanji_addr;
    byte[] kanji_rom;
    private int kanji_rom2;

    Kanji() {
    }

    boolean init() {
        this.kanji_rom = Util.malloc(262144);
        if (this.kanji_rom == null) {
            return false;
        }
        if (!File.load("KANJI.ROM", this.kanji_rom, 131072)) {
            return false;
        }
        this.kanji_rom2 = 131072;
        return File.load("KANJI2.ROM", this.kanji_rom, this.kanji_rom2, 131072);
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        if (this.kanji_rom != null) {
            Util.free(this.kanji_rom);
            this.kanji_rom = null;
            this.kanji_rom2 = 0;
        }
    }

    void reset() {
        this.kanji_addr = 0;
    }

    boolean readb(int addr, IntHolder dat) {
        switch (addr) {
            case 64800: 
            case 64801: 
            case 64812: 
            case 64813: {
                dat.value = 255;
                return true;
            }
            case 64802: 
            case 64803: {
                int offset = this.kanji_addr << 1;
                dat.value = this.kanji_rom[offset + (addr & 1)] & 0xFF;
                return true;
            }
            case 64814: 
            case 64815: {
                if (Kanji.vm.fm7_ver < 3) {
                    dat.value = 255;
                } else {
                    int offset = this.kanji_addr << 1;
                    dat.value = this.kanji_rom[this.kanji_rom2 + offset + (addr & 1)] & 0xFF;
                }
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        switch (addr) {
            case 64812: {
                if (Kanji.vm.fm7_ver < 3) {
                    return true;
                }
            }
            case 64800: {
                this.kanji_addr &= 0xFF;
                this.kanji_addr |= dat << 8;
                return true;
            }
            case 64813: {
                if (Kanji.vm.fm7_ver < 3) {
                    return true;
                }
            }
            case 64801: {
                this.kanji_addr &= 0xFF00;
                this.kanji_addr |= dat;
                return true;
            }
            case 64802: 
            case 64803: 
            case 64815: {
                return true;
            }
            case 64814: {
                if (Kanji.vm.fm7_ver < 3) {
                    return true;
                }
                Kanji.jcard.dicram_en = (dat & 0x80) != 0;
                Kanji.jcard.dicrom_en = (dat & 0x40) != 0;
                Kanji.jcard.dicrom_bank = dat & 0x3F;
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        return File.word_write(fileh, this.kanji_addr);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.kanji_addr = File.word_read(fileh);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

