/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Cpu;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Maincpu
extends Cpu {
    Maincpu() {
        super(mainmem);
    }

    @Override
    boolean init() {
        return super.init();
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        super.reset();
    }

    @Override
    void reset() {
        super.reset();
    }

    void firq() {
        this.intr = Maincpu.keyboard.break_flag || Maincpu.subctrl.subattn_flag ? (this.intr |= 2) : (this.intr &= 0xFFFFFFFD);
    }

    void irq() {
        this.intr = Maincpu.mainetc.key_irq_flag && !Maincpu.mainetc.key_irq_mask || Maincpu.mainetc.timer_irq_flag || Maincpu.mainetc.lp_irq_flag || Maincpu.mainetc.mfd_irq_flag || Maincpu.mainetc.txrdy_irq_flag || Maincpu.mainetc.rxrdy_irq_flag || Maincpu.mainetc.syndet_irq_flag || Maincpu.mainetc.dma_irq_flag || Maincpu.mainetc.opn_irq_flag || Maincpu.mainetc.whg_irq_flag || Maincpu.mainetc.thg_irq_flag ? (this.intr |= 4) : (this.intr &= 0xFFFFFFFB);
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.byte_write(fileh, this.getCc())) {
            return false;
        }
        if (!File.byte_write(fileh, this.getDp())) {
            return false;
        }
        if (!File.word_write(fileh, this.getD())) {
            return false;
        }
        if (!File.word_write(fileh, this.getX())) {
            return false;
        }
        if (!File.word_write(fileh, this.getY())) {
            return false;
        }
        if (!File.word_write(fileh, this.getU())) {
            return false;
        }
        if (!File.word_write(fileh, this.getS())) {
            return false;
        }
        if (!File.word_write(fileh, this.getPc())) {
            return false;
        }
        if (!File.word_write(fileh, this.getIntr())) {
            return false;
        }
        if (!File.word_write(fileh, this.getCycle())) {
            return false;
        }
        return File.word_write(fileh, this.getTotal());
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.setCc(File.byte_read(fileh));
            this.setDp(File.byte_read(fileh));
            this.setD(File.word_read(fileh));
            this.setX(File.word_read(fileh));
            this.setY(File.word_read(fileh));
            this.setU(File.word_read(fileh));
            this.setS(File.word_read(fileh));
            this.setPc(File.word_read(fileh));
            this.setIntr(File.word_read(fileh));
            this.setCycle(File.word_read(fileh));
            this.setTotal(File.word_read(fileh));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

