/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import java.awt.Point;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Mouse
extends Base
implements EventHandler {
    public int mos_port;
    public boolean mos_capture;
    private int mos_x;
    private int mos_y;
    private int mos_phase;
    private boolean mos_strobe;
    private final int mos_timeout = 0;

    Mouse() {
    }

    boolean init() {
        this.mos_port = 1;
        this.mos_capture = false;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        this.mos_x = 0;
        this.mos_y = 0;
        this.mos_phase = 0;
        this.mos_strobe = false;
    }

    @Override
    public boolean event(int callbackid) {
        schedule.delevent(18);
        this.mos_phase = 0;
        this.mos_strobe = false;
        return true;
    }

    void strobe_signal(boolean strb) {
        if (strb != this.mos_strobe) {
            this.mos_strobe = strb;
            if (this.mos_phase == 0) {
                Point mospos = new Point(this.mos_x, this.mos_y);
                Mouse.sysmain.sys_kbd.mospos_request(mospos);
                this.mos_x = mospos.x;
                this.mos_y = mospos.y;
                schedule.setevent(18, 2000, this, 0);
            }
            this.mos_phase = this.mos_phase + 1 & 3;
        }
    }

    int readdata(int trigger) {
        int ret = 0;
        switch (this.mos_phase) {
            case 1: {
                ret = this.mos_x >> 4 & 0xF;
                break;
            }
            case 2: {
                ret = this.mos_x & 0xF;
                break;
            }
            case 3: {
                ret = this.mos_y >> 4 & 0xF;
                break;
            }
            case 0: {
                ret = this.mos_y & 0xF;
            }
        }
        return ret |= Mouse.sysmain.sys_kbd.mosbtn_request() & trigger << 4 & 0x30;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.byte_write(fileh, this.mos_x)) {
            return false;
        }
        if (!File.byte_write(fileh, this.mos_y)) {
            return false;
        }
        if (!File.byte_write(fileh, this.mos_phase)) {
            return false;
        }
        return File.bool_write(fileh, this.mos_strobe);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.reset();
            if (ver >= 900 || ver >= 700 && ver <= 799) {
                this.mos_x = File.byte_read(fileh);
                this.mos_y = File.byte_read(fileh);
                this.mos_phase = File.byte_read(fileh);
                this.mos_strobe = File.bool_read(fileh);
            }
            schedule.handle(18, this, 0);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

