/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Subctrl
extends Base {
    boolean subhalt_flag;
    boolean subbusy_flag;
    boolean subcancel_flag;
    boolean subattn_flag;
    private boolean subhalt_request;
    boolean subcancel_request;
    byte[] shared_ram = new byte[128];
    boolean subreset_flag;
    boolean busy_CLR_flag;
    boolean mode320;
    boolean mode400l;
    boolean mode256k;
    boolean subram_protect;
    private int subif_dat;
    private boolean subreset_halt;

    Subctrl() {
    }

    boolean init() {
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        this.subhalt_request = false;
        this.subhalt_flag = false;
        this.subbusy_flag = true;
        this.subcancel_request = false;
        this.subcancel_flag = false;
        this.subattn_flag = false;
        this.subreset_flag = false;
        this.busy_CLR_flag = false;
        this.mode320 = false;
        this.mode400l = false;
        this.mode256k = false;
        Subctrl.display.screen_mode = 0;
        this.subram_protect = true;
        this.subif_dat = 8;
        this.subreset_halt = false;
        Util.memset(this.shared_ram, (byte)-1, this.shared_ram.length);
    }

    void halt_ack() {
        this.subhalt_flag = this.subhalt_request;
        this.subcancel_flag = this.subcancel_request;
        if (this.subhalt_request) {
            this.subbusy_flag = true;
        }
    }

    boolean readb(int addr, IntHolder dat) {
        switch (addr) {
            case 64772: {
                int ret = this.subbusy_flag ? 255 : 127;
                if (this.subattn_flag) {
                    ret &= 0xFFFFFFFE;
                    this.subattn_flag = false;
                }
                if (Subctrl.keyboard.break_flag || Subctrl.vm.hotreset_flag) {
                    ret &= 0xFFFFFFFD;
                    if (Subctrl.vm.hotreset_flag && !Subctrl.mainmem.initrom_en) {
                        Subctrl.keyboard.break_flag = false;
                        Subctrl.vm.hotreset_flag = false;
                    }
                }
                dat.value = ret;
                maincpu.firq();
                return true;
            }
            case 64773: {
                if (this.subbusy_flag) {
                    dat.value = 254;
                    return true;
                }
                dat.value = 126;
                if (this.busy_CLR_flag) {
                    this.subbusy_flag = true;
                    this.busy_CLR_flag = false;
                }
                return true;
            }
            case 64786: {
                int ret = 255;
                if (Subctrl.vm.fm7_ver >= 2) {
                    if (!this.mode320) {
                        ret &= 0xFFFFFFBF;
                    }
                    if (Subctrl.display.blank_flag) {
                        ret &= 0xFFFFFFFD;
                    }
                    if (!Subctrl.display.vsync_flag) {
                        ret &= 0xFFFFFFFE;
                    }
                }
                dat.value = ret;
                return true;
            }
            case 64787: {
                dat.value = 255;
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        switch (addr) {
            case 64772: {
                if (Subctrl.vm.fm7_ver >= 3) {
                    this.subram_protect = (dat & 4) == 0;
                    this.mode400l = (dat & 8) == 0;
                    this.mode256k = (dat & 0x10) != 0 ? !this.mode400l : false;
                    if ((dat & 0x18) != this.subif_dat) {
                        display.setpointer(true);
                    }
                    this.subif_dat = dat & 0x18;
                }
                return true;
            }
            case 64773: {
                if ((dat & 0x80) != 0) {
                    this.subhalt_request = true;
                } else {
                    this.subhalt_request = false;
                    if (this.subreset_halt) {
                        subcpu.reset();
                        this.subreset_halt = false;
                    }
                }
                if ((dat & 0x40) != 0) {
                    this.subcancel_request = true;
                }
                subcpu.irq();
                return true;
            }
            case 64786: {
                if (Subctrl.vm.fm7_ver >= 2) {
                    if ((dat & 0x40) != 0) {
                        if (!this.mode320) {
                            this.mode320 = true;
                            display.setpointer(true);
                        }
                    } else if (this.mode320) {
                        this.mode320 = false;
                        display.setpointer(true);
                    }
                }
                return true;
            }
            case 64787: {
                if (Subctrl.vm.fm7_ver >= 2) {
                    Subctrl.submem.subrom_bank = Subctrl.vm.fm7_ver >= 3 && (dat & 4) != 0 ? 4 : dat & 3;
                    subcpu.reset();
                    this.subreset_halt = this.subhalt_flag;
                    this.subreset_flag = true;
                    this.subbusy_flag = true;
                    aluline.reset();
                    ttlpalet.reset();
                    multipag.reset();
                    display.reset();
                    Subctrl.sysmain.sys_dsp.display_notify();
                    Subctrl.keyboard.ins_flag = false;
                }
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.subhalt_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subbusy_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subcancel_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subattn_flag)) {
            return false;
        }
        if (!File.write(fileh, this.shared_ram, 128)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subreset_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mode320)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subhalt_request)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subcancel_request)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mode400l)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mode256k)) {
            return false;
        }
        if (!File.bool_write(fileh, this.subram_protect)) {
            return false;
        }
        return File.bool_write(fileh, this.subreset_halt);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        block10: {
            block9: {
                if (ver < 200) {
                    return false;
                }
                try {
                    this.subhalt_flag = File.bool_read(fileh);
                    this.subbusy_flag = File.bool_read(fileh);
                    this.subcancel_flag = File.bool_read(fileh);
                    this.subattn_flag = File.bool_read(fileh);
                    if (File.read(fileh, this.shared_ram, 128)) break block9;
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            this.subreset_flag = File.bool_read(fileh);
            this.mode320 = File.bool_read(fileh);
            if (ver >= 700 && ver <= 799 || ver >= 900) {
                this.subhalt_request = File.bool_read(fileh);
                this.subcancel_request = File.bool_read(fileh);
            } else {
                this.subhalt_request = this.subhalt_flag;
                this.subcancel_request = this.subcancel_flag;
            }
            if (ver >= 800) break block10;
            this.mode400l = false;
            this.mode256k = false;
            this.subif_dat = 8;
            this.subram_protect = false;
            this.subreset_halt = false;
            display.setpointer(true);
            return true;
        }
        this.mode400l = File.bool_read(fileh);
        this.mode256k = File.bool_read(fileh);
        this.subram_protect = File.bool_read(fileh);
        this.subreset_halt = File.bool_read(fileh);
        this.subif_dat = 0;
        if (!this.mode400l) {
            this.subif_dat |= 8;
        }
        if (this.mode256k) {
            this.subif_dat |= 0x10;
        }
        display.setpointer(true);
        return true;
    }
}

