/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.Sys_main;
import emu.xm7.vm.System;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.MemoryImageSource;

public class Sys_dsp {
    private final DirectColorModel CM = new DirectColorModel(32, 0xFF0000, 65280, 255);
    private final int[] ttltable;
    private int[][][] anlgtable;
    Image image;
    private Image image640;
    private Image image320;
    private MemoryImageSource mis640;
    private MemoryImageSource mis320;
    private Image blank;
    private int[] vram;
    private int[] vram_blank;
    private boolean draw_request;
    private boolean force_redraw;
    private boolean[][] drawreq;
    private boolean mode_change;
    private boolean bFullScan;
    private Sys_main sysmain;
    private System vm;

    Sys_dsp(Sys_main sysmain, System vm) {
        int[] nArray = new int[8];
        nArray[1] = 255;
        nArray[2] = 0xFF0000;
        nArray[3] = 0xFF00FF;
        nArray[4] = 65280;
        nArray[5] = 65535;
        nArray[6] = 0xFFFF00;
        nArray[7] = 0xFFFFFF;
        this.ttltable = nArray;
        this.anlgtable = new int[16][16][16];
        this.vram = new int[256000];
        this.vram_blank = new int[1];
        this.draw_request = false;
        this.force_redraw = false;
        this.drawreq = new boolean[52][80];
        this.mode_change = true;
        this.bFullScan = false;
        this.sysmain = sysmain;
        this.vm = vm;
        this.mis640 = new MemoryImageSource(640, 400, (ColorModel)this.CM, this.vram, 0, 640);
        this.mis640.setAnimated(true);
        this.mis640.setFullBufferUpdates(true);
        this.mis640.newPixels();
        this.mis320 = new MemoryImageSource(320, 200, (ColorModel)this.CM, this.vram, 0, 320);
        this.mis320.setAnimated(true);
        this.mis320.setFullBufferUpdates(true);
        this.mis320.newPixels();
        this.image640 = Toolkit.getDefaultToolkit().createImage(this.mis640);
        this.image320 = Toolkit.getDefaultToolkit().createImage(this.mis320);
        this.blank = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(1, 1, (ColorModel)this.CM, this.vram_blank, 0, 1));
        this.image = this.image640;
        int r = 0;
        while (r < 16) {
            int cr = r << 4;
            if (cr > 0) {
                cr |= 0xF;
            }
            int g = 0;
            while (g < 16) {
                int cg = g << 4;
                if (cg > 0) {
                    cg |= 0xF;
                }
                int b = 0;
                while (b < 16) {
                    int cb = b << 4;
                    if (cb > 0) {
                        cb |= 0xF;
                    }
                    this.anlgtable[r][g][b] = cr << 16 | cg << 8 | cb;
                    ++b;
                }
                ++g;
            }
            ++r;
        }
    }

    public void digitize_notify() {
        this.draw_request = true;
    }

    public void ttlpalet_notify() {
        this.force_redraw = true;
    }

    public void apalet_notify() {
        this.force_redraw = true;
    }

    public void display_notify() {
        this.force_redraw = true;
        this.mode_change = true;
    }

    public void window_notify() {
        this.force_redraw = true;
    }

    public void vram_notify(int addr, int dat) {
        switch (this.vm.display.screen_mode) {
            case 2: {
                int x = (addr &= Short.MAX_VALUE) % 80;
                int y = addr / 80 >> 3;
                break;
            }
            case 1: 
            case 3: {
                int x = (addr &= 0x1FFF) % 40;
                int y = addr / 40 >> 3;
                break;
            }
            case 0: {
                int x = (addr &= 0x3FFF) % 80;
                int y = addr / 80 >> 3;
                break;
            }
            default: {
                return;
            }
        }
        this.drawreq[y][x] = true;
        this.draw_request = true;
    }

    void setFullScan(boolean bFullScan) {
        this.bFullScan = bFullScan;
    }

    void display() {
        if (this.draw_request || this.force_redraw) {
            if (this.vm.display.crt_flag) {
                switch (this.vm.display.screen_mode) {
                    case 0: {
                        this.display_640();
                        this.mis640.newPixels();
                        this.image = this.image640;
                        break;
                    }
                    case 2: {
                        this.display_400l();
                        this.mis640.newPixels();
                        this.image = this.image640;
                        break;
                    }
                    case 1: {
                        this.display_320();
                        this.mis320.newPixels();
                        this.image = this.image320;
                        break;
                    }
                    case 3: {
                        this.display_256k();
                        this.mis320.newPixels();
                        this.image = this.image320;
                    }
                }
            } else {
                this.image = this.blank;
            }
            this.force_redraw = false;
            this.draw_request = false;
            if (this.mode_change) {
                this.sysmain.crtview.repaint();
                this.mode_change = false;
            }
        }
    }

    private void display_640() {
        int offset = 0;
        int vpage = ~(this.vm.multipag.multi_page >> 4) & 7;
        this.vm.display.window_clip(0);
        int dx1 = this.vm.display.window_dx1 >> 3;
        int dx2 = this.vm.display.window_dx2 >> 3;
        int y = 0;
        while (y < 200) {
            int x = 0;
            while (x < 80) {
                if (this.force_redraw || this.drawreq[y / 8][x]) {
                    int by = y;
                    while (by < y + 8) {
                        boolean winy = by >= this.vm.display.window_dy1 && by <= this.vm.display.window_dy2;
                        offset = winy && x >= dx1 && x < dx2 ? by * 80 + x + this.vm.display.vram_bdptr_p : by * 80 + x + this.vm.display.vram_dptr_p;
                        int b = this.vm.submem.vram_c[offset] & 0xFF;
                        int r = this.vm.submem.vram_c[offset + 32768] & 0xFF;
                        int g = this.vm.submem.vram_c[offset + 65536] & 0xFF;
                        int bit = 128;
                        int addr = by * 640 * 2 + x * 8;
                        int bx = 7;
                        while (bx >= 0) {
                            int dat = ((g & bit) >> bx << 2 | (r & bit) >> bx << 1 | (b & bit) >> bx) & vpage;
                            int color = this.ttltable[this.vm.ttlpalet.ttl_palet[dat] & 7];
                            if (this.vram[addr] != color) {
                                this.vram[addr] = color;
                            }
                            if (!this.bFullScan) {
                                color = 0;
                            }
                            if (this.vram[addr + 640] != color) {
                                this.vram[addr + 640] = color;
                            }
                            ++addr;
                            bit >>= 1;
                            --bx;
                        }
                        ++by;
                    }
                    this.drawreq[y / 8][x] = false;
                }
                ++x;
            }
            y += 8;
        }
    }

    private void display_400l() {
        int offset = 0;
        int vpage = ~(this.vm.multipag.multi_page >> 4) & 7;
        this.vm.display.window_clip(0);
        int dx1 = this.vm.display.window_dx1 >> 3;
        int dx2 = this.vm.display.window_dx2 >> 3;
        int y = 0;
        while (y < 400) {
            int x = 0;
            while (x < 80) {
                if (this.force_redraw || this.drawreq[y / 8][x]) {
                    int by = y;
                    while (by < y + 8) {
                        boolean winy = by >= this.vm.display.window_dy1 && by <= this.vm.display.window_dy2;
                        offset = winy && x >= dx1 && x < dx2 ? by * 80 + x + this.vm.display.vram_bdptr_p : by * 80 + x + this.vm.display.vram_dptr_p;
                        int b = this.vm.submem.vram_c[offset] & 0xFF;
                        int r = this.vm.submem.vram_c[offset + 32768] & 0xFF;
                        int g = this.vm.submem.vram_c[offset + 65536] & 0xFF;
                        int bit = 128;
                        int addr = by * 640 + x * 8;
                        int bx = 7;
                        while (bx >= 0) {
                            int dat = ((g & bit) >> bx << 2 | (r & bit) >> bx << 1 | (b & bit) >> bx) & vpage;
                            int color = this.ttltable[this.vm.ttlpalet.ttl_palet[dat] & 7];
                            if (this.vram[addr] != color) {
                                this.vram[addr] = color;
                            }
                            ++addr;
                            bit >>= 1;
                            --bx;
                        }
                        ++by;
                    }
                    this.drawreq[y / 8][x] = false;
                }
                ++x;
            }
            y += 8;
        }
    }

    private void display_320() {
        int offset = 0;
        this.vm.display.window_clip(1);
        int dx1 = this.vm.display.window_dx1 >> 3;
        int dx2 = this.vm.display.window_dx2 >> 3;
        int y = 0;
        while (y < 200) {
            int x = 0;
            while (x < 40) {
                if (this.force_redraw || this.drawreq[y / 8][x]) {
                    int j = y;
                    while (j < y + 8) {
                        boolean winy = j >= this.vm.display.window_dy1 && j <= this.vm.display.window_dy2;
                        offset = winy && x >= dx1 && x < dx2 ? j * 40 + x + this.vm.display.vram_bdptr_p : j * 40 + x + this.vm.display.vram_dptr_p;
                        int gb1 = this.vm.submem.vram_c[offset + 65536] & 0xFF;
                        int gb2 = this.vm.submem.vram_c[offset + 73728] & 0xFF;
                        int gb3 = this.vm.submem.vram_c[offset + 81920] & 0xFF;
                        int gb4 = this.vm.submem.vram_c[offset + 90112] & 0xFF;
                        int rb1 = this.vm.submem.vram_c[offset + 32768] & 0xFF;
                        int rb2 = this.vm.submem.vram_c[offset + 40960] & 0xFF;
                        int rb3 = this.vm.submem.vram_c[offset + 49152] & 0xFF;
                        int rb4 = this.vm.submem.vram_c[offset + 57344] & 0xFF;
                        int bb1 = this.vm.submem.vram_c[offset] & 0xFF;
                        int bb2 = this.vm.submem.vram_c[offset + 8192] & 0xFF;
                        int bb3 = this.vm.submem.vram_c[offset + 16384] & 0xFF;
                        int bb4 = this.vm.submem.vram_c[offset + 24576] & 0xFF;
                        int bit = 128;
                        int addr = j * 8 * 40 + x * 8;
                        int i = 7;
                        while (i >= 0) {
                            int cl;
                            int dat = 0;
                            if ((this.vm.multipag.multi_page & 0x10) == 0) {
                                dat |= (bb1 & bit) >> i << 3 | (bb2 & bit) >> i << 2 | (bb3 & bit) >> i << 1 | (bb4 & bit) >> i;
                            }
                            if ((this.vm.multipag.multi_page & 0x20) == 0) {
                                dat |= (rb1 & bit) >> i << 7 | (rb2 & bit) >> i << 6 | (rb3 & bit) >> i << 5 | (rb4 & bit) >> i << 4;
                            }
                            if ((this.vm.multipag.multi_page & 0x40) == 0) {
                                dat |= (gb1 & bit) >> i << 11 | (gb2 & bit) >> i << 10 | (gb3 & bit) >> i << 9 | (gb4 & bit) >> i << 8;
                            }
                            if (this.vram[addr] != (cl = this.anlgtable[this.vm.apalet.apalet_r[dat]][this.vm.apalet.apalet_g[dat]][this.vm.apalet.apalet_b[dat]])) {
                                this.vram[addr] = cl;
                            }
                            ++addr;
                            bit >>= 1;
                            --i;
                        }
                        ++j;
                    }
                    this.drawreq[y / 8][x] = false;
                }
                ++x;
            }
            y += 8;
        }
    }

    private void display_256k() {
        int offset = 0;
        int y = 0;
        while (y < 200) {
            int x = 0;
            while (x < 40) {
                if (this.force_redraw || this.drawreq[y / 8][x]) {
                    int j = y;
                    while (j < y + 8) {
                        offset = j * 40 + x;
                        int gb1 = this.vm.submem.vram_c[offset + 65536] & 0xFF;
                        int gb2 = this.vm.submem.vram_c[offset + 73728] & 0xFF;
                        int gb3 = this.vm.submem.vram_c[offset + 81920] & 0xFF;
                        int gb4 = this.vm.submem.vram_c[offset + 90112] & 0xFF;
                        int gb5 = this.vm.submem.vram_c[offset + 163840] & 0xFF;
                        int gb6 = this.vm.submem.vram_c[offset + 172032] & 0xFF;
                        int rb1 = this.vm.submem.vram_c[offset + 32768] & 0xFF;
                        int rb2 = this.vm.submem.vram_c[offset + 40960] & 0xFF;
                        int rb3 = this.vm.submem.vram_c[offset + 49152] & 0xFF;
                        int rb4 = this.vm.submem.vram_c[offset + 57344] & 0xFF;
                        int rb5 = this.vm.submem.vram_c[offset + 131072] & 0xFF;
                        int rb6 = this.vm.submem.vram_c[offset + 139264] & 0xFF;
                        int bb1 = this.vm.submem.vram_c[offset] & 0xFF;
                        int bb2 = this.vm.submem.vram_c[offset + 8192] & 0xFF;
                        int bb3 = this.vm.submem.vram_c[offset + 16384] & 0xFF;
                        int bb4 = this.vm.submem.vram_c[offset + 24576] & 0xFF;
                        int bb5 = this.vm.submem.vram_c[offset + 98304] & 0xFF;
                        int bb6 = this.vm.submem.vram_c[offset + 106496] & 0xFF;
                        int bit = 128;
                        int addr = j * 8 * 40 + x * 8;
                        int i = 0;
                        while (i < 8) {
                            int dat = 0;
                            if ((this.vm.multipag.multi_page & 0x40) == 0) {
                                if ((gb1 & bit) != 0) {
                                    dat |= 0x8300;
                                }
                                if ((gb2 & bit) != 0) {
                                    dat |= 0x4300;
                                }
                                if ((gb3 & bit) != 0) {
                                    dat |= 0x2300;
                                }
                                if ((gb4 & bit) != 0) {
                                    dat |= 0x1300;
                                }
                                if ((gb5 & bit) != 0) {
                                    dat |= 0xB00;
                                }
                                if ((gb6 & bit) != 0) {
                                    dat |= 0x700;
                                }
                            }
                            if ((this.vm.multipag.multi_page & 0x20) == 0) {
                                if ((rb1 & bit) != 0) {
                                    dat |= 0x830000;
                                }
                                if ((rb2 & bit) != 0) {
                                    dat |= 0x430000;
                                }
                                if ((rb3 & bit) != 0) {
                                    dat |= 0x230000;
                                }
                                if ((rb4 & bit) != 0) {
                                    dat |= 0x130000;
                                }
                                if ((rb5 & bit) != 0) {
                                    dat |= 0xB0000;
                                }
                                if ((rb6 & bit) != 0) {
                                    dat |= 0x70000;
                                }
                            }
                            if ((this.vm.multipag.multi_page & 0x10) == 0) {
                                if ((bb1 & bit) != 0) {
                                    dat |= 0x83;
                                }
                                if ((bb2 & bit) != 0) {
                                    dat |= 0x43;
                                }
                                if ((bb3 & bit) != 0) {
                                    dat |= 0x23;
                                }
                                if ((bb4 & bit) != 0) {
                                    dat |= 0x13;
                                }
                                if ((bb5 & bit) != 0) {
                                    dat |= 0xB;
                                }
                                if ((bb6 & bit) != 0) {
                                    dat |= 7;
                                }
                            }
                            if (this.vram[addr] != dat) {
                                this.vram[addr] = dat;
                            }
                            ++addr;
                            bit >>= 1;
                            ++i;
                        }
                        ++j;
                    }
                    this.drawreq[y / 8][x] = false;
                }
                ++x;
            }
            ++y;
        }
    }
}

