/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Apalet
extends Base {
    private int apalet_no;
    public byte[] apalet_b = new byte[4096];
    public byte[] apalet_r = new byte[4096];
    public byte[] apalet_g = new byte[4096];

    Apalet() {
    }

    boolean init() {
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        this.apalet_no = 0;
        Util.memset(this.apalet_b, (byte)0, Util.sizeof(this.apalet_b));
        Util.memset(this.apalet_r, (byte)0, Util.sizeof(this.apalet_r));
        Util.memset(this.apalet_g, (byte)0, Util.sizeof(this.apalet_g));
    }

    boolean readb(int addr, IntHolder dat) {
        if (Apalet.vm.fm7_ver < 2) {
            return false;
        }
        if (addr >= 64816 && addr <= 64820) {
            if (Apalet.vm.fm7_ver < 3) {
                dat.value = 255;
                return true;
            }
            switch (addr) {
                case 64816: {
                    dat.value = 0xF0 | this.apalet_no >> 8;
                    return true;
                }
                case 64817: {
                    dat.value = 0xF0 | this.apalet_no & 0xFF;
                    return true;
                }
                case 64818: {
                    dat.value = 0xF0 | this.apalet_b[this.apalet_no] & 0xF;
                    return true;
                }
                case 64819: {
                    dat.value = 0xF0 | this.apalet_r[this.apalet_no] & 0xF;
                    return true;
                }
                case 64820: {
                    dat.value = 0xF0 | this.apalet_g[this.apalet_no] & 0xF;
                    return true;
                }
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        if (Apalet.vm.fm7_ver < 2) {
            return false;
        }
        switch (addr) {
            case 64816: {
                this.apalet_no &= 0xFF;
                this.apalet_no |= (dat & 0xF) << 8;
                return true;
            }
            case 64817: {
                this.apalet_no &= 0xF00;
                this.apalet_no |= dat;
                return true;
            }
            case 64818: {
                if (this.apalet_b[this.apalet_no] != (dat & 0xF)) {
                    this.apalet_b[this.apalet_no] = (byte)(dat & 0xF);
                    if (Apalet.display.screen_mode == 1) {
                        Apalet.sysmain.sys_dsp.apalet_notify();
                    }
                }
                return true;
            }
            case 64819: {
                if (this.apalet_r[this.apalet_no] != (dat & 0xF)) {
                    this.apalet_r[this.apalet_no] = (byte)(dat & 0xF);
                    if (Apalet.display.screen_mode == 1) {
                        Apalet.sysmain.sys_dsp.apalet_notify();
                    }
                }
                return true;
            }
            case 64820: {
                if (this.apalet_g[this.apalet_no] != (dat & 0xF)) {
                    this.apalet_g[this.apalet_no] = (byte)(dat & 0xF);
                    if (Apalet.display.screen_mode == 1) {
                        Apalet.sysmain.sys_dsp.apalet_notify();
                    }
                }
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.word_write(fileh, this.apalet_no)) {
            return false;
        }
        if (!File.write(fileh, this.apalet_b, this.apalet_b.length)) {
            return false;
        }
        if (!File.write(fileh, this.apalet_r, this.apalet_r.length)) {
            return false;
        }
        return File.write(fileh, this.apalet_g, this.apalet_g.length);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        block6: {
            block5: {
                if (ver < 200) {
                    return false;
                }
                try {
                    this.apalet_no = File.word_read(fileh);
                    if (File.read(fileh, this.apalet_b, this.apalet_b.length)) break block5;
                    return false;
                }
                catch (IOException e) {
                    return false;
                }
            }
            if (File.read(fileh, this.apalet_r, this.apalet_r.length)) break block6;
            return false;
        }
        return File.read(fileh, this.apalet_g, this.apalet_g.length);
    }
}

