/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.vm.Base;
import emu.xm7.vm.Memory;

public class Cpu
extends Base {
    private Memory mem;
    private int a = 0;
    private int b = 0;
    private int dp = 0;
    private int s = 0;
    private int u = 0;
    private int x = 0;
    private int y = 0;
    private int pc = 0;
    private int cc = 0;
    private int ir = 0;
    private int ea = 0;
    int cycle;
    int intr;
    int total = 0;
    private final int[] cycles1;
    private final int[] cycles2;
    private final int[] flags8i;
    private final int[] flags8d;
    private final int[] signed5;

    private int READB(int _ea) {
        return this.mem.readb(_ea);
    }

    private int READW(int _ea) {
        return this.mem.readb(_ea) << 8 | this.mem.readb(_ea + 1);
    }

    private void WRITEB(int _ea, int dat) {
        this.mem.writeb(_ea, dat);
    }

    private void WRITEW(int _ea, int dat) {
        this.mem.writeb(_ea, dat >>> 8);
        this.mem.writeb(_ea + 1, dat);
    }

    private int IMMBYTE() {
        return this.READB(this.pc++);
    }

    private int IMMWORD() {
        this.pc += 2;
        return this.READW(this.pc - 2);
    }

    private void DIRECT() {
        this.ea = this.IMMBYTE();
        this.ea |= this.dp << 8;
    }

    private int DIRBYTE() {
        this.DIRECT();
        return this.READB(this.ea);
    }

    private int DIRWORD() {
        this.DIRECT();
        return this.READW(this.ea);
    }

    private void EXTENDED() {
        this.ea = this.IMMWORD();
    }

    private int EXTBYTE() {
        this.ea = this.IMMWORD();
        return this.READB(this.ea);
    }

    private int EXTWORD() {
        this.ea = this.IMMWORD();
        return this.READW(this.ea);
    }

    private void BRANCH(boolean f) {
        if (f) {
            int t = this.IMMBYTE();
            this.pc += this.SIGNED(t);
        } else {
            ++this.pc;
        }
    }

    private void BRANCH(int f) {
        if (f != 0) {
            int t = this.IMMBYTE();
            this.pc += this.SIGNED(t);
        } else {
            ++this.pc;
        }
    }

    private void LBRANCH(boolean f) {
        if (f) {
            int t = this.IMMWORD();
            this.pc = this.pc + t & 0xFFFF;
            ++this.cycle;
        } else {
            this.pc += 2;
        }
    }

    private void LBRANCH(int f) {
        if (f != 0) {
            int t = this.IMMWORD();
            this.pc = this.pc + t & 0xFFFF;
            ++this.cycle;
        } else {
            this.pc += 2;
        }
    }

    private int NXORV() {
        return this.cc & 8 ^ (this.cc & 2) << 2;
    }

    private void SEC() {
        this.cc |= 1;
    }

    private void SEZ() {
        this.cc |= 4;
    }

    private void CLR_HNZVC() {
        this.cc &= 0xD0;
    }

    private void CLR_NZV() {
        this.cc &= 0xF1;
    }

    private void CLR_NZVC() {
        this.cc &= 0xF0;
    }

    private void CLR_Z() {
        this.cc &= 0xFB;
    }

    private void CLR_NZC() {
        this.cc &= 0xF2;
    }

    private void CLR_ZC() {
        this.cc &= 0xFA;
    }

    private void SET_Z(int a) {
        if (a == 0) {
            this.SEZ();
        }
    }

    private void SET_Z8(int a) {
        this.SET_Z(a & 0xFF);
    }

    private void SET_Z16(int a) {
        this.SET_Z(a & 0xFFFF);
    }

    private void SET_N8(int a) {
        this.cc |= (a & 0x80) >> 4;
    }

    private void SET_N16(int a) {
        this.cc |= (a & 0x8000) >> 12;
    }

    private void SET_H(int a, int b, int r) {
        this.cc |= ((a ^ b ^ r) & 0x10) << 1;
    }

    private void SET_C8(int a) {
        this.cc |= (a & 0x100) >> 8;
    }

    private void SET_C16(int a) {
        this.cc |= (a & 0x10000) >> 16;
    }

    private void SET_V8(int a, int b, int r) {
        this.cc |= ((a ^ b ^ r ^ r >> 1) & 0x80) >> 6;
    }

    private void SET_V16(int a, int b, int r) {
        this.cc |= ((a ^ b ^ r ^ r >> 1) & 0x8000) >> 14;
    }

    private void SET_NZ8(int a) {
        this.SET_N8(a);
        this.SET_Z(a);
    }

    private void SET_NZ16(int a) {
        this.SET_N16(a);
        this.SET_Z(a);
    }

    private void SET_FLAGS8I(int a) {
        this.cc |= this.flags8i[a & 0xFF];
    }

    private void SET_FLAGS8D(int a) {
        this.cc |= this.flags8d[a & 0xFF];
    }

    private void SET_FLAGS8(int a, int b, int r) {
        this.SET_N8(r);
        this.SET_Z8(r);
        this.SET_V8(a, b, r);
        this.SET_C8(r);
    }

    private void SET_FLAGS16(int a, int b, int r) {
        this.SET_N16(r);
        this.SET_Z16(r);
        this.SET_V16(a, b, r);
        this.SET_C16(r);
    }

    private int SIGNED(int b) {
        return b > 127 ? b | 0xFFFFFF00 : b;
    }

    private int SIGNED16(int b) {
        return b > Short.MAX_VALUE ? b | 0xFFFF0000 : b;
    }

    private int d() {
        return this.a << 8 | this.b;
    }

    private void d(int _r) {
        this.a = (_r &= 0xFFFF) >>> 8;
        this.b = _r & 0xFF;
    }

    private void PUSHBYTE(int b) {
        this.READB(this.s);
        --this.s;
        this.WRITEB(this.s, b);
    }

    private void PUSHWORD(int w) {
        this.READB(this.s);
        this.s -= 2;
        this.WRITEW(this.s, w);
    }

    private int PULLBYTE() {
        ++this.s;
        int t = this.READB(this.s - 1);
        this.READB(this.s);
        return t;
    }

    private int PULLWORD() {
        this.s += 2;
        int t = this.READW(this.s - 2);
        this.READB(this.s);
        return t;
    }

    private void PSHUBYTE(int b) {
        this.READB(this.u);
        --this.u;
        this.WRITEB(this.u, b);
    }

    private void PSHUWORD(int w) {
        this.READB(this.u);
        this.u -= 2;
        this.WRITEW(this.u, w);
    }

    private int PULUBYTE() {
        ++this.u;
        int t = this.READB(this.u - 1);
        this.READB(this.u);
        return t;
    }

    private int PULUWORD() {
        this.u += 2;
        int t = this.READW(this.u - 2);
        this.READB(this.u);
        return t;
    }

    private int GETREG(int reg) {
        int val;
        switch (reg) {
            case 0: {
                val = this.d();
                break;
            }
            case 1: {
                val = this.x;
                break;
            }
            case 2: {
                val = this.y;
                break;
            }
            case 3: {
                val = this.u;
                break;
            }
            case 4: {
                val = this.s;
                break;
            }
            case 5: {
                val = this.pc;
                break;
            }
            case 8: {
                val = this.a;
                break;
            }
            case 9: {
                val = this.b;
                break;
            }
            case 10: {
                val = this.cc;
                break;
            }
            case 11: {
                val = this.dp;
                break;
            }
            default: {
                val = 65535;
            }
        }
        return val;
    }

    private void SETREG(int val, int reg) {
        switch (reg) {
            case 0: {
                this.d(val);
                break;
            }
            case 1: {
                this.x = val;
                break;
            }
            case 2: {
                this.y = val;
                break;
            }
            case 3: {
                this.u = val;
                break;
            }
            case 4: {
                this.s = val;
                this.intr |= 0x10;
                break;
            }
            case 5: {
                this.pc = val;
                break;
            }
            case 8: {
                this.a = val;
                break;
            }
            case 9: {
                this.b = val;
                break;
            }
            case 10: {
                this.cc = val;
                break;
            }
            case 11: {
                this.dp = val;
                break;
            }
        }
    }

    public Cpu(Memory mem) {
        int[] nArray = new int[256];
        nArray[0] = 6;
        nArray[1] = 6;
        nArray[2] = 6;
        nArray[3] = 6;
        nArray[4] = 6;
        nArray[5] = 6;
        nArray[6] = 6;
        nArray[7] = 6;
        nArray[8] = 6;
        nArray[9] = 6;
        nArray[10] = 6;
        nArray[11] = 6;
        nArray[12] = 6;
        nArray[13] = 6;
        nArray[14] = 3;
        nArray[15] = 6;
        nArray[16] = 255;
        nArray[17] = 255;
        nArray[18] = 2;
        nArray[19] = 2;
        nArray[22] = 5;
        nArray[23] = 9;
        nArray[24] = 3;
        nArray[25] = 2;
        nArray[26] = 3;
        nArray[27] = 2;
        nArray[28] = 3;
        nArray[29] = 2;
        nArray[30] = 8;
        nArray[31] = 6;
        nArray[32] = 3;
        nArray[33] = 3;
        nArray[34] = 3;
        nArray[35] = 3;
        nArray[36] = 3;
        nArray[37] = 3;
        nArray[38] = 3;
        nArray[39] = 3;
        nArray[40] = 3;
        nArray[41] = 3;
        nArray[42] = 3;
        nArray[43] = 3;
        nArray[44] = 3;
        nArray[45] = 3;
        nArray[46] = 3;
        nArray[47] = 3;
        nArray[48] = 132;
        nArray[49] = 132;
        nArray[50] = 132;
        nArray[51] = 132;
        nArray[52] = 5;
        nArray[53] = 5;
        nArray[54] = 5;
        nArray[55] = 5;
        nArray[56] = 4;
        nArray[57] = 5;
        nArray[58] = 3;
        nArray[59] = 6;
        nArray[60] = 20;
        nArray[61] = 11;
        nArray[62] = 1;
        nArray[63] = 19;
        nArray[64] = 2;
        nArray[65] = 2;
        nArray[66] = 2;
        nArray[67] = 2;
        nArray[68] = 2;
        nArray[69] = 2;
        nArray[70] = 2;
        nArray[71] = 2;
        nArray[72] = 2;
        nArray[73] = 2;
        nArray[74] = 2;
        nArray[75] = 2;
        nArray[76] = 2;
        nArray[77] = 2;
        nArray[78] = 2;
        nArray[79] = 2;
        nArray[80] = 2;
        nArray[81] = 2;
        nArray[82] = 2;
        nArray[83] = 2;
        nArray[84] = 2;
        nArray[85] = 2;
        nArray[86] = 2;
        nArray[87] = 2;
        nArray[88] = 2;
        nArray[89] = 2;
        nArray[90] = 2;
        nArray[91] = 2;
        nArray[92] = 2;
        nArray[93] = 2;
        nArray[94] = 2;
        nArray[95] = 2;
        nArray[96] = 134;
        nArray[97] = 134;
        nArray[98] = 134;
        nArray[99] = 134;
        nArray[100] = 134;
        nArray[101] = 134;
        nArray[102] = 134;
        nArray[103] = 134;
        nArray[104] = 134;
        nArray[105] = 134;
        nArray[106] = 134;
        nArray[107] = 134;
        nArray[108] = 134;
        nArray[109] = 134;
        nArray[110] = 131;
        nArray[111] = 134;
        nArray[112] = 7;
        nArray[113] = 7;
        nArray[114] = 7;
        nArray[115] = 7;
        nArray[116] = 7;
        nArray[117] = 7;
        nArray[118] = 7;
        nArray[119] = 7;
        nArray[120] = 7;
        nArray[121] = 7;
        nArray[122] = 7;
        nArray[123] = 7;
        nArray[124] = 7;
        nArray[125] = 7;
        nArray[126] = 4;
        nArray[127] = 7;
        nArray[128] = 2;
        nArray[129] = 2;
        nArray[130] = 2;
        nArray[131] = 4;
        nArray[132] = 2;
        nArray[133] = 2;
        nArray[134] = 2;
        nArray[135] = 2;
        nArray[136] = 2;
        nArray[137] = 2;
        nArray[138] = 2;
        nArray[139] = 2;
        nArray[140] = 4;
        nArray[141] = 7;
        nArray[142] = 3;
        nArray[143] = 3;
        nArray[144] = 4;
        nArray[145] = 4;
        nArray[146] = 4;
        nArray[147] = 6;
        nArray[148] = 4;
        nArray[149] = 4;
        nArray[150] = 4;
        nArray[151] = 4;
        nArray[152] = 4;
        nArray[153] = 4;
        nArray[154] = 4;
        nArray[155] = 4;
        nArray[156] = 6;
        nArray[157] = 7;
        nArray[158] = 5;
        nArray[159] = 5;
        nArray[160] = 132;
        nArray[161] = 132;
        nArray[162] = 132;
        nArray[163] = 134;
        nArray[164] = 132;
        nArray[165] = 132;
        nArray[166] = 132;
        nArray[167] = 132;
        nArray[168] = 132;
        nArray[169] = 132;
        nArray[170] = 132;
        nArray[171] = 132;
        nArray[172] = 134;
        nArray[173] = 135;
        nArray[174] = 133;
        nArray[175] = 133;
        nArray[176] = 5;
        nArray[177] = 5;
        nArray[178] = 5;
        nArray[179] = 7;
        nArray[180] = 5;
        nArray[181] = 5;
        nArray[182] = 5;
        nArray[183] = 5;
        nArray[184] = 5;
        nArray[185] = 5;
        nArray[186] = 5;
        nArray[187] = 5;
        nArray[188] = 7;
        nArray[189] = 8;
        nArray[190] = 6;
        nArray[191] = 6;
        nArray[192] = 2;
        nArray[193] = 2;
        nArray[194] = 2;
        nArray[195] = 4;
        nArray[196] = 2;
        nArray[197] = 2;
        nArray[198] = 2;
        nArray[199] = 2;
        nArray[200] = 2;
        nArray[201] = 2;
        nArray[202] = 2;
        nArray[203] = 2;
        nArray[204] = 3;
        nArray[206] = 3;
        nArray[207] = 3;
        nArray[208] = 4;
        nArray[209] = 4;
        nArray[210] = 4;
        nArray[211] = 6;
        nArray[212] = 4;
        nArray[213] = 4;
        nArray[214] = 4;
        nArray[215] = 4;
        nArray[216] = 4;
        nArray[217] = 4;
        nArray[218] = 4;
        nArray[219] = 4;
        nArray[220] = 5;
        nArray[221] = 5;
        nArray[222] = 5;
        nArray[223] = 5;
        nArray[224] = 132;
        nArray[225] = 132;
        nArray[226] = 132;
        nArray[227] = 134;
        nArray[228] = 132;
        nArray[229] = 132;
        nArray[230] = 132;
        nArray[231] = 132;
        nArray[232] = 132;
        nArray[233] = 132;
        nArray[234] = 132;
        nArray[235] = 132;
        nArray[236] = 133;
        nArray[237] = 133;
        nArray[238] = 133;
        nArray[239] = 133;
        nArray[240] = 5;
        nArray[241] = 5;
        nArray[242] = 5;
        nArray[243] = 7;
        nArray[244] = 5;
        nArray[245] = 5;
        nArray[246] = 5;
        nArray[247] = 5;
        nArray[248] = 5;
        nArray[249] = 5;
        nArray[250] = 5;
        nArray[251] = 5;
        nArray[252] = 6;
        nArray[253] = 6;
        nArray[254] = 6;
        nArray[255] = 6;
        this.cycles1 = nArray;
        int[] nArray2 = new int[256];
        nArray2[33] = 5;
        nArray2[34] = 5;
        nArray2[35] = 5;
        nArray2[36] = 5;
        nArray2[37] = 5;
        nArray2[38] = 5;
        nArray2[39] = 5;
        nArray2[40] = 5;
        nArray2[41] = 5;
        nArray2[42] = 5;
        nArray2[43] = 5;
        nArray2[44] = 5;
        nArray2[45] = 5;
        nArray2[46] = 5;
        nArray2[47] = 5;
        nArray2[48] = 128;
        nArray2[49] = 128;
        nArray2[50] = 128;
        nArray2[51] = 128;
        nArray2[63] = 20;
        nArray2[96] = 128;
        nArray2[97] = 128;
        nArray2[98] = 128;
        nArray2[99] = 128;
        nArray2[100] = 128;
        nArray2[101] = 128;
        nArray2[102] = 128;
        nArray2[103] = 128;
        nArray2[104] = 128;
        nArray2[105] = 128;
        nArray2[106] = 128;
        nArray2[107] = 128;
        nArray2[108] = 128;
        nArray2[109] = 128;
        nArray2[110] = 128;
        nArray2[111] = 128;
        nArray2[131] = 5;
        nArray2[140] = 5;
        nArray2[142] = 4;
        nArray2[147] = 7;
        nArray2[156] = 7;
        nArray2[158] = 6;
        nArray2[159] = 6;
        nArray2[160] = 128;
        nArray2[161] = 128;
        nArray2[162] = 128;
        nArray2[163] = 135;
        nArray2[164] = 128;
        nArray2[165] = 128;
        nArray2[166] = 128;
        nArray2[167] = 128;
        nArray2[168] = 128;
        nArray2[169] = 128;
        nArray2[170] = 128;
        nArray2[171] = 128;
        nArray2[172] = 135;
        nArray2[173] = 128;
        nArray2[174] = 134;
        nArray2[175] = 134;
        nArray2[179] = 8;
        nArray2[188] = 8;
        nArray2[190] = 7;
        nArray2[191] = 7;
        nArray2[206] = 4;
        nArray2[222] = 6;
        nArray2[223] = 6;
        nArray2[224] = 128;
        nArray2[225] = 128;
        nArray2[226] = 128;
        nArray2[227] = 128;
        nArray2[228] = 128;
        nArray2[229] = 128;
        nArray2[230] = 128;
        nArray2[231] = 128;
        nArray2[232] = 128;
        nArray2[233] = 128;
        nArray2[234] = 128;
        nArray2[235] = 128;
        nArray2[236] = 128;
        nArray2[237] = 128;
        nArray2[238] = 134;
        nArray2[239] = 134;
        nArray2[254] = 7;
        nArray2[255] = 7;
        this.cycles2 = nArray2;
        int[] nArray3 = new int[256];
        nArray3[0] = 4;
        nArray3[128] = 10;
        nArray3[129] = 8;
        nArray3[130] = 8;
        nArray3[131] = 8;
        nArray3[132] = 8;
        nArray3[133] = 8;
        nArray3[134] = 8;
        nArray3[135] = 8;
        nArray3[136] = 8;
        nArray3[137] = 8;
        nArray3[138] = 8;
        nArray3[139] = 8;
        nArray3[140] = 8;
        nArray3[141] = 8;
        nArray3[142] = 8;
        nArray3[143] = 8;
        nArray3[144] = 8;
        nArray3[145] = 8;
        nArray3[146] = 8;
        nArray3[147] = 8;
        nArray3[148] = 8;
        nArray3[149] = 8;
        nArray3[150] = 8;
        nArray3[151] = 8;
        nArray3[152] = 8;
        nArray3[153] = 8;
        nArray3[154] = 8;
        nArray3[155] = 8;
        nArray3[156] = 8;
        nArray3[157] = 8;
        nArray3[158] = 8;
        nArray3[159] = 8;
        nArray3[160] = 8;
        nArray3[161] = 8;
        nArray3[162] = 8;
        nArray3[163] = 8;
        nArray3[164] = 8;
        nArray3[165] = 8;
        nArray3[166] = 8;
        nArray3[167] = 8;
        nArray3[168] = 8;
        nArray3[169] = 8;
        nArray3[170] = 8;
        nArray3[171] = 8;
        nArray3[172] = 8;
        nArray3[173] = 8;
        nArray3[174] = 8;
        nArray3[175] = 8;
        nArray3[176] = 8;
        nArray3[177] = 8;
        nArray3[178] = 8;
        nArray3[179] = 8;
        nArray3[180] = 8;
        nArray3[181] = 8;
        nArray3[182] = 8;
        nArray3[183] = 8;
        nArray3[184] = 8;
        nArray3[185] = 8;
        nArray3[186] = 8;
        nArray3[187] = 8;
        nArray3[188] = 8;
        nArray3[189] = 8;
        nArray3[190] = 8;
        nArray3[191] = 8;
        nArray3[192] = 8;
        nArray3[193] = 8;
        nArray3[194] = 8;
        nArray3[195] = 8;
        nArray3[196] = 8;
        nArray3[197] = 8;
        nArray3[198] = 8;
        nArray3[199] = 8;
        nArray3[200] = 8;
        nArray3[201] = 8;
        nArray3[202] = 8;
        nArray3[203] = 8;
        nArray3[204] = 8;
        nArray3[205] = 8;
        nArray3[206] = 8;
        nArray3[207] = 8;
        nArray3[208] = 8;
        nArray3[209] = 8;
        nArray3[210] = 8;
        nArray3[211] = 8;
        nArray3[212] = 8;
        nArray3[213] = 8;
        nArray3[214] = 8;
        nArray3[215] = 8;
        nArray3[216] = 8;
        nArray3[217] = 8;
        nArray3[218] = 8;
        nArray3[219] = 8;
        nArray3[220] = 8;
        nArray3[221] = 8;
        nArray3[222] = 8;
        nArray3[223] = 8;
        nArray3[224] = 8;
        nArray3[225] = 8;
        nArray3[226] = 8;
        nArray3[227] = 8;
        nArray3[228] = 8;
        nArray3[229] = 8;
        nArray3[230] = 8;
        nArray3[231] = 8;
        nArray3[232] = 8;
        nArray3[233] = 8;
        nArray3[234] = 8;
        nArray3[235] = 8;
        nArray3[236] = 8;
        nArray3[237] = 8;
        nArray3[238] = 8;
        nArray3[239] = 8;
        nArray3[240] = 8;
        nArray3[241] = 8;
        nArray3[242] = 8;
        nArray3[243] = 8;
        nArray3[244] = 8;
        nArray3[245] = 8;
        nArray3[246] = 8;
        nArray3[247] = 8;
        nArray3[248] = 8;
        nArray3[249] = 8;
        nArray3[250] = 8;
        nArray3[251] = 8;
        nArray3[252] = 8;
        nArray3[253] = 8;
        nArray3[254] = 8;
        nArray3[255] = 8;
        this.flags8i = nArray3;
        int[] nArray4 = new int[256];
        nArray4[0] = 4;
        nArray4[127] = 2;
        nArray4[128] = 8;
        nArray4[129] = 8;
        nArray4[130] = 8;
        nArray4[131] = 8;
        nArray4[132] = 8;
        nArray4[133] = 8;
        nArray4[134] = 8;
        nArray4[135] = 8;
        nArray4[136] = 8;
        nArray4[137] = 8;
        nArray4[138] = 8;
        nArray4[139] = 8;
        nArray4[140] = 8;
        nArray4[141] = 8;
        nArray4[142] = 8;
        nArray4[143] = 8;
        nArray4[144] = 8;
        nArray4[145] = 8;
        nArray4[146] = 8;
        nArray4[147] = 8;
        nArray4[148] = 8;
        nArray4[149] = 8;
        nArray4[150] = 8;
        nArray4[151] = 8;
        nArray4[152] = 8;
        nArray4[153] = 8;
        nArray4[154] = 8;
        nArray4[155] = 8;
        nArray4[156] = 8;
        nArray4[157] = 8;
        nArray4[158] = 8;
        nArray4[159] = 8;
        nArray4[160] = 8;
        nArray4[161] = 8;
        nArray4[162] = 8;
        nArray4[163] = 8;
        nArray4[164] = 8;
        nArray4[165] = 8;
        nArray4[166] = 8;
        nArray4[167] = 8;
        nArray4[168] = 8;
        nArray4[169] = 8;
        nArray4[170] = 8;
        nArray4[171] = 8;
        nArray4[172] = 8;
        nArray4[173] = 8;
        nArray4[174] = 8;
        nArray4[175] = 8;
        nArray4[176] = 8;
        nArray4[177] = 8;
        nArray4[178] = 8;
        nArray4[179] = 8;
        nArray4[180] = 8;
        nArray4[181] = 8;
        nArray4[182] = 8;
        nArray4[183] = 8;
        nArray4[184] = 8;
        nArray4[185] = 8;
        nArray4[186] = 8;
        nArray4[187] = 8;
        nArray4[188] = 8;
        nArray4[189] = 8;
        nArray4[190] = 8;
        nArray4[191] = 8;
        nArray4[192] = 8;
        nArray4[193] = 8;
        nArray4[194] = 8;
        nArray4[195] = 8;
        nArray4[196] = 8;
        nArray4[197] = 8;
        nArray4[198] = 8;
        nArray4[199] = 8;
        nArray4[200] = 8;
        nArray4[201] = 8;
        nArray4[202] = 8;
        nArray4[203] = 8;
        nArray4[204] = 8;
        nArray4[205] = 8;
        nArray4[206] = 8;
        nArray4[207] = 8;
        nArray4[208] = 8;
        nArray4[209] = 8;
        nArray4[210] = 8;
        nArray4[211] = 8;
        nArray4[212] = 8;
        nArray4[213] = 8;
        nArray4[214] = 8;
        nArray4[215] = 8;
        nArray4[216] = 8;
        nArray4[217] = 8;
        nArray4[218] = 8;
        nArray4[219] = 8;
        nArray4[220] = 8;
        nArray4[221] = 8;
        nArray4[222] = 8;
        nArray4[223] = 8;
        nArray4[224] = 8;
        nArray4[225] = 8;
        nArray4[226] = 8;
        nArray4[227] = 8;
        nArray4[228] = 8;
        nArray4[229] = 8;
        nArray4[230] = 8;
        nArray4[231] = 8;
        nArray4[232] = 8;
        nArray4[233] = 8;
        nArray4[234] = 8;
        nArray4[235] = 8;
        nArray4[236] = 8;
        nArray4[237] = 8;
        nArray4[238] = 8;
        nArray4[239] = 8;
        nArray4[240] = 8;
        nArray4[241] = 8;
        nArray4[242] = 8;
        nArray4[243] = 8;
        nArray4[244] = 8;
        nArray4[245] = 8;
        nArray4[246] = 8;
        nArray4[247] = 8;
        nArray4[248] = 8;
        nArray4[249] = 8;
        nArray4[250] = 8;
        nArray4[251] = 8;
        nArray4[252] = 8;
        nArray4[253] = 8;
        nArray4[254] = 8;
        nArray4[255] = 8;
        this.flags8d = nArray4;
        int[] nArray5 = new int[32];
        nArray5[1] = 1;
        nArray5[2] = 2;
        nArray5[3] = 3;
        nArray5[4] = 4;
        nArray5[5] = 5;
        nArray5[6] = 6;
        nArray5[7] = 7;
        nArray5[8] = 8;
        nArray5[9] = 9;
        nArray5[10] = 10;
        nArray5[11] = 11;
        nArray5[12] = 12;
        nArray5[13] = 13;
        nArray5[14] = 14;
        nArray5[15] = 15;
        nArray5[16] = -16;
        nArray5[17] = -15;
        nArray5[18] = -14;
        nArray5[19] = -13;
        nArray5[20] = -12;
        nArray5[21] = -11;
        nArray5[22] = -10;
        nArray5[23] = -9;
        nArray5[24] = -8;
        nArray5[25] = -7;
        nArray5[26] = -6;
        nArray5[27] = -5;
        nArray5[28] = -4;
        nArray5[29] = -3;
        nArray5[30] = -2;
        nArray5[31] = -1;
        this.signed5 = nArray5;
        this.mem = mem;
    }

    boolean init() {
        this.cpu_reset();
        return true;
    }

    void reset() {
        this.cpu_reset();
    }

    private void neg_di() {
        int t = this.DIRBYTE();
        int r = -t;
        this.CLR_NZVC();
        this.SET_FLAGS8(0, t, r);
        this.WRITEB(this.ea, r);
    }

    private void ngc_di() {
        if ((this.cc & 1) != 0) {
            this.com_di();
        } else {
            this.neg_di();
        }
    }

    private void com_di() {
        int t = this.DIRBYTE();
        t = ~t & 0xFF;
        this.CLR_NZV();
        this.SET_NZ8(t);
        this.SEC();
        this.WRITEB(this.ea, t);
    }

    private void lsr_di() {
        int t = this.DIRBYTE();
        this.CLR_NZC();
        this.cc |= t & 1;
        this.SET_Z8(t >>= 1);
        this.WRITEB(this.ea, t);
    }

    private void ror_di() {
        int t = this.DIRBYTE();
        int r = (this.cc & 1) << 7;
        this.CLR_NZC();
        this.cc |= t & 1;
        this.SET_NZ8(r |= t >> 1);
        this.WRITEB(this.ea, r);
    }

    private void asr_di() {
        int t = this.DIRBYTE();
        this.CLR_NZC();
        this.cc |= t & 1;
        t >>= 1;
        t |= (t & 0x40) << 1;
        this.SET_NZ8(t);
        this.WRITEB(this.ea, t);
    }

    private void asl_di() {
        int t = this.DIRBYTE();
        int r = t << 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r);
        this.WRITEB(this.ea, r);
    }

    private void rol_di() {
        int t = this.DIRBYTE();
        int r = this.cc & 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r |= t << 1);
        this.WRITEB(this.ea, r);
    }

    private void dec_di() {
        int t = this.DIRBYTE();
        this.CLR_NZV();
        this.SET_FLAGS8D(--t);
        this.WRITEB(this.ea, t);
    }

    private void dcc_di() {
        int t = this.DIRBYTE();
        this.CLR_NZVC();
        this.SET_FLAGS8D(--t);
        this.WRITEB(this.ea, t);
        if (t != 0) {
            this.SEC();
        }
    }

    private void inc_di() {
        int t = this.DIRBYTE();
        this.CLR_NZV();
        this.SET_FLAGS8I(++t);
        this.WRITEB(this.ea, t);
    }

    private void tst_di() {
        int t = this.DIRBYTE();
        this.CLR_NZV();
        this.SET_NZ8(t);
    }

    private void jmp_di() {
        this.DIRECT();
        this.pc = this.ea;
    }

    private void clr_di() {
        this.DIRECT();
        this.READB(this.ea);
        this.WRITEB(this.ea, 0);
        this.CLR_NZVC();
        this.SEZ();
    }

    private void nop() {
    }

    private void sync() {
        if ((this.intr & 0x20) == 0) {
            this.intr |= 0x20;
            this.intr &= 0xFFFFFFBF;
            --this.pc;
            return;
        }
        if ((this.intr & 0x40) == 0) {
            --this.pc;
            return;
        }
        this.intr &= 0xFFFFFFDF;
        this.intr &= 0xFFFFFFBF;
    }

    private void lbra() {
        int op = this.IMMWORD();
        if (op > Short.MAX_VALUE) {
            op |= 0xFFFF0000;
        }
        this.pc += op;
    }

    private void lbsr() {
        int op = this.IMMWORD();
        if (op > Short.MAX_VALUE) {
            op |= 0xFFFF0000;
        }
        this.PUSHWORD(this.pc);
        this.pc += op;
    }

    private void aslcc() {
        if ((this.cc & 4) != 0) {
            this.cc |= 1;
        }
        this.cc += this.cc;
        this.cc &= 0x3E;
    }

    private void daa() {
        int cf = 0;
        int msn = this.a & 0xF0;
        int lsn = this.a & 0xF;
        if (lsn > 9 || (this.cc & 0x20) != 0) {
            cf |= 6;
        }
        if (msn > 128 && lsn > 9) {
            cf |= 0x60;
        }
        if (msn > 144 || (this.cc & 1) != 0) {
            cf |= 0x60;
        }
        int t = cf + this.a;
        this.CLR_NZV();
        this.SET_NZ8(t);
        this.SET_C8(t);
        this.a = t & 0xFF;
    }

    private void orcc() {
        int t = this.IMMBYTE();
        this.cc |= t;
    }

    private void andcc() {
        int t = this.IMMBYTE();
        this.cc &= t;
    }

    private void sex() {
        int t = this.SIGNED(this.b);
        this.d(t);
        this.CLR_NZV();
        this.SET_NZ16(t);
    }

    private void exg() {
        int t1 = 0;
        int t2 = 0;
        int tb = this.IMMBYTE();
        t1 = this.GETREG(tb >> 4);
        t2 = this.GETREG(tb & 0xF);
        this.SETREG(t2, tb >> 4);
        this.SETREG(t1, tb & 0xF);
    }

    private void tfr() {
        int t = 0;
        int tb = this.IMMBYTE();
        t = this.GETREG(tb >> 4);
        this.SETREG(t, tb & 0xF);
    }

    private void bra() {
        int t = this.IMMBYTE();
        this.pc += this.SIGNED(t);
    }

    private void brn() {
        ++this.pc;
    }

    private void lbrn() {
        this.pc += 2;
    }

    private void bhi() {
        this.BRANCH((this.cc & 5) == 0);
    }

    private void lbhi() {
        this.LBRANCH((this.cc & 5) == 0);
    }

    private void bls() {
        this.BRANCH(this.cc & 5);
    }

    private void lbls() {
        this.LBRANCH(this.cc & 5);
    }

    private void bcc() {
        this.BRANCH((this.cc & 1) == 0);
    }

    private void lbcc() {
        this.LBRANCH((this.cc & 1) == 0);
    }

    private void bcs() {
        this.BRANCH(this.cc & 1);
    }

    private void lbcs() {
        this.LBRANCH(this.cc & 1);
    }

    private void bne() {
        this.BRANCH((this.cc & 4) == 0);
    }

    private void lbne() {
        this.LBRANCH((this.cc & 4) == 0);
    }

    private void beq() {
        this.BRANCH(this.cc & 4);
    }

    private void lbeq() {
        this.LBRANCH(this.cc & 4);
    }

    private void bvc() {
        this.BRANCH((this.cc & 2) == 0);
    }

    private void lbvc() {
        this.LBRANCH((this.cc & 2) == 0);
    }

    private void bvs() {
        this.BRANCH(this.cc & 2);
    }

    private void lbvs() {
        this.LBRANCH(this.cc & 2);
    }

    private void bpl() {
        this.BRANCH((this.cc & 8) == 0);
    }

    private void lbpl() {
        this.LBRANCH((this.cc & 8) == 0);
    }

    private void bmi() {
        this.BRANCH(this.cc & 8);
    }

    private void lbmi() {
        this.LBRANCH(this.cc & 8);
    }

    private void bge() {
        this.BRANCH(this.NXORV() == 0);
    }

    private void lbge() {
        this.LBRANCH(this.NXORV() == 0);
    }

    private void blt() {
        this.BRANCH(this.NXORV());
    }

    private void lblt() {
        this.LBRANCH(this.NXORV());
    }

    private void bgt() {
        this.BRANCH(this.NXORV() == 0 && (this.cc & 4) == 0);
    }

    private void lbgt() {
        this.LBRANCH(this.NXORV() == 0 && (this.cc & 4) == 0);
    }

    private void ble() {
        this.BRANCH(this.NXORV() != 0 || (this.cc & 4) != 0);
    }

    private void lble() {
        this.LBRANCH(this.NXORV() != 0 || (this.cc & 4) != 0);
    }

    private void leax() {
        this.x = this.ea & 0xFFFF;
        this.CLR_Z();
        this.SET_Z(this.x);
    }

    private void leay() {
        this.y = this.ea & 0xFFFF;
        this.CLR_Z();
        this.SET_Z(this.y);
    }

    private void leas() {
        this.s = this.ea & 0xFFFF;
    }

    private void leau() {
        this.u = this.ea & 0xFFFF;
    }

    private void pshs() {
        int t = this.IMMBYTE();
        if ((t & 0x80) != 0) {
            this.READB(this.s);
            this.PUSHWORD(this.pc);
            this.cycle += 2;
        }
        if ((t & 0x40) != 0) {
            this.READB(this.s);
            this.PUSHWORD(this.u);
            this.cycle += 2;
        }
        if ((t & 0x20) != 0) {
            this.READB(this.s);
            this.PUSHWORD(this.y);
            this.cycle += 2;
        }
        if ((t & 0x10) != 0) {
            this.READB(this.s);
            this.PUSHWORD(this.x);
            this.cycle += 2;
        }
        if ((t & 8) != 0) {
            this.READB(this.s);
            this.PUSHBYTE(this.dp);
            ++this.cycle;
        }
        if ((t & 4) != 0) {
            this.READB(this.s);
            this.PUSHBYTE(this.b);
            ++this.cycle;
        }
        if ((t & 2) != 0) {
            this.READB(this.s);
            this.PUSHBYTE(this.a);
            ++this.cycle;
        }
        if ((t & 1) != 0) {
            this.READB(this.s);
            this.PUSHBYTE(this.cc);
            ++this.cycle;
        }
    }

    private void puls() {
        int t = this.IMMBYTE();
        if ((t & 1) != 0) {
            this.cc = this.PULLBYTE();
            this.READB(this.s);
            ++this.cycle;
        }
        if ((t & 2) != 0) {
            this.a = this.PULLBYTE();
            this.READB(this.s);
            ++this.cycle;
        }
        if ((t & 4) != 0) {
            this.b = this.PULLBYTE();
            this.READB(this.s);
            ++this.cycle;
        }
        if ((t & 8) != 0) {
            this.dp = this.PULLBYTE();
            this.READB(this.s);
            ++this.cycle;
        }
        if ((t & 0x10) != 0) {
            this.x = this.PULLWORD();
            this.READB(this.s);
            this.cycle += 2;
        }
        if ((t & 0x20) != 0) {
            this.y = this.PULLWORD();
            this.READB(this.s);
            this.cycle += 2;
        }
        if ((t & 0x40) != 0) {
            this.u = this.PULLWORD();
            this.READB(this.s);
            this.cycle += 2;
        }
        if ((t & 0x80) != 0) {
            this.pc = this.PULLWORD();
            this.READB(this.s);
            this.cycle += 2;
        }
    }

    private void pshu() {
        int t = this.IMMBYTE();
        if ((t & 0x80) != 0) {
            this.READB(this.u);
            this.PSHUWORD(this.pc);
            this.cycle += 2;
        }
        if ((t & 0x40) != 0) {
            this.READB(this.u);
            this.PSHUWORD(this.s);
            this.cycle += 2;
        }
        if ((t & 0x20) != 0) {
            this.READB(this.u);
            this.PSHUWORD(this.y);
            this.cycle += 2;
        }
        if ((t & 0x10) != 0) {
            this.READB(this.u);
            this.PSHUWORD(this.x);
            this.cycle += 2;
        }
        if ((t & 8) != 0) {
            this.READB(this.u);
            this.PSHUBYTE(this.dp);
            ++this.cycle;
        }
        if ((t & 4) != 0) {
            this.READB(this.u);
            this.PSHUBYTE(this.b);
            ++this.cycle;
        }
        if ((t & 2) != 0) {
            this.READB(this.u);
            this.PSHUBYTE(this.a);
            ++this.cycle;
        }
        if ((t & 1) != 0) {
            this.READB(this.u);
            this.PSHUBYTE(this.cc);
            ++this.cycle;
        }
    }

    private void pulu() {
        int t = this.IMMBYTE();
        if ((t & 1) != 0) {
            this.cc = this.PULUBYTE();
            this.READB(this.u);
            ++this.cycle;
        }
        if ((t & 2) != 0) {
            this.a = this.PULUBYTE();
            this.READB(this.u);
            ++this.cycle;
        }
        if ((t & 4) != 0) {
            this.b = this.PULUBYTE();
            this.READB(this.u);
            ++this.cycle;
        }
        if ((t & 8) != 0) {
            this.dp = this.PULUBYTE();
            this.READB(this.u);
            ++this.cycle;
        }
        if ((t & 0x10) != 0) {
            this.x = this.PULUWORD();
            this.READB(this.u);
            this.cycle += 2;
        }
        if ((t & 0x20) != 0) {
            this.y = this.PULUWORD();
            this.READB(this.u);
            this.cycle += 2;
        }
        if ((t & 0x40) != 0) {
            this.s = this.PULUWORD();
            this.READB(this.u);
            this.cycle += 2;
        }
        if ((t & 0x80) != 0) {
            this.pc = this.PULUWORD();
            this.READB(this.u);
            this.cycle += 2;
        }
    }

    private void rts() {
        this.pc = this.PULLWORD();
    }

    private void abx() {
        this.x += this.b & 0xFFFF;
    }

    private void rti() {
        this.cc = this.PULLBYTE();
        if ((this.cc & 0x80) != 0) {
            this.a = this.PULLBYTE();
            this.b = this.PULLBYTE();
            this.dp = this.PULLBYTE();
            this.x = this.PULLWORD();
            this.y = this.PULLWORD();
            this.u = this.PULLWORD();
            this.cycle += 9;
        }
        this.pc = this.PULLWORD();
    }

    private void cwai() {
        if ((this.intr & 0x80) == 0) {
            int t = this.IMMBYTE();
            this.cc &= t;
            this.intr |= 0x80;
            this.intr &= 0xFFFFFEFF;
            this.pc -= 2;
            return;
        }
        if ((this.intr & 0x100) == 0) {
            --this.pc;
            return;
        }
        this.intr &= 0xFFFFFF7F;
        this.intr &= 0xFFFFFEFF;
        ++this.pc;
    }

    private void mul() {
        int t = this.a * this.b;
        this.CLR_ZC();
        this.SET_Z16(t);
        if ((t & 0x80) != 0) {
            this.SEC();
        }
        this.d(t);
    }

    private void rst() {
        this.cpu_reset();
    }

    private void swi() {
        this.cc |= 0x80;
        this.PUSHWORD(this.pc);
        this.PUSHWORD(this.u);
        this.PUSHWORD(this.y);
        this.PUSHWORD(this.x);
        this.PUSHBYTE(this.dp);
        this.PUSHBYTE(this.b);
        this.PUSHBYTE(this.a);
        this.PUSHBYTE(this.cc);
        this.cc |= 0x50;
        this.pc = this.READW(65530);
    }

    private void swi2() {
        this.cc |= 0x80;
        this.PUSHWORD(this.pc);
        this.PUSHWORD(this.u);
        this.PUSHWORD(this.y);
        this.PUSHWORD(this.x);
        this.PUSHBYTE(this.dp);
        this.PUSHBYTE(this.b);
        this.PUSHBYTE(this.a);
        this.PUSHBYTE(this.cc);
        this.pc = this.READW(65524);
    }

    private void swi3() {
        this.cc |= 0x80;
        this.PUSHWORD(this.pc);
        this.PUSHWORD(this.u);
        this.PUSHWORD(this.y);
        this.PUSHWORD(this.x);
        this.PUSHBYTE(this.dp);
        this.PUSHBYTE(this.b);
        this.PUSHBYTE(this.a);
        this.PUSHBYTE(this.cc);
        this.pc = this.READW(65522);
    }

    private void nega() {
        int r = -this.a;
        this.CLR_NZVC();
        this.SET_FLAGS8(0, this.a, r);
        this.a = r & 0xFF;
    }

    private void ngca() {
        if ((this.cc & 1) != 0) {
            this.coma();
        } else {
            this.nega();
        }
    }

    private void coma() {
        this.a = ~this.a & 0xFF;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
        this.SEC();
    }

    private void lsra() {
        this.CLR_NZC();
        this.cc |= this.a & 1;
        this.a >>= 1;
        this.SET_Z8(this.a);
    }

    private void rora() {
        int r = (this.cc & 1) << 7;
        this.CLR_NZC();
        this.cc |= this.a & 1;
        this.SET_NZ8(r |= this.a >> 1);
        this.a = r;
    }

    private void asra() {
        this.CLR_NZC();
        this.cc |= this.a & 1;
        this.a >>= 1;
        this.a |= (this.a & 0x40) << 1;
        this.SET_NZ8(this.a);
    }

    private void asla() {
        int r = this.a << 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, this.a, r);
        this.a = r & 0xFF;
    }

    private void rola() {
        int t = this.a;
        int r = this.cc & 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r |= t << 1);
        this.a = r & 0xFF;
    }

    private void deca() {
        this.a = this.a - 1 & 0xFF;
        this.CLR_NZV();
        this.SET_FLAGS8D(this.a);
    }

    private void dcca() {
        this.a = this.a - 1 & 0xFF;
        this.CLR_NZVC();
        this.SET_FLAGS8D(this.a);
        if (this.a != 0) {
            this.SEC();
        }
    }

    private void inca() {
        this.a = this.a + 1 & 0xFF;
        this.CLR_NZV();
        this.SET_FLAGS8I(this.a);
    }

    private void tsta() {
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void clca() {
        this.a = 0;
        this.CLR_NZV();
        this.SEZ();
    }

    private void clra() {
        this.a = 0;
        this.CLR_NZVC();
        this.SEZ();
    }

    private void negb() {
        int r = -this.b;
        this.CLR_NZVC();
        this.SET_FLAGS8(0, this.b, r);
        this.b = r & 0xFF;
    }

    private void ngcb() {
        if ((this.cc & 1) != 0) {
            this.comb();
        } else {
            this.negb();
        }
    }

    private void comb() {
        this.b = ~this.b & 0xFF;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
        this.SEC();
    }

    private void lsrb() {
        this.CLR_NZC();
        this.cc |= this.b & 1;
        this.b >>= 1;
        this.SET_Z8(this.b);
    }

    private void rorb() {
        int r = (this.cc & 1) << 7;
        this.CLR_NZC();
        this.cc |= this.b & 1;
        this.SET_NZ8(r |= this.b >> 1);
        this.b = r;
    }

    private void asrb() {
        this.CLR_NZC();
        this.cc |= this.b & 1;
        this.b >>= 1;
        this.b |= (this.b & 0x40) << 1;
        this.SET_NZ8(this.b);
    }

    private void aslb() {
        int r = this.b << 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, this.b, r);
        this.b = r & 0xFF;
    }

    private void rolb() {
        int t = this.b;
        int r = this.cc & 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r |= t << 1);
        this.b = r & 0xFF;
    }

    private void decb() {
        this.b = this.b - 1 & 0xFF;
        this.CLR_NZV();
        this.SET_FLAGS8D(this.b);
    }

    private void dccb() {
        this.b = this.b - 1 & 0xFF;
        this.CLR_NZVC();
        this.SET_FLAGS8D(this.b);
        if (this.b != 0) {
            this.SEC();
        }
    }

    private void incb() {
        this.b = this.b + 1 & 0xFF;
        this.CLR_NZV();
        this.SET_FLAGS8I(this.b);
    }

    private void tstb() {
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void clcb() {
        this.b = 0;
        this.CLR_NZV();
        this.SEZ();
    }

    private void clrb() {
        this.b = 0;
        this.CLR_NZVC();
        this.SEZ();
    }

    private void neg_ix() {
        int t = this.READB(this.ea);
        int r = -t;
        this.CLR_NZVC();
        this.SET_FLAGS8(0, t, r);
        this.WRITEB(this.ea, r);
    }

    private void ngc_ix() {
        if ((this.cc & 1) != 0) {
            this.com_ix();
        } else {
            this.neg_ix();
        }
    }

    private void com_ix() {
        int t = ~this.READB(this.ea) & 0xFF;
        this.CLR_NZV();
        this.SET_NZ8(t);
        this.SEC();
        this.WRITEB(this.ea, t);
    }

    private void lsr_ix() {
        int t = this.READB(this.ea);
        this.CLR_NZC();
        this.cc |= t & 1;
        this.SET_Z8(t >>= 1);
        this.WRITEB(this.ea, t);
    }

    private void ror_ix() {
        int t = this.READB(this.ea);
        int r = (this.cc & 1) << 7;
        this.CLR_NZC();
        this.cc |= t & 1;
        this.SET_NZ8(r |= t >> 1);
        this.WRITEB(this.ea, r);
    }

    private void asr_ix() {
        int t = this.READB(this.ea);
        this.CLR_NZC();
        this.cc |= t & 1;
        t >>= 1;
        t |= (t & 0x40) << 1;
        this.SET_NZ8(t);
        this.WRITEB(this.ea, t);
    }

    private void asl_ix() {
        int t = this.READB(this.ea);
        int r = t << 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r);
        this.WRITEB(this.ea, r);
    }

    private void rol_ix() {
        int t = this.READB(this.ea);
        int r = this.cc & 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r |= t << 1);
        this.WRITEB(this.ea, r);
    }

    private void dec_ix() {
        int t = this.READB(this.ea) - 1;
        this.CLR_NZV();
        this.SET_FLAGS8D(t);
        this.WRITEB(this.ea, t);
    }

    private void dcc_ix() {
        int t = this.READB(this.ea) - 1;
        this.CLR_NZVC();
        this.SET_FLAGS8D(t);
        this.WRITEB(this.ea, t);
        if (t != 0) {
            this.SEC();
        }
    }

    private void inc_ix() {
        int t = this.READB(this.ea) + 1;
        this.CLR_NZV();
        this.SET_FLAGS8I(t);
        this.WRITEB(this.ea, t);
    }

    private void tst_ix() {
        int t = this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(t);
    }

    private void jmp_ix() {
        this.pc = this.ea;
    }

    private void clr_ix() {
        this.READB(this.ea);
        this.WRITEB(this.ea, 0);
        this.CLR_NZVC();
        this.SEZ();
    }

    private void neg_ex() {
        int t = this.EXTBYTE();
        int r = -t;
        this.CLR_NZVC();
        this.SET_FLAGS8(0, t, r);
        this.WRITEB(this.ea, r);
    }

    private void ngc_ex() {
        if ((this.cc & 1) != 0) {
            this.com_ex();
        } else {
            this.neg_ex();
        }
    }

    private void com_ex() {
        int t = this.EXTBYTE();
        this.CLR_NZV();
        this.SET_NZ8(t ^= 0xFFFFFFFF);
        this.SEC();
        this.WRITEB(this.ea, t);
    }

    private void lsr_ex() {
        int t = this.EXTBYTE();
        this.CLR_NZC();
        this.cc |= t & 1;
        this.SET_Z8(t >>= 1);
        this.WRITEB(this.ea, t);
    }

    private void ror_ex() {
        int t = this.EXTBYTE();
        int r = (this.cc & 1) << 7;
        this.CLR_NZC();
        this.cc |= t & 1;
        this.SET_NZ8(r |= t >> 1);
        this.WRITEB(this.ea, r);
    }

    private void asr_ex() {
        int t = this.EXTBYTE();
        this.CLR_NZC();
        this.cc |= t & 1;
        t >>= 1;
        t |= (t & 0x40) << 1;
        this.SET_NZ8(t);
        this.WRITEB(this.ea, t);
    }

    private void asl_ex() {
        int t = this.EXTBYTE();
        int r = t << 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r);
        this.WRITEB(this.ea, r);
    }

    private void rol_ex() {
        int t = this.EXTBYTE();
        int r = this.cc & 1;
        this.CLR_NZVC();
        this.SET_FLAGS8(t, t, r |= t << 1);
        this.WRITEB(this.ea, r);
    }

    private void dec_ex() {
        int t = this.EXTBYTE();
        this.CLR_NZV();
        this.SET_FLAGS8D(--t);
        this.WRITEB(this.ea, t);
    }

    private void dcc_ex() {
        int t = this.EXTBYTE();
        this.CLR_NZV();
        this.SET_FLAGS8D(--t);
        this.WRITEB(this.ea, t);
        if (t != 0) {
            this.SEC();
        }
    }

    private void inc_ex() {
        int t = this.EXTBYTE();
        this.CLR_NZV();
        this.SET_FLAGS8I(++t);
        this.WRITEB(this.ea, t);
    }

    private void tst_ex() {
        int t = this.EXTBYTE();
        this.CLR_NZV();
        this.SET_NZ8(t);
    }

    private void jmp_ex() {
        this.EXTENDED();
        this.pc = this.ea;
    }

    private void clr_ex() {
        this.EXTENDED();
        this.READB(this.ea);
        this.WRITEB(this.ea, 0);
        this.CLR_NZVC();
        this.SEZ();
    }

    private void suba_im() {
        int t = this.IMMBYTE();
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpa_im() {
        int t = this.IMMBYTE();
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
    }

    private void sbca_im() {
        int t = this.IMMBYTE();
        int r = this.a - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void subd_im() {
        int t = this.IMMWORD();
        int r = this.d() - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
        this.d(r);
    }

    private void cmpd_im() {
        int t = this.IMMWORD();
        int r = this.d() - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
    }

    private void cmpu_im() {
        int b = this.IMMWORD();
        int r = this.u - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.u, b, r);
    }

    private void anda_im() {
        int t = this.IMMBYTE();
        this.a &= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void bita_im() {
        int t = this.IMMBYTE();
        int r = this.a & t;
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void lda_im() {
        this.a = this.IMMBYTE();
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void flag8_im() {
        this.IMMBYTE();
        this.CLR_NZV();
        this.cc |= 8;
    }

    private void eora_im() {
        int t = this.IMMBYTE();
        this.a ^= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adca_im() {
        int t = this.IMMBYTE();
        int r = this.a + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void ora_im() {
        int t = this.IMMBYTE();
        this.a |= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adda_im() {
        int t = this.IMMBYTE();
        int r = this.a + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpx_im() {
        int b = this.IMMWORD();
        int d = this.x;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void cmpy_im() {
        int b = this.IMMWORD();
        int d = this.y;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void cmps_im() {
        int b = this.IMMWORD();
        int d = this.s;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void bsr() {
        int t = this.IMMBYTE();
        this.PUSHWORD(this.pc);
        this.pc += this.SIGNED(t);
    }

    private void ldx_im() {
        this.x = this.IMMWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.x);
    }

    private void ldy_im() {
        this.y = this.IMMWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.y);
    }

    private void flag16_im() {
        this.IMMWORD();
        this.CLR_NZV();
        this.cc |= 8;
    }

    private void sty_im() {
    }

    private void suba_di() {
        int t = this.DIRBYTE();
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpa_di() {
        int t = this.DIRBYTE();
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
    }

    private void sbca_di() {
        int t = this.DIRBYTE();
        int r = this.a - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void subd_di() {
        int b = this.DIRWORD();
        int r = this.d() - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), b, r);
        this.d(r);
    }

    private void cmpd_di() {
        int b = this.DIRWORD();
        int r = this.d() - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), b, r);
    }

    private void cmpu_di() {
        int b = this.DIRWORD();
        int r = this.u - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.u, b, r);
    }

    private void anda_di() {
        int t = this.DIRBYTE();
        this.a &= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void bita_di() {
        int t = this.DIRBYTE();
        int r = this.a & t;
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void lda_di() {
        this.a = this.DIRBYTE();
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void sta_di() {
        this.CLR_NZV();
        this.SET_NZ8(this.a);
        this.DIRECT();
        this.WRITEB(this.ea, this.a);
    }

    private void eora_di() {
        int t = this.DIRBYTE();
        this.a ^= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adca_di() {
        int t = this.DIRBYTE();
        int r = this.a + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void ora_di() {
        int t = this.DIRBYTE();
        this.a |= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adda_di() {
        int t = this.DIRBYTE();
        int r = this.a + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpx_di() {
        int b = this.DIRWORD();
        int d = this.x;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void cmpy_di() {
        int b = this.DIRWORD();
        int d = this.y;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void cmps_di() {
        int b = this.DIRWORD();
        int d = this.s;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void jsr_di() {
        this.DIRECT();
        this.PUSHWORD(this.pc);
        this.pc = this.ea;
    }

    private void ldx_di() {
        this.x = this.DIRWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.x);
    }

    private void ldy_di() {
        this.y = this.DIRWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.y);
    }

    private void stx_di() {
        this.CLR_NZV();
        this.SET_NZ16(this.x);
        this.DIRECT();
        this.WRITEW(this.ea, this.x);
    }

    private void sty_di() {
        this.CLR_NZV();
        this.SET_NZ16(this.y);
        this.DIRECT();
        this.WRITEW(this.ea, this.y);
    }

    private void suba_ix() {
        int t = this.READB(this.ea);
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpa_ix() {
        int t = this.READB(this.ea);
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
    }

    private void sbca_ix() {
        int t = this.READB(this.ea);
        int r = this.a - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void subd_ix() {
        int t = this.READW(this.ea);
        int r = this.d() - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
        this.d(r);
    }

    private void cmpd_ix() {
        int t = this.READW(this.ea);
        int r = this.d() - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
    }

    private void cmpu_ix() {
        int t = this.READW(this.ea);
        int r = this.u - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.u, t, r);
    }

    private void anda_ix() {
        this.a &= this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void bita_ix() {
        int r = this.a & this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void lda_ix() {
        this.a = this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void sta_ix() {
        this.CLR_NZV();
        this.SET_NZ8(this.a);
        this.WRITEB(this.ea, this.a);
    }

    private void eora_ix() {
        this.a ^= this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adca_ix() {
        int t = this.READB(this.ea);
        int r = this.a + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void ora_ix() {
        this.a |= this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adda_ix() {
        int t = this.READB(this.ea);
        int r = this.a + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpx_ix() {
        int t = this.READW(this.ea);
        int r = this.x - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.x, t, r);
    }

    private void cmpy_ix() {
        int t = this.READW(this.ea);
        int r = this.y - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.y, t, r);
    }

    private void cmps_ix() {
        int t = this.READW(this.ea);
        int r = this.s - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.s, t, r);
    }

    private void jsr_ix() {
        this.PUSHWORD(this.pc);
        this.pc = this.ea;
    }

    private void ldx_ix() {
        this.x = this.READW(this.ea);
        this.CLR_NZV();
        this.SET_NZ16(this.x);
    }

    private void ldy_ix() {
        this.y = this.READW(this.ea);
        this.CLR_NZV();
        this.SET_NZ16(this.y);
    }

    private void stx_ix() {
        this.CLR_NZV();
        this.SET_NZ16(this.x);
        this.WRITEW(this.ea, this.x);
    }

    private void sty_ix() {
        this.CLR_NZV();
        this.SET_NZ16(this.y);
        this.WRITEW(this.ea, this.y);
    }

    private void suba_ex() {
        int t = this.EXTBYTE();
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpa_ex() {
        int t = this.EXTBYTE();
        int r = this.a - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
    }

    private void sbca_ex() {
        int t = this.EXTBYTE();
        int r = this.a - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void subd_ex() {
        int t = this.EXTWORD();
        int r = this.d() - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
        this.d(r);
    }

    private void cmpd_ex() {
        int t = this.EXTWORD();
        int r = this.d() - (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
    }

    private void cmpu_ex() {
        int b = this.EXTWORD();
        int r = this.u - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.u, b, r);
    }

    private void anda_ex() {
        int t = this.EXTBYTE();
        this.a &= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void bita_ex() {
        int t = this.EXTBYTE();
        int r = this.a & t;
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void lda_ex() {
        this.a = this.EXTBYTE();
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void sta_ex() {
        this.CLR_NZV();
        this.SET_NZ8(this.a);
        this.EXTENDED();
        this.WRITEB(this.ea, this.a);
    }

    private void eora_ex() {
        int t = this.EXTBYTE();
        this.a ^= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adca_ex() {
        int t = this.EXTBYTE();
        int r = this.a + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void ora_ex() {
        int t = this.EXTBYTE();
        this.a |= t;
        this.CLR_NZV();
        this.SET_NZ8(this.a);
    }

    private void adda_ex() {
        int t = this.EXTBYTE();
        int r = this.a + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.a, t, r);
        this.SET_H(this.a, t, r);
        this.a = r & 0xFF;
    }

    private void cmpx_ex() {
        int b = this.EXTWORD();
        int d = this.x;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void cmpy_ex() {
        int b = this.EXTWORD();
        int d = this.y;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void cmps_ex() {
        int b = this.EXTWORD();
        int d = this.s;
        int r = d - (b &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(d, b, r);
    }

    private void jsr_ex() {
        this.EXTENDED();
        this.PUSHWORD(this.pc);
        this.pc = this.ea;
    }

    private void ldx_ex() {
        this.x = this.EXTWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.x);
    }

    private void ldy_ex() {
        this.y = this.EXTWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.y);
    }

    private void stx_ex() {
        this.CLR_NZV();
        this.SET_NZ16(this.x);
        this.EXTENDED();
        this.WRITEW(this.ea, this.x);
    }

    private void sty_ex() {
        this.CLR_NZV();
        this.SET_NZ16(this.y);
        this.EXTENDED();
        this.WRITEW(this.ea, this.y);
    }

    private void subb_im() {
        int t = this.IMMBYTE();
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void cmpb_im() {
        int t = this.IMMBYTE();
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
    }

    private void sbcb_im() {
        int t = this.IMMBYTE();
        int r = this.b - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void addd_im() {
        int t = this.IMMWORD();
        int r = this.d() + (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
        this.d(r);
    }

    private void andb_im() {
        int t = this.IMMBYTE();
        this.b &= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void bitb_im() {
        int t = this.IMMBYTE();
        int r = this.b & t;
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void ldb_im() {
        this.b = this.IMMBYTE();
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void eorb_im() {
        int t = this.IMMBYTE();
        this.b ^= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void adcb_im() {
        int t = this.IMMBYTE();
        int r = this.b + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void orb_im() {
        int t = this.IMMBYTE();
        this.b |= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void addb_im() {
        int t = this.IMMBYTE();
        int r = this.b + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void ldd_im() {
        int t = this.IMMWORD();
        this.d(t);
        this.CLR_NZV();
        this.SET_NZ16(t);
    }

    private void ldu_im() {
        this.u = this.IMMWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.u);
    }

    private void lds_im() {
        this.s = this.IMMWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.s);
        this.intr |= 0x10;
    }

    private void sts_im() {
    }

    private void subb_di() {
        int t = this.DIRBYTE();
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void cmpb_di() {
        int t = this.DIRBYTE();
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
    }

    private void sbcb_di() {
        int t = this.DIRBYTE();
        int r = this.b - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void addd_di() {
        int t = this.DIRWORD();
        int r = this.d() + (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
        this.d(r);
    }

    private void andb_di() {
        int t = this.DIRBYTE();
        this.b &= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void bitb_di() {
        int t = this.DIRBYTE();
        int r = this.b & t;
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void ldb_di() {
        this.b = this.DIRBYTE();
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void stb_di() {
        this.CLR_NZV();
        this.SET_NZ8(this.b);
        this.DIRECT();
        this.WRITEB(this.ea, this.b);
    }

    private void eorb_di() {
        int t = this.DIRBYTE();
        this.b ^= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void adcb_di() {
        int t = this.DIRBYTE();
        int r = this.b + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void orb_di() {
        int t = this.DIRBYTE();
        this.b |= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void addb_di() {
        int t = this.DIRBYTE();
        int r = this.b + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void ldd_di() {
        int t = this.DIRWORD();
        this.d(t);
        this.CLR_NZV();
        this.SET_NZ16(t);
    }

    private void std_di() {
        this.DIRECT();
        this.CLR_NZV();
        this.SET_NZ16(this.d());
        this.WRITEW(this.ea, this.d());
    }

    private void ldu_di() {
        this.u = this.DIRWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.u);
    }

    private void lds_di() {
        this.s = this.DIRWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.s);
        this.intr |= 0x10;
    }

    private void stu_di() {
        this.CLR_NZV();
        this.SET_NZ16(this.u);
        this.DIRECT();
        this.WRITEW(this.ea, this.u);
    }

    private void sts_di() {
        this.CLR_NZV();
        this.SET_NZ16(this.s);
        this.DIRECT();
        this.WRITEW(this.ea, this.s);
    }

    private void subb_ix() {
        int t = this.READB(this.ea);
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void cmpb_ix() {
        int t = this.READB(this.ea);
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
    }

    private void sbcb_ix() {
        int t = this.READB(this.ea);
        int r = this.b - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void addd_ix() {
        int t = this.READW(this.ea);
        int r = this.d() + (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
        this.d(r);
    }

    private void andb_ix() {
        this.b &= this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void bitb_ix() {
        int r = this.b & this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void ldb_ix() {
        this.b = this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void stb_ix() {
        this.CLR_NZV();
        this.SET_NZ8(this.b);
        this.WRITEB(this.ea, this.b);
    }

    private void eorb_ix() {
        this.b ^= this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void adcb_ix() {
        int t = this.READB(this.ea);
        int r = this.b + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void orb_ix() {
        this.b |= this.READB(this.ea);
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void addb_ix() {
        int t = this.READB(this.ea);
        int r = this.b + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void ldd_ix() {
        int t = this.READW(this.ea);
        this.CLR_NZV();
        this.SET_NZ16(t);
        this.d(t);
    }

    private void std_ix() {
        this.CLR_NZV();
        this.SET_NZ16(this.d());
        this.WRITEW(this.ea, this.d());
    }

    private void ldu_ix() {
        this.u = this.READW(this.ea);
        this.CLR_NZV();
        this.SET_NZ16(this.u);
    }

    private void lds_ix() {
        this.s = this.READW(this.ea);
        this.CLR_NZV();
        this.SET_NZ16(this.s);
        this.intr |= 0x10;
    }

    private void stu_ix() {
        this.CLR_NZV();
        this.SET_NZ16(this.u);
        this.WRITEW(this.ea, this.u);
    }

    private void sts_ix() {
        this.CLR_NZV();
        this.SET_NZ16(this.s);
        this.WRITEW(this.ea, this.s);
    }

    private void subb_ex() {
        int t = this.EXTBYTE();
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void cmpb_ex() {
        int t = this.EXTBYTE();
        int r = this.b - t;
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
    }

    private void sbcb_ex() {
        int t = this.EXTBYTE();
        int r = this.b - t - (this.cc & 1);
        this.CLR_NZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void addd_ex() {
        int t = this.EXTWORD();
        int r = this.d() + (t &= 0xFFFF);
        this.CLR_NZVC();
        this.SET_FLAGS16(this.d(), t, r);
        this.d(r);
    }

    private void andb_ex() {
        int t = this.EXTBYTE();
        this.b &= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void bitb_ex() {
        int t = this.EXTBYTE();
        int r = this.b & t;
        this.CLR_NZV();
        this.SET_NZ8(r);
    }

    private void ldb_ex() {
        this.b = this.EXTBYTE();
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void stb_ex() {
        this.CLR_NZV();
        this.SET_NZ8(this.b);
        this.EXTENDED();
        this.WRITEB(this.ea, this.b);
    }

    private void eorb_ex() {
        int t = this.EXTBYTE();
        this.b ^= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void adcb_ex() {
        int t = this.EXTBYTE();
        int r = this.b + t + (this.cc & 1);
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void orb_ex() {
        int t = this.EXTBYTE();
        this.b |= t;
        this.CLR_NZV();
        this.SET_NZ8(this.b);
    }

    private void addb_ex() {
        int t = this.EXTBYTE();
        int r = this.b + t;
        this.CLR_HNZVC();
        this.SET_FLAGS8(this.b, t, r);
        this.SET_H(this.b, t, r);
        this.b = r & 0xFF;
    }

    private void ldd_ex() {
        int t = this.EXTWORD();
        this.d(t);
        this.CLR_NZV();
        this.SET_NZ16(t);
    }

    private void std_ex() {
        this.EXTENDED();
        this.CLR_NZV();
        this.SET_NZ16(this.d());
        this.WRITEW(this.ea, this.d());
    }

    private void ldu_ex() {
        this.u = this.EXTWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.u);
    }

    private void lds_ex() {
        this.s = this.EXTWORD();
        this.CLR_NZV();
        this.SET_NZ16(this.s);
        this.intr |= 0x10;
    }

    private void stu_ex() {
        this.CLR_NZV();
        this.SET_NZ16(this.u);
        this.EXTENDED();
        this.WRITEW(this.ea, this.u);
    }

    private void sts_ex() {
        this.CLR_NZV();
        this.SET_NZ16(this.s);
        this.EXTENDED();
        this.WRITEW(this.ea, this.s);
    }

    private void illegal() {
    }

    private void cpu_calc_ea() {
        int pb;
        if ((pb = this.READB(this.pc++)) < 128) {
            this.ea = this.signed5[pb & 0x1F];
            switch ((pb & 0x70) >>> 5) {
                case 0: {
                    this.ea += this.x;
                    break;
                }
                case 1: {
                    this.ea += this.y;
                    break;
                }
                case 2: {
                    this.ea += this.u;
                    break;
                }
                case 3: {
                    this.ea += this.s;
                }
            }
            ++this.cycle;
        }
        if (pb < 192) {
            if (pb < 160) {
                switch (pb) {
                    case 128: {
                        this.ea = this.x++;
                        this.cycle += 2;
                        break;
                    }
                    case 129: {
                        this.ea = this.x;
                        this.x += 2;
                        this.cycle += 3;
                        break;
                    }
                    case 130: {
                        --this.x;
                        this.ea = this.x;
                        this.cycle += 2;
                        break;
                    }
                    case 131: {
                        this.x -= 2;
                        this.ea = this.x;
                        this.cycle += 3;
                        break;
                    }
                    case 132: {
                        this.ea = this.x;
                        break;
                    }
                    case 133: {
                        this.ea = this.x + this.SIGNED(this.b);
                        ++this.cycle;
                        break;
                    }
                    case 134: {
                        this.ea = this.x + this.SIGNED(this.a);
                        ++this.cycle;
                        break;
                    }
                    case 135: {
                        this.ea = 0;
                        break;
                    }
                    case 136: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.x + this.SIGNED(this.ea);
                        ++this.cycle;
                        break;
                    }
                    case 137: {
                        this.ea = this.IMMWORD();
                        this.ea = this.x + this.SIGNED16(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 138: {
                        this.ea = 0;
                        break;
                    }
                    case 139: {
                        this.ea = this.x + this.d();
                        this.cycle += 4;
                        break;
                    }
                    case 140: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.pc + this.SIGNED(this.ea);
                        ++this.cycle;
                        break;
                    }
                    case 141: {
                        this.ea = this.IMMWORD();
                        this.ea = this.pc + this.SIGNED16(this.ea);
                        this.cycle += 5;
                        break;
                    }
                    case 142: {
                        this.ea = 0;
                        break;
                    }
                    case 143: {
                        this.ea = this.IMMWORD();
                        this.cycle += 5;
                        break;
                    }
                    case 144: {
                        this.ea = this.x++;
                        this.ea = this.READW(this.ea);
                        this.cycle += 5;
                        break;
                    }
                    case 145: {
                        this.ea = this.x;
                        this.x += 2;
                        this.ea = this.READW(this.ea);
                        this.cycle += 6;
                        break;
                    }
                    case 146: {
                        --this.x;
                        this.ea = this.x;
                        this.ea = this.READW(this.ea);
                        this.cycle += 5;
                        break;
                    }
                    case 147: {
                        this.x -= 2;
                        this.ea = this.x;
                        this.ea = this.READW(this.ea);
                        this.cycle += 6;
                        break;
                    }
                    case 148: {
                        this.ea = this.x;
                        this.ea = this.READW(this.ea);
                        this.cycle += 3;
                        break;
                    }
                    case 149: {
                        this.ea = this.x + this.SIGNED(this.b);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 150: {
                        this.ea = this.x + this.SIGNED(this.a);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 151: {
                        this.ea = 0;
                        break;
                    }
                    case 152: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.x + this.SIGNED(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 153: {
                        this.ea = this.IMMWORD();
                        this.ea = this.x + this.SIGNED16(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 7;
                        break;
                    }
                    case 154: {
                        this.ea = 0;
                        break;
                    }
                    case 155: {
                        this.ea = this.x + this.d();
                        this.ea = this.READW(this.ea);
                        this.cycle += 7;
                        break;
                    }
                    case 156: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.pc + this.SIGNED(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 157: {
                        this.ea = this.IMMWORD();
                        this.ea = this.pc + this.SIGNED16(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 8;
                        break;
                    }
                    case 158: {
                        this.ea = 0;
                        break;
                    }
                    case 159: {
                        this.ea = this.IMMWORD();
                        this.ea = this.READW(this.ea);
                        this.cycle += 5;
                    }
                }
            } else {
                switch (pb) {
                    case 160: {
                        this.ea = this.y++;
                        this.cycle += 2;
                        break;
                    }
                    case 161: {
                        this.ea = this.y;
                        this.y += 2;
                        this.cycle += 3;
                        break;
                    }
                    case 162: {
                        --this.y;
                        this.ea = this.y;
                        this.cycle += 2;
                        break;
                    }
                    case 163: {
                        this.y -= 2;
                        this.ea = this.y;
                        this.cycle += 3;
                        break;
                    }
                    case 164: {
                        this.ea = this.y;
                        break;
                    }
                    case 165: {
                        this.ea = this.y + this.SIGNED(this.b);
                        ++this.cycle;
                        break;
                    }
                    case 166: {
                        this.ea = this.y + this.SIGNED(this.a);
                        ++this.cycle;
                        break;
                    }
                    case 167: {
                        this.ea = 0;
                        break;
                    }
                    case 168: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.y + this.SIGNED(this.ea);
                        ++this.cycle;
                        break;
                    }
                    case 169: {
                        this.ea = this.IMMWORD();
                        this.ea = this.y + this.SIGNED16(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 170: {
                        this.ea = 0;
                        break;
                    }
                    case 171: {
                        this.ea = this.y + this.d();
                        this.cycle += 4;
                        break;
                    }
                    case 172: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.pc + this.SIGNED(this.ea);
                        ++this.cycle;
                        break;
                    }
                    case 173: {
                        this.ea = this.IMMWORD();
                        this.ea = this.pc + this.SIGNED16(this.ea);
                        this.cycle += 5;
                        break;
                    }
                    case 174: {
                        this.ea = 0;
                        break;
                    }
                    case 175: {
                        this.ea = this.IMMWORD();
                        this.cycle += 5;
                        break;
                    }
                    case 176: {
                        this.ea = this.y++;
                        this.ea = this.READW(this.ea);
                        this.cycle += 5;
                        break;
                    }
                    case 177: {
                        this.ea = this.y;
                        this.y += 2;
                        this.ea = this.READW(this.ea);
                        this.cycle += 6;
                        break;
                    }
                    case 178: {
                        --this.y;
                        this.ea = this.y;
                        this.ea = this.READW(this.ea);
                        this.cycle += 5;
                        break;
                    }
                    case 179: {
                        this.y -= 2;
                        this.ea = this.y;
                        this.ea = this.READW(this.ea);
                        this.cycle += 6;
                        break;
                    }
                    case 180: {
                        this.ea = this.y;
                        this.ea = this.READW(this.ea);
                        this.cycle += 3;
                        break;
                    }
                    case 181: {
                        this.ea = this.y + this.SIGNED(this.b);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 182: {
                        this.ea = this.y + this.SIGNED(this.a);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 183: {
                        this.ea = 0;
                        break;
                    }
                    case 184: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.y + this.SIGNED(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 185: {
                        this.ea = this.IMMWORD();
                        this.ea = this.y + this.SIGNED16(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 7;
                        break;
                    }
                    case 186: {
                        this.ea = 0;
                        break;
                    }
                    case 187: {
                        this.ea = this.y + this.d();
                        this.ea = this.READW(this.ea);
                        this.cycle += 7;
                        break;
                    }
                    case 188: {
                        this.ea = this.IMMBYTE();
                        this.ea = this.pc + this.SIGNED(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 4;
                        break;
                    }
                    case 189: {
                        this.ea = this.IMMWORD();
                        this.ea = this.pc + this.SIGNED16(this.ea);
                        this.ea = this.READW(this.ea);
                        this.cycle += 8;
                        break;
                    }
                    case 190: {
                        this.ea = 0;
                        break;
                    }
                    case 191: {
                        this.ea = this.IMMWORD();
                        this.ea = this.READW(this.ea);
                        this.cycle += 8;
                    }
                }
            }
        } else if (pb < 224) {
            switch (pb) {
                case 192: {
                    this.ea = this.u++;
                    this.cycle += 2;
                    break;
                }
                case 193: {
                    this.ea = this.u;
                    this.u += 2;
                    this.cycle += 3;
                    break;
                }
                case 194: {
                    --this.u;
                    this.ea = this.u;
                    this.cycle += 2;
                    break;
                }
                case 195: {
                    this.u -= 2;
                    this.ea = this.u;
                    this.cycle += 3;
                    break;
                }
                case 196: {
                    this.ea = this.u;
                    break;
                }
                case 197: {
                    this.ea = this.u + this.SIGNED(this.b);
                    ++this.cycle;
                    break;
                }
                case 198: {
                    this.ea = this.u + this.SIGNED(this.a);
                    ++this.cycle;
                    break;
                }
                case 199: {
                    this.ea = 0;
                    break;
                }
                case 200: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.u + this.SIGNED(this.ea);
                    ++this.cycle;
                    break;
                }
                case 201: {
                    this.ea = this.IMMWORD();
                    this.ea = this.u + this.SIGNED16(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 202: {
                    this.ea = 0;
                    break;
                }
                case 203: {
                    this.ea = this.u + this.d();
                    this.cycle += 4;
                    break;
                }
                case 204: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.pc + this.SIGNED(this.ea);
                    ++this.cycle;
                    break;
                }
                case 205: {
                    this.ea = this.IMMWORD();
                    this.ea = this.pc + this.SIGNED16(this.ea);
                    this.cycle += 5;
                    break;
                }
                case 206: {
                    this.ea = 0;
                    break;
                }
                case 207: {
                    this.ea = this.IMMWORD();
                    this.cycle += 5;
                    break;
                }
                case 208: {
                    this.ea = this.u++;
                    this.ea = this.READW(this.ea);
                    this.cycle += 5;
                    break;
                }
                case 209: {
                    this.ea = this.u;
                    this.u += 2;
                    this.ea = this.READW(this.ea);
                    this.cycle += 6;
                    break;
                }
                case 210: {
                    --this.u;
                    this.ea = this.u;
                    this.ea = this.READW(this.ea);
                    this.cycle += 5;
                    break;
                }
                case 211: {
                    this.u -= 2;
                    this.ea = this.u;
                    this.ea = this.READW(this.ea);
                    this.cycle += 6;
                    break;
                }
                case 212: {
                    this.ea = this.u;
                    this.ea = this.READW(this.ea);
                    this.cycle += 3;
                    break;
                }
                case 213: {
                    this.ea = this.u + this.SIGNED(this.b);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 214: {
                    this.ea = this.u + this.SIGNED(this.a);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 215: {
                    this.ea = 0;
                    break;
                }
                case 216: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.u + this.SIGNED(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 217: {
                    this.ea = this.IMMWORD();
                    this.ea = this.u + this.SIGNED16(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 7;
                    break;
                }
                case 218: {
                    this.ea = 0;
                    break;
                }
                case 219: {
                    this.ea = this.u + this.d();
                    this.ea = this.READW(this.ea);
                    this.cycle += 7;
                    break;
                }
                case 220: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.pc + this.SIGNED(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 221: {
                    this.ea = this.IMMWORD();
                    this.ea = this.pc + this.SIGNED16(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 8;
                    break;
                }
                case 222: {
                    this.ea = 0;
                    break;
                }
                case 223: {
                    this.ea = this.IMMWORD();
                    this.ea = this.READW(this.ea);
                    this.cycle += 8;
                }
            }
        } else {
            switch (pb) {
                case 224: {
                    this.ea = this.s++;
                    this.cycle += 2;
                    break;
                }
                case 225: {
                    this.ea = this.s;
                    this.s += 2;
                    this.cycle += 3;
                    break;
                }
                case 226: {
                    --this.s;
                    this.ea = this.s;
                    this.cycle += 2;
                    break;
                }
                case 227: {
                    this.s -= 2;
                    this.ea = this.s;
                    this.cycle += 3;
                    break;
                }
                case 228: {
                    this.ea = this.s;
                    break;
                }
                case 229: {
                    this.ea = this.s + this.SIGNED(this.b);
                    ++this.cycle;
                    break;
                }
                case 230: {
                    this.ea = this.s + this.SIGNED(this.a);
                    ++this.cycle;
                    break;
                }
                case 231: {
                    this.ea = 0;
                    break;
                }
                case 232: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.s + this.SIGNED(this.ea);
                    ++this.cycle;
                    break;
                }
                case 233: {
                    this.ea = this.IMMWORD();
                    this.ea = this.s + this.SIGNED16(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 234: {
                    this.ea = 0;
                    break;
                }
                case 235: {
                    this.ea = this.s + this.d();
                    this.cycle += 4;
                    break;
                }
                case 236: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.pc + this.SIGNED(this.ea);
                    ++this.cycle;
                    break;
                }
                case 237: {
                    this.ea = this.IMMWORD();
                    this.ea = this.pc + this.SIGNED16(this.ea);
                    this.cycle += 5;
                    break;
                }
                case 238: {
                    this.ea = 0;
                    break;
                }
                case 239: {
                    this.ea = this.IMMWORD();
                    this.cycle += 5;
                    break;
                }
                case 240: {
                    this.ea = this.s++;
                    this.ea = this.READW(this.ea);
                    this.cycle += 5;
                    break;
                }
                case 241: {
                    this.ea = this.s;
                    this.s += 2;
                    this.ea = this.READW(this.ea);
                    this.cycle += 6;
                    break;
                }
                case 242: {
                    --this.s;
                    this.ea = this.s;
                    this.ea = this.READW(this.ea);
                    this.cycle += 5;
                    break;
                }
                case 243: {
                    this.s -= 2;
                    this.ea = this.s;
                    this.ea = this.READW(this.ea);
                    this.cycle += 6;
                    break;
                }
                case 244: {
                    this.ea = this.s;
                    this.ea = this.READW(this.ea);
                    this.cycle += 3;
                    break;
                }
                case 245: {
                    this.ea = this.s + this.SIGNED(this.b);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 246: {
                    this.ea = this.s + this.SIGNED(this.a);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 247: {
                    this.ea = 0;
                    break;
                }
                case 248: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.s + this.SIGNED(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 249: {
                    this.ea = this.IMMWORD();
                    this.ea = this.s + this.SIGNED16(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 7;
                    break;
                }
                case 250: {
                    this.ea = 0;
                    break;
                }
                case 251: {
                    this.ea = this.s + this.d();
                    this.ea = this.READW(this.ea);
                    this.cycle += 7;
                    break;
                }
                case 252: {
                    this.ea = this.IMMBYTE();
                    this.ea = this.pc + this.SIGNED(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 4;
                    break;
                }
                case 253: {
                    this.ea = this.IMMWORD();
                    this.ea = this.pc + this.SIGNED16(this.ea);
                    this.ea = this.READW(this.ea);
                    this.cycle += 8;
                    break;
                }
                case 254: {
                    this.ea = 0;
                    break;
                }
                case 255: {
                    this.ea = this.IMMWORD();
                    this.ea = this.READW(this.ea);
                    this.cycle += 8;
                }
            }
        }
    }

    void execline() {
        this.execl();
    }

    private void execl() {
        int op;
        this.ir = op = this.mem.readb(this.pc++);
        this.cycle = this.cycles1[op];
        if (this.cycle != 255) {
            if ((this.cycle & 0x80) != 0) {
                this.cycle &= 0x7F;
                this.cpu_calc_ea();
            }
            if (op < 128) {
                if (op < 64) {
                    if (op < 32) {
                        switch (op) {
                            case 0: {
                                this.neg_di();
                                break;
                            }
                            case 1: {
                                this.neg_di();
                                break;
                            }
                            case 2: {
                                this.ngc_di();
                                break;
                            }
                            case 3: {
                                this.com_di();
                                break;
                            }
                            case 4: {
                                this.lsr_di();
                                break;
                            }
                            case 5: {
                                this.lsr_di();
                                break;
                            }
                            case 6: {
                                this.ror_di();
                                break;
                            }
                            case 7: {
                                this.asr_di();
                                break;
                            }
                            case 8: {
                                this.asl_di();
                                break;
                            }
                            case 9: {
                                this.rol_di();
                                break;
                            }
                            case 10: {
                                this.dec_di();
                                break;
                            }
                            case 11: {
                                this.dcc_di();
                                break;
                            }
                            case 12: {
                                this.inc_di();
                                break;
                            }
                            case 13: {
                                this.tst_di();
                                break;
                            }
                            case 14: {
                                this.jmp_di();
                                break;
                            }
                            case 15: {
                                this.clr_di();
                                break;
                            }
                            case 16: {
                                this.illegal();
                                break;
                            }
                            case 17: {
                                this.illegal();
                                break;
                            }
                            case 18: {
                                this.nop();
                                break;
                            }
                            case 19: {
                                this.sync();
                                break;
                            }
                            case 20: {
                                this.illegal();
                                break;
                            }
                            case 21: {
                                this.illegal();
                                break;
                            }
                            case 22: {
                                this.lbra();
                                break;
                            }
                            case 23: {
                                this.lbsr();
                                break;
                            }
                            case 24: {
                                this.aslcc();
                                break;
                            }
                            case 25: {
                                this.daa();
                                break;
                            }
                            case 26: {
                                this.orcc();
                                break;
                            }
                            case 27: {
                                this.nop();
                                break;
                            }
                            case 28: {
                                this.andcc();
                                break;
                            }
                            case 29: {
                                this.sex();
                                break;
                            }
                            case 30: {
                                this.exg();
                                break;
                            }
                            case 31: {
                                this.tfr();
                            }
                        }
                    } else {
                        switch (op) {
                            case 32: {
                                this.bra();
                                break;
                            }
                            case 33: {
                                this.brn();
                                break;
                            }
                            case 34: {
                                this.bhi();
                                break;
                            }
                            case 35: {
                                this.bls();
                                break;
                            }
                            case 36: {
                                this.bcc();
                                break;
                            }
                            case 37: {
                                this.bcs();
                                break;
                            }
                            case 38: {
                                this.bne();
                                break;
                            }
                            case 39: {
                                this.beq();
                                break;
                            }
                            case 40: {
                                this.bvc();
                                break;
                            }
                            case 41: {
                                this.bvs();
                                break;
                            }
                            case 42: {
                                this.bpl();
                                break;
                            }
                            case 43: {
                                this.bmi();
                                break;
                            }
                            case 44: {
                                this.bge();
                                break;
                            }
                            case 45: {
                                this.blt();
                                break;
                            }
                            case 46: {
                                this.bgt();
                                break;
                            }
                            case 47: {
                                this.ble();
                                break;
                            }
                            case 48: {
                                this.leax();
                                break;
                            }
                            case 49: {
                                this.leay();
                                break;
                            }
                            case 50: {
                                this.leas();
                                break;
                            }
                            case 51: {
                                this.leau();
                                break;
                            }
                            case 52: {
                                this.pshs();
                                break;
                            }
                            case 53: {
                                this.puls();
                                break;
                            }
                            case 54: {
                                this.pshu();
                                break;
                            }
                            case 55: {
                                this.pulu();
                                break;
                            }
                            case 56: {
                                this.andcc();
                                break;
                            }
                            case 57: {
                                this.rts();
                                break;
                            }
                            case 58: {
                                this.abx();
                                break;
                            }
                            case 59: {
                                this.rti();
                                break;
                            }
                            case 60: {
                                this.cwai();
                                break;
                            }
                            case 61: {
                                this.mul();
                                break;
                            }
                            case 62: {
                                this.rst();
                                break;
                            }
                            case 63: {
                                this.swi();
                            }
                        }
                    }
                } else if (op < 96) {
                    switch (op) {
                        case 64: {
                            this.nega();
                            break;
                        }
                        case 65: {
                            this.nega();
                            break;
                        }
                        case 66: {
                            this.ngca();
                            break;
                        }
                        case 67: {
                            this.coma();
                            break;
                        }
                        case 68: {
                            this.lsra();
                            break;
                        }
                        case 69: {
                            this.lsra();
                            break;
                        }
                        case 70: {
                            this.rora();
                            break;
                        }
                        case 71: {
                            this.asra();
                            break;
                        }
                        case 72: {
                            this.asla();
                            break;
                        }
                        case 73: {
                            this.rola();
                            break;
                        }
                        case 74: {
                            this.deca();
                            break;
                        }
                        case 75: {
                            this.dcca();
                            break;
                        }
                        case 76: {
                            this.inca();
                            break;
                        }
                        case 77: {
                            this.tsta();
                            break;
                        }
                        case 78: {
                            this.clca();
                            break;
                        }
                        case 79: {
                            this.clra();
                            break;
                        }
                        case 80: {
                            this.negb();
                            break;
                        }
                        case 81: {
                            this.negb();
                            break;
                        }
                        case 82: {
                            this.ngcb();
                            break;
                        }
                        case 83: {
                            this.comb();
                            break;
                        }
                        case 84: {
                            this.lsrb();
                            break;
                        }
                        case 85: {
                            this.lsrb();
                            break;
                        }
                        case 86: {
                            this.rorb();
                            break;
                        }
                        case 87: {
                            this.asrb();
                            break;
                        }
                        case 88: {
                            this.aslb();
                            break;
                        }
                        case 89: {
                            this.rolb();
                            break;
                        }
                        case 90: {
                            this.decb();
                            break;
                        }
                        case 91: {
                            this.dccb();
                            break;
                        }
                        case 92: {
                            this.incb();
                            break;
                        }
                        case 93: {
                            this.tstb();
                            break;
                        }
                        case 94: {
                            this.clcb();
                            break;
                        }
                        case 95: {
                            this.clrb();
                        }
                    }
                } else {
                    switch (op) {
                        case 96: {
                            this.neg_ix();
                            break;
                        }
                        case 97: {
                            this.neg_ix();
                            break;
                        }
                        case 98: {
                            this.ngc_ix();
                            break;
                        }
                        case 99: {
                            this.com_ix();
                            break;
                        }
                        case 100: {
                            this.lsr_ix();
                            break;
                        }
                        case 101: {
                            this.lsr_ix();
                            break;
                        }
                        case 102: {
                            this.ror_ix();
                            break;
                        }
                        case 103: {
                            this.asr_ix();
                            break;
                        }
                        case 104: {
                            this.asl_ix();
                            break;
                        }
                        case 105: {
                            this.rol_ix();
                            break;
                        }
                        case 106: {
                            this.dec_ix();
                            break;
                        }
                        case 107: {
                            this.dcc_ix();
                            break;
                        }
                        case 108: {
                            this.inc_ix();
                            break;
                        }
                        case 109: {
                            this.tst_ix();
                            break;
                        }
                        case 110: {
                            this.jmp_ix();
                            break;
                        }
                        case 111: {
                            this.clr_ix();
                            break;
                        }
                        case 112: {
                            this.neg_ex();
                            break;
                        }
                        case 113: {
                            this.neg_ex();
                            break;
                        }
                        case 114: {
                            this.ngc_ex();
                            break;
                        }
                        case 115: {
                            this.com_ex();
                            break;
                        }
                        case 116: {
                            this.lsr_ex();
                            break;
                        }
                        case 117: {
                            this.lsr_ex();
                            break;
                        }
                        case 118: {
                            this.ror_ex();
                            break;
                        }
                        case 119: {
                            this.asr_ex();
                            break;
                        }
                        case 120: {
                            this.asl_ex();
                            break;
                        }
                        case 121: {
                            this.rol_ex();
                            break;
                        }
                        case 122: {
                            this.dec_ex();
                            break;
                        }
                        case 123: {
                            this.dcc_ex();
                            break;
                        }
                        case 124: {
                            this.inc_ex();
                            break;
                        }
                        case 125: {
                            this.tst_ex();
                            break;
                        }
                        case 126: {
                            this.jmp_ex();
                            break;
                        }
                        case 127: {
                            this.clr_ex();
                        }
                    }
                }
            } else if (op < 192) {
                if (op < 160) {
                    switch (op) {
                        case 128: {
                            this.suba_im();
                            break;
                        }
                        case 129: {
                            this.cmpa_im();
                            break;
                        }
                        case 130: {
                            this.sbca_im();
                            break;
                        }
                        case 131: {
                            this.subd_im();
                            break;
                        }
                        case 132: {
                            this.anda_im();
                            break;
                        }
                        case 133: {
                            this.bita_im();
                            break;
                        }
                        case 134: {
                            this.lda_im();
                            break;
                        }
                        case 135: {
                            this.flag8_im();
                            break;
                        }
                        case 136: {
                            this.eora_im();
                            break;
                        }
                        case 137: {
                            this.adca_im();
                            break;
                        }
                        case 138: {
                            this.ora_im();
                            break;
                        }
                        case 139: {
                            this.adda_im();
                            break;
                        }
                        case 140: {
                            this.cmpx_im();
                            break;
                        }
                        case 141: {
                            this.bsr();
                            break;
                        }
                        case 142: {
                            this.ldx_im();
                            break;
                        }
                        case 143: {
                            this.flag16_im();
                            break;
                        }
                        case 144: {
                            this.suba_di();
                            break;
                        }
                        case 145: {
                            this.cmpa_di();
                            break;
                        }
                        case 146: {
                            this.sbca_di();
                            break;
                        }
                        case 147: {
                            this.subd_di();
                            break;
                        }
                        case 148: {
                            this.anda_di();
                            break;
                        }
                        case 149: {
                            this.bita_di();
                            break;
                        }
                        case 150: {
                            this.lda_di();
                            break;
                        }
                        case 151: {
                            this.sta_di();
                            break;
                        }
                        case 152: {
                            this.eora_di();
                            break;
                        }
                        case 153: {
                            this.adca_di();
                            break;
                        }
                        case 154: {
                            this.ora_di();
                            break;
                        }
                        case 155: {
                            this.adda_di();
                            break;
                        }
                        case 156: {
                            this.cmpx_di();
                            break;
                        }
                        case 157: {
                            this.jsr_di();
                            break;
                        }
                        case 158: {
                            this.ldx_di();
                            break;
                        }
                        case 159: {
                            this.stx_di();
                        }
                    }
                } else {
                    switch (op) {
                        case 160: {
                            this.suba_ix();
                            break;
                        }
                        case 161: {
                            this.cmpa_ix();
                            break;
                        }
                        case 162: {
                            this.sbca_ix();
                            break;
                        }
                        case 163: {
                            this.subd_ix();
                            break;
                        }
                        case 164: {
                            this.anda_ix();
                            break;
                        }
                        case 165: {
                            this.bita_ix();
                            break;
                        }
                        case 166: {
                            this.lda_ix();
                            break;
                        }
                        case 167: {
                            this.sta_ix();
                            break;
                        }
                        case 168: {
                            this.eora_ix();
                            break;
                        }
                        case 169: {
                            this.adca_ix();
                            break;
                        }
                        case 170: {
                            this.ora_ix();
                            break;
                        }
                        case 171: {
                            this.adda_ix();
                            break;
                        }
                        case 172: {
                            this.cmpx_ix();
                            break;
                        }
                        case 173: {
                            this.jsr_ix();
                            break;
                        }
                        case 174: {
                            this.ldx_ix();
                            break;
                        }
                        case 175: {
                            this.stx_ix();
                            break;
                        }
                        case 176: {
                            this.suba_ex();
                            break;
                        }
                        case 177: {
                            this.cmpa_ex();
                            break;
                        }
                        case 178: {
                            this.sbca_ex();
                            break;
                        }
                        case 179: {
                            this.subd_ex();
                            break;
                        }
                        case 180: {
                            this.anda_ex();
                            break;
                        }
                        case 181: {
                            this.bita_ex();
                            break;
                        }
                        case 182: {
                            this.lda_ex();
                            break;
                        }
                        case 183: {
                            this.sta_ex();
                            break;
                        }
                        case 184: {
                            this.eora_ex();
                            break;
                        }
                        case 185: {
                            this.adca_ex();
                            break;
                        }
                        case 186: {
                            this.ora_ex();
                            break;
                        }
                        case 187: {
                            this.adda_ex();
                            break;
                        }
                        case 188: {
                            this.cmpx_ex();
                            break;
                        }
                        case 189: {
                            this.jsr_ex();
                            break;
                        }
                        case 190: {
                            this.ldx_ex();
                            break;
                        }
                        case 191: {
                            this.stx_ex();
                        }
                    }
                }
            } else if (op < 224) {
                switch (op) {
                    case 192: {
                        this.subb_im();
                        break;
                    }
                    case 193: {
                        this.cmpb_im();
                        break;
                    }
                    case 194: {
                        this.sbcb_im();
                        break;
                    }
                    case 195: {
                        this.addd_im();
                        break;
                    }
                    case 196: {
                        this.andb_im();
                        break;
                    }
                    case 197: {
                        this.bitb_im();
                        break;
                    }
                    case 198: {
                        this.ldb_im();
                        break;
                    }
                    case 199: {
                        this.flag8_im();
                        break;
                    }
                    case 200: {
                        this.eorb_im();
                        break;
                    }
                    case 201: {
                        this.adcb_im();
                        break;
                    }
                    case 202: {
                        this.orb_im();
                        break;
                    }
                    case 203: {
                        this.addb_im();
                        break;
                    }
                    case 204: {
                        this.ldd_im();
                        break;
                    }
                    case 205: {
                        this.illegal();
                        break;
                    }
                    case 206: {
                        this.ldu_im();
                        break;
                    }
                    case 207: {
                        this.flag16_im();
                        break;
                    }
                    case 208: {
                        this.subb_di();
                        break;
                    }
                    case 209: {
                        this.cmpb_di();
                        break;
                    }
                    case 210: {
                        this.sbcb_di();
                        break;
                    }
                    case 211: {
                        this.addd_di();
                        break;
                    }
                    case 212: {
                        this.andb_di();
                        break;
                    }
                    case 213: {
                        this.bitb_di();
                        break;
                    }
                    case 214: {
                        this.ldb_di();
                        break;
                    }
                    case 215: {
                        this.stb_di();
                        break;
                    }
                    case 216: {
                        this.eorb_di();
                        break;
                    }
                    case 217: {
                        this.adcb_di();
                        break;
                    }
                    case 218: {
                        this.orb_di();
                        break;
                    }
                    case 219: {
                        this.addb_di();
                        break;
                    }
                    case 220: {
                        this.ldd_di();
                        break;
                    }
                    case 221: {
                        this.std_di();
                        break;
                    }
                    case 222: {
                        this.ldu_di();
                        break;
                    }
                    case 223: {
                        this.stu_di();
                    }
                }
            } else {
                switch (op) {
                    case 224: {
                        this.subb_ix();
                        break;
                    }
                    case 225: {
                        this.cmpb_ix();
                        break;
                    }
                    case 226: {
                        this.sbcb_ix();
                        break;
                    }
                    case 227: {
                        this.addd_ix();
                        break;
                    }
                    case 228: {
                        this.andb_ix();
                        break;
                    }
                    case 229: {
                        this.bitb_ix();
                        break;
                    }
                    case 230: {
                        this.ldb_ix();
                        break;
                    }
                    case 231: {
                        this.stb_ix();
                        break;
                    }
                    case 232: {
                        this.eorb_ix();
                        break;
                    }
                    case 233: {
                        this.adcb_ix();
                        break;
                    }
                    case 234: {
                        this.orb_ix();
                        break;
                    }
                    case 235: {
                        this.addb_ix();
                        break;
                    }
                    case 236: {
                        this.ldd_ix();
                        break;
                    }
                    case 237: {
                        this.std_ix();
                        break;
                    }
                    case 238: {
                        this.ldu_ix();
                        break;
                    }
                    case 239: {
                        this.stu_ix();
                        break;
                    }
                    case 240: {
                        this.subb_ex();
                        break;
                    }
                    case 241: {
                        this.cmpb_ex();
                        break;
                    }
                    case 242: {
                        this.sbcb_ex();
                        break;
                    }
                    case 243: {
                        this.addd_ex();
                        break;
                    }
                    case 244: {
                        this.andb_ex();
                        break;
                    }
                    case 245: {
                        this.bitb_ex();
                        break;
                    }
                    case 246: {
                        this.ldb_ex();
                        break;
                    }
                    case 247: {
                        this.stb_ex();
                        break;
                    }
                    case 248: {
                        this.eorb_ex();
                        break;
                    }
                    case 249: {
                        this.adcb_ex();
                        break;
                    }
                    case 250: {
                        this.orb_ex();
                        break;
                    }
                    case 251: {
                        this.addb_ex();
                        break;
                    }
                    case 252: {
                        this.ldd_ex();
                        break;
                    }
                    case 253: {
                        this.std_ex();
                        break;
                    }
                    case 254: {
                        this.ldu_ex();
                        break;
                    }
                    case 255: {
                        this.stu_ex();
                    }
                }
            }
        } else if (op == 16) {
            op = this.mem.readb(this.pc++);
            this.cycle = this.cycles2[op];
            if ((this.cycle & 0x80) != 0) {
                this.cycle &= 0x7F;
                this.cpu_calc_ea();
            }
            switch (op) {
                case 33: {
                    this.lbrn();
                    break;
                }
                case 34: {
                    this.lbhi();
                    break;
                }
                case 35: {
                    this.lbls();
                    break;
                }
                case 36: {
                    this.lbcc();
                    break;
                }
                case 37: {
                    this.lbcs();
                    break;
                }
                case 38: {
                    this.lbne();
                    break;
                }
                case 39: {
                    this.lbeq();
                    break;
                }
                case 40: {
                    this.lbvc();
                    break;
                }
                case 41: {
                    this.lbvs();
                    break;
                }
                case 42: {
                    this.lbpl();
                    break;
                }
                case 43: {
                    this.lbmi();
                    break;
                }
                case 44: {
                    this.lbge();
                    break;
                }
                case 45: {
                    this.lblt();
                    break;
                }
                case 46: {
                    this.lbgt();
                    break;
                }
                case 47: {
                    this.lble();
                    break;
                }
                case 63: {
                    this.swi2();
                    break;
                }
                case 131: {
                    this.cmpd_im();
                    break;
                }
                case 140: {
                    this.cmpy_im();
                    break;
                }
                case 142: {
                    this.ldy_im();
                    break;
                }
                case 143: {
                    this.sty_im();
                    break;
                }
                case 147: {
                    this.cmpd_di();
                    break;
                }
                case 156: {
                    this.cmpy_di();
                    break;
                }
                case 158: {
                    this.ldy_di();
                    break;
                }
                case 159: {
                    this.sty_di();
                    break;
                }
                case 163: {
                    this.cmpd_ix();
                    break;
                }
                case 172: {
                    this.cmpy_ix();
                    break;
                }
                case 174: {
                    this.ldy_ix();
                    break;
                }
                case 175: {
                    this.sty_ix();
                    break;
                }
                case 179: {
                    this.cmpd_ex();
                    break;
                }
                case 188: {
                    this.cmpy_ex();
                    break;
                }
                case 190: {
                    this.ldy_ex();
                    break;
                }
                case 191: {
                    this.sty_ex();
                    break;
                }
                case 206: {
                    this.lds_im();
                    break;
                }
                case 207: {
                    this.sts_im();
                    break;
                }
                case 222: {
                    this.lds_di();
                    break;
                }
                case 223: {
                    this.sts_di();
                    break;
                }
                case 238: {
                    this.lds_ix();
                    break;
                }
                case 239: {
                    this.sts_ix();
                    break;
                }
                case 254: {
                    this.lds_ex();
                    break;
                }
                case 255: {
                    this.sts_ex();
                    break;
                }
                default: {
                    this.illegal();
                    break;
                }
            }
        } else {
            op = this.mem.readb(this.pc++);
            this.cycle = this.cycles2[op];
            if ((this.cycle & 0x80) != 0) {
                this.cycle &= 0x7F;
                this.cpu_calc_ea();
            }
            switch (op) {
                case 63: {
                    this.swi3();
                    break;
                }
                case 131: {
                    this.cmpu_im();
                    break;
                }
                case 140: {
                    this.cmps_im();
                    break;
                }
                case 147: {
                    this.cmpu_di();
                    break;
                }
                case 156: {
                    this.cmps_di();
                    break;
                }
                case 163: {
                    this.cmpu_ix();
                    break;
                }
                case 172: {
                    this.cmps_ix();
                    break;
                }
                case 179: {
                    this.cmpu_ex();
                    break;
                }
                case 188: {
                    this.cmps_ex();
                    break;
                }
                default: {
                    this.illegal();
                }
            }
        }
    }

    private void cpu_nmi() {
        this.intr |= 0x100;
        this.cc |= 0x80;
        this.PUSHWORD(this.pc);
        this.PUSHWORD(this.u);
        this.PUSHWORD(this.y);
        this.PUSHWORD(this.x);
        this.PUSHBYTE(this.dp);
        this.PUSHBYTE(this.b);
        this.PUSHBYTE(this.a);
        this.PUSHBYTE(this.cc);
        this.cycle += 12;
        this.cc |= 0x50;
        this.pc = this.READW(65532);
        this.intr &= 0xFFFFFFFE;
    }

    private void cpu_firq() {
        if ((this.intr & 0x80) != 0) {
            this.cc |= 0x80;
            this.PUSHWORD(this.pc);
            this.PUSHWORD(this.u);
            this.PUSHWORD(this.y);
            this.PUSHWORD(this.x);
            this.PUSHBYTE(this.dp);
            this.PUSHBYTE(this.b);
            this.PUSHBYTE(this.a);
            this.PUSHBYTE(this.cc);
            this.cycle += 12;
        } else {
            this.cc &= 0x7F;
            this.PUSHWORD(this.pc);
            this.PUSHBYTE(this.cc);
            this.cycle += 3;
        }
        this.cc |= 0x50;
        this.pc = this.READW(65526);
        this.intr &= 0xFFFFFFFD;
    }

    private void cpu_irq() {
        this.intr |= 0x100;
        this.cc |= 0x80;
        this.PUSHWORD(this.pc);
        this.PUSHWORD(this.u);
        this.PUSHWORD(this.y);
        this.PUSHWORD(this.x);
        this.PUSHBYTE(this.dp);
        this.PUSHBYTE(this.b);
        this.PUSHBYTE(this.a);
        this.PUSHBYTE(this.cc);
        this.cycle += 12;
        this.cc |= 0x10;
        this.pc = this.READW(65528);
        this.intr &= 0xFFFFFFFB;
    }

    private void cpu_reset() {
        this.cc = 80;
        this.a = 0;
        this.b = 0;
        this.dp = 0;
        this.x = 0;
        this.y = 0;
        this.u = 0;
        this.s = 0;
        this.ir = 0;
        this.intr = 0;
        this.cycle = 0;
        this.total = 0;
        this.pc = this.READB(65534) << 8 | this.READB(65535);
    }

    void exec() {
        if ((this.intr & 1) != 0) {
            this.intr |= 0x40;
            if ((this.intr & 0x10) != 0) {
                this.cpu_nmi();
                this.execl();
                this.total += this.cycle;
                return;
            }
        }
        if ((this.intr & 2) != 0) {
            this.intr |= 0x40;
            if ((this.cc & 0x40) == 0) {
                this.cpu_firq();
                this.execl();
                this.total += this.cycle;
                return;
            }
        }
        if ((this.intr & 4) != 0) {
            this.intr |= 0x40;
            if ((this.cc & 0x10) == 0) {
                this.cpu_irq();
                this.execl();
                this.total += this.cycle;
                return;
            }
        }
        this.execl();
        this.total += this.cycle;
    }

    void setTotal(int total) {
        this.total = total;
    }

    int getTotal() {
        return this.total;
    }

    void setIntr(int intr) {
        this.intr = intr & 0xFFFF;
    }

    int getIntr() {
        return this.intr & 0xFFFF;
    }

    void setCycle(int cycle) {
        this.cycle = cycle;
    }

    int getCycle() {
        return this.cycle;
    }

    void setCc(int cc) {
        this.cc = cc & 0xFF;
    }

    int getCc() {
        return this.cc & 0xFF;
    }

    void setEa(int ea) {
        this.ea = ea & 0xFFFF;
    }

    int getEa() {
        return this.ea & 0xFFFF;
    }

    void setIr(int ir) {
        this.ir = ir & 0xFF;
    }

    int getIr() {
        return this.ir & 0xFF;
    }

    void setS(int s) {
        this.s = s & 0xFFFF;
    }

    int getS() {
        return this.s & 0xFFFF;
    }

    void setU(int u) {
        this.u = u & 0xFFFF;
    }

    int getU() {
        return this.u & 0xFFFF;
    }

    void setX(int x) {
        this.x = x & 0xFFFF;
    }

    int getX() {
        return this.x & 0xFFFF;
    }

    void setY(int y) {
        this.y = y & 0xFFFF;
    }

    int getY() {
        return this.y & 0xFFFF;
    }

    void setPc(int pc) {
        this.pc = pc & 0xFFFF;
    }

    int getPc() {
        return this.pc & 0xFFFF;
    }

    void setA(int a) {
        this.a = a & 0xFF;
    }

    int getA() {
        return this.a & 0xFF;
    }

    void setB(int b) {
        this.b = b & 0xFF;
    }

    int getB() {
        return this.b & 0xFF;
    }

    void setD(int d) {
        this.a = (d &= 0xFFFF) >>> 8;
        this.b = d & 0xFF;
    }

    int getD() {
        return (this.a << 8 | this.b) & 0xFFFF;
    }

    void setDp(int dp) {
        this.dp = dp & 0xFF;
    }

    int getDp() {
        return this.dp & 0xFF;
    }
}

