/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.BoolHolder;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Pointer;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Fdc
extends Base
implements EventHandler {
    private int fdc_command;
    int fdc_status;
    private int fdc_trkreg;
    private int fdc_secreg;
    private int fdc_datareg;
    private int fdc_sidereg;
    private int fdc_drvreg;
    private int fdc_drvregP;
    private int fdc_motor;
    private int fdc_drqirq;
    private int fdc_cmdtype;
    private int fdc_totalcnt;
    private int fdc_nowcnt;
    public int[] fdc_ready = new int[4];
    public boolean[] fdc_teject = new boolean[4];
    public boolean[] fdc_writep = new boolean[4];
    private int[] fdc_track = new int[4];
    private int fdc_logidrv;
    private int[] fdc_physdrv = new int[4];
    private int fdc_2ddmode;
    private String[] fdc_fname = new String[4];
    public boolean[] fdc_fwritep = new boolean[4];
    private int[][] fdc_header = new int[4][688];
    public int[] fdc_media = new int[4];
    public int[] fdc_medias = new int[4];
    public String[][] fdc_name = new String[4][16];
    public int[] fdc_access = new int[4];
    public boolean fdc_waitmode;
    public boolean fdc_sound;
    private int[] fdc_buffer = new int[8192];
    private Pointer fdc_dataptr = new Pointer();
    private int[] fdc_seekofs = new int[4];
    private int[] fdc_secofs = new int[4];
    private int[][] fdc_foffset = new int[4][16];
    private int[] fdc_trklen = new int[4];
    private boolean fdc_seekvct;
    private int fdc_indexcnt;
    private boolean fdc_boot;
    private boolean fdc_wait;
    private int fdc_seek_track;
    private int rand_s;
    private final int fdd_seek_event = 1;
    private final int fdc_drq_event = 2;
    private final int fdc_lost_event = 3;
    private final int fdc_multi_event = 4;
    private final int[] fdc_steprate = new int[]{6000, 12000, 20000, 30000};
    private final int[] crc_table;

    Fdc() {
        int[] nArray = new int[256];
        nArray[1] = 4129;
        nArray[2] = 8258;
        nArray[3] = 12387;
        nArray[4] = 16516;
        nArray[5] = 20645;
        nArray[6] = 24774;
        nArray[7] = 28903;
        nArray[8] = 33032;
        nArray[9] = 37161;
        nArray[10] = 41290;
        nArray[11] = 45419;
        nArray[12] = 49548;
        nArray[13] = 53677;
        nArray[14] = 57806;
        nArray[15] = 61935;
        nArray[16] = 4657;
        nArray[17] = 528;
        nArray[18] = 12915;
        nArray[19] = 8786;
        nArray[20] = 21173;
        nArray[21] = 17044;
        nArray[22] = 29431;
        nArray[23] = 25302;
        nArray[24] = 37689;
        nArray[25] = 33560;
        nArray[26] = 45947;
        nArray[27] = 41818;
        nArray[28] = 54205;
        nArray[29] = 50076;
        nArray[30] = 62463;
        nArray[31] = 58334;
        nArray[32] = 9314;
        nArray[33] = 13379;
        nArray[34] = 1056;
        nArray[35] = 5121;
        nArray[36] = 25830;
        nArray[37] = 29895;
        nArray[38] = 17572;
        nArray[39] = 21637;
        nArray[40] = 42346;
        nArray[41] = 46411;
        nArray[42] = 34088;
        nArray[43] = 38153;
        nArray[44] = 58862;
        nArray[45] = 62927;
        nArray[46] = 50604;
        nArray[47] = 54669;
        nArray[48] = 13907;
        nArray[49] = 9842;
        nArray[50] = 5649;
        nArray[51] = 1584;
        nArray[52] = 30423;
        nArray[53] = 26358;
        nArray[54] = 22165;
        nArray[55] = 18100;
        nArray[56] = 46939;
        nArray[57] = 42874;
        nArray[58] = 38681;
        nArray[59] = 34616;
        nArray[60] = 63455;
        nArray[61] = 59390;
        nArray[62] = 55197;
        nArray[63] = 51132;
        nArray[64] = 18628;
        nArray[65] = 22757;
        nArray[66] = 26758;
        nArray[67] = 30887;
        nArray[68] = 2112;
        nArray[69] = 6241;
        nArray[70] = 10242;
        nArray[71] = 14371;
        nArray[72] = 51660;
        nArray[73] = 55789;
        nArray[74] = 59790;
        nArray[75] = 63919;
        nArray[76] = 35144;
        nArray[77] = 39273;
        nArray[78] = 43274;
        nArray[79] = 47403;
        nArray[80] = 23285;
        nArray[81] = 19156;
        nArray[82] = 31415;
        nArray[83] = 27286;
        nArray[84] = 6769;
        nArray[85] = 2640;
        nArray[86] = 14899;
        nArray[87] = 10770;
        nArray[88] = 56317;
        nArray[89] = 52188;
        nArray[90] = 64447;
        nArray[91] = 60318;
        nArray[92] = 39801;
        nArray[93] = 35672;
        nArray[94] = 47931;
        nArray[95] = 43802;
        nArray[96] = 27814;
        nArray[97] = 31879;
        nArray[98] = 19684;
        nArray[99] = 23749;
        nArray[100] = 11298;
        nArray[101] = 15363;
        nArray[102] = 3168;
        nArray[103] = 7233;
        nArray[104] = 60846;
        nArray[105] = 64911;
        nArray[106] = 52716;
        nArray[107] = 56781;
        nArray[108] = 44330;
        nArray[109] = 48395;
        nArray[110] = 36200;
        nArray[111] = 40265;
        nArray[112] = 32407;
        nArray[113] = 28342;
        nArray[114] = 24277;
        nArray[115] = 20212;
        nArray[116] = 15891;
        nArray[117] = 11826;
        nArray[118] = 7761;
        nArray[119] = 3696;
        nArray[120] = 65439;
        nArray[121] = 61374;
        nArray[122] = 57309;
        nArray[123] = 53244;
        nArray[124] = 48923;
        nArray[125] = 44858;
        nArray[126] = 40793;
        nArray[127] = 36728;
        nArray[128] = 37256;
        nArray[129] = 33193;
        nArray[130] = 45514;
        nArray[131] = 41451;
        nArray[132] = 53516;
        nArray[133] = 49453;
        nArray[134] = 61774;
        nArray[135] = 57711;
        nArray[136] = 4224;
        nArray[137] = 161;
        nArray[138] = 12482;
        nArray[139] = 8419;
        nArray[140] = 20484;
        nArray[141] = 16421;
        nArray[142] = 28742;
        nArray[143] = 24679;
        nArray[144] = 33721;
        nArray[145] = 37784;
        nArray[146] = 41979;
        nArray[147] = 46042;
        nArray[148] = 49981;
        nArray[149] = 54044;
        nArray[150] = 58239;
        nArray[151] = 62302;
        nArray[152] = 689;
        nArray[153] = 4752;
        nArray[154] = 8947;
        nArray[155] = 13010;
        nArray[156] = 16949;
        nArray[157] = 21012;
        nArray[158] = 25207;
        nArray[159] = 29270;
        nArray[160] = 46570;
        nArray[161] = 42443;
        nArray[162] = 38312;
        nArray[163] = 34185;
        nArray[164] = 62830;
        nArray[165] = 58703;
        nArray[166] = 54572;
        nArray[167] = 50445;
        nArray[168] = 13538;
        nArray[169] = 9411;
        nArray[170] = 5280;
        nArray[171] = 1153;
        nArray[172] = 29798;
        nArray[173] = 25671;
        nArray[174] = 21540;
        nArray[175] = 17413;
        nArray[176] = 42971;
        nArray[177] = 47098;
        nArray[178] = 34713;
        nArray[179] = 38840;
        nArray[180] = 59231;
        nArray[181] = 63358;
        nArray[182] = 50973;
        nArray[183] = 55100;
        nArray[184] = 9939;
        nArray[185] = 14066;
        nArray[186] = 1681;
        nArray[187] = 5808;
        nArray[188] = 26199;
        nArray[189] = 30326;
        nArray[190] = 17941;
        nArray[191] = 22068;
        nArray[192] = 55628;
        nArray[193] = 51565;
        nArray[194] = 63758;
        nArray[195] = 59695;
        nArray[196] = 39368;
        nArray[197] = 35305;
        nArray[198] = 47498;
        nArray[199] = 43435;
        nArray[200] = 22596;
        nArray[201] = 18533;
        nArray[202] = 30726;
        nArray[203] = 26663;
        nArray[204] = 6336;
        nArray[205] = 2273;
        nArray[206] = 14466;
        nArray[207] = 10403;
        nArray[208] = 52093;
        nArray[209] = 56156;
        nArray[210] = 60223;
        nArray[211] = 64286;
        nArray[212] = 35833;
        nArray[213] = 39896;
        nArray[214] = 43963;
        nArray[215] = 48026;
        nArray[216] = 19061;
        nArray[217] = 23124;
        nArray[218] = 27191;
        nArray[219] = 31254;
        nArray[220] = 2801;
        nArray[221] = 6864;
        nArray[222] = 10931;
        nArray[223] = 14994;
        nArray[224] = 64814;
        nArray[225] = 60687;
        nArray[226] = 56684;
        nArray[227] = 52557;
        nArray[228] = 48554;
        nArray[229] = 44427;
        nArray[230] = 40424;
        nArray[231] = 36297;
        nArray[232] = 31782;
        nArray[233] = 27655;
        nArray[234] = 23652;
        nArray[235] = 19525;
        nArray[236] = 15522;
        nArray[237] = 11395;
        nArray[238] = 7392;
        nArray[239] = 3265;
        nArray[240] = 61215;
        nArray[241] = 65342;
        nArray[242] = 53085;
        nArray[243] = 57212;
        nArray[244] = 44955;
        nArray[245] = 49082;
        nArray[246] = 36825;
        nArray[247] = 40952;
        nArray[248] = 28183;
        nArray[249] = 32310;
        nArray[250] = 20053;
        nArray[251] = 24180;
        nArray[252] = 11923;
        nArray[253] = 16050;
        nArray[254] = 3793;
        nArray[255] = 7920;
        this.crc_table = nArray;
    }

    boolean init() {
        int i = 0;
        while (i < 4) {
            this.fdc_ready[i] = 0;
            this.fdc_teject[i] = false;
            this.fdc_fwritep[i] = false;
            this.fdc_medias[i] = 0;
            ++i;
        }
        i = 0;
        while (i < this.fdc_foffset.length) {
            Util.memset(this.fdc_foffset[i], 0, this.fdc_foffset[i].length);
            ++i;
        }
        this.fdc_waitmode = false;
        this.fdc_sound = false;
        this.fdc_wait = false;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        int i = 0;
        while (i < 4) {
            this.fdc_ready[i] = 0;
            ++i;
        }
    }

    void reset() {
        this.fdc_command = 255;
        this.fdc_status = 0;
        this.fdc_trkreg = 0;
        this.fdc_secreg = 0;
        this.fdc_datareg = 0;
        this.fdc_sidereg = 0;
        this.fdc_drvreg = 0;
        this.fdc_drvregP = 0;
        this.fdc_motor = 0;
        this.fdc_logidrv = 0;
        this.fdc_2ddmode = 0;
        int i = 0;
        while (i < 4) {
            this.fdc_physdrv[i] = i;
            ++i;
        }
        this.fdc_cmdtype = 0;
        this.fdc_seekvct = false;
        Util.memset(this.fdc_track, 0, this.fdc_track.length);
        this.fdc_dataptr.set(null);
        this.fdc_boot = false;
        this.fdc_readbuf(this.fdc_drvreg);
    }

    private int byteArrayToInt(int[] array, int offset) {
        offset = array[offset] << 32 | array[offset + 1] << 16 | array[offset + 2] << 8 | array[offset + 3];
        return offset;
    }

    private void intToByteArray(int[] array, int offset, int value) {
        int b1 = value >>> 32 & 0xFF;
        int b2 = value >>> 16 & 0xFF;
        int b3 = value >>> 8 & 0xFF;
        int b4 = value & 0xF;
        array[offset] = b1;
        array[offset + 1] = b2;
        array[offset + 2] = b3;
        array[offset + 3] = b4;
    }

    private void calc_crc(int[] dat, int addr, int size) {
        int crc = 0;
        while (size > 0) {
            crc = crc << 8 ^ this.crc_table[crc >>> 8 ^ dat[addr++]];
            crc &= 0xFFFF;
            --size;
        }
        dat[addr++] = crc >>> 8;
        dat[addr] = crc & 0xFF;
    }

    private int calc_rand() {
        int tmp1 = this.rand_s = 32552;
        int tmp2 = tmp1 & 0xFF;
        tmp1 = (tmp1 << 1) + 1 + this.rand_s;
        int tmp3 = (tmp1 >>> 8) + tmp2 & 0xFF;
        this.rand_s = tmp3 << 8 | (tmp1 &= 0xFF);
        return tmp3;
    }

    private void fdc_make_track() {
        int p;
        int j;
        int count;
        int q;
        int i;
        int secs = 0;
        boolean flag = false;
        if (this.fdc_ready[this.fdc_drvreg] != 2) {
            if (this.fdc_track[this.fdc_drvreg] > 79) {
                flag = true;
            }
        } else if (this.fdc_buffer[4] == 0 && this.fdc_buffer[5] == 0) {
            flag = true;
        }
        if (flag) {
            int p2 = 0;
            int i2 = 0;
            while (i2 < 6144) {
                this.fdc_buffer[p2++] = this.calc_rand();
                ++i2;
            }
            this.fdc_dataptr.set(this.fdc_buffer);
            this.fdc_totalcnt = 6144;
            this.fdc_nowcnt = 0;
            return;
        }
        if (this.fdc_ready[this.fdc_drvreg] == 1) {
            secs = 16;
            i = 0;
            q = 4096;
            while (i < 4096) {
                this.fdc_buffer[q] = this.fdc_buffer[i];
                ++i;
                ++q;
            }
        } else if (this.fdc_ready[this.fdc_drvreg] == 3) {
            count = this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 4];
            count = count == 0 ? 128 : (count *= 256);
            q = 8192 - (count *= this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 5]);
            j = count - 1;
            while (j >= 0) {
                this.fdc_buffer[q + j] = this.fdc_buffer[j];
                --j;
            }
        } else {
            secs = this.fdc_buffer[5] * 256;
            secs += this.fdc_buffer[4];
            count = 0;
            j = 0;
            while (j < secs) {
                p = count;
                count += this.fdc_buffer[p + 15] * 256 + this.fdc_buffer[p + 14];
                count += 16;
                ++j;
            }
            q = 8192 - count;
            j = count - 1;
            while (j >= 0) {
                this.fdc_buffer[q + j] = this.fdc_buffer[j];
                --j;
            }
        }
        int gap3 = secs <= 5 ? 116 : (secs <= 10 ? 84 : (secs <= 16 ? 51 : 16));
        p = 0;
        count = 0;
        i = 0;
        while (i < 80) {
            this.fdc_buffer[p++] = 78;
            ++i;
        }
        count += 80;
        i = 0;
        while (i < 12) {
            this.fdc_buffer[p++] = 0;
            ++i;
        }
        count += 12;
        this.fdc_buffer[p++] = 194;
        this.fdc_buffer[p++] = 194;
        this.fdc_buffer[p++] = 194;
        this.fdc_buffer[p++] = 252;
        count += 4;
        i = 0;
        while (i < 50) {
            this.fdc_buffer[p++] = 78;
            ++i;
        }
        count += 50;
        j = 0;
        while (j < secs) {
            boolean ddm;
            int size;
            i = 0;
            while (i < 12) {
                this.fdc_buffer[p++] = 0;
                ++i;
            }
            count += 12;
            this.fdc_buffer[p++] = 161;
            this.fdc_buffer[p++] = 161;
            this.fdc_buffer[p++] = 161;
            this.fdc_buffer[p++] = 254;
            count += 4;
            if (this.fdc_ready[this.fdc_drvreg] == 1) {
                this.fdc_buffer[p + 0] = this.fdc_track[this.fdc_drvreg];
                this.fdc_buffer[p + 1] = this.fdc_sidereg;
                this.fdc_buffer[p + 2] = j + 1;
                this.fdc_buffer[p + 3] = 1;
                size = 256;
                ddm = false;
            } else if (this.fdc_ready[this.fdc_drvreg] == 3) {
                this.fdc_buffer[p + 0] = this.fdc_track[this.fdc_drvreg];
                this.fdc_buffer[p + 1] = this.fdc_sidereg;
                this.fdc_buffer[p + 2] = j + 1;
                this.fdc_buffer[p + 3] = this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 4];
                size = this.fdc_buffer[p + 3] == 0 ? 128 : this.fdc_buffer[p + 3] * 256;
                ddm = false;
            } else {
                Util.memcpy(this.fdc_buffer, p, this.fdc_buffer, q, 4);
                size = this.fdc_buffer[q + 15] * 256 + this.fdc_buffer[q + 14];
                ddm = this.fdc_buffer[q + 7] != 0;
                q += 16;
            }
            this.calc_crc(this.fdc_buffer, p, 4);
            p += 6;
            count += 6;
            i = 0;
            while (i < 22) {
                this.fdc_buffer[p++] = 78;
                ++i;
            }
            count += 22;
            i = 0;
            while (i < 12) {
                this.fdc_buffer[p++] = 0;
                ++i;
            }
            count += 12;
            this.fdc_buffer[p++] = 161;
            this.fdc_buffer[p++] = 161;
            this.fdc_buffer[p++] = 161;
            this.fdc_buffer[p++] = ddm ? 248 : 251;
            count += 4;
            Util.memcpy(this.fdc_buffer, p, this.fdc_buffer, q, size);
            q += size;
            this.calc_crc(this.fdc_buffer, p, size);
            p += size + 2;
            count += size + 2;
            i = 0;
            while (i < gap3) {
                this.fdc_buffer[p++] = 78;
                ++i;
            }
            count += gap3;
            ++j;
        }
        j = 6144 - count;
        if (j < 6144) {
            i = 0;
            while (i < j) {
                this.fdc_buffer[p++] = 78;
                ++i;
            }
            count += j;
        }
        this.fdc_dataptr.set(this.fdc_buffer);
        this.fdc_totalcnt = count;
        this.fdc_nowcnt = 0;
    }

    private void fdc_makeaddr(int index) {
        int p = 8176;
        if (this.fdc_ready[this.fdc_drvreg] == 1) {
            this.fdc_buffer[p + 0] = this.fdc_track[this.fdc_drvreg];
            this.fdc_buffer[p + 1] = this.fdc_sidereg;
            this.fdc_buffer[p + 2] = index + 1;
            this.fdc_buffer[p + 3] = 1;
        } else if (this.fdc_ready[this.fdc_drvreg] == 3) {
            this.fdc_buffer[p + 0] = this.fdc_track[this.fdc_drvreg];
            this.fdc_buffer[p + 1] = this.fdc_sidereg;
            this.fdc_buffer[p + 2] = index + 1;
            this.fdc_buffer[p + 3] = this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 4];
        } else {
            int offset = 0;
            int i = 0;
            while (i < index) {
                int size = this.fdc_buffer[offset + 15];
                size *= 256;
                size |= this.fdc_buffer[offset + 14];
                offset += size;
                offset += 16;
                ++i;
            }
            Util.memcpy(this.fdc_buffer, p, this.fdc_buffer, offset, 4);
        }
        this.calc_crc(this.fdc_buffer, p, 4);
        this.fdc_dataptr.set(this.fdc_buffer, 8176);
        this.fdc_totalcnt = 6;
        this.fdc_nowcnt = 0;
        this.fdc_secreg = this.fdc_buffer[p + 0];
    }

    private int fdc_next_index() {
        int secs;
        if (this.fdc_ready[this.fdc_drvreg] == 1) {
            this.fdc_indexcnt = this.fdc_indexcnt + 1 & 0xF;
            if (this.fdc_track[this.fdc_drvreg] >= 40) {
                return -1;
            }
            return this.fdc_indexcnt;
        }
        if (this.fdc_ready[this.fdc_drvreg] == 3) {
            secs = this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 5];
        } else {
            secs = this.fdc_buffer[5];
            secs *= 256;
            secs |= this.fdc_buffer[4];
        }
        if (secs == 0) {
            this.fdc_indexcnt = this.fdc_indexcnt + 1 & 0xF;
            return -1;
        }
        ++this.fdc_indexcnt;
        if (this.fdc_indexcnt >= secs) {
            this.fdc_indexcnt = 0;
        }
        return this.fdc_indexcnt;
    }

    private boolean fdc_idmark(IntHolder p) {
        int offset = p.value;
        while (offset < this.fdc_totalcnt) {
            int dat;
            if ((dat = this.fdc_buffer[offset++]) != 161 && dat != 245 || (dat = this.fdc_buffer[offset++]) != 161 && dat != 245 || (dat = this.fdc_buffer[offset++]) != 161 && dat != 245 || (dat = this.fdc_buffer[offset++]) != 254) continue;
            p.value = offset;
            return true;
        }
        p.value = offset;
        return false;
    }

    private boolean fdc_datamark(IntHolder p, BoolHolder deleted_mark) {
        int offset = p.value;
        while (offset < this.fdc_totalcnt) {
            int dat;
            if ((dat = this.fdc_buffer[offset++]) != 161 && dat != 245 || (dat = this.fdc_buffer[offset++]) != 161 && dat != 245 || (dat = this.fdc_buffer[offset++]) != 161 && dat != 245 || (dat = this.fdc_buffer[offset++]) != 251 && dat != 248) continue;
            p.value = offset;
            deleted_mark.value = dat != 251;
            return true;
        }
        p.value = offset;
        return false;
    }

    private boolean fdc_writetrk() {
        int seclen;
        IntHolder offset = new IntHolder();
        BoolHolder ddm = new BoolHolder();
        int total = 0;
        int sectors = 0;
        offset.value = 0;
        while (offset.value < this.fdc_totalcnt) {
            if (!this.fdc_idmark(offset)) break;
            offset.value += 4;
            if (offset.value >= this.fdc_totalcnt) {
                return false;
            }
            if (this.fdc_buffer[offset.value] != 247) {
                return false;
            }
            ++offset.value;
            if (!this.fdc_datamark(offset, ddm)) {
                return false;
            }
            seclen = 0;
            while (offset.value < this.fdc_totalcnt) {
                if (this.fdc_buffer[offset.value] == 247) break;
                ++offset.value;
                ++seclen;
            }
            if (offset.value >= this.fdc_totalcnt) {
                return false;
            }
            total += seclen;
            ++sectors;
            ++offset.value;
        }
        if (this.fdc_ready[this.fdc_drvreg] == 1) {
            if (total != 4096) {
                return false;
            }
            return sectors == 16;
        }
        if (this.fdc_ready[this.fdc_drvreg] == 3) {
            return true;
        }
        if (total + sectors * 16 > this.fdc_trklen[this.fdc_drvreg]) {
            return false;
        }
        if (sectors == 0 && total == 0) {
            return true;
        }
        int writep = 0;
        offset.value = 0;
        int i = 0;
        while (i < sectors) {
            this.fdc_idmark(offset);
            this.fdc_buffer[writep++] = this.fdc_buffer[offset.value++];
            this.fdc_buffer[writep++] = this.fdc_buffer[offset.value++];
            this.fdc_buffer[writep++] = this.fdc_buffer[offset.value++];
            this.fdc_buffer[writep++] = this.fdc_buffer[offset.value++];
            this.fdc_buffer[writep++] = sectors & 0xFF;
            this.fdc_buffer[writep++] = sectors >>> 8;
            this.fdc_buffer[writep++] = 0;
            ++offset.value;
            this.fdc_datamark(offset, ddm);
            this.fdc_buffer[writep++] = ddm.value ? 16 : 0;
            Util.memset(this.fdc_buffer, writep, 0, 8);
            writep += 8;
            seclen = 0;
            while (this.fdc_buffer[offset.value] != 247) {
                this.fdc_buffer[writep++] = this.fdc_buffer[offset.value++];
                ++seclen;
            }
            ++offset.value;
            this.fdc_buffer[writep - seclen - 2] = seclen & 0xFF;
            this.fdc_buffer[writep - seclen - 1] = seclen >>> 8;
            ++i;
        }
        RandomAccessFile handle = File.open(this.fdc_fname[this.fdc_drvreg], 3);
        if (handle == null) {
            return false;
        }
        if (!File.seek(handle, this.fdc_seekofs[this.fdc_drvreg])) {
            File.close(handle);
            return false;
        }
        if (!File.write(handle, this.fdc_buffer, sectors * 16 + total)) {
            File.close(handle);
            return false;
        }
        File.close(handle);
        return true;
    }

    private boolean fdc_writesec() {
        int offset = this.fdc_seekofs[this.fdc_drvreg];
        offset += this.fdc_secofs[this.fdc_drvreg];
        RandomAccessFile handle = File.open(this.fdc_fname[this.fdc_drvreg], 3);
        if (handle == null) {
            return false;
        }
        if (!File.seek(handle, offset)) {
            File.close(handle);
            return false;
        }
        if (!File.write(handle, this.fdc_buffer, this.fdc_dataptr.p, this.fdc_totalcnt)) {
            File.close(handle);
            return false;
        }
        File.close(handle);
        return true;
    }

    private int fdc_readsec(int track, int sector, int side, boolean sidecmp) {
        if (this.fdc_ready[this.fdc_drvreg] == 1) {
            if (track != this.fdc_track[this.fdc_drvreg]) {
                return 16;
            }
            if (side != this.fdc_sidereg) {
                return 16;
            }
            if (sector < 1 || sector > 16) {
                return 16;
            }
            this.fdc_dataptr.set(this.fdc_buffer, (sector - 1) * 256);
            this.fdc_secofs[this.fdc_drvreg] = (sector - 1) * 256;
            this.fdc_totalcnt = 256;
            this.fdc_nowcnt = 0;
            return 0;
        }
        if (this.fdc_ready[this.fdc_drvreg] == 3) {
            if (track != this.fdc_track[this.fdc_drvreg]) {
                return 16;
            }
            if (side != this.fdc_sidereg) {
                return 16;
            }
            int vfdoffset = this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 3];
            vfdoffset *= 256;
            vfdoffset |= this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 2];
            vfdoffset *= 256;
            vfdoffset |= this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 1];
            vfdoffset *= 256;
            if ((vfdoffset |= this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 0]) == 0) {
                return 16;
            }
            int len = this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 4];
            len = len == 0 ? 128 : (len *= 256);
            int size = this.fdc_header[this.fdc_drvreg][this.fdc_track[this.fdc_drvreg] * 6 + 5];
            if (sector < 1 || sector > size) {
                return 16;
            }
            this.fdc_dataptr.set(this.fdc_buffer, (sector - 1) * len);
            this.fdc_secofs[this.fdc_drvreg] = (sector - 1) * len;
            this.fdc_totalcnt = len;
            this.fdc_nowcnt = 0;
            return 0;
        }
        int secs = this.fdc_buffer[5];
        secs *= 256;
        if ((secs |= this.fdc_buffer[4]) == 0) {
            return 16;
        }
        int offset = 0;
        int i = 0;
        while (i < secs) {
            int size = this.fdc_buffer[offset + 15];
            size *= 256;
            size |= this.fdc_buffer[offset + 14];
            if (this.fdc_buffer[offset + 0] != track) {
                offset += size;
                offset += 16;
            } else if (sidecmp && (this.fdc_buffer[offset + 1] & 1) != side) {
                offset += size;
                offset += 16;
            } else if (this.fdc_buffer[offset + 2] != sector) {
                offset += size;
                offset += 16;
            } else if (this.fdc_buffer[offset + 6] == 0) {
                this.fdc_dataptr.set(this.fdc_buffer, offset + 16);
                this.fdc_secofs[this.fdc_drvreg] = offset + 16;
                this.fdc_totalcnt = size;
                this.fdc_nowcnt = 0;
                int stat = 0;
                if (this.fdc_buffer[offset + 7] != 0) {
                    stat |= 0x20;
                }
                if (this.fdc_buffer[offset + 8] == 176) {
                    stat |= 8;
                }
                return stat;
            }
            ++i;
        }
        return 16;
    }

    private void fdc_readbuf(int drive) {
        int offset;
        if (drive < 0 || drive >= 4) {
            return;
        }
        if (this.fdc_ready[drive] == 0) {
            return;
        }
        this.fdc_indexcnt = 0;
        int trkside = this.fdc_track[drive] * 2 + this.fdc_sidereg;
        if (this.fdc_ready[drive] == 1) {
            if (this.fdc_2ddmode != 0) {
                trkside = (this.fdc_track[drive] >>> 1) * 2 + this.fdc_sidereg;
            }
            if (trkside >= 80) {
                Util.memset(this.fdc_buffer, 0, 4096);
                return;
            }
            int offset2 = trkside;
            this.fdc_seekofs[drive] = offset2 *= 4096;
            this.fdc_trklen[drive] = 4096;
            Util.memset(this.fdc_buffer, 0, 4096);
            RandomAccessFile handle = File.open(this.fdc_fname[drive], 1);
            if (handle == null) {
                return;
            }
            if (!File.seek(handle, offset2)) {
                File.close(handle);
                return;
            }
            File.read(handle, this.fdc_buffer, 4096);
            File.close(handle);
            return;
        }
        if (this.fdc_ready[drive] == 3) {
            if (this.fdc_2ddmode != 0) {
                trkside = (this.fdc_track[drive] >>> 1) * 2 + this.fdc_sidereg;
            }
            if (trkside >= 80) {
                Util.memset(this.fdc_buffer, 0, 4096);
                return;
            }
            int offset3 = this.fdc_header[drive][trkside * 6 + 3];
            offset3 *= 256;
            offset3 |= this.fdc_header[drive][trkside * 6 + 2];
            offset3 *= 256;
            offset3 |= this.fdc_header[drive][trkside * 6 + 1];
            offset3 *= 256;
            this.fdc_seekofs[drive] = offset3 |= this.fdc_header[drive][trkside * 6 + 0];
            int len = this.fdc_header[drive][trkside * 6 + 4];
            int secs = this.fdc_header[drive][trkside * 6 + 5];
            len = len == 0 ? 128 : (len *= 256);
            this.fdc_trklen[drive] = len * secs;
            Util.memset(this.fdc_buffer, 0, this.fdc_trklen[drive]);
            RandomAccessFile handle = File.open(this.fdc_fname[drive], 1);
            if (handle == null) {
                return;
            }
            if (!File.seek(handle, offset3)) {
                File.close(handle);
                return;
            }
            File.read(handle, this.fdc_buffer, this.fdc_trklen[drive]);
            File.close(handle);
            return;
        }
        if (this.fdc_2ddmode != 0) {
            if (trkside >= 164) {
                this.fdc_buffer[4] = 0;
                this.fdc_buffer[5] = 0;
                return;
            }
            if (this.fdc_header[drive][27] == 0) {
                trkside = (this.fdc_track[drive] >>> 1) * 2 + this.fdc_sidereg;
            }
        } else {
            if (this.fdc_header[drive][27] == 16) {
                trkside = this.fdc_track[drive] * 4 + this.fdc_sidereg;
            }
            if (trkside >= 84) {
                this.fdc_buffer[4] = 0;
                this.fdc_buffer[5] = 0;
                return;
            }
        }
        if ((offset = this.byteArrayToInt(this.fdc_header[drive], 32 + trkside * 4)) == 0) {
            this.fdc_buffer[4] = 0;
            this.fdc_buffer[5] = 0;
            return;
        }
        int len = this.byteArrayToInt(this.fdc_header[drive], 32 + (trkside + 1) * 4);
        if (len == 0) {
            len = this.byteArrayToInt(this.fdc_header[drive], 20);
        }
        if ((len -= offset) > 8192) {
            len = 8192;
        }
        this.fdc_seekofs[drive] = offset;
        this.fdc_trklen[drive] = len;
        Util.memset(this.fdc_buffer, 0, 8192);
        RandomAccessFile handle = File.open(this.fdc_fname[drive], 1);
        if (handle == null) {
            return;
        }
        if (!File.seek(handle, offset)) {
            File.close(handle);
            return;
        }
        File.read(handle, this.fdc_buffer, len);
        File.close(handle);
    }

    private boolean fdc_readhead(int drive, int index) {
        int temp;
        int offset = this.fdc_foffset[drive][index];
        RandomAccessFile handle = File.open(this.fdc_fname[drive], 1);
        if (handle == null) {
            return false;
        }
        if (!File.seek(handle, offset)) {
            File.close(handle);
            return false;
        }
        if (!File.read(handle, this.fdc_header[drive], 688)) {
            File.close(handle);
            return false;
        }
        File.close(handle);
        if (this.fdc_header[drive][27] != 0 && this.fdc_header[drive][27] != 16) {
            return false;
        }
        this.fdc_writep[drive] = this.fdc_fwritep[drive] ? true : (this.fdc_header[drive][26] & 0x10) != 0;
        int i = 0;
        while (i < 164) {
            temp = 0;
            temp |= this.fdc_header[drive][32 + i * 4 + 3];
            temp *= 256;
            temp |= this.fdc_header[drive][32 + i * 4 + 2];
            temp *= 256;
            temp |= this.fdc_header[drive][32 + i * 4 + 1];
            temp *= 256;
            if ((temp |= this.fdc_header[drive][32 + i * 4 + 0]) != 0) {
                this.intToByteArray(this.fdc_header[drive], 32 + i * 4, temp += offset);
            }
            ++i;
        }
        temp = 0;
        temp |= this.fdc_header[drive][31];
        temp *= 256;
        temp |= this.fdc_header[drive][30];
        temp *= 256;
        temp |= this.fdc_header[drive][29];
        temp *= 256;
        temp |= this.fdc_header[drive][28];
        this.intToByteArray(this.fdc_header[drive], 20, temp += offset);
        return true;
    }

    private boolean fdc_readhead_vfd(int drive) {
        RandomAccessFile handle = File.open(this.fdc_fname[drive], 1);
        if (handle == null) {
            return false;
        }
        if (!File.seek(handle, 0)) {
            File.close(handle);
            return false;
        }
        if (!File.read(handle, this.fdc_header[drive], 480)) {
            File.close(handle);
            return false;
        }
        File.close(handle);
        return true;
    }

    public boolean fdc_setwritep(int drive, boolean writep) {
        int[] header = new int[688];
        RandomAccessFile handle = null;
        if (this.fdc_ready[drive] == 0) {
            return false;
        }
        if (this.fdc_fwritep[drive]) {
            return false;
        }
        if (this.fdc_ready[drive] == 2) {
            int offset = this.fdc_foffset[drive][this.fdc_media[drive]];
            handle = File.open(this.fdc_fname[drive], 3);
            if (handle == null) {
                return false;
            }
            if (!File.seek(handle, offset)) {
                File.close(handle);
                return false;
            }
            if (!File.read(handle, header, 688)) {
                File.close(handle);
                return false;
            }
            header[26] = writep ? header[26] | 0x10 : header[26] & 0xFFFFFFEF;
            if (!File.seek(handle, offset)) {
                File.close(handle);
                return false;
            }
            if (!File.write(handle, header, 688)) {
                File.close(handle);
                return false;
            }
        }
        File.close(handle);
        this.fdc_writep[drive] = writep;
        return true;
    }

    public boolean fdc_setmedia(int drive, int index) {
        if (this.fdc_ready[drive] == 0) {
            return false;
        }
        if (this.fdc_ready[drive] == 1 && index != 0) {
            return false;
        }
        if (this.fdc_ready[drive] == 3) {
            if (index != 0) {
                return false;
            }
            if (!this.fdc_readhead_vfd(drive)) {
                return false;
            }
        }
        if (index > 0 && this.fdc_foffset[drive][index] == 0) {
            return false;
        }
        if (this.fdc_ready[drive] == 2) {
            if (!this.fdc_readhead(drive, index)) {
                return false;
            }
        } else {
            this.fdc_writep[drive] = this.fdc_fwritep[drive];
        }
        this.fdc_teject[this.fdc_drvreg] = false;
        this.fdc_readbuf(this.fdc_drvreg);
        this.fdc_media[drive] = index;
        return true;
    }

    /*
     * Unable to fully structure code
     */
    private int fdc_chkd77(int drive) {
        buf = new byte[32];
        i = 0;
        while (i < 16) {
            this.fdc_foffset[drive][i] = 0;
            this.fdc_name[drive][i] = "";
            ++i;
        }
        count = 0;
        offset = 0;
        handle = File.open(this.fdc_fname[drive], 1);
        if (handle != null) ** GOTO lbl34
        return count;
lbl-1000:
        // 1 sources

        {
            if (!File.seek(handle, offset)) {
                File.close(handle);
                return count;
            }
            if (!File.read(handle, buf, 32)) {
                File.close(handle);
                return count;
            }
            if (buf[27] != 0 && buf[27] != 16) {
                File.close(handle);
                return count;
            }
            buf[17] = 0;
            this.fdc_name[drive][count] = Util.byt2str(buf);
            this.fdc_foffset[drive][count] = offset;
            len = 0;
            len |= buf[31] & 255;
            len *= 256;
            len |= buf[30] & 255;
            len *= 256;
            len |= buf[29] & 255;
            len *= 256;
            offset += (len |= buf[28] & 255);
            ++count;
lbl34:
            // 2 sources

            ** while (count < 16)
        }
lbl35:
        // 1 sources

        File.close(handle);
        return count;
    }

    private int fdc_chkvfd(int drive) {
        int[] buf = new int[32];
        int i = 0;
        while (i < 16) {
            this.fdc_foffset[drive][i] = 0;
            this.fdc_name[drive][i] = "";
            ++i;
        }
        RandomAccessFile handle = File.open(this.fdc_fname[drive], 1);
        if (handle == null) {
            return 0;
        }
        if (!File.seek(handle, 0)) {
            File.close(handle);
            return 0;
        }
        if (!File.read(handle, buf, 32)) {
            File.close(handle);
            return 0;
        }
        File.close(handle);
        if (buf[0] != 224 || buf[1] != 1 || buf[2] != 0 || buf[3] != 0) {
            return 0;
        }
        return 1;
    }

    public int fdc_setdisk(int drive, String fname) {
        if (fname == null) {
            this.fdc_ready[drive] = 0;
            this.fdc_fname[drive] = "";
            return 1;
        }
        this.fdc_fname[drive] = new String(fname);
        boolean writep = false;
        RandomAccessFile handle = File.open(fname, 3);
        if (handle == null) {
            handle = File.open(fname, 1);
            if (handle == null) {
                return 0;
            }
            writep = true;
        }
        int fsize = File.getsize(handle);
        File.close(handle);
        if (fsize == 327680) {
            this.fdc_ready[drive] = 1;
            this.fdc_fwritep[drive] = writep;
            if (!this.fdc_setmedia(drive, 0)) {
                this.fdc_ready[drive] = 0;
                return 0;
            }
            this.fdc_teject[drive] = false;
            this.fdc_medias[drive] = 1;
            return 1;
        }
        if (this.fdc_chkvfd(drive) != 0) {
            this.fdc_ready[drive] = 3;
            this.fdc_fwritep[drive] = writep;
            if (!this.fdc_setmedia(drive, 0)) {
                this.fdc_ready[drive] = 0;
                return 0;
            }
            this.fdc_teject[drive] = false;
            this.fdc_medias[drive] = 1;
            return 1;
        }
        this.fdc_ready[drive] = 2;
        this.fdc_fwritep[drive] = writep;
        int count = this.fdc_chkd77(drive);
        if (count == 0) {
            this.fdc_ready[drive] = 0;
            return 0;
        }
        if (!this.fdc_setmedia(drive, 0)) {
            this.fdc_ready[drive] = 0;
            return 0;
        }
        this.fdc_teject[drive] = false;
        this.fdc_medias[drive] = count;
        return count;
    }

    @Override
    public boolean event(int callbackid) {
        switch (callbackid) {
            case 1: {
                return this.fdd_seek_event();
            }
            case 2: {
                return this.fdc_drq_event();
            }
            case 3: {
                return this.fdc_lost_event();
            }
            case 4: {
                return this.fdc_multi_event();
            }
        }
        return true;
    }

    private boolean fdc_drq_event() {
        if ((this.fdc_drqirq & 0x80) != 0) {
            return this.fdc_lost_event();
        }
        this.fdc_status |= 2;
        this.fdc_drqirq |= 0x80;
        return true;
    }

    private boolean fdd_seek_event() {
        if (this.fdc_seek_track < 0) {
            mainetc.fdc();
            this.fdc_drqirq = 64;
            this.fdc_status &= 0xFFFFFFFE;
            this.fdc_access[this.fdc_drvreg] = 0;
            schedule.delevent(16);
        } else if (this.fdc_seek_track-- == 0) {
            schedule.setevent(16, 20000, this, 1);
        } else if (this.fdc_sound) {
            Fdc.sysmain.sys_snd.wav_notify(2);
        }
        return true;
    }

    private void fdc_setseekevent(int track) {
        this.fdc_seek_track = track;
        if (track > 0) {
            schedule.setevent(16, this.fdc_steprate[this.fdc_command & 3], this, 1);
        } else {
            schedule.setevent(16, 300, this, 1);
        }
    }

    private void fdc_make_stat() {
        if (this.fdc_drvreg >= 4) {
            this.fdc_status |= 0x80;
            return;
        }
        this.fdc_status = this.fdc_ready[this.fdc_drvreg] == 0 ? (this.fdc_status |= 0x80) : (this.fdc_status &= 0xFFFFFF7F);
        if (this.fdc_teject[this.fdc_drvreg]) {
            this.fdc_status |= 0x80;
        }
        this.fdc_status = this.fdc_cmdtype == 2 || this.fdc_cmdtype == 4 || this.fdc_cmdtype == 6 ? (this.fdc_status &= 0xFFFFFFBF) : (this.fdc_writep[this.fdc_drvreg] || (this.fdc_status & 0x80) != 0 ? (this.fdc_status |= 0x40) : (this.fdc_status &= 0xFFFFFFBF));
        if (this.fdc_cmdtype != 1) {
            return;
        }
        this.fdc_status = this.fdc_track[this.fdc_drvreg] == 0 ? (this.fdc_status |= 4) : (this.fdc_status &= 0xFFFFFFFB);
        if ((this.fdc_status & 0x80) == 0) {
            this.fdc_status = this.fdc_indexcnt == 0 ? (this.fdc_status |= 2) : (this.fdc_status &= 0xFFFFFFFD);
            this.fdc_next_index();
        }
    }

    private void fdc_restore() {
        this.fdc_cmdtype = 1;
        this.fdc_status = 0;
        if (this.fdc_drvreg >= 4) {
            mainetc.fdc();
            this.fdc_drqirq = 64;
            this.fdc_make_stat();
            return;
        }
        int prevtrk = this.fdc_track[this.fdc_drvreg];
        if (this.fdc_track[this.fdc_drvreg] != 0) {
            this.fdc_track[this.fdc_drvreg] = 0;
            this.fdc_readbuf(this.fdc_drvreg);
        }
        this.fdc_seekvct = true;
        this.fdc_trkreg = 0;
        this.fdc_datareg = 0;
        this.fdc_drqirq = 0;
        if (this.fdc_wait) {
            this.fdc_setseekevent(prevtrk);
        } else if (!Fdc.mainetc.mfd_irq_mask) {
            mainetc.fdc();
            this.fdc_drqirq |= 0x40;
        }
        this.fdc_status = 1;
        if ((this.fdc_command & 8) != 0) {
            this.fdc_status |= 0x20;
        }
        this.fdc_make_stat();
        this.fdc_access[this.fdc_drvreg] = 1;
    }

    private void fdc_seek() {
        this.fdc_cmdtype = 1;
        this.fdc_status = 0;
        if (this.fdc_drvreg >= 4) {
            mainetc.fdc();
            this.fdc_drqirq = 64;
            this.fdc_make_stat();
            return;
        }
        if ((this.fdc_command & 4) != 0 && this.fdc_trkreg != this.fdc_track[this.fdc_drvreg]) {
            this.fdc_status |= 0x10;
            this.fdc_trkreg = this.fdc_track[this.fdc_drvreg];
        }
        int prevtrk = this.fdc_track[this.fdc_drvreg];
        int target = this.fdc_track[this.fdc_drvreg] + this.fdc_datareg - this.fdc_trkreg;
        if (this.fdc_datareg > this.fdc_trkreg) {
            this.fdc_seekvct = false;
            if (this.fdc_2ddmode != 0) {
                if (target > 81) {
                    target = 81;
                }
            } else if (target > 41) {
                target = 41;
            }
        } else {
            this.fdc_seekvct = true;
            if (this.fdc_track[this.fdc_drvreg] < this.fdc_trkreg - this.fdc_datareg) {
                target = 0;
            }
        }
        if (this.fdc_track[this.fdc_drvreg] != target) {
            this.fdc_track[this.fdc_drvreg] = target;
            this.fdc_readbuf(this.fdc_drvreg);
        }
        this.fdc_trkreg = this.fdc_track[this.fdc_drvreg];
        this.fdc_drqirq = 0;
        if (this.fdc_wait) {
            this.fdc_setseekevent(Math.abs(target - prevtrk));
        } else if (!Fdc.mainetc.mfd_irq_mask) {
            mainetc.fdc();
            this.fdc_drqirq |= 0x40;
        }
        this.fdc_status |= 1;
        if ((this.fdc_command & 8) != 0) {
            this.fdc_status |= 0x20;
        }
        this.fdc_make_stat();
        this.fdc_access[this.fdc_drvreg] = 1;
    }

    private void fdc_step_in() {
        this.fdc_cmdtype = 1;
        this.fdc_status = 0;
        if (this.fdc_drvreg >= 4) {
            mainetc.fdc();
            this.fdc_drqirq = 64;
            this.fdc_make_stat();
            return;
        }
        int prevtrk = this.fdc_track[this.fdc_drvreg];
        if ((this.fdc_command & 4) != 0 && this.fdc_trkreg != this.fdc_track[this.fdc_drvreg]) {
            this.fdc_status |= 0x10;
        }
        if (this.fdc_2ddmode != 0) {
            if (this.fdc_track[this.fdc_drvreg] < 81) {
                int n = this.fdc_drvreg;
                this.fdc_track[n] = this.fdc_track[n] + 1;
                this.fdc_readbuf(this.fdc_drvreg);
            }
        } else if (this.fdc_track[this.fdc_drvreg] < 41) {
            int n = this.fdc_drvreg;
            this.fdc_track[n] = this.fdc_track[n] + 1;
            this.fdc_readbuf(this.fdc_drvreg);
        }
        this.fdc_seekvct = false;
        if ((this.fdc_command & 0x10) != 0) {
            this.fdc_trkreg = this.fdc_track[this.fdc_drvreg];
        }
        this.fdc_drqirq = 0;
        if (this.fdc_wait && prevtrk != this.fdc_track[this.fdc_drvreg]) {
            this.fdc_setseekevent(1);
        } else if (!Fdc.mainetc.mfd_irq_mask) {
            mainetc.fdc();
            this.fdc_drqirq |= 0x40;
        }
        this.fdc_status |= 1;
        if ((this.fdc_command & 8) != 0) {
            this.fdc_status |= 0x20;
        }
        this.fdc_make_stat();
        this.fdc_access[this.fdc_drvreg] = 1;
    }

    private void fdc_step_out() {
        this.fdc_cmdtype = 1;
        this.fdc_status = 0;
        if (this.fdc_drvreg >= 4) {
            mainetc.fdc();
            this.fdc_drqirq = 64;
            this.fdc_make_stat();
            return;
        }
        int prevtrk = this.fdc_track[this.fdc_drvreg];
        if ((this.fdc_command & 4) != 0 && this.fdc_trkreg != this.fdc_track[this.fdc_drvreg]) {
            this.fdc_status |= 0x10;
        }
        if (this.fdc_track[this.fdc_drvreg] != 0) {
            int n = this.fdc_drvreg;
            this.fdc_track[n] = this.fdc_track[n] - 1;
            this.fdc_readbuf(this.fdc_drvreg);
        }
        this.fdc_seekvct = true;
        if ((this.fdc_command & 0x10) != 0) {
            this.fdc_trkreg = this.fdc_track[this.fdc_drvreg];
        }
        this.fdc_drqirq = 0;
        if (this.fdc_wait && prevtrk != this.fdc_track[this.fdc_drvreg]) {
            this.fdc_setseekevent(1);
        } else if (!Fdc.mainetc.mfd_irq_mask) {
            mainetc.fdc();
            this.fdc_drqirq |= 0x40;
        }
        this.fdc_status |= 1;
        if ((this.fdc_command & 8) != 0) {
            this.fdc_status |= 0x20;
        }
        this.fdc_make_stat();
        this.fdc_access[this.fdc_drvreg] = 1;
    }

    private void fdc_step() {
        if (this.fdc_seekvct) {
            this.fdc_step_out();
        } else {
            this.fdc_step_in();
        }
    }

    private boolean fdc_rw_sub() {
        this.fdc_status = 0;
        if (this.fdc_drvreg >= 4) {
            this.fdc_make_stat();
            mainetc.fdc();
            this.fdc_drqirq = 64;
            return false;
        }
        if (this.fdc_ready[this.fdc_drvreg] == 0 || this.fdc_teject[this.fdc_drvreg]) {
            this.fdc_make_stat();
            mainetc.fdc();
            this.fdc_drqirq = 64;
            return false;
        }
        return true;
    }

    private void fdc_read_data() {
        this.fdc_cmdtype = 2;
        if (!this.fdc_rw_sub()) {
            return;
        }
        int drv = Fdc.vm.fm7_ver <= 2 ? 0 : 1;
        if (!this.fdc_boot && this.fdc_drvreg > drv) {
            this.fdc_status |= 0x80;
            mainetc.fdc();
            this.fdc_drqirq = 64;
            return;
        }
        int stat = (this.fdc_command & 2) != 0 ? this.fdc_readsec(this.fdc_trkreg, this.fdc_secreg, (this.fdc_command & 8) >>> 3, true) : this.fdc_readsec(this.fdc_trkreg, this.fdc_secreg, this.fdc_sidereg, false);
        this.fdc_status = stat;
        if ((this.fdc_status & 0x10) != 0) {
            mainetc.fdc();
            this.fdc_drqirq = 64;
            this.fdc_access[this.fdc_drvreg] = 0;
            return;
        }
        this.fdc_status |= 1;
        this.fdc_datareg = this.fdc_dataptr.v(0);
        if (this.fdc_wait) {
            schedule.setevent(15, 2304, this, 2);
            this.fdc_drqirq = 0;
        } else {
            this.fdc_status |= 2;
            this.fdc_drqirq = 128;
        }
        if (this.fdc_trkreg == 0 && this.fdc_secreg == 1 && this.fdc_sidereg == 0) {
            this.fdc_boot = true;
        }
        this.fdc_access[this.fdc_drvreg] = 2;
        dmac.start();
        if (!this.fdc_wait) {
            schedule.setevent(15, 30000, this, 3);
        }
    }

    private void fdc_write_data() {
        this.fdc_cmdtype = 3;
        if (!this.fdc_rw_sub()) {
            return;
        }
        if (this.fdc_writep[this.fdc_drvreg]) {
            this.fdc_make_stat();
            mainetc.fdc();
            this.fdc_drqirq = 64;
            return;
        }
        int stat = (this.fdc_command & 2) != 0 ? this.fdc_readsec(this.fdc_trkreg, this.fdc_secreg, (this.fdc_command & 8) >>> 3, true) : this.fdc_readsec(this.fdc_trkreg, this.fdc_secreg, this.fdc_sidereg, false);
        this.fdc_status = stat;
        if ((this.fdc_status & 0x10) != 0) {
            this.fdc_status = 16;
            mainetc.fdc();
            this.fdc_drqirq = 64;
            this.fdc_access[this.fdc_drvreg] = 0;
            return;
        }
        this.fdc_status = 1;
        if (this.fdc_wait) {
            schedule.setevent(15, 2304, this, 2);
            this.fdc_drqirq = 0;
        } else {
            this.fdc_status |= 2;
            this.fdc_drqirq = 128;
        }
        this.fdc_access[this.fdc_drvreg] = 3;
        dmac.start();
        if (!this.fdc_wait) {
            schedule.setevent(15, 30000, this, 3);
        }
    }

    private void fdc_read_addr() {
        this.fdc_cmdtype = 4;
        if (!this.fdc_rw_sub()) {
            return;
        }
        int idx = this.fdc_next_index();
        if (idx == -1) {
            this.fdc_status = 16;
            mainetc.fdc();
            this.fdc_drqirq = 64;
            return;
        }
        this.fdc_makeaddr(idx);
        this.fdc_status |= 1;
        this.fdc_datareg = this.fdc_dataptr.v(0);
        if (this.fdc_wait) {
            schedule.setevent(15, 192, this, 2);
            this.fdc_drqirq = 0;
        } else {
            this.fdc_status |= 2;
            this.fdc_drqirq = 128;
        }
        this.fdc_secreg = this.fdc_track[this.fdc_drvreg];
        this.fdc_access[this.fdc_drvreg] = 2;
        dmac.start();
        if (!this.fdc_wait) {
            schedule.setevent(15, 10000, this, 3);
        }
    }

    private void fdc_read_track() {
        this.fdc_cmdtype = 6;
        if (!this.fdc_rw_sub()) {
            return;
        }
        this.fdc_make_track();
        this.fdc_status |= 1;
        this.fdc_datareg = this.fdc_dataptr.v(0);
        if (this.fdc_wait) {
            schedule.setevent(15, 48, this, 2);
            this.fdc_drqirq = 0;
        } else {
            this.fdc_status |= 2;
            this.fdc_drqirq = 128;
        }
        this.fdc_access[this.fdc_drvreg] = 2;
        dmac.start();
        if (!this.fdc_wait) {
            schedule.setevent(15, 150000, this, 3);
        }
    }

    private void fdc_write_track() {
        this.fdc_status = 0;
        this.fdc_cmdtype = 5;
        if (!this.fdc_rw_sub()) {
            return;
        }
        if (this.fdc_writep[this.fdc_drvreg]) {
            this.fdc_make_stat();
            mainetc.fdc();
            this.fdc_drqirq = 64;
            return;
        }
        this.fdc_status = 1;
        if (this.fdc_wait) {
            schedule.setevent(15, 48, this, 2);
            this.fdc_drqirq = 0;
        } else {
            this.fdc_status |= 2;
            this.fdc_drqirq = 128;
        }
        this.fdc_dataptr.set(this.fdc_buffer);
        this.fdc_totalcnt = 6144;
        this.fdc_nowcnt = 0;
        this.fdc_access[this.fdc_drvreg] = 3;
        dmac.start();
        if (!this.fdc_wait) {
            schedule.setevent(15, 150000, this, 3);
        }
    }

    private void fdc_force_intr() {
        if (this.fdc_cmdtype == 5) {
            if (!this.fdc_writetrk()) {
                this.fdc_status |= 0x20;
            }
            this.fdc_readbuf(this.fdc_drvreg);
        }
        if (!this.fdc_wait) {
            schedule.delevent(15);
        }
        this.fdc_readbuf(this.fdc_drvreg);
        this.fdc_dataptr.set(null);
        switch (this.fdc_access[this.fdc_drvreg]) {
            case 2: 
            case 3: {
                this.fdc_status &= 0xFFFFFFFE;
                break;
            }
            case 0: 
            case 1: {
                this.fdc_status = 0;
                this.fdc_indexcnt = 0;
                this.fdc_make_stat();
            }
        }
        this.fdc_access[this.fdc_drvreg] = 0;
        if ((this.fdc_command & 0xF) != 0) {
            mainetc.fdc();
            this.fdc_drqirq = 64;
        } else {
            this.fdc_drqirq = 0;
        }
    }

    private boolean fdc_multi_event() {
        if ((this.fdc_drqirq & 0x10) != 0) {
            this.fdc_drqirq = 8;
            ++this.fdc_secreg;
            schedule.setevent(14, 30, this, 4);
            return true;
        }
        if ((this.fdc_drqirq & 8) != 0) {
            this.fdc_drqirq = 0;
            if (this.fdc_cmdtype == 2) {
                this.fdc_read_data();
                this.fdc_drqirq |= 0x20;
            }
            if (this.fdc_cmdtype == 3) {
                this.fdc_write_data();
                this.fdc_drqirq |= 0x20;
            }
        }
        schedule.delevent(14);
        return true;
    }

    private boolean fdc_lost_event() {
        if (this.fdc_dataptr.isValid() && (this.fdc_drqirq & 0x80) != 0) {
            this.fdc_dataptr.set(null);
            this.fdc_status |= 4;
            this.fdc_status &= 0xFFFFFFFD;
            this.fdc_status &= 0xFFFFFFFE;
            this.fdc_access[this.fdc_drvreg] = 0;
            mainetc.fdc();
            this.fdc_drqirq = 64;
        }
        schedule.delevent(15);
        return true;
    }

    private void fdc_process_cmd() {
        int high = this.fdc_command >>> 4;
        this.fdc_wait = this.fdc_waitmode;
        this.fdc_dataptr.set(null);
        switch (high) {
            case 0: {
                this.fdc_restore();
                break;
            }
            case 1: {
                this.fdc_seek();
                break;
            }
            case 2: 
            case 3: {
                this.fdc_step();
                break;
            }
            case 4: 
            case 5: {
                this.fdc_step_in();
                break;
            }
            case 6: 
            case 7: {
                this.fdc_step_out();
                break;
            }
            case 8: 
            case 9: {
                this.fdc_read_data();
                break;
            }
            case 10: 
            case 11: {
                this.fdc_write_data();
                break;
            }
            case 12: {
                this.fdc_read_addr();
                break;
            }
            case 13: {
                this.fdc_force_intr();
                break;
            }
            case 14: {
                this.fdc_read_track();
                break;
            }
            case 15: {
                this.fdc_write_track();
                break;
            }
        }
    }

    boolean readb(int addr, IntHolder dat) {
        switch (addr) {
            case 64792: {
                this.fdc_make_stat();
                dat.value = this.fdc_status;
                this.fdc_drqirq |= 0x20;
                if ((this.fdc_status & 1) != 0 && !this.fdc_dataptr.isValid()) {
                    if (!this.fdc_wait && this.fdc_cmdtype == 1) {
                        this.fdc_drqirq |= 0x40;
                    }
                    if (!this.fdc_wait || this.fdc_cmdtype != 1 || (this.fdc_drqirq & 0x40) != 0) {
                        this.fdc_status &= 0xFFFFFFFE;
                        this.fdc_access[this.fdc_drvreg] = 0;
                    }
                    return true;
                }
                Fdc.mainetc.mfd_irq_flag = false;
                this.fdc_drqirq &= 0xFFFFFFBF;
                maincpu.irq();
                return true;
            }
            case 64793: {
                dat.value = this.fdc_trkreg;
                return true;
            }
            case 64794: {
                dat.value = this.fdc_secreg;
                return true;
            }
            case 64795: {
                dat.value = this.fdc_datareg;
                if (this.fdc_dataptr.isValid() && (this.fdc_drqirq & 0x20) != 0) {
                    ++this.fdc_nowcnt;
                    if (this.fdc_nowcnt == this.fdc_totalcnt) {
                        if (this.fdc_wait) {
                            schedule.delevent(15);
                        }
                        this.fdc_status &= 0xFFFFFFFE;
                        this.fdc_status &= 0xFFFFFFFD;
                        this.fdc_drqirq &= 0xFFFFFF7F;
                        if (this.fdc_cmdtype == 2 && (this.fdc_command & 0x10) != 0) {
                            this.fdc_status |= 1;
                            this.fdc_dataptr.set(null);
                            this.fdc_drqirq = 16;
                            schedule.setevent(14, 30, this, 4);
                            return true;
                        }
                        this.fdc_dataptr.set(null);
                        mainetc.fdc();
                        this.fdc_drqirq = 64;
                        this.fdc_access[this.fdc_drvreg] = 0;
                        if (this.fdc_cmdtype == 6) {
                            this.fdc_status |= 4;
                            this.fdc_readbuf(this.fdc_drvreg);
                        }
                    } else {
                        this.fdc_datareg = this.fdc_dataptr.v(this.fdc_nowcnt);
                        if (this.fdc_wait) {
                            schedule.setevent(15, 48, this, 2);
                            this.fdc_status &= 0xFFFFFFFD;
                            this.fdc_drqirq &= 0xFFFFFF7F;
                        } else {
                            this.fdc_drqirq |= 0x80;
                        }
                    }
                }
                return true;
            }
            case 64796: {
                dat.value = this.fdc_sidereg | 0xFE;
                return true;
            }
            case 64797: {
                dat.value = this.fdc_motor != 0 ? 0xBC | this.fdc_drvregP : 0x3C | this.fdc_drvregP;
                return true;
            }
            case 64798: {
                if (Fdc.vm.fm7_ver < 3) {
                    dat.value = 255;
                    return true;
                }
                int tmp = this.fdc_logidrv << 2 | this.fdc_physdrv[this.fdc_logidrv];
                dat.value = this.fdc_2ddmode != 0 ? tmp | 0xB0 : tmp | 0xF0;
                return true;
            }
            case 64799: {
                dat.value = this.fdc_drqirq | 0x3F;
                this.fdc_drqirq |= 0x20;
                if (!this.fdc_dataptr.isValid()) {
                    if (!this.fdc_wait && this.fdc_cmdtype == 1 && (this.fdc_status & 1) != 0) {
                        this.fdc_drqirq |= 0x40;
                    }
                    if (!this.fdc_wait || this.fdc_cmdtype != 1 || (this.fdc_drqirq & 0x40) != 0) {
                        this.fdc_status &= 0xFFFFFFFE;
                        this.fdc_access[this.fdc_drvreg] = 0;
                    }
                }
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        switch (addr) {
            case 64792: {
                this.fdc_command = dat;
                this.fdc_process_cmd();
                return true;
            }
            case 64793: {
                this.fdc_trkreg = dat;
                if ((this.fdc_status & 1) != 0 && this.fdc_nowcnt == 0 && (this.fdc_cmdtype == 2 || this.fdc_cmdtype == 3)) {
                    this.fdc_process_cmd();
                }
                return true;
            }
            case 64794: {
                this.fdc_secreg = dat;
                if ((this.fdc_status & 1) != 0 && this.fdc_nowcnt == 0 && (this.fdc_cmdtype == 2 || this.fdc_cmdtype == 3)) {
                    this.fdc_process_cmd();
                }
                return true;
            }
            case 64795: {
                this.fdc_datareg = dat;
                if (this.fdc_dataptr.isValid() && (this.fdc_drqirq & 0x20) != 0) {
                    this.fdc_dataptr.setv(this.fdc_nowcnt, this.fdc_datareg);
                    ++this.fdc_nowcnt;
                    if (this.fdc_nowcnt == this.fdc_totalcnt) {
                        if (this.fdc_wait) {
                            schedule.delevent(15);
                        }
                        this.fdc_status &= 0xFFFFFFFD;
                        this.fdc_drqirq &= 0xFFFFFF7F;
                        this.fdc_status &= 0xFFFFFFFE;
                        if (this.fdc_cmdtype == 3 && !this.fdc_writesec()) {
                            this.fdc_status |= 0x20;
                        }
                        if (this.fdc_cmdtype == 5) {
                            if (!this.fdc_writetrk()) {
                                this.fdc_status |= 0x20;
                            }
                            this.fdc_readbuf(this.fdc_drvreg);
                        }
                        if (this.fdc_cmdtype == 3 && (this.fdc_command & 0x10) != 0) {
                            this.fdc_status |= 1;
                            this.fdc_dataptr.set(null);
                            this.fdc_drqirq = 16;
                            schedule.setevent(14, 30, this, 4);
                            return true;
                        }
                        this.fdc_dataptr.set(null);
                        mainetc.fdc();
                        this.fdc_drqirq = 64;
                        this.fdc_access[this.fdc_drvreg] = 0;
                    } else if (this.fdc_wait) {
                        schedule.setevent(15, 48, this, 2);
                        this.fdc_status &= 0xFFFFFFFD;
                        this.fdc_drqirq &= 0xFFFFFF7F;
                    } else {
                        this.fdc_drqirq |= 0x80;
                    }
                }
                return true;
            }
            case 64796: {
                if ((dat & 1) != this.fdc_sidereg) {
                    this.fdc_sidereg = dat & 1;
                    this.fdc_readbuf(this.fdc_drvreg);
                }
                return true;
            }
            case 64797: {
                if (this.fdc_drvregP != (dat & 3)) {
                    this.fdc_drvregP = dat & 3;
                    this.fdc_drvreg = this.fdc_physdrv[this.fdc_drvregP];
                    this.fdc_readbuf(this.fdc_drvreg);
                }
                this.fdc_motor = dat & 0x80;
                if (this.fdc_drvreg >= 4) {
                    this.fdc_motor = 0;
                }
                return true;
            }
            case 64798: {
                if (Fdc.vm.fm7_ver < 3) {
                    return true;
                }
                int tmp = this.fdc_2ddmode;
                this.fdc_2ddmode = (dat & 0x40) != 0 ? 0 : -1;
                this.fdc_logidrv = (dat & 0xC) >>> 2;
                if ((dat & 0x10) != 0) {
                    this.fdc_physdrv[this.fdc_logidrv] = dat & 3;
                    if (this.fdc_logidrv == this.fdc_drvregP) {
                        this.fdc_drvreg = this.fdc_physdrv[this.fdc_logidrv];
                        this.fdc_readbuf(this.fdc_drvreg);
                        return true;
                    }
                }
                if (this.fdc_2ddmode != tmp) {
                    this.fdc_readbuf(this.fdc_drvreg);
                }
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        int i = 0;
        while (i < 4) {
            if (!File.byte_write(fileh, this.fdc_ready[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            int fnamesize = 129;
            if (this.fdc_fname[i] != null) {
                byte[] fname = Util.str2byt(this.fdc_fname[i]);
                if (fname == null) {
                    return false;
                }
                if (!File.write(fileh, fname, fname.length)) {
                    return false;
                }
                fnamesize -= fname.length;
            }
            while (fnamesize > 0) {
                if (!File.byte_write(fileh, 0)) {
                    return false;
                }
                --fnamesize;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (!File.byte_write(fileh, this.fdc_media[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (!File.bool_write(fileh, this.fdc_teject[i])) {
                // empty if block
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (!File.byte_write(fileh, this.fdc_track[i])) {
                return false;
            }
            ++i;
        }
        if (!File.write(fileh, this.fdc_buffer, 8192)) {
            return false;
        }
        if (!this.fdc_dataptr.isValid() ? !File.word_write(fileh, 8192) : !File.word_write(fileh, this.fdc_dataptr.p)) {
            return false;
        }
        i = 0;
        while (i < 4) {
            if (!File.dword_write(fileh, this.fdc_seekofs[i])) {
                return false;
            }
            ++i;
        }
        i = 0;
        while (i < 4) {
            if (!File.dword_write(fileh, this.fdc_secofs[i])) {
                return false;
            }
            ++i;
        }
        if (!File.byte_write(fileh, this.fdc_command)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_status)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_trkreg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_secreg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_datareg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_sidereg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_drvreg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_motor)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_drqirq)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_cmdtype)) {
            return false;
        }
        if (!File.word_write(fileh, this.fdc_totalcnt)) {
            return false;
        }
        if (!File.word_write(fileh, this.fdc_nowcnt)) {
            return false;
        }
        if (!File.bool_write(fileh, this.fdc_seekvct)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_indexcnt)) {
            return false;
        }
        i = 0;
        while (i < 4) {
            if (!File.byte_write(fileh, this.fdc_access[i])) {
                return false;
            }
            ++i;
        }
        if (!File.bool_write(fileh, this.fdc_boot)) {
            return false;
        }
        if (!File.bool_write(fileh, this.fdc_wait)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_2ddmode)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_logidrv)) {
            return false;
        }
        if (!File.byte_write(fileh, this.fdc_drvregP)) {
            return false;
        }
        i = 0;
        while (i < 4) {
            if (!File.byte_write(fileh, this.fdc_physdrv[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    boolean load(RandomAccessFile fileh, int ver) {
        int[] ready = new int[4];
        byte[][] fname = new byte[4][129];
        int[] media = new int[4];
        int offset = 0;
        if (ver < 200) {
            return false;
        }
        try {
            int i = 0;
            while (i < 4) {
                ready[i] = File.byte_read(fileh);
                ++i;
            }
            i = 0;
            while (i < 4) {
                if (!File.read(fileh, fname[i], 129)) {
                    return false;
                }
                ++i;
            }
            i = 0;
            while (i < 4) {
                media[i] = File.byte_read(fileh);
                ++i;
            }
            i = 0;
            while (i < 4) {
                this.fdc_setdisk(i, null);
                if (ready[i] != 0) {
                    this.fdc_setdisk(i, Util.byt2str(fname[i]));
                    if (this.fdc_ready[i] != 0 && this.fdc_medias[i] >= media[i] + 1) {
                        this.fdc_setmedia(i, media[i]);
                    }
                }
                ++i;
            }
            if (ver >= 400) {
                i = 0;
                while (i < 4) {
                    this.fdc_teject[i] = File.bool_read(fileh);
                    ++i;
                }
            } else {
                int j = 0;
                while (j < this.fdc_teject.length) {
                    this.fdc_teject[j] = false;
                    ++j;
                }
            }
            i = 0;
            while (i < 4) {
                this.fdc_track[i] = File.byte_read(fileh);
                ++i;
            }
            if (!File.read(fileh, this.fdc_buffer, 8192)) {
                return false;
            }
            offset = File.word_read(fileh);
            if (offset >= 8192) {
                this.fdc_dataptr.set(null);
            } else {
                this.fdc_dataptr.set(this.fdc_buffer, offset);
            }
            i = 0;
            while (i < 4) {
                this.fdc_seekofs[i] = File.dword_read(fileh);
                ++i;
            }
            i = 0;
            while (i < 4) {
                this.fdc_secofs[i] = File.dword_read(fileh);
                ++i;
            }
            this.fdc_command = File.byte_read(fileh);
            this.fdc_status = File.byte_read(fileh);
            this.fdc_trkreg = File.byte_read(fileh);
            this.fdc_secreg = File.byte_read(fileh);
            this.fdc_datareg = File.byte_read(fileh);
            this.fdc_sidereg = File.byte_read(fileh);
            this.fdc_drvreg = File.byte_read(fileh);
            this.fdc_motor = File.byte_read(fileh);
            this.fdc_drqirq = File.byte_read(fileh);
            if (ver < 600) {
                this.fdc_drqirq |= 0x20;
            }
            this.fdc_cmdtype = File.byte_read(fileh);
            this.fdc_totalcnt = File.word_read(fileh);
            this.fdc_nowcnt = File.word_read(fileh);
            this.fdc_seekvct = File.bool_read(fileh);
            this.fdc_indexcnt = File.byte_read(fileh);
            i = 0;
            while (i < 4) {
                this.fdc_access[i] = File.byte_read(fileh);
                ++i;
            }
            this.fdc_boot = File.bool_read(fileh);
            schedule.handle(14, this, 4);
            schedule.handle(15, this, 3);
            if (ver >= 905 || ver >= 705 && ver <= 799) {
                this.fdc_wait = File.bool_read(fileh);
                schedule.handle(16, this, 1);
            } else {
                this.fdc_wait = false;
                schedule.delevent(16);
            }
            if (ver < 800) {
                this.fdc_2ddmode = 0;
                this.fdc_logidrv = 0;
                this.fdc_drvregP = this.fdc_drvreg;
                i = 0;
                while (i < 4) {
                    this.fdc_physdrv[i] = (byte)i;
                    ++i;
                }
                return true;
            }
            this.fdc_2ddmode = File.byte_read(fileh);
            this.fdc_logidrv = File.byte_read(fileh);
            this.fdc_drvregP = File.byte_read(fileh);
            i = 0;
            while (i < 4) {
                this.fdc_physdrv[i] = File.byte_read(fileh);
                ++i;
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

