/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Jcard
extends Base {
    private byte[] dicrom;
    private byte[] dicram;
    private byte[] extram_b;
    int dicrom_bank;
    boolean extrom_sel;
    boolean dicrom_en;
    boolean dicram_en;
    private byte[] extrom;

    Jcard() {
    }

    boolean init() {
        this.extram_b = null;
        this.dicrom = null;
        this.dicram = null;
        this.extrom = null;
        this.extram_b = Util.malloc(65536);
        if (this.extram_b == null) {
            return false;
        }
        this.dicrom = Util.malloc(262144);
        if (this.dicrom == null) {
            return false;
        }
        if (!File.load("DICROM.ROM", this.dicrom, 262144)) {
            return false;
        }
        this.dicram = Util.malloc(8192);
        if (this.dicram == null) {
            return false;
        }
        if (!File.load("USERDIC.DAT", this.dicram, 8192)) {
            Util.memset(this.dicram, (byte)-1, 8192);
        }
        this.extrom = Util.malloc(49152);
        if (this.extrom == null) {
            return false;
        }
        return File.load("EXTSUB.ROM", this.extrom, 49152);
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        if (this.extrom != null) {
            Util.free(this.extrom);
        }
        if (this.dicram != null) {
            File.save("USERDIC.DAT", this.dicram, 8192);
            Util.free(this.dicram);
        }
        if (this.dicrom != null) {
            Util.free(this.dicrom);
        }
        if (this.extram_b != null) {
            Util.free(this.extram_b);
        }
    }

    void reset() {
        this.dicrom_bank = 0;
        this.dicram_en = false;
        this.dicrom_en = false;
        this.extrom_sel = false;
    }

    int readb(int addr) {
        if (Jcard.vm.fm7_ver < 3) {
            return 255;
        }
        if (addr >= 32768 && addr < 40960 && this.dicram_en) {
            return this.dicram[addr - 32768] & 0xFF;
        }
        if (addr >= 57344 && addr < 61440 && this.dicrom_en) {
            addr &= 0xFFF;
            int dicrom_addr = this.dicrom_bank << 12;
            if (!this.extrom_sel) {
                return this.dicrom[addr | dicrom_addr] & 0xFF;
            }
            if (this.dicrom_bank < 32) {
                return Jcard.kanji.kanji_rom[addr | dicrom_addr] & 0xFF;
            }
            if (this.dicrom_bank < 44) {
                return this.extrom[addr | dicrom_addr - 131072] & 0xFF;
            }
            if (this.dicrom_bank < 56) {
                return 255;
            }
            if (this.dicrom_bank < 63) {
                return mainmem.basic_rom(addr | dicrom_addr - 229376);
            }
            if (addr < 3072) {
                return mainmem.basic_rom(addr | dicrom_addr - 229376);
            }
            if (addr < 3584) {
                return 0;
            }
            if (addr < 4064) {
                return Jcard.mainmem.init_rom[addr & 0x1FF | 0x1A00] & 0xFF;
            }
            if (addr == 4094) {
                return 254;
            }
            return 0;
        }
        return this.extram_b[addr] & 0xFF;
    }

    boolean writeb(int addr, int dat) {
        if (Jcard.vm.fm7_ver < 3) {
            return true;
        }
        if (addr >= 32768 && addr < 40960 && this.dicram_en) {
            this.dicram[addr - 32768] = (byte)dat;
            return true;
        }
        this.extram_b[addr] = (byte)dat;
        return true;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.byte_write(fileh, this.dicrom_bank)) {
            return false;
        }
        if (!File.bool_write(fileh, this.extrom_sel)) {
            return false;
        }
        if (!File.bool_write(fileh, this.dicrom_en)) {
            return false;
        }
        if (!File.bool_write(fileh, this.dicram_en)) {
            return false;
        }
        return File.write(fileh, this.extram_b, 65536);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 800) {
            this.dicrom_bank = 0;
            this.extrom_sel = false;
            this.dicram_en = false;
            this.dicrom_en = false;
            return true;
        }
        try {
            this.dicrom_bank = File.byte_read(fileh);
            this.extrom_sel = File.bool_read(fileh);
            this.dicrom_en = File.bool_read(fileh);
            this.dicram_en = File.bool_read(fileh);
            File.read(fileh, this.extram_b, 65536);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

