/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Mainetc
extends Base
implements EventHandler {
    boolean key_irq_flag;
    boolean key_irq_mask;
    boolean lp_irq_flag;
    private boolean lp_irq_mask;
    boolean timer_irq_flag;
    private boolean timer_irq_mask;
    boolean mfd_irq_flag;
    boolean mfd_irq_mask;
    boolean txrdy_irq_flag;
    private boolean txrdy_irq_mask;
    boolean rxrdy_irq_flag;
    private boolean rxrdy_irq_mask;
    boolean syndet_irq_flag;
    private boolean syndet_irq_mask;
    boolean opn_irq_flag;
    boolean whg_irq_flag;
    boolean thg_irq_flag;
    boolean dma_irq_flag;
    public boolean beep_flag;
    public boolean speaker_flag;
    private final int mainetc_event = 0;
    private final int mainetc_beep = 1;

    Mainetc() {
    }

    boolean init() {
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    void reset() {
        this.key_irq_flag = false;
        this.key_irq_mask = true;
        this.lp_irq_flag = false;
        this.lp_irq_mask = true;
        this.timer_irq_flag = false;
        this.timer_irq_mask = true;
        this.mfd_irq_flag = false;
        this.mfd_irq_mask = true;
        this.txrdy_irq_flag = false;
        this.txrdy_irq_mask = true;
        this.rxrdy_irq_flag = false;
        this.rxrdy_irq_mask = true;
        this.syndet_irq_flag = false;
        this.syndet_irq_mask = true;
        this.opn_irq_flag = false;
        this.whg_irq_flag = false;
        this.thg_irq_flag = false;
        this.dma_irq_flag = false;
        this.beep_flag = false;
        this.speaker_flag = false;
        schedule.setevent(0, 2034, this, 0);
        Mainetc.sysmain.sys_snd.beep_notify();
    }

    private boolean beep() {
        this.beep_flag = false;
        schedule.delevent(5);
        Mainetc.sysmain.sys_snd.beep_notify();
        return true;
    }

    @Override
    public boolean event(int callbackid) {
        if (callbackid == 1) {
            return this.beep();
        }
        this.timer_irq_flag = !this.timer_irq_mask;
        maincpu.irq();
        if (schedule.get_reload(0) == 2034) {
            schedule.setevent(0, 2035, this, 0);
        } else {
            schedule.setevent(0, 2034, this, 0);
        }
        return true;
    }

    void fdc() {
        if (this.mfd_irq_mask) {
            return;
        }
        this.mfd_irq_flag = true;
        maincpu.irq();
    }

    void lp() {
        if (this.lp_irq_mask) {
            return;
        }
        this.lp_irq_flag = true;
        maincpu.irq();
    }

    boolean readb(int addr, IntHolder dat) {
        switch (addr) {
            case 64768: {
                dat.value = (Mainetc.keyboard.key_fm7 & 0x100) != 0 ? 255 : 127;
                return true;
            }
            case 64769: {
                dat.value = Mainetc.keyboard.key_fm7 & 0xFF;
                this.key_irq_flag = false;
                maincpu.irq();
                subcpu.firq();
                return true;
            }
            case 64771: {
                int ret = 255;
                if (this.key_irq_flag && !this.key_irq_mask) {
                    ret &= 0xFFFFFFFE;
                }
                if (this.lp_irq_flag) {
                    ret &= 0xFFFFFFFD;
                    this.lp_irq_flag = false;
                }
                if (this.timer_irq_flag) {
                    ret &= 0xFFFFFFFB;
                    this.timer_irq_flag = false;
                }
                if (this.mfd_irq_flag || this.txrdy_irq_flag || this.rxrdy_irq_flag || this.syndet_irq_flag || this.dma_irq_flag || this.opn_irq_flag || this.whg_irq_flag || this.thg_irq_flag) {
                    ret &= 0xFFFFFFF7;
                }
                dat.value = ret;
                maincpu.irq();
                return true;
            }
            case 64783: {
                Mainetc.mainmem.basicrom_en = true;
                dat.value = 255;
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        switch (addr) {
            case 64770: {
                this.syndet_irq_mask = (dat & 0x80) == 0;
                this.rxrdy_irq_mask = (dat & 0x40) == 0;
                this.txrdy_irq_mask = (dat & 0x20) == 0;
                this.mfd_irq_mask = (dat & 0x10) == 0;
                this.timer_irq_mask = (dat & 4) == 0;
                this.lp_irq_mask = (dat & 2) == 0;
                this.key_irq_mask = (dat & 1) == 0;
                maincpu.irq();
                subcpu.firq();
                return true;
            }
            case 64771: {
                this.speaker_flag = (dat & 1) != 0;
                if ((dat & 0x40) != 0) {
                    this.beep_flag = true;
                    schedule.setevent(5, 205000, this, 1);
                    Mainetc.sysmain.sys_snd.beep_notify();
                } else {
                    this.beep_flag = (dat & 0x80) != 0;
                    Mainetc.sysmain.sys_snd.beep_notify();
                }
                return true;
            }
            case 64783: {
                Mainetc.mainmem.basicrom_en = false;
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.key_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.key_irq_mask)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.lp_irq_mask)) {
            return false;
        }
        if (!File.bool_write(fileh, this.timer_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.timer_irq_mask)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mfd_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.mfd_irq_mask)) {
            return false;
        }
        if (!File.bool_write(fileh, this.txrdy_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.txrdy_irq_mask)) {
            return false;
        }
        if (!File.bool_write(fileh, this.rxrdy_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.rxrdy_irq_mask)) {
            return false;
        }
        if (!File.bool_write(fileh, this.syndet_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.syndet_irq_mask)) {
            return false;
        }
        if (!File.bool_write(fileh, this.opn_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.whg_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.thg_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.dma_irq_flag)) {
            return false;
        }
        if (!File.bool_write(fileh, this.beep_flag)) {
            return false;
        }
        return File.bool_write(fileh, this.speaker_flag);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.key_irq_flag = File.bool_read(fileh);
            this.key_irq_mask = File.bool_read(fileh);
            this.lp_irq_flag = File.bool_read(fileh);
            this.lp_irq_mask = File.bool_read(fileh);
            this.timer_irq_flag = File.bool_read(fileh);
            this.timer_irq_mask = File.bool_read(fileh);
            this.mfd_irq_flag = File.bool_read(fileh);
            this.mfd_irq_mask = File.bool_read(fileh);
            this.txrdy_irq_flag = File.bool_read(fileh);
            this.txrdy_irq_mask = File.bool_read(fileh);
            this.rxrdy_irq_flag = File.bool_read(fileh);
            this.rxrdy_irq_mask = File.bool_read(fileh);
            this.syndet_irq_flag = File.bool_read(fileh);
            this.syndet_irq_mask = File.bool_read(fileh);
            this.opn_irq_flag = File.bool_read(fileh);
            this.whg_irq_flag = File.bool_read(fileh);
            if (ver >= 600) {
                this.thg_irq_flag = File.bool_read(fileh);
            }
            if (ver >= 800) {
                this.dma_irq_flag = File.bool_read(fileh);
            }
            this.beep_flag = File.bool_read(fileh);
            this.speaker_flag = File.bool_read(fileh);
            schedule.handle(0, this, 0);
            schedule.handle(5, this, 1);
            Mainetc.sysmain.sys_snd.beep_notify();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

