/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.Pointer;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;

public class Rtc
extends Base
implements EventHandler {
    private int rtc_year;
    private int rtc_month;
    private int rtc_day;
    private int rtc_week;
    private int rtc_hour;
    private int rtc_minute;
    private int rtc_second;
    private boolean rtc_24h;
    private boolean rtc_pm;
    private int rtc_leap;
    private boolean rtc_init_flag;
    private long rtc_ltime;
    private final int rtc_event = 0;
    private final int rtc_event_adjust = 1;
    private final int[] rtc_day_table = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};

    Rtc() {
    }

    boolean init() {
        this.rtc_24h = true;
        this.rtc_leap = 0;
        this.rtc_init_flag = false;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
    }

    public void reset() {
        if (!this.rtc_init_flag) {
            this.time_adjust();
            this.rtc_init_flag = true;
        }
    }

    private long time() {
        return System.currentTimeMillis();
    }

    private final tm localtime(long time) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(time);
        tm lt = new tm();
        lt.tm_year = cal.get(1);
        lt.tm_mon = cal.get(2);
        lt.tm_mday = cal.get(5);
        lt.tm_wday = cal.get(7);
        lt.tm_hour = cal.get(11);
        lt.tm_min = cal.get(12);
        lt.tm_sec = cal.get(13);
        return lt;
    }

    public void time_adjust() {
        this.time_adjust_sub();
        this.rtc_ltime = 0L;
        schedule.setevent(9, 1000, this, 1);
    }

    private boolean event_adjust() {
        if (this.rtc_ltime == 0L) {
            this.rtc_ltime = this.time();
        } else if (this.rtc_ltime != this.time()) {
            this.time_adjust_sub();
        }
        return true;
    }

    private void time_adjust_sub() {
        long ltime = this.time();
        tm now = this.localtime(ltime);
        this.rtc_year = now.tm_year % 100;
        this.rtc_month = now.tm_mon + 1;
        this.rtc_day = now.tm_mday;
        this.rtc_week = now.tm_wday;
        this.rtc_hour = now.tm_hour;
        this.rtc_minute = now.tm_min;
        this.rtc_second = now.tm_sec;
        this.rtc_pm = this.rtc_hour >= 12;
        schedule.setevent(9, 1000000, this, 0);
    }

    @Override
    public boolean event(int callbackid) {
        if (callbackid == 1) {
            return this.event_adjust();
        }
        ++this.rtc_second;
        if (this.rtc_second < 60) {
            return true;
        }
        this.rtc_second = 0;
        ++this.rtc_minute;
        if (this.rtc_minute < 60) {
            return true;
        }
        this.rtc_minute = 0;
        ++this.rtc_hour;
        if (this.rtc_24h) {
            this.rtc_pm = this.rtc_hour >= 12;
            if (this.rtc_hour < 24) {
                return true;
            }
        } else if (this.rtc_pm) {
            if (this.rtc_hour < 12) {
                return true;
            }
        } else {
            if (this.rtc_hour < 12) {
                return true;
            }
            this.rtc_hour = 0;
            this.rtc_pm = true;
            return true;
        }
        this.rtc_hour = 0;
        this.rtc_pm = false;
        ++this.rtc_week;
        if (this.rtc_week > 6) {
            this.rtc_week = 0;
        }
        ++this.rtc_day;
        if (this.rtc_day <= this.rtc_day_table[this.rtc_month]) {
            return true;
        }
        if (this.rtc_month == 2 && this.rtc_day == 29 && (this.rtc_leap == 0 ? this.rtc_year % 4 == 0 : this.rtc_year % 4 == 4 - this.rtc_leap)) {
            return true;
        }
        this.rtc_day = 1;
        ++this.rtc_month;
        if (this.rtc_month <= 12) {
            return true;
        }
        this.rtc_month = 0;
        ++this.rtc_year;
        if (this.rtc_year > 99) {
            this.rtc_year = 0;
        }
        return true;
    }

    void set(Pointer packet) {
        if (Rtc.vm.fm7_ver < 2) {
            return;
        }
        int dat = packet.v();
        ++packet.p;
        this.rtc_year = (dat >> 4) * 10;
        this.rtc_year |= dat & 0xF;
        dat = packet.v();
        ++packet.p;
        this.rtc_month = (dat >> 4) * 10;
        this.rtc_month |= dat & 0xF;
        dat = packet.v();
        ++packet.p;
        this.rtc_day = ((dat & 0x30) >> 4) * 10;
        this.rtc_day |= dat & 0xF;
        dat = packet.v();
        ++packet.p;
        this.rtc_week = dat >> 4 & 7;
        this.rtc_hour = (dat & 3) * 10;
        this.rtc_24h = (dat & 8) != 0;
        this.rtc_pm = (dat & 4) != 0;
        dat = packet.v();
        ++packet.p;
        this.rtc_hour |= dat >> 4;
        this.rtc_minute = (dat & 0xF) * 10;
        dat = packet.v();
        ++packet.p;
        this.rtc_minute |= dat >> 4;
        this.rtc_second = (dat & 0xF) * 10;
        dat = packet.v();
        ++packet.p;
        this.rtc_second |= dat >> 4;
    }

    void get(Pointer packet) {
        if (Rtc.vm.fm7_ver < 2) {
            return;
        }
        int dat = this.rtc_year / 10 << 4;
        packet.setv(dat |= this.rtc_year % 10);
        ++packet.p;
        dat = this.rtc_month / 10 << 4;
        packet.setv(dat |= this.rtc_month % 10);
        ++packet.p;
        dat = this.rtc_day / 10 << 4;
        dat |= this.rtc_day % 10;
        packet.setv(dat |= this.rtc_leap * 64);
        ++packet.p;
        dat = this.rtc_week << 4;
        dat |= this.rtc_hour / 10;
        if (this.rtc_24h) {
            dat |= 8;
        }
        if (!this.rtc_24h && this.rtc_pm) {
            dat |= 4;
        }
        packet.setv(dat);
        ++packet.p;
        dat = this.rtc_hour % 10 << 4;
        packet.setv(dat |= this.rtc_minute / 10);
        ++packet.p;
        dat = this.rtc_minute % 10 << 4;
        packet.setv(dat |= this.rtc_second / 10);
        ++packet.p;
        dat = this.rtc_second % 10 << 4;
        packet.setv(dat);
        ++packet.p;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.rtc_24h)) {
            return false;
        }
        if (!File.bool_write(fileh, this.rtc_pm)) {
            return false;
        }
        return File.byte_write(fileh, this.rtc_leap);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.rtc_24h = File.bool_read(fileh);
            this.rtc_pm = File.bool_read(fileh);
            this.rtc_leap = File.byte_read(fileh);
            this.time_adjust();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private final class tm {
        int tm_sec;
        int tm_min;
        int tm_hour;
        int tm_mday;
        int tm_mon;
        int tm_year;
        int tm_wday;

        private tm() {
        }
    }
}

