/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Cpu;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Subcpu
extends Cpu {
    Subcpu() {
        super(submem);
    }

    @Override
    boolean init() {
        return super.init();
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        super.reset();
    }

    @Override
    void reset() {
        super.reset();
    }

    void nmi() {
        if ((this.intr & 0x10) != 0) {
            this.intr |= 1;
        }
    }

    void firq() {
        this.intr = !Subcpu.mainetc.key_irq_mask ? (this.intr &= 0xFFFFFFFD) : (Subcpu.mainetc.key_irq_flag ? (this.intr |= 2) : (this.intr &= 0xFFFFFFFD));
    }

    void irq() {
        this.intr = Subcpu.subctrl.subcancel_flag ? (this.intr |= 4) : (this.intr &= 0xFFFFFFFB);
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.byte_write(fileh, this.getCc())) {
            return false;
        }
        if (!File.byte_write(fileh, this.getDp())) {
            return false;
        }
        if (!File.word_write(fileh, this.getD())) {
            return false;
        }
        if (!File.word_write(fileh, this.getX())) {
            return false;
        }
        if (!File.word_write(fileh, this.getY())) {
            return false;
        }
        if (!File.word_write(fileh, this.getU())) {
            return false;
        }
        if (!File.word_write(fileh, this.getS())) {
            return false;
        }
        if (!File.word_write(fileh, this.getPc())) {
            return false;
        }
        if (!File.word_write(fileh, this.getIntr())) {
            return false;
        }
        if (!File.word_write(fileh, this.getCycle())) {
            return false;
        }
        return File.word_write(fileh, this.getTotal());
    }

    boolean load(RandomAccessFile fileh, int ver) {
        if (ver < 200) {
            return false;
        }
        try {
            this.setCc(File.byte_read(fileh));
            this.setDp(File.byte_read(fileh));
            this.setD(File.word_read(fileh));
            this.setX(File.word_read(fileh));
            this.setY(File.word_read(fileh));
            this.setU(File.word_read(fileh));
            this.setS(File.word_read(fileh));
            this.setPc(File.word_read(fileh));
            this.setIntr(File.word_read(fileh));
            this.setCycle(File.word_read(fileh));
            this.setTotal(File.word_read(fileh));
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

