/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Aluline;
import emu.xm7.vm.Apalet;
import emu.xm7.vm.Base;
import emu.xm7.vm.Display;
import emu.xm7.vm.Dmac;
import emu.xm7.vm.Fdc;
import emu.xm7.vm.Jcard;
import emu.xm7.vm.Kanji;
import emu.xm7.vm.Keyboard;
import emu.xm7.vm.Maincpu;
import emu.xm7.vm.Mainetc;
import emu.xm7.vm.Mainmem;
import emu.xm7.vm.Mmr;
import emu.xm7.vm.Mouse;
import emu.xm7.vm.Multipag;
import emu.xm7.vm.Opn;
import emu.xm7.vm.Rtc;
import emu.xm7.vm.Schedule;
import emu.xm7.vm.Subcpu;
import emu.xm7.vm.Subctrl;
import emu.xm7.vm.Submem;
import emu.xm7.vm.Tapelp;
import emu.xm7.vm.Thg;
import emu.xm7.vm.Ttlpalet;
import emu.xm7.vm.Whg;
import java.io.IOException;
import java.io.RandomAccessFile;

public class System {
    public int fm7_ver;
    public int boot_mode;
    boolean hotreset_flag;
    public boolean reset_flag;
    int fetch_op;
    byte[] state_header = "XM7 VM STATE 905".getBytes();
    public Schedule schedule;
    public Mainmem mainmem;
    public Submem submem;
    public Mmr mmr;
    public Maincpu maincpu;
    public Subcpu subcpu;
    public Display display;
    public Ttlpalet ttlpalet;
    public Subctrl subctrl;
    public Keyboard keyboard;
    public Fdc fdc;
    public Mainetc mainetc;
    public Multipag multipag;
    public Kanji kanji;
    public Tapelp tapelp;
    public Opn opn;
    public Whg whg;
    public Thg thg;
    public Aluline aluline;
    public Apalet apalet;
    public Rtc rtc;
    public Jcard jcard;
    public Dmac dmac;
    public Mouse mouse;

    public System() {
        Base.vm = this;
        Base.schedule = this.schedule = new Schedule();
        Base.mainmem = this.mainmem = new Mainmem();
        Base.submem = this.submem = new Submem();
        Base.mmr = this.mmr = new Mmr();
        Base.maincpu = this.maincpu = new Maincpu();
        Base.subcpu = this.subcpu = new Subcpu();
        Base.display = this.display = new Display();
        Base.ttlpalet = this.ttlpalet = new Ttlpalet();
        Base.subctrl = this.subctrl = new Subctrl();
        Base.keyboard = this.keyboard = new Keyboard();
        Base.fdc = this.fdc = new Fdc();
        Base.mainetc = this.mainetc = new Mainetc();
        Base.multipag = this.multipag = new Multipag();
        Base.kanji = this.kanji = new Kanji();
        Base.tapelp = this.tapelp = new Tapelp();
        Base.opn = this.opn = new Opn();
        Base.whg = this.whg = new Whg();
        Base.thg = this.thg = new Thg();
        Base.aluline = this.aluline = new Aluline();
        Base.apalet = this.apalet = new Apalet();
        Base.rtc = this.rtc = new Rtc();
        Base.jcard = this.jcard = new Jcard();
        Base.dmac = this.dmac = new Dmac();
        Base.mouse = this.mouse = new Mouse();
    }

    public boolean init() {
        this.fm7_ver = 3;
        this.boot_mode = 0;
        this.hotreset_flag = false;
        this.reset_flag = false;
        if (!this.schedule.init()) {
            return false;
        }
        if (!this.mmr.init()) {
            return false;
        }
        if (!this.mainmem.init()) {
            return false;
        }
        if (!this.submem.init()) {
            return false;
        }
        if (!this.maincpu.init()) {
            return false;
        }
        if (!this.subcpu.init()) {
            return false;
        }
        if (!this.display.init()) {
            return false;
        }
        if (!this.ttlpalet.init()) {
            return false;
        }
        if (!this.subctrl.init()) {
            return false;
        }
        if (!this.keyboard.init()) {
            return false;
        }
        if (!this.fdc.init()) {
            return false;
        }
        if (!this.mainetc.init()) {
            return false;
        }
        if (!this.multipag.init()) {
            return false;
        }
        if (!this.kanji.init()) {
            return false;
        }
        if (!this.tapelp.init()) {
            return false;
        }
        if (!this.opn.init()) {
            return false;
        }
        if (!this.whg.init()) {
            return false;
        }
        if (!this.thg.init()) {
            return false;
        }
        if (!this.aluline.init()) {
            return false;
        }
        if (!this.apalet.init()) {
            return false;
        }
        if (!this.rtc.init()) {
            return false;
        }
        if (!this.jcard.init()) {
            return false;
        }
        if (!this.dmac.init()) {
            return false;
        }
        return this.mouse.init();
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void cleanup() {
        this.mouse.cleanup();
        this.dmac.cleanup();
        this.jcard.cleanup();
        this.rtc.cleanup();
        this.apalet.cleanup();
        this.aluline.cleanup();
        this.opn.cleanup();
        this.whg.cleanup();
        this.thg.cleanup();
        this.tapelp.cleanup();
        this.kanji.cleanup();
        this.multipag.cleanup();
        this.mainetc.cleanup();
        this.fdc.cleanup();
        this.keyboard.cleanup();
        this.subctrl.cleanup();
        this.ttlpalet.cleanup();
        this.display.cleanup();
        this.subcpu.cleanup();
        this.maincpu.cleanup();
        this.submem.cleanup();
        this.mainmem.cleanup();
        this.mmr.cleanup();
        this.schedule.cleanup();
    }

    public void reset() {
        this.schedule.reset();
        this.mmr.reset();
        this.display.reset();
        this.ttlpalet.reset();
        this.subctrl.reset();
        this.keyboard.reset();
        this.fdc.reset();
        this.mainetc.reset();
        this.multipag.reset();
        this.kanji.reset();
        this.tapelp.reset();
        this.opn.reset();
        this.whg.reset();
        this.thg.reset();
        this.aluline.reset();
        this.apalet.reset();
        this.rtc.reset();
        this.jcard.reset();
        this.dmac.reset();
        this.mouse.reset();
        this.mainmem.reset();
        this.submem.reset();
        this.maincpu.reset();
        this.subcpu.reset();
        this.display.setpointer(false);
        Base.sysmain.sys_dsp.display_notify();
        this.reset_flag = true;
        this.fetch_op = 0;
    }

    public void hotreset() {
        if (this.mmr.twr_flag) {
            this.boot_mode = 1;
        }
        this.reset();
        this.keyboard.break_flag = true;
        this.maincpu.firq();
        this.hotreset_flag = true;
    }

    public boolean save(String filename) {
        RandomAccessFile fileh = File.open(filename, 2, true);
        if (fileh == null) {
            return false;
        }
        boolean flag = true;
        byte[] state_header_b = new byte[this.state_header.length];
        int i = 0;
        while (i < this.state_header.length) {
            state_header_b[i] = this.state_header[i];
            ++i;
        }
        if (!File.write(fileh, state_header_b, 16)) {
            flag = false;
        }
        if (!File.word_write(fileh, this.fm7_ver)) {
            return false;
        }
        if (!File.word_write(fileh, this.boot_mode)) {
            return false;
        }
        if (!this.mainmem.save(fileh)) {
            flag = false;
        }
        if (!this.submem.save(fileh)) {
            flag = false;
        }
        if (!this.maincpu.save(fileh)) {
            flag = false;
        }
        if (!this.subcpu.save(fileh)) {
            flag = false;
        }
        if (!this.schedule.save(fileh)) {
            flag = false;
        }
        if (!this.display.save(fileh)) {
            flag = false;
        }
        if (!this.ttlpalet.save(fileh)) {
            flag = false;
        }
        if (!this.subctrl.save(fileh)) {
            flag = false;
        }
        if (!this.keyboard.save(fileh)) {
            flag = false;
        }
        if (!this.fdc.save(fileh)) {
            flag = false;
        }
        if (!this.mainetc.save(fileh)) {
            flag = false;
        }
        if (!this.multipag.save(fileh)) {
            flag = false;
        }
        if (!this.kanji.save(fileh)) {
            flag = false;
        }
        if (!this.tapelp.save(fileh)) {
            flag = false;
        }
        if (!this.opn.save(fileh)) {
            flag = false;
        }
        if (!this.mmr.save(fileh)) {
            flag = false;
        }
        if (!this.aluline.save(fileh)) {
            flag = false;
        }
        if (!this.rtc.save(fileh)) {
            flag = false;
        }
        if (!this.apalet.save(fileh)) {
            flag = false;
        }
        if (!this.whg.save(fileh)) {
            flag = false;
        }
        if (!this.thg.save(fileh)) {
            flag = false;
        }
        if (!this.jcard.save(fileh)) {
            flag = false;
        }
        if (!this.dmac.save(fileh)) {
            flag = false;
        }
        if (!this.mouse.save(fileh)) {
            flag = false;
        }
        File.close(fileh);
        return flag;
    }

    public int load(String filename) {
        boolean flag;
        block44: {
            int ver;
            int[] header = new int[16];
            byte[] cmpheader = "XM7 VM STATE ".getBytes();
            RandomAccessFile fileh = File.open(filename, 1);
            if (fileh == null) {
                return -1;
            }
            flag = true;
            boolean old_scheduler = false;
            if (!File.read(fileh, header, 16)) {
                flag = false;
            } else {
                int i = 0;
                while (i < 13) {
                    if (header[i] != cmpheader[i]) {
                        flag = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!flag) {
                File.close(fileh);
                return -2;
            }
            if (header[13] != 32) {
                ver = (header[13] - 48) * 100 + (header[14] - 48) * 10 + (header[15] - 48);
            } else {
                ver = header[15];
                ver -= 48;
                ver *= 100;
            }
            if (ver < 200) {
                File.close(fileh);
                return -3;
            }
            if (ver > (this.state_header[13] - 48) * 100 + (this.state_header[14] - 48) * 10 + (this.state_header[15] - 48)) {
                File.close(fileh);
                return -3;
            }
            int filesize = File.getsize(fileh);
            if (ver <= 500) {
                old_scheduler = true;
            } else if (filesize == 454758 || filesize == 1241190 || filesize == 258030) {
                old_scheduler = true;
            }
            try {
                try {
                    this.fm7_ver = File.word_read(fileh);
                    this.boot_mode = File.word_read(fileh);
                    if (!this.mainmem.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.submem.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.maincpu.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.subcpu.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.schedule.load(fileh, ver, old_scheduler)) {
                        flag = false;
                    }
                    if (!this.display.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.ttlpalet.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.subctrl.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.keyboard.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.fdc.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.mainetc.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.multipag.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.kanji.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.tapelp.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.opn.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.mmr.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.aluline.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.rtc.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.apalet.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.whg.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.thg.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.jcard.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.dmac.load(fileh, ver)) {
                        flag = false;
                    }
                    if (!this.mouse.load(fileh, ver)) {
                        flag = false;
                    }
                }
                catch (IOException e) {
                    flag = false;
                    File.close(fileh);
                    break block44;
                }
            }
            catch (Throwable throwable) {
                File.close(fileh);
                throw throwable;
            }
            File.close(fileh);
        }
        if (this.subctrl.mode400l && !this.display.fix_vram_address()) {
            flag = false;
        }
        Base.sysmain.sys_dsp.display_notify();
        this.schedule.speed_ratio = 10000;
        if (!flag) {
            return 0;
        }
        return 1;
    }
}

