/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.IniFile;
import emu.xm7.sys.Sys_kbd;
import emu.xm7.sys.Sys_main;
import emu.xm7.sys.Sys_util;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Hashtable;
import javax.swing.AbstractCellEditor;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.BevelBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;

public class Sys_cfg {
    private IniFile xm7ini;
    String DiskImageDir;
    String TapeImageDir;
    String StateFileDir;
    String BMPFileDir;
    String WAVFileDir;
    int Version;
    private boolean CycleSteal;
    private int MainSpeed;
    private int MMRSpeed;
    private int FastMMRSpeed;
    private int SubSpeed;
    private boolean TapeFullSpeed;
    private boolean TapeFullSpeedMode;
    private boolean FDDWait;
    private boolean FullSpeed;
    private boolean AutoSpeedAdjust;
    private int SampleRate;
    private int SoundBuffer;
    private int StereoOut;
    private int BeepFreq;
    private boolean TapeMon;
    private boolean FDDSound;
    private boolean UseArrowFor10Key;
    private boolean Arrow8Dir;
    private boolean RealTimeKeyScan;
    private int[] KeyMap;
    private boolean FullScan;
    private boolean PrinterEnable;
    private boolean UseOsFont;
    private boolean OutputKanji;
    private boolean OPNEnable;
    private boolean WHGEnable;
    private boolean THGEnable;
    private boolean MouseEmulation;
    private int MousePort;
    private boolean DigitizeEnable;
    private boolean ExtRAMEnable;
    private Sys_main sysmain;
    private emu.xm7.vm.System vm;

    Sys_cfg(Sys_main sysmain, emu.xm7.vm.System vm) {
        this.sysmain = sysmain;
        this.vm = vm;
        this.xm7ini = new IniFile("XM7.INI");
        this.xm7ini.init();
    }

    void load() {
        String CurrentDirectory = new File(".").getAbsoluteFile().getParentFile().toString();
        this.xm7ini.load();
        this.DiskImageDir = this.xm7ini.getString("General", "DiskImageDir", CurrentDirectory);
        this.TapeImageDir = this.xm7ini.getString("General", "TapeImageDir", CurrentDirectory);
        this.StateFileDir = this.xm7ini.getString("General", "StateFileDir", CurrentDirectory);
        this.BMPFileDir = this.xm7ini.getString("General", "BMPFileDir", CurrentDirectory);
        this.WAVFileDir = this.xm7ini.getString("General", "WAVFileDir", CurrentDirectory);
        this.Version = this.xm7ini.getInt("General", "Version", 3);
        this.CycleSteal = this.xm7ini.getBool("General", "CycleSteal", true);
        this.MainSpeed = this.xm7ini.getInt("General", "MainSpeed", 1799);
        this.MMRSpeed = this.xm7ini.getInt("General", "MMRSpeed", 1565);
        this.FastMMRSpeed = this.xm7ini.getInt("General", "FastMMRSpeed", 2016);
        this.SubSpeed = this.xm7ini.getInt("General", "SubSpeed", 1998);
        this.TapeFullSpeed = this.xm7ini.getBool("General", "TapeFullSpeed", true);
        this.TapeFullSpeedMode = this.xm7ini.getBool("General", "TapeFullSpeedMode", false);
        this.FDDWait = this.xm7ini.getBool("General", "FDDWait", false);
        this.FullSpeed = this.xm7ini.getBool("General", "FullSpeed", false);
        this.AutoSpeedAdjust = this.xm7ini.getBool("General", "AutoSpeedAdjust", false);
        this.SampleRate = this.xm7ini.getInt("Sound", "SampleRate", 44100);
        this.SoundBuffer = this.xm7ini.getInt("Sound", "SoundBuffer", 100);
        this.StereoOut = this.xm7ini.getInt("Sound", "StereoOut", 0);
        this.BeepFreq = this.xm7ini.getInt("Sound", "BeepFreq", 1200);
        this.TapeMon = this.xm7ini.getBool("Sound", "TapeMon", false);
        this.FDDSound = this.xm7ini.getBool("Sound", "FDDSound", false);
        this.UseArrowFor10Key = this.xm7ini.getBool("Keyboard", "UseArrowFor10Key", false);
        this.Arrow8Dir = this.xm7ini.getBool("Keyboard", "Arrow8Dir", true);
        this.RealTimeKeyScan = this.xm7ini.getBool("Keyboard", "RealTimeKeyScan", false);
        this.KeyMap = new int[Sys_kbd.KbdPageFM77AV.length];
        int i = 1;
        while (i < this.KeyMap.length) {
            String IniKey = "JavaKey" + (i < 10 ? "0" + i : Integer.toString(i));
            this.KeyMap[i] = this.xm7ini.getInt("Keyboard", IniKey, this.sysmain.sys_kbd.KeyMap[i]);
            ++i;
        }
        this.FullScan = this.xm7ini.getBool("Screen", "FullScan", false);
        this.PrinterEnable = this.xm7ini.getBool("Printer", "PrinterEnable", true);
        this.UseOsFont = this.xm7ini.getBool("Printer", "UseOsFont", false);
        this.OutputKanji = this.xm7ini.getBool("Printer", "OutputKanji", false);
        this.OPNEnable = this.xm7ini.getBool("Option", "OPNEnable", true);
        this.WHGEnable = this.xm7ini.getBool("Option", "WHGEnable", true);
        this.THGEnable = this.xm7ini.getBool("Option", "THGEnable", true);
        this.MouseEmulation = this.xm7ini.getBool("Option", "MouseEmulation", false);
        this.MousePort = this.xm7ini.getInt("Option", "MousePort", 1);
        this.DigitizeEnable = this.xm7ini.getBool("Option", "DigitizeEnable", true);
        this.ExtRAMEnable = this.xm7ini.getBool("Option", "ExtRAMEnable", false);
    }

    void save() {
        this.xm7ini.setString("General", "DiskImageDir", this.DiskImageDir);
        this.xm7ini.setString("General", "TapeImageDir", this.TapeImageDir);
        this.xm7ini.setString("General", "StateFileDir", this.StateFileDir);
        this.xm7ini.setString("General", "BMPFileDir", this.BMPFileDir);
        this.xm7ini.setString("General", "WAVFileDir", this.WAVFileDir);
        this.xm7ini.setInt("General", "Version", this.Version);
        this.xm7ini.setBool("General", "CycleSteal", this.CycleSteal);
        this.xm7ini.setInt("General", "MainSpeed", this.MainSpeed);
        this.xm7ini.setInt("General", "MMRSpeed", this.MMRSpeed);
        this.xm7ini.setInt("General", "FastMMRSpeed", this.FastMMRSpeed);
        this.xm7ini.setInt("General", "SubSpeed", this.SubSpeed);
        this.xm7ini.setBool("General", "TapeFullSpeed", this.TapeFullSpeed);
        this.xm7ini.setBool("General", "TapeFullSpeedMode", this.TapeFullSpeedMode);
        this.xm7ini.setBool("General", "FDDWait", this.FDDWait);
        this.xm7ini.setBool("General", "FullSpeed", this.FullSpeed);
        this.xm7ini.setBool("General", "AutoSpeedAdjust", this.AutoSpeedAdjust);
        this.xm7ini.setInt("Sound", "SampleRate", this.SampleRate);
        this.xm7ini.setInt("Sound", "SoundBuffer", this.SoundBuffer);
        this.xm7ini.setInt("Sound", "StereoOut", this.StereoOut);
        this.xm7ini.setInt("Sound", "BeepFreq", this.BeepFreq);
        this.xm7ini.setBool("Sound", "TapeMon", this.TapeMon);
        this.xm7ini.setBool("Sound", "FDDSound", this.FDDSound);
        this.xm7ini.setBool("Keyboard", "UseArrowFor10Key", this.UseArrowFor10Key);
        this.xm7ini.setBool("Keyboard", "Arrow8Dir", this.Arrow8Dir);
        this.xm7ini.setBool("Keyboard", "RealTimeKeyScan", this.RealTimeKeyScan);
        int i = 1;
        while (i < this.KeyMap.length) {
            String IniKey = "JavaKey" + (i < 10 ? "0" + i : Integer.toString(i));
            this.xm7ini.setInt("Keyboard", IniKey, this.KeyMap[i]);
            ++i;
        }
        this.xm7ini.setBool("Screen", "FullScan", this.FullScan);
        this.xm7ini.setBool("Printer", "PrinterEnable", this.PrinterEnable);
        this.xm7ini.setBool("Printer", "UseOsFont", this.UseOsFont);
        this.xm7ini.setBool("Printer", "OutputKanji", this.OutputKanji);
        this.xm7ini.setBool("Option", "OPNEnable", this.OPNEnable);
        this.xm7ini.setBool("Option", "WHGEnable", this.WHGEnable);
        this.xm7ini.setBool("Option", "THGEnable", this.THGEnable);
        this.xm7ini.setBool("Option", "MouseEmulation", this.MouseEmulation);
        this.xm7ini.setInt("Option", "MousePort", this.MousePort);
        this.xm7ini.setBool("Option", "DigitizeEnable", this.DigitizeEnable);
        this.xm7ini.setBool("Option", "ExtRAMEnable", this.ExtRAMEnable);
        this.xm7ini.save();
    }

    void apply() {
        int ver = this.vm.fm7_ver;
        this.vm.fm7_ver = this.Version;
        this.vm.schedule.cycle_steal = this.CycleSteal;
        this.vm.schedule.main_speed = this.MainSpeed * 10;
        this.vm.schedule.mmr_speed = this.MMRSpeed * 10;
        this.vm.schedule.fmmr_speed = this.FastMMRSpeed * 10;
        this.vm.schedule.sub_speed = this.SubSpeed * 10;
        this.sysmain.sys_sch.bTapeFullSpeed = this.TapeFullSpeed;
        this.sysmain.sys_sch.bFullSpeed = this.FullSpeed;
        this.sysmain.sys_sch.bAutoSpeedAdjust = this.AutoSpeedAdjust;
        this.vm.fdc.fdc_waitmode = this.FDDWait;
        this.sysmain.sys_sch.bTapeModeType = this.TapeFullSpeedMode;
        this.sysmain.sys_snd.nSampleRate = this.SampleRate;
        this.sysmain.sys_snd.nSoundBuffer = this.SoundBuffer;
        this.sysmain.sys_snd.nBeepFreq = this.BeepFreq;
        this.sysmain.sys_snd.nStereoOut = this.StereoOut;
        this.sysmain.sys_snd.bTapeMon = this.TapeMon;
        this.vm.tapelp.tape_monitor = this.TapeMon;
        this.vm.fdc.fdc_sound = this.FDDSound;
        this.vm.tapelp.tape_sound = this.FDDSound;
        this.sysmain.sys_snd.ApplySnd();
        this.sysmain.sys_kbd.bKbdReal = this.RealTimeKeyScan;
        this.sysmain.sys_kbd.bTenCursor = this.UseArrowFor10Key;
        this.sysmain.sys_kbd.bArrow8Dir = this.Arrow8Dir;
        System.arraycopy(this.KeyMap, 0, this.sysmain.sys_kbd.KeyMap, 0, this.KeyMap.length);
        this.sysmain.sys_kbd.setCvtKeyMap();
        this.sysmain.sys_dsp.setFullScan(this.FullScan);
        this.sysmain.sys_dsp.display_notify();
        this.vm.tapelp.lp_use = this.PrinterEnable;
        this.sysmain.sys_lpr.use_os_font = this.UseOsFont;
        this.sysmain.sys_lpr.output_kanji = this.OutputKanji;
        this.vm.opn.opn_enable = this.OPNEnable;
        this.vm.whg.whg_enable = this.WHGEnable;
        this.vm.thg.thg_enable = this.THGEnable;
        this.vm.keyboard.digitize_enable = this.DigitizeEnable;
        this.vm.mmr.mmr_extram = this.ExtRAMEnable;
        this.vm.mouse.mos_capture = this.MouseEmulation;
        this.vm.mouse.mos_port = this.MousePort;
        switch (this.vm.fm7_ver) {
            case 1: {
                this.sysmain.setWindowIcon("emu/xm7/sys/Tamori.gif");
                break;
            }
            case 2: {
                this.sysmain.setWindowIcon("emu/xm7/sys/APP_AV.gif");
                break;
            }
            case 3: {
                this.sysmain.setWindowIcon("emu/xm7/sys/APP_EX.gif");
                break;
            }
        }
        if (ver != this.Version) {
            this.vm.reset();
        }
    }

    void openGeneralDialog(Frame frame) {
        GeneralDialog dlg = new GeneralDialog(frame);
        dlg.open();
    }

    void openSoundDialog(Frame frame) {
        SoundDialog dlg = new SoundDialog(frame);
        dlg.open();
    }

    void openKeyboardDialog(Frame frame) {
        KeyboardDialog dlg = new KeyboardDialog(frame);
        dlg.open();
    }

    void openScreenDialog(Frame frame) {
        ScreenDialog dlg = new ScreenDialog(frame);
        dlg.open();
    }

    void openPrinterDialog(Frame frame) {
        PrinterDialog dlg = new PrinterDialog(frame);
        dlg.open();
    }

    void openOptionDialog(Frame frame) {
        OptionDialog dlg = new OptionDialog(frame);
        dlg.open();
    }

    private abstract class BaseDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        JPanel pnlBody;
        JPanel pnlFoot;
        final GridBagLayout layout;
        final GridBagConstraints cons;
        final RaisedButton btnOk;
        final RaisedButton btnCancel;

        BaseDialog(Frame frame, String Message) {
            super(frame, Message, true);
            this.pnlBody = new JPanel();
            this.pnlFoot = new JPanel();
            this.layout = new GridBagLayout();
            this.cons = new GridBagConstraints();
            this.btnOk = new RaisedButton("\u3000 \uff2f\uff2b\u3000 ");
            this.btnCancel = new RaisedButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.pnlBody, "North");
            this.getContentPane().add((Component)this.pnlFoot, "South");
            this.pnlBody.setLayout(this.layout);
            this.pnlFoot.setLayout(new FlowLayout());
            this.pnlFoot.add(this.btnOk);
            this.pnlFoot.add(this.btnCancel);
            this.btnOk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ((Sys_cfg)((BaseDialog)BaseDialog.this).Sys_cfg.this).sysmain.sys_sch.SuspendVM();
                    ((Sys_cfg)((BaseDialog)BaseDialog.this).Sys_cfg.this).sysmain.sys_snd.StopSnd();
                    BaseDialog.this.submit();
                    Sys_cfg.this.save();
                    Sys_cfg.this.apply();
                    BaseDialog.this.dispose();
                    ((Sys_cfg)((BaseDialog)BaseDialog.this).Sys_cfg.this).sysmain.sys_snd.PlaySnd();
                    ((Sys_cfg)((BaseDialog)BaseDialog.this).Sys_cfg.this).sysmain.sys_sch.ReleaseVM();
                }
            });
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BaseDialog.this.dispose();
                }
            });
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    BaseDialog.this.dispose();
                }
            });
        }

        void open() {
            this.make();
            this.reset();
            this.setResizable(false);
            this.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setLocation((d.width - this.getWidth()) / 2, (d.height - this.getHeight()) / 2);
            this.setVisible(true);
        }

        void addComponent(Component item, int gx, int gy, int gw, int gh) {
            this.cons.anchor = 17;
            this.cons.insets = new Insets(0, 10, 0, 0);
            this.cons.gridx = gx;
            this.cons.gridy = gy;
            this.cons.gridwidth = gw;
            this.cons.gridheight = gh;
            this.layout.setConstraints(item, this.cons);
            this.pnlBody.add(item);
        }

        abstract void make();

        abstract void reset();

        abstract void submit();
    }

    private class GeneralDialog
    extends BaseDialog
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = 1L;
        JLabel lblModel;
        ButtonGroup grpModel;
        JRadioButton[] chkVersion;
        JLabel lblMode;
        ButtonGroup grpMode;
        JRadioButton[] chkCycleSteal;
        JLabel lblSpeed;
        JComboBox choSpeed;
        JTextField txtSpeed;
        JLabel lblCycle;
        JButton btnDefault;
        JCheckBox chkTapeFullSpeed;
        JCheckBox chkTapeFullSpeedMode;
        JCheckBox chkFDDWait;
        JCheckBox chkFullSpeed;
        JCheckBox chkAutoSpeedAdjust;
        int curSpeed;

        GeneralDialog(Frame frame) {
            super(frame, "\u52d5\u4f5c\u8a2d\u5b9a\uff08\u5168\u822c\uff09");
            this.chkVersion = new JRadioButton[3];
            this.chkCycleSteal = new JRadioButton[2];
            this.lblModel = new JLabel("\u52d5\u4f5c\u6a5f\u7a2e", 0);
            this.grpModel = new ButtonGroup();
            this.chkVersion[0] = new JRadioButton("FM-7", false);
            this.chkVersion[1] = new JRadioButton("FM77AV", false);
            this.chkVersion[2] = new JRadioButton("FM77AV40EX", false);
            this.grpModel.add(this.chkVersion[0]);
            this.grpModel.add(this.chkVersion[1]);
            this.grpModel.add(this.chkVersion[2]);
            this.lblMode = new JLabel("\u52d5\u4f5c\u30e2\u30fc\u30c9", 0);
            this.grpMode = new ButtonGroup();
            this.chkCycleSteal[0] = new JRadioButton("\u9ad8\u901f", false);
            this.chkCycleSteal[1] = new JRadioButton("\u4f4e\u901f", false);
            this.grpMode.add(this.chkCycleSteal[0]);
            this.grpMode.add(this.chkCycleSteal[1]);
            this.lblSpeed = new JLabel("\u52d5\u4f5c\u901f\u5ea6", 0);
            this.choSpeed = new JComboBox();
            this.txtSpeed = new JTextField();
            this.lblCycle = new JLabel("\u30b5\u30a4\u30af\u30eb/ms", 0);
            this.btnDefault = new JButton("Default");
            this.chkTapeFullSpeed = new JCheckBox("\u30c6\u30fc\u30d7\u30e2\u30fc\u30bf\u30aa\u30f3\u6642\u306f\u30d5\u30eb\u30b9\u30d4\u30fc\u30c9\u52d5\u4f5c", false);
            this.chkTapeFullSpeedMode = new JCheckBox("\u30c6\u30fc\u30d7\u30e2\u30fc\u30bf\u30aa\u30f3\u6642\u306e\u52d5\u4f5c\u3092\u901f\u5ea6\u8abf\u6574\u7701\u7565\u306b\u3059\u308b", false);
            this.chkFDDWait = new JCheckBox("\u30d5\u30ed\u30c3\u30d4\u30fc\u30a2\u30af\u30bb\u30b9\u6642\u306b\u30a6\u30a7\u30a4\u30c8\u3092\u633f\u5165\u3059\u308b", false);
            this.chkFullSpeed = new JCheckBox("\u5168\u529b\u99c6\u52d5", false);
            this.chkAutoSpeedAdjust = new JCheckBox("\u81ea\u52d5\u901f\u5ea6\u8abf\u6574", false);
            this.curSpeed = 0;
            this.choSpeed.addItem("\u30e1\u30a4\u30f3\uff23\uff30\uff35");
            this.choSpeed.addItem("\uff2d\uff2d\uff32\u4f7f\u7528\u6642");
            this.choSpeed.addItem("\uff2d\uff2d\uff32\u9ad8\u901f\u30e2\u30fc\u30c9\u6642");
            this.choSpeed.addItem("\u30b5\u30d6\uff23\uff30\uff35");
        }

        @Override
        void make() {
            this.addComponent(this.lblModel, 0, 0, 1, 1);
            this.addComponent(this.chkVersion[0], 0, 1, 2, 1);
            this.addComponent(this.chkVersion[1], 0, 2, 2, 1);
            this.addComponent(this.chkVersion[2], 0, 3, 2, 1);
            this.addComponent(this.lblMode, 2, 0, 1, 1);
            this.addComponent(this.chkCycleSteal[0], 2, 1, 2, 1);
            this.addComponent(this.chkCycleSteal[1], 2, 2, 2, 1);
            this.addComponent(this.lblSpeed, 0, 4, 1, 1);
            this.addComponent(this.choSpeed, 0, 5, 1, 1);
            this.addComponent(this.txtSpeed, 1, 5, 1, 1);
            this.addComponent(this.lblCycle, 2, 5, 1, 1);
            this.addComponent(this.btnDefault, 3, 5, 1, 1);
            this.addComponent(this.chkTapeFullSpeed, 0, 6, 4, 1);
            this.addComponent(this.chkTapeFullSpeedMode, 0, 7, 4, 1);
            this.addComponent(this.chkFDDWait, 0, 8, 4, 1);
            this.addComponent(this.chkFullSpeed, 0, 9, 2, 1);
            this.addComponent(this.chkAutoSpeedAdjust, 2, 9, 2, 1);
            this.chkTapeFullSpeed.addItemListener(this);
            this.choSpeed.addItemListener(this);
            this.btnDefault.addActionListener(this);
        }

        @Override
        void reset() {
            int i = 0;
            while (i < this.chkVersion.length) {
                if (Sys_cfg.this.Version == i + 1) {
                    this.chkVersion[i].setSelected(Sys_cfg.this.Version == i + 1);
                }
                ++i;
            }
            this.chkCycleSteal[0].setSelected(Sys_cfg.this.CycleSteal);
            this.chkCycleSteal[1].setSelected(!Sys_cfg.this.CycleSteal);
            this.txtSpeed.setText(Integer.toString(Sys_cfg.this.MainSpeed));
            this.curSpeed = 0;
            this.chkTapeFullSpeed.setSelected(Sys_cfg.this.TapeFullSpeed);
            this.chkTapeFullSpeedMode.setSelected(Sys_cfg.this.TapeFullSpeedMode);
            this.chkFDDWait.setSelected(Sys_cfg.this.FDDWait);
            this.chkFullSpeed.setSelected(Sys_cfg.this.FullSpeed);
            this.chkAutoSpeedAdjust.setSelected(Sys_cfg.this.AutoSpeedAdjust);
            this.chkTapeFullSpeedMode.setEnabled(this.chkTapeFullSpeed.isSelected());
        }

        @Override
        void submit() {
            int i = 0;
            while (i < this.chkVersion.length) {
                if (this.chkVersion[i].isSelected()) {
                    Sys_cfg.this.Version = i + 1;
                }
                ++i;
            }
            Sys_cfg.this.CycleSteal = false;
            if (this.chkCycleSteal[0].isSelected()) {
                Sys_cfg.this.CycleSteal = true;
            }
            try {
                int tmp = Integer.parseInt(this.txtSpeed.getText());
                switch (this.curSpeed) {
                    case 0: {
                        Sys_cfg.this.MainSpeed = tmp;
                        break;
                    }
                    case 1: {
                        Sys_cfg.this.MMRSpeed = tmp;
                        break;
                    }
                    case 2: {
                        Sys_cfg.this.FastMMRSpeed = tmp;
                        break;
                    }
                    case 3: {
                        Sys_cfg.this.SubSpeed = tmp;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Sys_cfg.this.TapeFullSpeed = this.chkTapeFullSpeed.isSelected();
            Sys_cfg.this.TapeFullSpeedMode = this.chkTapeFullSpeedMode.isSelected();
            Sys_cfg.this.FDDWait = this.chkFDDWait.isSelected();
            Sys_cfg.this.FullSpeed = this.chkFullSpeed.isSelected();
            Sys_cfg.this.AutoSpeedAdjust = this.chkAutoSpeedAdjust.isSelected();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.btnDefault) {
                Sys_cfg.this.MainSpeed = 1799;
                Sys_cfg.this.MMRSpeed = 1565;
                Sys_cfg.this.FastMMRSpeed = 2016;
                Sys_cfg.this.SubSpeed = 1998;
                this.txtSpeed.setText(Integer.toString(Sys_cfg.this.MainSpeed));
                this.curSpeed = 0;
            }
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            int tmp = 0;
            if (e.getSource() == this.choSpeed) {
                JComboBox jcomb = (JComboBox)e.getItemSelectable();
                try {
                    tmp = Integer.parseInt(this.txtSpeed.getText());
                    switch (this.curSpeed) {
                        case 0: {
                            Sys_cfg.this.MainSpeed = tmp;
                            break;
                        }
                        case 1: {
                            Sys_cfg.this.MMRSpeed = tmp;
                            break;
                        }
                        case 2: {
                            Sys_cfg.this.FastMMRSpeed = tmp;
                            break;
                        }
                        case 3: {
                            Sys_cfg.this.SubSpeed = tmp;
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                switch (jcomb.getSelectedIndex()) {
                    case 0: {
                        this.txtSpeed.setText(Integer.toString(Sys_cfg.this.MainSpeed));
                        break;
                    }
                    case 1: {
                        this.txtSpeed.setText(Integer.toString(Sys_cfg.this.MMRSpeed));
                        break;
                    }
                    case 2: {
                        this.txtSpeed.setText(Integer.toString(Sys_cfg.this.FastMMRSpeed));
                        break;
                    }
                    case 3: {
                        this.txtSpeed.setText(Integer.toString(Sys_cfg.this.SubSpeed));
                    }
                }
                this.curSpeed = jcomb.getSelectedIndex();
            } else if (e.getSource() == this.chkTapeFullSpeed) {
                this.chkTapeFullSpeedMode.setEnabled(this.chkTapeFullSpeed.isSelected());
            }
        }
    }

    private class KeyboardDialog
    extends BaseDialog
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        String[] columnNames;
        int[] columnSize;
        Hashtable<Integer, String> vkCvtTbl;
        JTable keyTable;
        KeyMapTableModel model;
        JScrollPane keyTablePane;
        String[][] rowData;
        JButton btnDefault;
        JCheckBox chkUseArrowFor10Key;
        JCheckBox chkArrow8Dir;
        JCheckBox chkRealTimeKeyScan;

        KeyboardDialog(Frame frame) {
            super(frame, "\u52d5\u4f5c\u8a2d\u5b9a\uff08\u30ad\u30fc\u30dc\u30fc\u30c9\uff09");
            this.columnNames = new String[]{"No.", "\u82f1\u3000\u6570", "\u304b\u3000\u306a", "\u30ad\u30fc\u30b3\u30fc\u30c9"};
            this.columnSize = new int[]{20, 50, 50, 200};
            this.vkCvtTbl = new Hashtable();
            this.rowData = new String[Sys_kbd.KbdPageFM77AV.length / 2][4];
            this.model = new KeyMapTableModel();
            this.keyTable = new JTable(this.model);
            int i = 0;
            while (i < this.columnSize.length) {
                this.keyTable.getColumnModel().getColumn(i).setPreferredWidth(this.columnSize[i]);
                ++i;
            }
            this.keyTable.setDefaultEditor(String.class, new KeymapEditor(this));
            this.keyTablePane = new JScrollPane();
            this.keyTablePane.getViewport().setView(this.keyTable);
            this.keyTablePane.setPreferredSize(new Dimension(450, 100));
            this.btnDefault = new JButton("\u30c7\u30d5\u30a9\u30eb\u30c8\u306e\u30ad\u30fc\u30de\u30c3\u30d7\u3092\u8aad\u307f\u8fbc\u3080");
            this.btnDefault.addActionListener(this);
            this.chkUseArrowFor10Key = new JCheckBox("\u30ab\u30fc\u30bd\u30eb\u30ad\u30fc\u3092\u30c6\u30f3\u30ad\u30fc\u306b\u5bfe\u5fdc\u3055\u305b\u308b", false);
            this.chkArrow8Dir = new JCheckBox("\u30ab\u30fc\u30bd\u30eb\u30ad\u30fc\u306e\uff12\u3064\u540c\u6642\u62bc\u3057\u3092\u659c\u3081\u65b9\u5411\u306b\u5bfe\u5fdc\u3055\u305b\u308b", false);
            this.chkRealTimeKeyScan = new JCheckBox("\u7591\u4f3c\u30ea\u30a2\u30eb\u30bf\u30a4\u30e0\u30ad\u30fc\u30b9\u30ad\u30e3\u30f3", false);
            Field[] kevntflds = KeyEvent.class.getFields();
            int i2 = 0;
            while (i2 < kevntflds.length) {
                try {
                    if (kevntflds[i2].getName().startsWith("VK_")) {
                        this.vkCvtTbl.put(new Integer(kevntflds[i2].getInt(null)), kevntflds[i2].getName());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i2;
            }
        }

        @Override
        void make() {
            this.addComponent(new JLabel("\u30ad\u30fc\u30dc\u30fc\u30c9\u30de\u30c3\u30d7"), 0, 0, 2, 1);
            this.addComponent(this.keyTablePane, 0, 1, 2, 1);
            this.addComponent(this.btnDefault, 0, 2, 2, 1);
            this.addComponent(this.chkUseArrowFor10Key, 0, 3, 2, 1);
            this.addComponent(this.chkArrow8Dir, 0, 4, 2, 1);
            this.addComponent(this.chkRealTimeKeyScan, 0, 5, 2, 1);
        }

        @Override
        void reset() {
            this.model.loadKeyMap();
            this.chkUseArrowFor10Key.setSelected(Sys_cfg.this.UseArrowFor10Key);
            this.chkArrow8Dir.setSelected(Sys_cfg.this.Arrow8Dir);
            this.chkRealTimeKeyScan.setSelected(Sys_cfg.this.RealTimeKeyScan);
        }

        @Override
        void submit() {
            Sys_cfg.this.UseArrowFor10Key = this.chkUseArrowFor10Key.isSelected();
            Sys_cfg.this.Arrow8Dir = this.chkArrow8Dir.isSelected();
            Sys_cfg.this.RealTimeKeyScan = this.chkRealTimeKeyScan.isSelected();
            int i = 0;
            while (i < Sys_kbd.KbdPageFM77AV.length / 2) {
                ((Sys_cfg)Sys_cfg.this).KeyMap[i] = Integer.parseInt(this.rowData[i][3]);
                ++i;
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.btnDefault) {
                int[] defmap = null;
                switch (Sys_util.OsType) {
                    case 0: {
                        defmap = Sys_kbd.kbd_table_java;
                        break;
                    }
                    case 1: {
                        defmap = Sys_kbd.kbd_table_windows;
                        break;
                    }
                    case 2: {
                        defmap = Sys_kbd.kbd_table_linux;
                        break;
                    }
                    case 3: {
                        defmap = Sys_kbd.kbd_table_mac;
                        break;
                    }
                    default: {
                        defmap = Sys_kbd.kbd_table_java;
                    }
                }
                int i = 0;
                while (i < defmap.length / 2) {
                    ((Sys_cfg)Sys_cfg.this).KeyMap[defmap[i * 2 + 1]] = defmap[i * 2];
                    ++i;
                }
                this.model.loadKeyMap();
                this.keyTable.repaint();
            }
        }

        public String cnvKeyCode(int KeyCode) {
            String KeyPos;
            String KeyStr = this.vkCvtTbl.get(new Integer(KeyCode & 0xFFFF));
            switch (KeyCode & 0xF0000) {
                case 65536: {
                    KeyPos = "(LEFT)";
                    break;
                }
                case 131072: {
                    KeyPos = "(RIGHT)";
                    break;
                }
                case 262144: {
                    KeyPos = "(NUMPAD)";
                    break;
                }
                default: {
                    KeyPos = "";
                }
            }
            return String.valueOf(KeyStr) + KeyPos;
        }

        class KeyMapTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;

            public KeyMapTableModel() {
                this.loadKeyMap();
            }

            public void loadKeyMap() {
                int i = 0;
                while (i < Sys_kbd.KbdPageFM77AV.length / 2) {
                    KeyboardDialog.this.rowData[i][0] = Integer.toString(i);
                    KeyboardDialog.this.rowData[i][1] = Sys_kbd.KbdPageFM77AV[i * 2];
                    KeyboardDialog.this.rowData[i][2] = Sys_kbd.KbdPageFM77AV[i * 2 + 1];
                    KeyboardDialog.this.rowData[i][3] = Integer.toString(Sys_cfg.this.KeyMap[i]);
                    ++i;
                }
            }

            @Override
            public int getColumnCount() {
                return KeyboardDialog.this.columnNames.length;
            }

            @Override
            public int getRowCount() {
                return KeyboardDialog.this.rowData.length - 1;
            }

            @Override
            public String getColumnName(int col) {
                return KeyboardDialog.this.columnNames[col];
            }

            @Override
            public Object getValueAt(int row, int col) {
                ++row;
                if (col == 3) {
                    return KeyboardDialog.this.cnvKeyCode(Integer.parseInt(KeyboardDialog.this.rowData[row][col]));
                }
                return KeyboardDialog.this.rowData[row][col];
            }

            public Class<String> getColumnClass(int c) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int colIndex) {
                return colIndex == 0;
            }
        }

        class KeymapEditor
        extends AbstractCellEditor
        implements TableCellEditor,
        ActionListener,
        KeyListener {
            private static final long serialVersionUID = 1L;
            final String EDIT = "edit";
            final String OK = "ok";
            final String CANCEL = "cancel";
            String currentKey;
            JButton button = new JButton();
            int KeyCode;
            JDialog dialog;
            JLabel msgLabel;
            JLabel keyLabel;
            JButton ok;
            JButton cancel;
            int tmp;

            public KeymapEditor(Dialog parent) {
                this.button.setActionCommand("edit");
                this.button.addActionListener(this);
                this.button.setBorderPainted(false);
                this.dialog = new JDialog(parent, true);
                this.msgLabel = new JLabel("", 0);
                this.keyLabel = new JLabel("", 0);
                this.dialog.getContentPane().setLayout(new BorderLayout());
                this.dialog.getContentPane().add((Component)this.msgLabel, "North");
                this.dialog.getContentPane().add((Component)this.keyLabel, "Center");
                this.ok = new JButton("\u3000 \uff2f\uff2b \u3000");
                this.cancel = new JButton("\u30ad\u30e3\u30f3\u30bb\u30eb");
                JPanel sbar = new JPanel();
                this.dialog.getContentPane().add((Component)sbar, "South");
                sbar.setLayout(new FlowLayout(1, 1, 1));
                sbar.add(this.ok);
                sbar.add(this.cancel);
                this.ok.setFocusable(false);
                this.cancel.setFocusable(false);
                this.dialog.setFocusTraversalKeysEnabled(false);
                this.ok.setActionCommand("ok");
                this.ok.addActionListener(this);
                this.cancel.setActionCommand("cancel");
                this.cancel.addActionListener(this);
                this.dialog.addKeyListener(this);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("edit".equals(e.getActionCommand())) {
                    this.msgLabel.setText("\u5272\u308a\u5f53\u3066\u308b\u30ad\u30fc\u3092\u30ad\u30fc\u30dc\u30fc\u30c9\u3088\u308a\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
                    this.keyLabel.setText("\u73fe\u5728\u306e\u30ad\u30fc " + KeyboardDialog.this.cnvKeyCode(this.KeyCode));
                    this.dialog.setSize(400, 100);
                    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
                    this.dialog.setLocation((d.width - KeyboardDialog.this.getWidth()) / 2, (d.height - KeyboardDialog.this.getHeight()) / 2);
                    this.dialog.setVisible(true);
                    this.fireEditingStopped();
                } else if ("ok".equals(e.getActionCommand())) {
                    int i = 0;
                    while (i < KeyboardDialog.this.rowData.length) {
                        if (Integer.parseInt(KeyboardDialog.this.rowData[i][3]) == this.KeyCode) {
                            KeyboardDialog.this.rowData[i][3] = String.valueOf(0);
                        }
                        ++i;
                    }
                    KeyboardDialog.this.rowData[Integer.parseInt((String)this.currentKey)][3] = String.valueOf(this.KeyCode);
                    this.dialog.dispose();
                    KeyboardDialog.this.keyTable.repaint();
                } else if ("cancel".equals(e.getActionCommand())) {
                    this.dialog.dispose();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                this.tmp = e.getKeyCode();
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (this.tmp == e.getKeyCode()) {
                    this.KeyCode = e.getKeyCode();
                    switch (e.getKeyLocation()) {
                        case 2: {
                            this.KeyCode |= 0x10000;
                            break;
                        }
                        case 3: {
                            this.KeyCode |= 0x20000;
                            break;
                        }
                        case 4: {
                            this.KeyCode |= 0x40000;
                            break;
                        }
                        default: {
                            if (this.KeyCode != 16 && this.KeyCode != 17 && this.KeyCode != 18) break;
                            this.KeyCode |= 0x10000;
                        }
                    }
                    this.keyLabel.setText("\u73fe\u5728\u306e\u30ad\u30fc " + KeyboardDialog.this.cnvKeyCode(this.KeyCode));
                }
            }

            @Override
            public Object getCellEditorValue() {
                return this.currentKey;
            }

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                this.currentKey = (String)value;
                this.KeyCode = Integer.parseInt(KeyboardDialog.this.rowData[Integer.parseInt(this.currentKey)][3]);
                this.button.setText(this.currentKey);
                return this.button;
            }
        }
    }

    private class OptionDialog
    extends BaseDialog {
        private static final long serialVersionUID = 1L;
        JLabel lblOpn;
        JCheckBox chkOPNEnable;
        JCheckBox chkWHGEnable;
        JCheckBox chkTHGEnable;
        JLabel lblMouse;
        JCheckBox chkMouseEmulation;
        ButtonGroup grpMouse;
        JRadioButton[] chkMousePort;
        JLabel lblVideoDigitize;
        JCheckBox chkDigitizeEnable;
        JLabel lblExtendRam;
        JCheckBox chkExtRAMEnable;

        OptionDialog(Frame frame) {
            super(frame, "\u52d5\u4f5c\u8a2d\u5b9a\uff08\u30aa\u30d7\u30b7\u30e7\u30f3\uff09");
            this.chkMousePort = new JRadioButton[2];
            this.lblOpn = new JLabel("FM\u97f3\u6e90", 2);
            this.chkOPNEnable = new JCheckBox("\u6a19\u6e96FM\u97f3\u6e90\u6709\u52b9", false);
            this.chkWHGEnable = new JCheckBox("WHG\u97f3\u6e90\u6709\u52b9", false);
            this.chkTHGEnable = new JCheckBox("THG\u97f3\u6e90\u6709\u52b9", false);
            this.lblMouse = new JLabel("\u30a4\u30f3\u30c6\u30ea\u30b8\u30a7\u30f3\u30c8\u30de\u30a6\u30b9", 2);
            this.chkMouseEmulation = new JCheckBox("\u30de\u30a6\u30b9\u3092\u4f7f\u7528\u3059\u308b", false);
            this.grpMouse = new ButtonGroup();
            this.chkMousePort[0] = new JRadioButton("\u30dd\u30fc\u30c81\u306b\u30de\u30a6\u30b9\u3092\u63a5\u7d9a", false);
            this.chkMousePort[1] = new JRadioButton("\u30dd\u30fc\u30c82\u306b\u30de\u30a6\u30b9\u3092\u63a5\u7d9a", false);
            this.grpMouse.add(this.chkMousePort[0]);
            this.grpMouse.add(this.chkMousePort[1]);
            this.lblVideoDigitize = new JLabel("\u30d3\u30c7\u30aa\u30c7\u30a3\u30b8\u30bf\u30a4\u30ba\u30ab\u30fc\u30c9", 2);
            this.chkDigitizeEnable = new JCheckBox("\u6709\u52b9", false);
            this.lblExtendRam = new JLabel("\u62e1\u5f35RAM\u30ab\u30fc\u30c9(768KB)", 2);
            this.chkExtRAMEnable = new JCheckBox("\u6709\u52b9", false);
        }

        @Override
        void make() {
            this.addComponent(this.lblOpn, 0, 0, 1, 1);
            this.addComponent(this.chkOPNEnable, 0, 1, 1, 1);
            this.addComponent(this.chkWHGEnable, 0, 2, 1, 1);
            this.addComponent(this.chkTHGEnable, 0, 3, 1, 1);
            this.addComponent(this.lblMouse, 3, 0, 2, 1);
            this.addComponent(this.chkMouseEmulation, 3, 1, 2, 1);
            this.addComponent(this.chkMousePort[0], 3, 2, 2, 1);
            this.addComponent(this.chkMousePort[1], 3, 3, 2, 1);
            this.addComponent(this.lblVideoDigitize, 0, 4, 3, 1);
            this.addComponent(this.chkDigitizeEnable, 0, 5, 3, 1);
            this.addComponent(this.lblExtendRam, 0, 6, 3, 1);
            this.addComponent(this.chkExtRAMEnable, 0, 7, 3, 1);
        }

        @Override
        void reset() {
            this.chkOPNEnable.setSelected(Sys_cfg.this.OPNEnable);
            this.chkWHGEnable.setSelected(Sys_cfg.this.WHGEnable);
            this.chkTHGEnable.setSelected(Sys_cfg.this.THGEnable);
            this.chkMouseEmulation.setSelected(Sys_cfg.this.MouseEmulation);
            this.chkMousePort[0].setSelected(false);
            this.chkMousePort[1].setSelected(false);
            this.chkMousePort[Sys_cfg.this.MousePort - 1].setSelected(true);
            this.chkDigitizeEnable.setSelected(Sys_cfg.this.DigitizeEnable);
            this.chkExtRAMEnable.setSelected(Sys_cfg.this.ExtRAMEnable);
        }

        @Override
        void submit() {
            Sys_cfg.this.OPNEnable = this.chkOPNEnable.isSelected();
            Sys_cfg.this.WHGEnable = this.chkWHGEnable.isSelected();
            Sys_cfg.this.THGEnable = this.chkTHGEnable.isSelected();
            Sys_cfg.this.MouseEmulation = this.chkMouseEmulation.isSelected();
            if (this.chkMousePort[0].isSelected()) {
                Sys_cfg.this.MousePort = 1;
            }
            if (this.chkMousePort[1].isSelected()) {
                Sys_cfg.this.MousePort = 2;
            }
            Sys_cfg.this.DigitizeEnable = this.chkDigitizeEnable.isSelected();
            Sys_cfg.this.ExtRAMEnable = this.chkExtRAMEnable.isSelected();
        }
    }

    private class PrinterDialog
    extends BaseDialog {
        private static final long serialVersionUID = 1L;
        JCheckBox chkPrinterEnable;
        JCheckBox chkUseOsFont;
        JCheckBox chkOutputKanji;

        PrinterDialog(Frame frame) {
            super(frame, "\u52d5\u4f5c\u8a2d\u5b9a\uff08\u30d7\u30ea\u30f3\u30bf\uff09");
            this.chkPrinterEnable = new JCheckBox("\u30d7\u30ea\u30f3\u30bf\u6709\u52b9", true);
            this.chkUseOsFont = new JCheckBox("OS\u306e\u30d5\u30a9\u30f3\u30c8\u3092\u5229\u7528\u3059\u308b", false);
            this.chkOutputKanji = new JCheckBox("\u6f22\u5b57\u3092\u51fa\u529b\u3059\u308b", false);
        }

        @Override
        void make() {
            this.addComponent(this.chkPrinterEnable, 0, 0, 2, 1);
            this.addComponent(this.chkUseOsFont, 0, 1, 2, 1);
            this.addComponent(this.chkOutputKanji, 2, 1, 2, 1);
        }

        @Override
        void reset() {
            this.chkPrinterEnable.setSelected(Sys_cfg.this.PrinterEnable);
            this.chkUseOsFont.setSelected(Sys_cfg.this.UseOsFont);
            this.chkOutputKanji.setSelected(Sys_cfg.this.OutputKanji);
        }

        @Override
        void submit() {
            Sys_cfg.this.PrinterEnable = this.chkPrinterEnable.isSelected();
            Sys_cfg.this.UseOsFont = this.chkUseOsFont.isSelected();
            Sys_cfg.this.OutputKanji = this.chkOutputKanji.isSelected();
        }
    }

    private class RaisedButton
    extends JButton {
        private static final long serialVersionUID = 1L;

        RaisedButton() {
            this.setBorder(new BevelBorder(0));
        }

        RaisedButton(String title) {
            super(title);
            this.setBorder(new BevelBorder(0));
        }
    }

    private class ScreenDialog
    extends BaseDialog {
        private static final long serialVersionUID = 1L;
        JCheckBox chkFullScan;

        ScreenDialog(Frame frame) {
            super(frame, "\u52d5\u4f5c\u8a2d\u5b9a\uff08\u753b\u9762\uff09");
            this.chkFullScan = new JCheckBox("24KHz\u8868\u793a\u30a8\u30df\u30e5\u30ec\u30fc\u30c8\uff08FM77AV40SX\uff09", false);
        }

        @Override
        void make() {
            this.addComponent(this.chkFullScan, 0, 0, 2, 1);
        }

        @Override
        void reset() {
            this.chkFullScan.setSelected(Sys_cfg.this.FullScan);
        }

        @Override
        void submit() {
            Sys_cfg.this.FullScan = this.chkFullScan.isSelected();
        }
    }

    private class SoundDialog
    extends BaseDialog {
        private static final long serialVersionUID = 1L;
        JLabel lblRate;
        ButtonGroup grpRate;
        JRadioButton[] chkSampleRate;
        JLabel lblBuffer;
        JLabel lblSize;
        JTextField txtSoundBuffer;
        JLabel lblMs;
        JLabel lblMode;
        JComboBox choMode;
        JLabel lblOther;
        JLabel lblBeep;
        JTextField txtBeepFreq;
        JLabel lblHz;
        JCheckBox chkTapeMon;
        JCheckBox chkFDDSound;

        SoundDialog(Frame frame) {
            super(frame, "\u52d5\u4f5c\u8a2d\u5b9a\uff08\u30b5\u30a6\u30f3\u30c9\uff09");
            this.chkSampleRate = new JRadioButton[4];
            this.lblRate = new JLabel("\u30b5\u30f3\u30d7\u30ea\u30f3\u30b0\u30ec\u30fc\u30c8", 2);
            this.grpRate = new ButtonGroup();
            this.chkSampleRate[0] = new JRadioButton("48.000kHz", false);
            this.chkSampleRate[1] = new JRadioButton("44.100kHz", false);
            this.chkSampleRate[2] = new JRadioButton("22.050kHz", false);
            this.chkSampleRate[3] = new JRadioButton("\u5408\u6210\u3057\u306a\u3044", false);
            this.grpRate.add(this.chkSampleRate[0]);
            this.grpRate.add(this.chkSampleRate[1]);
            this.grpRate.add(this.chkSampleRate[2]);
            this.grpRate.add(this.chkSampleRate[3]);
            this.lblBuffer = new JLabel("\u30b5\u30a6\u30f3\u30c9\u30d0\u30c3\u30d5\u30a1", 2);
            this.lblSize = new JLabel("\u30d0\u30c3\u30d5\u30a1\u30b5\u30a4\u30ba", 2);
            this.txtSoundBuffer = new JTextField("100");
            this.lblMs = new JLabel("ms", 2);
            this.lblMode = new JLabel("\u51fa\u529b\u30e2\u30fc\u30c9", 2);
            this.choMode = new JComboBox();
            this.lblOther = new JLabel("\u305d\u306e\u4ed6\u306e\u30aa\u30d7\u30b7\u30e7\u30f3", 2);
            this.lblBeep = new JLabel("BEEP\u767a\u4fe1\u5468\u6ce2\u6570", 2);
            this.txtBeepFreq = new JTextField("1200");
            this.lblHz = new JLabel("Hz", 2);
            this.chkTapeMon = new JCheckBox("\u30c6\u30fc\u30d7\u97f3\u30e2\u30cb\u30bf", false);
            this.chkFDDSound = new JCheckBox("FDD\u30b7\u30fc\u30af\u97f3/CMT\u30ea\u30ec\u30fc\u97f3", false);
            this.choMode.addItem("\u30e2\u30ce\u30e9\u30eb");
            this.choMode.addItem("\u30b9\u30c6\u30ec\u30aa(WHG)");
            this.choMode.addItem("\u30b9\u30c6\u30ec\u30aa(\u53cd\u8ee2)");
            this.choMode.addItem("\u30b9\u30c6\u30ec\u30aa(THG)");
        }

        @Override
        void make() {
            this.addComponent(this.lblRate, 0, 0, 1, 1);
            this.addComponent(this.chkSampleRate[0], 0, 1, 1, 1);
            this.addComponent(this.chkSampleRate[1], 0, 2, 1, 1);
            this.addComponent(this.chkSampleRate[2], 0, 3, 1, 1);
            this.addComponent(this.chkSampleRate[3], 0, 4, 1, 1);
            this.addComponent(this.lblBuffer, 1, 0, 3, 1);
            this.addComponent(this.lblSize, 2, 1, 1, 1);
            this.addComponent(this.txtSoundBuffer, 3, 1, 1, 1);
            this.addComponent(this.lblMs, 4, 1, 1, 1);
            this.addComponent(this.lblMode, 2, 2, 1, 1);
            this.addComponent(this.choMode, 3, 2, 2, 1);
            this.addComponent(this.lblOther, 1, 3, 3, 1);
            this.addComponent(this.lblBeep, 2, 4, 1, 1);
            this.addComponent(this.txtBeepFreq, 3, 4, 1, 1);
            this.addComponent(this.lblHz, 4, 4, 1, 1);
            this.addComponent(this.chkTapeMon, 2, 5, 3, 1);
            this.addComponent(this.chkFDDSound, 2, 6, 3, 1);
        }

        @Override
        void reset() {
            this.chkSampleRate[0].setSelected(false);
            this.chkSampleRate[1].setSelected(false);
            this.chkSampleRate[2].setSelected(false);
            this.chkSampleRate[3].setSelected(false);
            if (Sys_cfg.this.SampleRate == 48000) {
                this.chkSampleRate[0].setSelected(true);
            }
            if (Sys_cfg.this.SampleRate == 44100) {
                this.chkSampleRate[1].setSelected(true);
            }
            if (Sys_cfg.this.SampleRate == 22050) {
                this.chkSampleRate[2].setSelected(true);
            }
            if (Sys_cfg.this.SampleRate == 0) {
                this.chkSampleRate[3].setSelected(true);
            }
            this.choMode.setSelectedIndex(Sys_cfg.this.StereoOut);
            this.txtSoundBuffer.setText(Integer.toString(Sys_cfg.this.SoundBuffer));
            this.txtBeepFreq.setText(Integer.toString(Sys_cfg.this.BeepFreq));
            this.chkTapeMon.setSelected(Sys_cfg.this.TapeMon);
            this.chkFDDSound.setSelected(Sys_cfg.this.FDDSound);
        }

        @Override
        void submit() {
            int tmp2;
            if (this.chkSampleRate[0].isSelected()) {
                Sys_cfg.this.SampleRate = 48000;
            }
            if (this.chkSampleRate[1].isSelected()) {
                Sys_cfg.this.SampleRate = 44100;
            }
            if (this.chkSampleRate[2].isSelected()) {
                Sys_cfg.this.SampleRate = 22050;
            }
            if (this.chkSampleRate[3].isSelected()) {
                Sys_cfg.this.SampleRate = 0;
            }
            Sys_cfg.this.StereoOut = this.choMode.getSelectedIndex();
            try {
                tmp2 = Integer.parseInt(this.txtSoundBuffer.getText());
                Sys_cfg.this.SoundBuffer = tmp2;
            }
            catch (Exception tmp2) {
                // empty catch block
            }
            try {
                tmp2 = Integer.parseInt(this.txtBeepFreq.getText());
                Sys_cfg.this.BeepFreq = tmp2;
            }
            catch (Exception exception) {
                // empty catch block
            }
            Sys_cfg.this.TapeMon = this.chkTapeMon.isSelected();
            Sys_cfg.this.FDDSound = this.chkFDDSound.isSelected();
        }
    }
}

