/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.Sys_main;
import emu.xm7.sys.Sys_util;
import emu.xm7.vm.System;
import emu.xm7.vm.Util;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.util.Hashtable;
import java.util.Vector;

public class Sys_kbd
implements KeyListener,
MouseMotionListener,
MouseListener {
    public static final int RELEASE = 0x1000000;
    public static final int LEFT = 65536;
    public static final int RIGHT = 131072;
    public static final int NUMPAD = 262144;
    private Vector<Integer> keyqueue = new Vector();
    public int[] KeyMap = null;
    private Hashtable<Integer, Integer> cnvKeyMap = null;
    private static final Cursor DEFAULT_CURSOR = Cursor.getPredefinedCursor(0);
    private static final Cursor NULL_CURSOR = Toolkit.getDefaultToolkit().createCustomCursor(new BufferedImage(16, 16, 6), new Point(0, 0), "NULLCURSOR");
    private int[] nJoyType = new int[2];
    private int[][] nJoyRapid = new int[2][2];
    private int[][] nJoyCode = new int[2][7];
    boolean bKbdReal;
    boolean bTenCursor;
    boolean bArrow8Dir;
    private int keytime;
    private int dmyreadtime;
    private boolean bDummyRead;
    private int[] nKeyBuffer = new int[64];
    private int nKeyReadPtr;
    private int nKeyWritePtr;
    private int nLastKey;
    private int nLastKey2;
    private int nTenDir;
    private int nTenDir2;
    private int[] joydat = new int[3];
    private int[] joybk = new int[2];
    private int[][] joyrapid = new int[2][2];
    private int joytime;
    private int joytime2;
    private boolean[] joyplugged = new boolean[2];
    private int mostime;
    private boolean bCapture;
    private int nMouseX;
    private int nMouseY;
    private int nMouseButton;
    private int nMouseSX;
    private int nMouseSY;
    boolean bActivate;
    private int nMouseDX;
    private int nMouseDY;
    private boolean bMouseR = false;
    private boolean bMouseL = false;
    private Sys_main sysmain;
    private System vm;
    public static String[] KbdPageFM77AV;
    public static int[] kbd_table_java;
    public static int[] kbd_table_linux;
    public static int[] kbd_table_windows;
    public static int[] kbd_table_mac;
    private final int[] TenDirTable;
    private final int[] JoyRapidCounter;

    static {
        String[] stringArray = new String[206];
        stringArray[2] = "ESC";
        stringArray[4] = "1";
        stringArray[5] = "\u306c";
        stringArray[6] = "2";
        stringArray[7] = "\u3075";
        stringArray[8] = "3";
        stringArray[9] = "\u3042";
        stringArray[10] = "4";
        stringArray[11] = "\u3046";
        stringArray[12] = "5";
        stringArray[13] = "\u3048";
        stringArray[14] = "6";
        stringArray[15] = "\u304a";
        stringArray[16] = "7";
        stringArray[17] = "\u3084";
        stringArray[18] = "8";
        stringArray[19] = "\u3086";
        stringArray[20] = "9";
        stringArray[21] = "\u3088";
        stringArray[22] = "0";
        stringArray[23] = "\u308f";
        stringArray[24] = "-";
        stringArray[25] = "\u307b";
        stringArray[26] = "^";
        stringArray[27] = "\u3078";
        stringArray[28] = "\\";
        stringArray[29] = "\u30fc";
        stringArray[30] = "BS";
        stringArray[32] = "TAB";
        stringArray[34] = "Q";
        stringArray[35] = "\u305f";
        stringArray[36] = "W";
        stringArray[37] = "\u3066";
        stringArray[38] = "E";
        stringArray[39] = "\u3044";
        stringArray[40] = "R";
        stringArray[41] = "\u3059";
        stringArray[42] = "T";
        stringArray[43] = "\u304b";
        stringArray[44] = "Y";
        stringArray[45] = "\u3093";
        stringArray[46] = "U";
        stringArray[47] = "\u306a";
        stringArray[48] = "I";
        stringArray[49] = "\u306b";
        stringArray[50] = "O";
        stringArray[51] = "\u3089";
        stringArray[52] = "P";
        stringArray[53] = "\u305b";
        stringArray[54] = "@";
        stringArray[55] = "\u309b";
        stringArray[56] = "[";
        stringArray[57] = "\u309c";
        stringArray[58] = "RETURN";
        stringArray[60] = "A";
        stringArray[61] = "\u3061";
        stringArray[62] = "S";
        stringArray[63] = "\u3068";
        stringArray[64] = "D";
        stringArray[65] = "\u3057";
        stringArray[66] = "F";
        stringArray[67] = "\u306f";
        stringArray[68] = "G";
        stringArray[69] = "\u304d";
        stringArray[70] = "H";
        stringArray[71] = "\u304f";
        stringArray[72] = "J";
        stringArray[73] = "\u307e";
        stringArray[74] = "K";
        stringArray[75] = "\u306e";
        stringArray[76] = "L";
        stringArray[77] = "\u308a";
        stringArray[78] = ";";
        stringArray[79] = "\u308c";
        stringArray[80] = ":";
        stringArray[81] = "\u3051";
        stringArray[82] = "]";
        stringArray[83] = "\u3080";
        stringArray[84] = "Z";
        stringArray[85] = "\u3064";
        stringArray[86] = "X";
        stringArray[87] = "\u3055";
        stringArray[88] = "C";
        stringArray[89] = "\u305d";
        stringArray[90] = "V";
        stringArray[91] = "\u3072";
        stringArray[92] = "B";
        stringArray[93] = "\u3053";
        stringArray[94] = "N";
        stringArray[95] = "\u307f";
        stringArray[96] = "M";
        stringArray[97] = "\u3082";
        stringArray[98] = ",";
        stringArray[99] = "\u306d";
        stringArray[100] = ".";
        stringArray[101] = "\u308b";
        stringArray[102] = "/";
        stringArray[103] = "\u3081";
        stringArray[104] = "_";
        stringArray[105] = "\u308d";
        stringArray[106] = "SPACE(\u53f3)";
        stringArray[108] = "*";
        stringArray[109] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[110] = "/";
        stringArray[111] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[112] = "+";
        stringArray[113] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[114] = "-";
        stringArray[115] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[116] = "7";
        stringArray[117] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[118] = "8";
        stringArray[119] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[120] = "9";
        stringArray[121] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[122] = "=";
        stringArray[123] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[124] = "4";
        stringArray[125] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[126] = "5";
        stringArray[127] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[128] = "6";
        stringArray[129] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[130] = ",";
        stringArray[131] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[132] = "1";
        stringArray[133] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[134] = "2";
        stringArray[135] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[136] = "3";
        stringArray[137] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[138] = "RETURN";
        stringArray[139] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[140] = "0";
        stringArray[141] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[142] = ".";
        stringArray[143] = "\u30c6\u30f3\u30ad\u30fc";
        stringArray[144] = "INS";
        stringArray[146] = "EL";
        stringArray[148] = "CLS";
        stringArray[150] = "DEL";
        stringArray[152] = "DUP";
        stringArray[154] = "\u2191";
        stringArray[156] = "HOME";
        stringArray[158] = "\u2190";
        stringArray[160] = "\u2193";
        stringArray[162] = "\u2192";
        stringArray[164] = "CTRL";
        stringArray[166] = "SHIFT(\u5de6)";
        stringArray[168] = "SHIFT(\u53f3)";
        stringArray[170] = "CAP";
        stringArray[172] = "GRAPH";
        stringArray[174] = "SPACE(\u5de6)";
        stringArray[176] = "SPACE(\u4e2d)";
        stringArray[180] = "\u304b\u306a";
        stringArray[184] = "BREAK";
        stringArray[186] = "PF1";
        stringArray[188] = "PF2";
        stringArray[190] = "PF3";
        stringArray[192] = "PF4";
        stringArray[194] = "PF5";
        stringArray[196] = "PF6";
        stringArray[198] = "PF7";
        stringArray[200] = "PF8";
        stringArray[202] = "PF9";
        stringArray[204] = "PF10";
        KbdPageFM77AV = stringArray;
        kbd_table_java = new int[]{19, 92, 112, 93, 113, 94, 114, 95, 115, 96, 116, 97, 117, 98, 118, 99, 119, 100, 120, 101, 121, 102, 27, 1, 49, 2, 50, 3, 51, 4, 52, 5, 53, 6, 54, 7, 55, 8, 56, 9, 57, 10, 48, 11, 45, 12, 514, 13, 123, 14, 8, 15, 9, 16, 81, 17, 87, 18, 69, 19, 82, 20, 84, 21, 89, 22, 85, 23, 73, 24, 79, 25, 80, 26, 512, 27, 91, 28, 10, 29, 65553, 82, 65, 30, 83, 31, 68, 32, 70, 33, 71, 34, 72, 35, 74, 36, 75, 37, 76, 38, 59, 39, 513, 40, 93, 41, 65552, 83, 90, 42, 88, 43, 67, 44, 86, 45, 66, 46, 78, 47, 77, 48, 44, 49, 46, 50, 47, 51, 92, 52, 131088, 84, 20, 85, 29, 86, 28, 87, 242, 88, 32, 53, 131089, 90, 155, 72, 127, 75, 38, 77, 37, 79, 40, 80, 39, 81, 36, 73, 33, 74, 35, 76, 34, 78, 262250, 54, 262255, 55, 262251, 56, 262253, 57, 262247, 58, 262248, 59, 262249, 60, 262244, 62, 262245, 63, 262246, 64, 262241, 66, 262242, 67, 262243, 68, 262240, 70, 262254, 71, 262154, 69};
        kbd_table_linux = new int[]{19, 92, 112, 93, 113, 94, 114, 95, 115, 96, 116, 97, 117, 98, 118, 99, 119, 100, 120, 101, 121, 102, 27, 1, 49, 2, 50, 3, 51, 4, 52, 5, 53, 6, 54, 7, 55, 8, 56, 9, 57, 10, 48, 11, 45, 12, 514, 13, 123, 14, 8, 15, 9, 16, 81, 17, 87, 18, 69, 19, 82, 20, 84, 21, 89, 22, 85, 23, 73, 24, 79, 25, 80, 26, 512, 27, 91, 28, 10, 29, 65553, 82, 65, 30, 83, 31, 68, 32, 70, 33, 71, 34, 72, 35, 74, 36, 75, 37, 76, 38, 59, 39, 513, 40, 93, 41, 65552, 83, 90, 42, 88, 43, 67, 44, 86, 45, 66, 46, 78, 47, 77, 48, 44, 49, 46, 50, 47, 51, 92, 52, 131088, 84, 20, 85, 29, 86, 28, 87, 242, 88, 32, 53, 131089, 90, 155, 72, 127, 75, 38, 77, 37, 79, 40, 80, 39, 81, 36, 73, 33, 74, 35, 76, 34, 78, 262250, 54, 262255, 55, 262251, 56, 262253, 57, 262247, 58, 262248, 59, 262249, 60, 262244, 62, 262245, 63, 262246, 64, 262241, 66, 262242, 67, 262243, 68, 262240, 70, 262254, 71, 262154, 69};
        kbd_table_windows = new int[]{19, 92, 112, 93, 113, 94, 114, 95, 115, 96, 116, 97, 117, 98, 118, 99, 119, 100, 120, 101, 121, 102, 27, 1, 49, 2, 50, 3, 51, 4, 52, 5, 53, 6, 54, 7, 55, 8, 56, 9, 57, 10, 48, 11, 45, 12, 514, 13, 123, 14, 8, 15, 9, 16, 81, 17, 87, 18, 69, 19, 82, 20, 84, 21, 89, 22, 85, 23, 73, 24, 79, 25, 80, 26, 512, 27, 91, 28, 10, 29, 65553, 82, 65, 30, 83, 31, 68, 32, 70, 33, 71, 34, 72, 35, 74, 36, 75, 37, 76, 38, 59, 39, 513, 40, 93, 41, 65552, 83, 90, 42, 88, 43, 67, 44, 86, 45, 66, 46, 78, 47, 77, 48, 44, 49, 46, 50, 47, 51, 92, 52, 131088, 84, 240, 85, 29, 86, 28, 87, 242, 88, 32, 53, 131089, 90, 155, 72, 127, 75, 38, 77, 37, 79, 40, 80, 39, 81, 36, 73, 33, 74, 35, 76, 34, 78, 262250, 54, 262255, 55, 262251, 56, 262253, 57, 262247, 58, 262248, 59, 262249, 60, 262244, 62, 262245, 63, 262246, 64, 262241, 66, 262242, 67, 262243, 68, 262240, 70, 262254, 71, 262154, 69};
        kbd_table_mac = new int[]{19, 92, 112, 93, 113, 94, 114, 95, 115, 96, 116, 97, 117, 98, 118, 99, 119, 100, 120, 101, 121, 102, 27, 1, 49, 2, 50, 3, 51, 4, 52, 5, 53, 6, 54, 7, 55, 8, 56, 9, 57, 10, 48, 11, 45, 12, 61, 13, 92, 14, 8, 15, 9, 16, 81, 17, 87, 18, 69, 19, 82, 20, 84, 21, 89, 22, 85, 23, 73, 24, 79, 25, 80, 26, 91, 27, 93, 28, 10, 29, 17, 82, 65, 30, 83, 31, 68, 32, 70, 33, 71, 34, 72, 35, 74, 36, 75, 37, 76, 38, 59, 39, 222, 40, 92, 41, 16, 83, 90, 42, 88, 43, 67, 44, 86, 45, 66, 46, 78, 47, 77, 48, 44, 49, 46, 50, 47, 51, 523, 52, 20, 85, 18, 86, 32, 53, 155, 72, 127, 75, 38, 77, 37, 79, 40, 80, 39, 81, 36, 73, 33, 74, 35, 76, 34, 78, 262250, 54, 262255, 55, 262251, 56, 262253, 57, 262247, 58, 262248, 59, 262249, 60, 262244, 62, 262245, 63, 262246, 64, 262241, 66, 262242, 67, 262243, 68, 262240, 70, 262254, 71, 262154, 69};
    }

    Sys_kbd(Sys_main sysmain, System vm) {
        int[] nArray = new int[16];
        nArray[1] = 59;
        nArray[2] = 67;
        nArray[3] = 255;
        nArray[4] = 62;
        nArray[5] = 58;
        nArray[6] = 66;
        nArray[7] = 62;
        nArray[8] = 64;
        nArray[9] = 60;
        nArray[10] = 68;
        nArray[11] = 64;
        nArray[12] = 255;
        nArray[13] = 59;
        nArray[14] = 67;
        nArray[15] = 255;
        this.TenDirTable = nArray;
        int[] nArray2 = new int[10];
        nArray2[1] = 25;
        nArray2[2] = 12;
        nArray2[3] = 8;
        nArray2[4] = 6;
        nArray2[5] = 5;
        nArray2[6] = 4;
        nArray2[7] = 3;
        nArray2[8] = 2;
        nArray2[9] = 1;
        this.JoyRapidCounter = nArray2;
        this.sysmain = sysmain;
        this.vm = vm;
    }

    public void setCvtKeyMap() {
        this.cnvKeyMap = new Hashtable();
        if (this.KeyMap == null) {
            int[] defmap = null;
            switch (Sys_util.OsType) {
                case 0: {
                    defmap = kbd_table_java;
                    break;
                }
                case 1: {
                    defmap = kbd_table_windows;
                    break;
                }
                case 2: {
                    defmap = kbd_table_linux;
                    break;
                }
                case 3: {
                    defmap = kbd_table_mac;
                    break;
                }
                default: {
                    defmap = kbd_table_java;
                }
            }
            this.KeyMap = new int[KbdPageFM77AV.length];
            int i = 0;
            while (i < defmap.length / 2) {
                this.KeyMap[defmap[i * 2 + 1]] = defmap[i * 2];
                ++i;
            }
        }
        int i = 0;
        while (i < this.KeyMap.length) {
            this.cnvKeyMap.put(new Integer(this.KeyMap[i]), new Integer(i));
            ++i;
        }
    }

    void InitKbd() {
        this.keytime = 0;
        this.bDummyRead = true;
        this.dmyreadtime = 0;
        Util.memset(this.nKeyBuffer, 0, Util.sizeof(this.nKeyBuffer));
        this.nKeyReadPtr = 0;
        this.nKeyWritePtr = 0;
        this.nLastKey = 0;
        this.nLastKey2 = 0;
        this.bKbdReal = false;
        this.bArrow8Dir = true;
        this.nTenDir = 0;
        this.nTenDir2 = 0;
        this.joytime = 0;
        this.joytime2 = 0;
        Util.memset(this.joydat, 0, Util.sizeof(this.joydat));
        Util.memset(this.joybk, 0, Util.sizeof(this.joybk));
        Util.memset(this.joyrapid[0], 0, Util.sizeof(this.joyrapid[0]));
        Util.memset(this.joyrapid[1], 0, Util.sizeof(this.joyrapid[1]));
        this.joyplugged[0] = true;
        this.joyplugged[1] = true;
        this.mostime = 0;
        this.bCapture = false;
        this.nMouseX = 0;
        this.nMouseY = 0;
        this.nMouseButton = 240;
        this.setCvtKeyMap();
        this.bTenCursor = false;
    }

    public void PushKeyCode(int code) {
        if (this.nKeyWritePtr < 64) {
            this.nKeyBuffer[this.nKeyWritePtr++] = code;
        } else {
            int i = 0;
            while (i < 64) {
                this.nKeyBuffer[i] = this.nKeyBuffer[i + 1];
                ++i;
            }
            this.nKeyBuffer[63] = code;
            if (this.nKeyReadPtr > 0) {
                --this.nKeyReadPtr;
            }
        }
    }

    private int Cur2Ten_DirCode(int code) {
        switch (code) {
            case 77: {
                return 1;
            }
            case 79: {
                return 4;
            }
            case 80: {
                return 2;
            }
            case 81: {
                return 8;
            }
        }
        return 0;
    }

    private int Cur2Ten_MaskCode(int code) {
        switch (code) {
            case 77: 
            case 80: {
                return 252;
            }
            case 79: 
            case 81: {
                return 243;
            }
        }
        return 255;
    }

    private boolean Cur2Ten_Make(int code) {
        int nTenDirOld = this.nTenDir;
        int dircode = this.Cur2Ten_DirCode(code);
        if (dircode != 0) {
            if (this.bArrow8Dir) {
                this.nTenDir2 = this.nTenDir & ~this.Cur2Ten_MaskCode(code);
                this.nTenDir &= this.Cur2Ten_MaskCode(code);
                this.nTenDir |= dircode;
            } else {
                if (this.vm.keyboard.key_format == 2) {
                    if (this.TenDirTable[dircode] != 0) {
                        this.vm.keyboard.make(this.TenDirTable[dircode]);
                    }
                    return true;
                }
                this.nTenDir2 = this.nTenDir & this.Cur2Ten_MaskCode(code);
                this.nTenDir = dircode;
            }
            if (this.TenDirTable[this.nTenDir] == 255) {
                this.nTenDir = nTenDirOld;
                return true;
            }
            if (this.nTenDir != nTenDirOld) {
                if (this.TenDirTable[nTenDirOld] != 0) {
                    this.vm.keyboard.Break(this.TenDirTable[nTenDirOld]);
                    this.PushKeyCode(this.TenDirTable[this.nTenDir]);
                } else {
                    this.vm.keyboard.make(this.TenDirTable[this.nTenDir]);
                }
            }
            return true;
        }
        return false;
    }

    private boolean Cur2Ten_Break(int code) {
        int nTenDirOld = this.nTenDir;
        int dircode = this.Cur2Ten_DirCode(code);
        if (dircode != 0) {
            if (this.vm.keyboard.key_format == 2 && !this.bArrow8Dir) {
                if (this.TenDirTable[dircode] != 0) {
                    this.vm.keyboard.Break(this.TenDirTable[dircode]);
                }
                return true;
            }
            this.nTenDir2 &= ~dircode;
            if (this.nTenDir2 != 0) {
                this.nTenDir |= this.nTenDir2;
                this.nTenDir2 = 0;
            }
            this.nTenDir &= ~dircode;
            if (this.TenDirTable[this.nTenDir] == 255) {
                this.nTenDir = nTenDirOld;
                return true;
            }
            if (this.nTenDir != nTenDirOld) {
                this.vm.keyboard.Break(this.TenDirTable[nTenDirOld]);
                if (this.TenDirTable[this.nTenDir] != 0) {
                    this.PushKeyCode(this.TenDirTable[this.nTenDir]);
                } else if (this.vm.keyboard.key_format != 2) {
                    this.PushKeyCode(63);
                    this.PushKeyCode(191);
                }
            }
            return true;
        }
        return false;
    }

    void PollKbd() {
        int key;
        Integer code;
        int key_last = 0;
        if (!this.bActivate) {
            this.bDummyRead = true;
            this.dmyreadtime = this.sysmain.sys_sch.dwExecTotal;
            return;
        }
        if (this.bDummyRead && this.sysmain.sys_sch.dwExecTotal - this.dmyreadtime > 100000) {
            this.bDummyRead = false;
        }
        if (this.sysmain.sys_sch.dwExecTotal - this.keytime < 20000) {
            return;
        }
        this.keytime = this.sysmain.sys_sch.dwExecTotal;
        if (this.nKeyReadPtr < this.nKeyWritePtr) {
            int fm7;
            if ((fm7 = this.nKeyBuffer[this.nKeyReadPtr++]) == 255) {
                this.vm.keyboard.repeat();
            } else if ((fm7 & 0x80) != 0) {
                this.vm.keyboard.Break(fm7 & 0x7F);
            } else {
                this.vm.keyboard.make(fm7);
            }
            return;
        }
        this.nKeyReadPtr = 0;
        this.nKeyWritePtr = 0;
        if (!this.keyqueue.isEmpty() && (code = this.cnvKeyMap.get(new Integer((key = this.keyqueue.remove(0).intValue()) & 0xFEFFFFFF))) != null) {
            if ((key & 0x1000000) == 0) {
                int fm7 = code;
                if (fm7 > 0) {
                    if (!this.bDummyRead) {
                        if (fm7 >= 77 && fm7 <= 81 && this.bTenCursor) {
                            if (this.vm.keyboard.key_format == 2 && fm7 != 78) {
                                this.PushKeyCode(fm7);
                            }
                            if (this.Cur2Ten_Make(fm7)) {
                                fm7 = 0;
                            }
                        }
                        if (fm7 != 0) {
                            this.vm.keyboard.make(fm7);
                        }
                        this.bDummyRead = false;
                        if (this.bKbdReal && this.vm.keyboard.key_format != 2) {
                            if (fm7 >= 58 && fm7 <= 70) {
                                if (this.nLastKey != 0 && this.vm.keyboard.key_repeat_flag) {
                                    this.PushKeyCode(this.nLastKey);
                                }
                                this.PushKeyCode(255);
                                this.nLastKey2 = fm7 == 63 ? 0 : fm7;
                            } else {
                                this.nLastKey = fm7 != 92 ? fm7 : 0;
                            }
                        }
                    }
                    if (fm7 != 92) {
                        key_last = fm7;
                    }
                }
            } else {
                int fm7 = code;
                if (fm7 > 0) {
                    if (fm7 >= 77 && fm7 <= 81 && this.bTenCursor) {
                        if (this.vm.keyboard.key_format == 2 && fm7 != 78) {
                            this.PushKeyCode(fm7 | 0x80);
                        }
                        if (this.Cur2Ten_Break(fm7)) {
                            fm7 = 0;
                        }
                    }
                    if (this.bKbdReal && this.vm.keyboard.key_format != 2) {
                        if (fm7 >= 58 && fm7 <= 70) {
                            this.PushKeyCode(fm7 | 0x80);
                            if (this.nLastKey2 == fm7) {
                                this.PushKeyCode(63);
                                this.PushKeyCode(191);
                                this.nLastKey2 = 0;
                            }
                            if (this.nLastKey != 0 && this.vm.keyboard.key_repeat_flag) {
                                this.PushKeyCode(this.nLastKey);
                                this.PushKeyCode(255);
                                key_last = this.nLastKey;
                            }
                        } else {
                            this.vm.keyboard.Break(fm7);
                            if (this.nLastKey == fm7) {
                                this.nLastKey = 0;
                            }
                            if (this.nLastKey2 != 0 && this.nLastKey2 != key_last) {
                                this.PushKeyCode(this.nLastKey2);
                                this.PushKeyCode(255);
                                key_last = this.nLastKey2;
                            }
                        }
                    } else if (fm7 != 0) {
                        this.vm.keyboard.Break(fm7);
                    }
                }
            }
        }
    }

    private int GetJoy(int index, boolean flag) {
        return 0;
    }

    private int GetRapidJoy(int index, boolean flag) {
        if (!flag && !this.joyplugged[index]) {
            return 0;
        }
        int dat = this.GetJoy(index, flag);
        if (!this.joyplugged[index]) {
            return 0;
        }
        int bit = 16;
        int i = 0;
        while (i < 2) {
            if ((dat & bit) != 0 && this.nJoyRapid[index][i] > 0) {
                if (this.joyrapid[index][i] == 0) {
                    this.joyrapid[index][i] = this.JoyRapidCounter[this.nJoyRapid[index][i]];
                } else {
                    int[] nArray = this.joyrapid[index];
                    int n = i;
                    nArray[n] = nArray[n] - 1;
                    if ((this.joyrapid[index][i] & 0xFF) == 0) {
                        int[] nArray2 = this.joyrapid[index];
                        int n2 = i;
                        nArray2[n2] = nArray2[n2] + this.JoyRapidCounter[this.nJoyRapid[index][i]];
                        int[] nArray3 = this.joyrapid[index];
                        int n3 = i;
                        nArray3[n3] = nArray3[n3] ^ 0x100;
                    }
                }
                if (this.joyrapid[index][i] >= 256) {
                    dat &= ~bit;
                }
            } else {
                this.joyrapid[index][i] = 0;
            }
            bit <<= 1;
            ++i;
        }
        return dat;
    }

    private int PollJoyCode(int code) {
        if (code < 112) {
            return 0;
        }
        switch (code) {
            case 112: {
                return 1;
            }
            case 113: {
                return 2;
            }
            case 114: {
                return 4;
            }
            case 115: {
                return 8;
            }
            case 116: {
                return 16;
            }
            case 117: {
                return 32;
            }
        }
        return 0;
    }

    private int PollJoySub(int index, int dat) {
        int ret = 0;
        int bit = 1;
        int i = 0;
        while (i < 4) {
            if ((dat & bit) != 0) {
                ret |= this.PollJoyCode(this.nJoyCode[index][i]);
            }
            bit <<= 1;
            ++i;
        }
        if ((dat & 0xF) == 0 && (this.joybk[index] & 0xF) != 0) {
            ret |= this.PollJoyCode(this.nJoyCode[index][4]);
        }
        if ((dat & 0x10) != 0) {
            ret |= this.PollJoyCode(this.nJoyCode[index][5]);
        }
        if ((dat & 0x20) != 0) {
            ret |= this.PollJoyCode(this.nJoyCode[index][6]);
        }
        return ret;
    }

    private void PollJoyKbd(int index, int dat) {
        int bit = 1;
        int i = 0;
        while (i < 4) {
            if ((dat & bit) != 0) {
                if ((this.joybk[index] & bit) == 0 && this.nJoyCode[index][i] > 0 && this.nJoyCode[index][i] <= 102) {
                    this.vm.keyboard.make(this.nJoyCode[index][i]);
                }
            } else if ((this.joybk[index] & bit) != 0 && this.nJoyCode[index][i] > 0 && this.nJoyCode[index][i] <= 102) {
                this.vm.keyboard.Break(this.nJoyCode[index][i]);
            }
            bit <<= 1;
            ++i;
        }
        if ((dat & 0xF) == 0 && (this.joybk[index] & 0xF) != 0 && this.nJoyCode[index][4] > 0 && this.nJoyCode[index][4] <= 102) {
            this.vm.keyboard.make(this.nJoyCode[index][4]);
            this.vm.keyboard.Break(this.nJoyCode[index][4]);
        }
        bit = 16;
        i = 0;
        while (i < 2) {
            if ((dat & bit) != 0) {
                if ((this.joybk[index] & bit) == 0 && this.nJoyCode[index][i + 5] > 0 && this.nJoyCode[index][i + 5] <= 102) {
                    this.vm.keyboard.make(this.nJoyCode[index][i + 5]);
                }
            } else if ((this.joybk[index] & bit) != 0 && this.nJoyCode[index][i + 5] > 0 && this.nJoyCode[index][i + 5] <= 102) {
                this.vm.keyboard.Break(this.nJoyCode[index][i + 5]);
            }
            bit <<= 1;
            ++i;
        }
    }

    void PollJoy() {
        boolean check;
        if (this.sysmain.sys_sch.dwExecTotal - this.joytime < 10000) {
            return;
        }
        this.joytime = this.sysmain.sys_sch.dwExecTotal;
        Util.memset(this.joydat, 0, Util.sizeof(this.joydat));
        if (this.nJoyType[0] == 0 && this.nJoyType[1] == 0) {
            return;
        }
        if (this.sysmain.sys_sch.dwExecTotal - this.joytime2 >= 500000) {
            this.joytime2 = this.sysmain.sys_sch.dwExecTotal;
            check = true;
        } else {
            check = false;
        }
        int i = 0;
        while (i < 2) {
            int dat = this.GetRapidJoy(i, check);
            switch (this.nJoyType[i]) {
                case 1: {
                    this.joydat[0] = this.PollJoySub(i, dat);
                    break;
                }
                case 2: {
                    this.joydat[1] = this.PollJoySub(i, dat);
                    break;
                }
                case 3: {
                    this.PollJoyKbd(i, dat);
                    break;
                }
                case 4: {
                    this.joydat[2] = this.PollJoySub(i, dat);
                }
            }
            this.joybk[i] = dat;
            ++i;
        }
    }

    public int joy_request(int no) {
        return this.joydat[no];
    }

    void PollMos() {
        if (!this.bActivate) {
            return;
        }
        if (this.sysmain.sys_sch.dwExecTotal - this.mostime < 10000) {
            return;
        }
        this.mostime = this.sysmain.sys_sch.dwExecTotal;
        if (this.bCapture && this.vm.mouse.mos_capture) {
            switch (this.vm.display.screen_mode) {
                case 0: {
                    this.nMouseDX = this.nMouseDX * 640 / this.sysmain.crtview.getWidth();
                    this.nMouseDY = this.nMouseDY * 200 / this.sysmain.crtview.getHeight();
                    break;
                }
                case 2: {
                    this.nMouseDX = this.nMouseDX * 640 / this.sysmain.crtview.getWidth();
                    this.nMouseDY = this.nMouseDY * 400 / this.sysmain.crtview.getHeight();
                    break;
                }
                case 1: {
                    this.nMouseDX = this.nMouseDX * 320 / this.sysmain.crtview.getWidth();
                    this.nMouseDY = this.nMouseDY * 200 / this.sysmain.getHeight();
                    break;
                }
                case 3: {
                    this.nMouseDX = this.nMouseDX * 320 / this.sysmain.crtview.getWidth();
                    this.nMouseDY = this.nMouseDY * 200 / this.sysmain.crtview.getHeight();
                }
            }
            this.nMouseX -= this.nMouseDX;
            this.nMouseY -= this.nMouseDY;
            this.nMouseButton = 240;
            if (this.bMouseL) {
                this.nMouseButton &= 0xFFFFFFEF;
            }
            if (this.bMouseR) {
                this.nMouseButton &= 0xFFFFFFDF;
            }
        }
        this.nMouseDX = 0;
        this.nMouseDY = 0;
    }

    public void SetMouseCapture(boolean en) {
        this.bCapture = en;
        if (this.bCapture) {
            this.sysmain.crtview.setCursor(NULL_CURSOR);
        } else {
            this.sysmain.crtview.setCursor(DEFAULT_CURSOR);
        }
        Point pos = this.moveMouseToCenter();
        this.nMouseSX = pos.x;
        this.nMouseSY = pos.y;
    }

    public void mospos_request(Point mospos) {
        if (this.bCapture) {
            if (this.nMouseX > 127) {
                this.nMouseX = 127;
            } else if (this.nMouseX < -127) {
                this.nMouseX = -127;
            }
            if (this.nMouseY > 127) {
                this.nMouseY = 127;
            } else if (this.nMouseY < -127) {
                this.nMouseY = -127;
            }
            mospos.x = this.nMouseX;
            mospos.y = this.nMouseY;
        } else {
            mospos.x = 0;
            mospos.y = 0;
        }
        this.nMouseX = 0;
        this.nMouseY = 0;
    }

    public int mosbtn_request() {
        return this.nMouseButton;
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.bCapture && this.vm.mouse.mos_capture) {
            Point pos = e.getPoint();
            this.nMouseDX = pos.x - this.nMouseSX;
            this.nMouseDY = pos.y - this.nMouseSY;
            this.nMouseSX = pos.x;
            this.nMouseSY = pos.y;
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.bCapture && this.vm.mouse.mos_capture) {
            Point pos = this.moveMouseToCenter();
            this.nMouseSX = pos.x;
            this.nMouseSY = pos.y;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                this.bMouseL = true;
                break;
            }
            case 2: {
                if (!this.vm.mouse.mos_capture) break;
                this.SetMouseCapture(!this.bCapture);
                break;
            }
            case 3: {
                this.bMouseR = true;
            }
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        switch (e.getButton()) {
            case 1: {
                this.bMouseL = false;
                break;
            }
            case 3: {
                this.bMouseR = false;
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int key = e.getKeyCode();
        if (Sys_util.OsType == 1 && (key == 28 || key == 242)) {
            e.consume();
            return;
        }
        if (Sys_util.OsType == 3 && (key == 240 || key == 241)) {
            e.consume();
            return;
        }
        switch (e.getKeyLocation()) {
            case 2: {
                key |= 0x10000;
                break;
            }
            case 3: {
                key |= 0x20000;
                break;
            }
            case 4: {
                key |= 0x40000;
                break;
            }
            default: {
                if (key != 16 && key != 17 && key != 18) break;
                key |= 0x10000;
            }
        }
        this.keyqueue.add(new Integer(key));
        if (e.getKeyCode() == 122 && this.vm.mouse.mos_capture) {
            this.SetMouseCapture(!this.bCapture);
        }
        e.consume();
    }

    @Override
    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        if (Sys_util.OsType == 1 && (key == 28 || key == 242)) {
            e.consume();
            return;
        }
        if (Sys_util.OsType == 3 && (key == 240 || key == 241)) {
            e.consume();
            return;
        }
        switch (e.getKeyLocation()) {
            case 2: {
                key |= 0x10000;
                break;
            }
            case 3: {
                key |= 0x20000;
                break;
            }
            case 4: {
                key |= 0x40000;
                break;
            }
            default: {
                if (key != 16 && key != 17 && key != 18) break;
                key |= 0x10000;
            }
        }
        this.keyqueue.add(new Integer(key | 0x1000000));
        e.consume();
    }

    Point moveMouseToCenter() {
        Sys_util.CursorCtrl.mouseMove(this.sysmain.crtview.getLocationOnScreen().x + this.sysmain.crtview.getWidth() / 2, this.sysmain.crtview.getLocationOnScreen().y + this.sysmain.crtview.getHeight() / 2);
        return new Point(this.sysmain.crtview.getWidth() / 2, this.sysmain.crtview.getHeight() / 2);
    }
}

