/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.sys;

import emu.xm7.sys.LowLbl;
import emu.xm7.sys.Sys_main;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class TapeInd
extends LowLbl
implements DropTargetListener {
    private static final long serialVersionUID = 1L;
    private final DecimalFormat TAPE_DFMT = new DecimalFormat("0000");
    private final Color TAPE_RED = new Color(191, 0, 0);
    private final Color TAPE_BLUE = new Color(0, 0, 191);
    private final String EMPTY = "";
    private Sys_main sysmain;
    private TapeIcon icon = new TapeIcon();
    private int nTape = 0;

    TapeInd(Sys_main sysmain) {
        super("", Color.black, Color.lightGray);
        this.sysmain = sysmain;
        this.setIcon(this.icon);
        this.setText("");
        this.setForeground(Color.black);
        this.setBackground(Color.lightGray);
        this.setDropTarget(new DropTarget(this, this));
        this.addMouseListener(new IndicatorListener());
        this.setPreferredSize(new Dimension(72, 16));
        this.setHorizontalAlignment(2);
    }

    void updateInd() {
        int num = 30000;
        if (this.sysmain.vm.tapelp.tape_fileh != null) {
            num = (this.sysmain.vm.tapelp.tape_offset >> 8) % 10000;
            if (this.sysmain.vm.tapelp.tape_motor) {
                num = this.sysmain.vm.tapelp.tape_rec ? (num += 20000) : (num += 10000);
            }
        }
        if (this.nTape == num) {
            return;
        }
        this.nTape = num;
        String idxstr = this.nTape >= 30000 ? "" : this.TAPE_DFMT.format(this.nTape % 10000);
        this.setText(idxstr);
        if (this.nTape >= 10000 && this.nTape < 30000) {
            this.setForeground(Color.white);
            if (this.nTape >= 20000) {
                this.setBackground(this.TAPE_BLUE);
            } else {
                this.setBackground(this.TAPE_RED);
            }
        } else {
            this.setForeground(Color.black);
            this.setBackground(Color.lightGray);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        if (e.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrag(1);
        }
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        Transferable t = e.getTransferable();
        if (t.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            e.acceptDrop(1);
            try {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                File f = (File)files.get(0);
                this.sysmain.vm.tapelp.tape_setfile(f.getAbsolutePath());
                this.sysmain.sys_cmd.resetTapeMenu();
                e.dropComplete(true);
            }
            catch (Exception ex) {
                e.dropComplete(false);
            }
        } else {
            e.rejectDrop();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    private class IndicatorListener
    implements MouseListener {
        private IndicatorListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            ((TapeInd)TapeInd.this).sysmain.sys_cmd.onOpenTape();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class TapeIcon
    implements Icon {
        ImageIcon imgBlank = null;
        ImageIcon imgInsert = null;
        int width = 0;
        int height = 0;

        TapeIcon() {
            URL url = null;
            url = ClassLoader.getSystemClassLoader().getResource("emu/xm7/sys/TAP_EMP.gif");
            if (url != null) {
                this.imgBlank = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
            }
            if ((url = ClassLoader.getSystemClassLoader().getResource("emu/xm7/sys/TAP_INS.gif")) != null) {
                this.imgInsert = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
            }
            if (this.imgInsert != null) {
                this.width = this.imgInsert.getIconWidth();
                this.height = this.imgInsert.getIconHeight();
            }
        }

        @Override
        public int getIconWidth() {
            return this.width;
        }

        @Override
        public int getIconHeight() {
            return this.height;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (((TapeInd)TapeInd.this).sysmain.vm.tapelp.tape_fileh != null) {
                this.imgInsert.paintIcon(c, g, x, y);
            } else {
                this.imgBlank.paintIcon(c, g, x, y);
            }
        }
    }
}

