/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Opn
extends Base
implements EventHandler {
    public boolean opn_enable;
    public int[] opn_reg = new int[256];
    public boolean[] opn_key = new boolean[4];
    private boolean opn_timera;
    private boolean opn_timerb;
    private int opn_timera_tick;
    private int opn_timerb_tick;
    public int opn_scale;
    private int opn_pstate;
    private int opn_selreg;
    private int opn_seldat;
    private boolean opn_timera_int;
    private boolean opn_timerb_int;
    private boolean opn_timera_en;
    private boolean opn_timerb_en;
    private final int opn_timera_event = 1;
    private final int opn_timerb_event = 2;

    Opn() {
    }

    boolean init() {
        Util.memset(this.opn_reg, 0, Util.sizeof(this.opn_reg));
        this.opn_enable = true;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        int i = 0;
        while (i < 6) {
            Opn.sysmain.sys_snd.opn_notify(i, 0);
            ++i;
        }
        Opn.sysmain.sys_snd.opn_notify(7, 255);
        i = 64;
        while (i < 80) {
            if ((i & 3) != 3) {
                Opn.sysmain.sys_snd.opn_notify(i, 127);
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Opn.sysmain.sys_snd.opn_notify(40, i);
            this.opn_key[i] = false;
            ++i;
        }
    }

    void reset() {
        Util.memset(this.opn_reg, 0, Util.sizeof(this.opn_reg));
        this.opn_timera = false;
        this.opn_timerb = false;
        this.opn_pstate = 0;
        this.opn_selreg = 0;
        this.opn_seldat = 0;
        this.opn_timera_int = false;
        this.opn_timerb_int = false;
        this.opn_timera_tick = 0;
        this.opn_timerb_tick = 0;
        this.opn_timera_en = false;
        this.opn_timerb_en = false;
        this.opn_scale = 3;
        int i = 0;
        while (i < 14) {
            if (i == 7) {
                Opn.sysmain.sys_snd.opn_notify(i, 255);
                this.opn_reg[i] = 255;
            } else {
                Opn.sysmain.sys_snd.opn_notify(i, 0);
            }
            ++i;
        }
        i = 48;
        while (i < 64) {
            if ((i & 3) != 3) {
                Opn.sysmain.sys_snd.opn_notify(i, 0);
            }
            ++i;
        }
        i = 64;
        while (i < 80) {
            if ((i & 3) != 3) {
                Opn.sysmain.sys_snd.opn_notify(i, 127);
                this.opn_reg[i] = 127;
            }
            ++i;
        }
        i = 80;
        while (i < 96) {
            if ((i & 3) != 3) {
                Opn.sysmain.sys_snd.opn_notify(i, 31);
                this.opn_reg[i] = 31;
            }
            ++i;
        }
        i = 96;
        while (i < 180) {
            if ((i & 3) != 3) {
                Opn.sysmain.sys_snd.opn_notify(i, 0);
            }
            ++i;
        }
        i = 128;
        while (i < 144) {
            if ((i & 3) != 3) {
                Opn.sysmain.sys_snd.opn_notify(i, 255);
                this.opn_reg[i] = 255;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Opn.sysmain.sys_snd.opn_notify(40, i);
            this.opn_key[i] = false;
            ++i;
        }
        Opn.sysmain.sys_snd.opn_notify(39, 0);
    }

    @Override
    public boolean event(int callbackid) {
        switch (callbackid) {
            case 1: {
                return this.timera_event();
            }
            case 2: {
                return this.timerb_event();
            }
        }
        return true;
    }

    private boolean timera_event() {
        if (this.opn_timera_en && this.opn_timera) {
            this.opn_timera = false;
            this.opn_timera_int = true;
            Opn.mainetc.opn_irq_flag = true;
            maincpu.irq();
        }
        Opn.sysmain.sys_snd.opn_notify(255, 0);
        this.timera_calc();
        return true;
    }

    private void timera_calc() {
        int t = this.opn_reg[36];
        t *= 4;
        int temp = this.opn_reg[37] & 3;
        t |= temp;
        t &= 0x3FF;
        t = 1024 - t;
        t *= this.opn_scale;
        t *= 12;
        t *= 10000;
        if ((t /= 12288) != this.opn_timera_tick) {
            this.opn_timera_tick = t;
            schedule.setevent(2, this.opn_timera_tick, this, 1);
        }
    }

    private boolean timerb_event() {
        if (this.opn_timerb_en && this.opn_timerb) {
            this.opn_timerb = false;
            this.opn_timerb_int = true;
            Opn.mainetc.opn_irq_flag = true;
            maincpu.irq();
        }
        this.timerb_calc();
        return true;
    }

    private void timerb_calc() {
        int t = this.opn_reg[38];
        t = 256 - t;
        t *= 192;
        t *= this.opn_scale;
        t *= 10000;
        if ((t /= 12288) != this.opn_timerb_tick) {
            this.opn_timerb_tick = t;
            schedule.setevent(3, this.opn_timerb_tick, this, 2);
        }
    }

    private int readreg(int reg) {
        if (reg >= 16) {
            return 255;
        }
        return this.opn_reg[reg];
    }

    private void writereg(int reg, int dat) {
        if (reg == 39) {
            if ((dat & 0x10) != 0) {
                this.opn_timera_int = false;
            }
            if ((dat & 0x20) != 0) {
                this.opn_timerb_int = false;
            }
            if (!this.opn_timera_int && !this.opn_timerb_int) {
                Opn.mainetc.opn_irq_flag = false;
                maincpu.irq();
            }
            if ((dat & 1) != 0) {
                if ((this.opn_reg[39] & 1) == 0) {
                    this.timera_calc();
                }
                this.opn_timera_en = true;
            } else {
                this.opn_timera_en = false;
            }
            this.opn_timera = (dat & 4) != 0;
            if ((dat & 2) != 0) {
                if ((this.opn_reg[39] & 2) == 0) {
                    this.timerb_calc();
                }
                this.opn_timerb_en = true;
            } else {
                this.opn_timerb_en = false;
            }
            this.opn_timerb = (dat & 8) != 0;
            this.opn_reg[reg] = dat;
            Opn.sysmain.sys_snd.opn_notify(39, dat & 0xC0);
            return;
        }
        this.opn_reg[reg] = dat;
        switch (reg) {
            case 15: {
                if (Opn.mouse.mos_capture) {
                    int mask = Opn.mouse.mos_port == 1 ? 16 : 32;
                    boolean strobe = (this.opn_reg[15] & mask) != 0;
                    mouse.strobe_signal(strobe);
                }
                return;
            }
            case 45: {
                if (this.opn_scale != 3) {
                    this.opn_scale = 6;
                    this.timera_calc();
                    this.timerb_calc();
                }
                return;
            }
            case 46: {
                this.opn_scale = 3;
                this.timera_calc();
                this.timerb_calc();
                return;
            }
            case 47: {
                this.opn_scale = 2;
                this.timera_calc();
                this.timerb_calc();
                return;
            }
            case 36: 
            case 37: {
                this.opn_timera_tick = 0;
                return;
            }
            case 38: {
                this.opn_timerb_tick = 0;
                return;
            }
        }
        if (reg >= 14 && reg <= 38) {
            return;
        }
        if (reg >= 41 && reg <= 44) {
            return;
        }
        if (reg == 40) {
            this.opn_key[dat & 3] = dat >= 16;
        }
        Opn.sysmain.sys_snd.opn_notify(reg, dat);
    }

    boolean readb(int addr, IntHolder dat) {
        if (Opn.vm.fm7_ver == 1 && !this.opn_enable) {
            return false;
        }
        switch (addr) {
            case 64781: {
                if (Opn.vm.fm7_ver == 1) {
                    return false;
                }
            }
            case 64789: {
                dat.value = 255;
                return true;
            }
            case 64782: {
                if (Opn.vm.fm7_ver == 1) {
                    return false;
                }
            }
            case 64790: {
                switch (this.opn_pstate) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        dat.value = this.opn_seldat;
                        break;
                    }
                    case 4: {
                        dat.value = 0;
                        if (this.opn_timera_int) {
                            dat.value = 1;
                        }
                        if (!this.opn_timerb_int) break;
                        dat.value = 2;
                        break;
                    }
                    case 9: {
                        if (this.opn_selreg == 14) {
                            if (Opn.mouse.mos_capture) {
                                int trigger;
                                int port;
                                if (Opn.mouse.mos_port == 1) {
                                    port = 0;
                                    trigger = this.opn_reg[15] & 3;
                                } else {
                                    port = 64;
                                    trigger = this.opn_reg[15] >> 2 & 3;
                                }
                                if ((this.opn_reg[15] & 0xC0) == port) {
                                    dat.value = mouse.readdata(trigger) | 0xC0;
                                    break;
                                }
                            }
                            if ((this.opn_reg[15] & 0xF0) == 32) {
                                dat.value = ~Opn.sysmain.sys_kbd.joy_request(0) | 0xC0;
                                break;
                            }
                            if ((this.opn_reg[15] & 0xF0) == 80) {
                                dat.value = ~Opn.sysmain.sys_kbd.joy_request(1) | 0xC0;
                                break;
                            }
                            dat.value = 255;
                            break;
                        }
                        dat.value = 0;
                    }
                }
                return true;
            }
            case 64791: {
                dat.value = this.opn_timera_int || this.opn_timerb_int ? 247 : 255;
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        if (Opn.vm.fm7_ver == 1 && !this.opn_enable) {
            return false;
        }
        switch (addr) {
            case 64781: {
                if (Opn.vm.fm7_ver == 1) {
                    return false;
                }
                dat &= 3;
            }
            case 64789: {
                switch (dat & 0xF) {
                    case 0: {
                        this.opn_pstate = 0;
                        break;
                    }
                    case 1: {
                        this.opn_pstate = 1;
                        this.opn_seldat = this.readreg(this.opn_selreg);
                        break;
                    }
                    case 2: {
                        this.opn_pstate = 2;
                        this.writereg(this.opn_selreg, this.opn_seldat);
                        break;
                    }
                    case 3: {
                        this.opn_pstate = 3;
                        this.opn_selreg = this.opn_seldat;
                        if (this.opn_selreg < 45 || this.opn_selreg > 47) break;
                        this.opn_seldat = 0;
                        this.writereg(this.opn_selreg, this.opn_seldat);
                        break;
                    }
                    case 4: {
                        this.opn_pstate = 4;
                        break;
                    }
                    case 9: {
                        this.opn_pstate = 9;
                    }
                }
                return true;
            }
            case 64782: {
                if (Opn.vm.fm7_ver == 1) {
                    return false;
                }
            }
            case 64790: {
                this.opn_seldat = dat;
                switch (this.opn_pstate) {
                    case 2: {
                        this.writereg(this.opn_selreg, this.opn_seldat);
                        break;
                    }
                    case 3: {
                        this.opn_selreg = this.opn_seldat;
                        if (this.opn_selreg < 45 || this.opn_selreg > 47) break;
                        this.opn_seldat = 0;
                        this.writereg(this.opn_selreg, this.opn_seldat);
                    }
                }
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.write(fileh, this.opn_reg, 256)) {
            return false;
        }
        if (!File.bool_write(fileh, this.opn_timera)) {
            return false;
        }
        if (!File.bool_write(fileh, this.opn_timerb)) {
            return false;
        }
        if (!File.dword_write(fileh, this.opn_timera_tick)) {
            return false;
        }
        if (!File.dword_write(fileh, this.opn_timerb_tick)) {
            return false;
        }
        if (!File.byte_write(fileh, this.opn_scale)) {
            return false;
        }
        if (!File.byte_write(fileh, this.opn_pstate)) {
            return false;
        }
        if (!File.byte_write(fileh, this.opn_selreg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.opn_seldat)) {
            return false;
        }
        if (!File.bool_write(fileh, this.opn_timera_int)) {
            return false;
        }
        if (!File.bool_write(fileh, this.opn_timerb_int)) {
            return false;
        }
        if (!File.bool_write(fileh, this.opn_timera_en)) {
            return false;
        }
        return File.bool_write(fileh, this.opn_timerb_en);
    }

    boolean load(RandomAccessFile fileh, int ver) {
        block8: {
            if (ver < 200) {
                return false;
            }
            if (File.read(fileh, this.opn_reg, 256)) break block8;
            return false;
        }
        try {
            this.opn_timera = File.bool_read(fileh);
            this.opn_timerb = File.bool_read(fileh);
            this.opn_timera_tick = File.dword_read(fileh);
            this.opn_timerb_tick = File.dword_read(fileh);
            this.opn_scale = File.byte_read(fileh);
            this.opn_pstate = File.byte_read(fileh);
            this.opn_selreg = File.byte_read(fileh);
            this.opn_seldat = File.byte_read(fileh);
            this.opn_timera_int = File.bool_read(fileh);
            this.opn_timerb_int = File.bool_read(fileh);
            this.opn_timera_en = File.bool_read(fileh);
            this.opn_timerb_en = File.bool_read(fileh);
            Opn.sysmain.sys_snd.opn_notify(39, this.opn_reg[39] & 0xC0);
            int i = 0;
            while (i < 3) {
                Opn.sysmain.sys_snd.opn_notify(40, i);
                this.opn_key[i] = false;
                ++i;
            }
            Opn.sysmain.sys_snd.opn_notify(8, 0);
            Opn.sysmain.sys_snd.opn_notify(9, 0);
            Opn.sysmain.sys_snd.opn_notify(10, 0);
            i = 0;
            while (i < 13) {
                if (i < 8 || i > 10) {
                    Opn.sysmain.sys_snd.opn_notify(i, this.opn_reg[i]);
                }
                ++i;
            }
            i = 48;
            while (i < 180) {
                Opn.sysmain.sys_snd.opn_notify(i, this.opn_reg[i]);
                ++i;
            }
            schedule.handle(2, this, 1);
            schedule.handle(3, this, 2);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

