/*
 * Decompiled with CFR 0.152.
 */
package emu.xm7.vm;

import emu.xm7.sys.File;
import emu.xm7.vm.Base;
import emu.xm7.vm.EventHandler;
import emu.xm7.vm.IntHolder;
import emu.xm7.vm.Util;
import java.io.IOException;
import java.io.RandomAccessFile;

public class Whg
extends Base
implements EventHandler {
    public boolean whg_enable;
    public boolean whg_use;
    public int[] whg_reg = new int[256];
    public boolean[] whg_key = new boolean[4];
    private boolean whg_timera;
    private boolean whg_timerb;
    private int whg_timera_tick;
    private int whg_timerb_tick;
    public int whg_scale;
    private int whg_pstate;
    private int whg_selreg;
    private int whg_seldat;
    private boolean whg_timera_int;
    private boolean whg_timerb_int;
    private boolean whg_timera_en;
    private boolean whg_timerb_en;
    private final int whg_timera_event = 1;
    private final int whg_timerb_event = 2;

    Whg() {
    }

    boolean init() {
        Util.memset(this.whg_reg, 0, Util.sizeof(this.whg_reg));
        this.whg_enable = true;
        this.whg_use = false;
        return true;
    }

    public void finalize() {
        this.cleanup();
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void cleanup() {
        int i = 0;
        while (i < 6) {
            Whg.sysmain.sys_snd.whg_notify(i, 0);
            ++i;
        }
        Whg.sysmain.sys_snd.whg_notify(7, 255);
        i = 64;
        while (i < 80) {
            if ((i & 3) != 3) {
                Whg.sysmain.sys_snd.whg_notify(i, 127);
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Whg.sysmain.sys_snd.whg_notify(40, i);
            this.whg_key[i] = false;
            ++i;
        }
    }

    void reset() {
        Util.memset(this.whg_reg, 0, this.whg_reg.length);
        this.whg_timera = false;
        this.whg_timerb = false;
        this.whg_pstate = 0;
        this.whg_selreg = 0;
        this.whg_seldat = 0;
        this.whg_timera_int = false;
        this.whg_timerb_int = false;
        this.whg_timera_tick = 0;
        this.whg_timerb_tick = 0;
        this.whg_timera_en = false;
        this.whg_timerb_en = false;
        this.whg_scale = 3;
        int i = 0;
        while (i < 14) {
            if (i == 7) {
                Whg.sysmain.sys_snd.whg_notify(i, 255);
                this.whg_reg[i] = 255;
            } else {
                Whg.sysmain.sys_snd.whg_notify(i, 0);
            }
            ++i;
        }
        i = 48;
        while (i < 64) {
            if ((i & 3) != 3) {
                Whg.sysmain.sys_snd.whg_notify(i, 0);
            }
            ++i;
        }
        i = 64;
        while (i < 80) {
            if ((i & 3) != 3) {
                Whg.sysmain.sys_snd.whg_notify(i, 127);
                this.whg_reg[i] = 127;
            }
            ++i;
        }
        i = 80;
        while (i < 96) {
            if ((i & 3) != 3) {
                Whg.sysmain.sys_snd.whg_notify(i, 31);
                this.whg_reg[i] = 31;
            }
            ++i;
        }
        i = 96;
        while (i < 180) {
            if ((i & 3) != 3) {
                Whg.sysmain.sys_snd.whg_notify(i, 0);
            }
            ++i;
        }
        i = 128;
        while (i < 144) {
            if ((i & 3) != 3) {
                Whg.sysmain.sys_snd.whg_notify(i, 255);
                this.whg_reg[i] = 255;
            }
            ++i;
        }
        i = 0;
        while (i < 3) {
            Whg.sysmain.sys_snd.whg_notify(40, i);
            this.whg_key[i] = false;
            ++i;
        }
        Whg.sysmain.sys_snd.whg_notify(39, 0);
        this.whg_use = false;
    }

    @Override
    public boolean event(int callbackid) {
        switch (callbackid) {
            case 1: {
                return this.timera_event();
            }
            case 2: {
                return this.timerb_event();
            }
        }
        return true;
    }

    private boolean timera_event() {
        if (this.whg_enable && this.whg_timera_en && this.whg_timera) {
            this.whg_timera = false;
            this.whg_timera_int = true;
            Whg.mainetc.whg_irq_flag = true;
            maincpu.irq();
        }
        if (this.whg_enable) {
            Whg.sysmain.sys_snd.whg_notify(255, 0);
        }
        this.timera_calc();
        return true;
    }

    private void timera_calc() {
        int t = this.whg_reg[36];
        t *= 4;
        int temp = this.whg_reg[37] & 3;
        t |= temp;
        t &= 0x3FF;
        t = 1024 - t;
        t *= this.whg_scale;
        t *= 12;
        t *= 10000;
        if (this.whg_timera_tick != (t /= 12288)) {
            this.whg_timera_tick = t;
            schedule.setevent(10, this.whg_timera_tick, this, 1);
        }
    }

    private boolean timerb_event() {
        if (this.whg_enable && this.whg_timerb_en && this.whg_timerb) {
            this.whg_timerb = false;
            this.whg_timerb_int = true;
            Whg.mainetc.whg_irq_flag = true;
            maincpu.irq();
        }
        this.timerb_calc();
        return true;
    }

    private void timerb_calc() {
        int t = this.whg_reg[38];
        t = 256 - t;
        t *= 192;
        t *= this.whg_scale;
        t *= 10000;
        if ((t /= 12288) != this.whg_timerb_tick) {
            this.whg_timerb_tick = t;
            schedule.setevent(11, this.whg_timerb_tick, this, 2);
        }
    }

    private int readreg(int reg) {
        if (reg >= 16) {
            return 255;
        }
        return this.whg_reg[reg];
    }

    private void writereg(int reg, int dat) {
        this.whg_use = true;
        if (reg == 39) {
            if ((dat & 0x10) != 0) {
                this.whg_timera_int = false;
            }
            if ((dat & 0x20) != 0) {
                this.whg_timerb_int = false;
            }
            if (!this.whg_timera_int && !this.whg_timerb_int) {
                Whg.mainetc.whg_irq_flag = false;
                maincpu.irq();
            }
            if ((dat & 1) != 0) {
                if ((this.whg_reg[39] & 1) == 0) {
                    this.timera_calc();
                }
                this.whg_timera_en = true;
            } else {
                this.whg_timera_en = false;
            }
            this.whg_timera = (dat & 4) != 0;
            if ((dat & 2) != 0) {
                if ((this.whg_reg[39] & 2) == 0) {
                    this.timerb_calc();
                }
                this.whg_timerb_en = true;
            } else {
                this.whg_timerb_en = false;
            }
            this.whg_timerb = (dat & 8) != 0;
            this.whg_reg[reg] = dat;
            Whg.sysmain.sys_snd.whg_notify(39, dat & 0xC0);
            return;
        }
        this.whg_reg[reg] = dat;
        switch (reg) {
            case 45: {
                if (this.whg_scale != 3) {
                    this.whg_scale = 6;
                    this.timera_calc();
                    this.timerb_calc();
                }
                return;
            }
            case 46: {
                this.whg_scale = 3;
                this.timera_calc();
                this.timerb_calc();
                return;
            }
            case 47: {
                this.whg_scale = 2;
                this.timera_calc();
                this.timerb_calc();
                return;
            }
            case 36: 
            case 37: {
                this.whg_timera_tick = 0;
                return;
            }
            case 38: {
                this.whg_timerb_tick = 0;
                return;
            }
        }
        if (reg >= 14 && reg <= 38) {
            return;
        }
        if (reg >= 41 && reg <= 44) {
            return;
        }
        if (reg == 40) {
            this.whg_key[dat & 3] = dat >= 16;
        }
        Whg.sysmain.sys_snd.whg_notify(reg, dat);
    }

    boolean readb(int addr, IntHolder dat) {
        if (!this.whg_enable) {
            return false;
        }
        switch (addr) {
            case 64837: {
                dat.value = 255;
                return true;
            }
            case 64838: {
                switch (this.whg_pstate) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        dat.value = this.whg_seldat;
                        break;
                    }
                    case 4: {
                        dat.value = 0;
                        if (this.whg_timera_int) {
                            dat.value = 1;
                        }
                        if (!this.whg_timerb_int) break;
                        dat.value = 2;
                        break;
                    }
                    case 9: {
                        dat.value = this.whg_selreg == 14 ? 255 : 0;
                    }
                }
                return true;
            }
            case 64839: {
                dat.value = this.whg_timera_int || this.whg_timerb_int ? 247 : 255;
                return true;
            }
        }
        return false;
    }

    boolean writeb(int addr, int dat) {
        if (!this.whg_enable) {
            return false;
        }
        switch (addr) {
            case 64837: {
                switch (dat & 0xF) {
                    case 0: {
                        this.whg_pstate = 0;
                        break;
                    }
                    case 1: {
                        this.whg_pstate = 1;
                        this.whg_seldat = this.readreg(this.whg_selreg);
                        break;
                    }
                    case 2: {
                        this.whg_pstate = 2;
                        this.writereg(this.whg_selreg, this.whg_seldat);
                        break;
                    }
                    case 3: {
                        this.whg_pstate = 3;
                        this.whg_selreg = this.whg_seldat;
                        if (this.whg_selreg < 45 || this.whg_selreg > 47) break;
                        this.whg_seldat = 0;
                        this.writereg(this.whg_selreg, this.whg_seldat);
                        break;
                    }
                    case 4: {
                        this.whg_pstate = 4;
                        break;
                    }
                    case 9: {
                        this.whg_pstate = 9;
                    }
                }
                return true;
            }
            case 64838: {
                this.whg_seldat = dat;
                switch (this.whg_pstate) {
                    case 2: {
                        this.writereg(this.whg_selreg, this.whg_seldat);
                        break;
                    }
                    case 3: {
                        this.whg_selreg = this.whg_seldat;
                        if (this.whg_selreg < 45 || this.whg_selreg > 47) break;
                        this.whg_seldat = 0;
                        this.writereg(this.whg_selreg, this.whg_seldat);
                    }
                }
                return true;
            }
        }
        return false;
    }

    boolean save(RandomAccessFile fileh) {
        if (!File.bool_write(fileh, this.whg_enable)) {
            return false;
        }
        if (!File.bool_write(fileh, this.whg_use)) {
            return false;
        }
        if (!File.write(fileh, this.whg_reg, 256)) {
            return false;
        }
        if (!File.bool_write(fileh, this.whg_timera)) {
            return false;
        }
        if (!File.bool_write(fileh, this.whg_timerb)) {
            return false;
        }
        if (!File.dword_write(fileh, this.whg_timera_tick)) {
            return false;
        }
        if (!File.dword_write(fileh, this.whg_timerb_tick)) {
            return false;
        }
        if (!File.byte_write(fileh, this.whg_scale)) {
            return false;
        }
        if (!File.byte_write(fileh, this.whg_pstate)) {
            return false;
        }
        if (!File.byte_write(fileh, this.whg_selreg)) {
            return false;
        }
        if (!File.byte_write(fileh, this.whg_seldat)) {
            return false;
        }
        if (!File.bool_write(fileh, this.whg_timera_int)) {
            return false;
        }
        if (!File.bool_write(fileh, this.whg_timerb_int)) {
            return false;
        }
        if (!File.bool_write(fileh, this.whg_timera_en)) {
            return false;
        }
        return File.bool_write(fileh, this.whg_timerb_en);
    }

    boolean load(RandomAccessFile fileh, int ver) throws IOException {
        block8: {
            if (ver < 300) {
                this.whg_use = false;
                return true;
            }
            this.whg_enable = File.bool_read(fileh);
            this.whg_use = File.bool_read(fileh);
            if (File.read(fileh, this.whg_reg, 256)) break block8;
            return false;
        }
        try {
            this.whg_timera = File.bool_read(fileh);
            this.whg_timerb = File.bool_read(fileh);
            this.whg_timera_tick = File.dword_read(fileh);
            this.whg_timerb_tick = File.dword_read(fileh);
            this.whg_scale = File.byte_read(fileh);
            this.whg_pstate = File.byte_read(fileh);
            this.whg_selreg = File.byte_read(fileh);
            this.whg_seldat = File.byte_read(fileh);
            this.whg_timera_int = File.bool_read(fileh);
            this.whg_timerb_int = File.bool_read(fileh);
            this.whg_timera_en = File.bool_read(fileh);
            this.whg_timerb_en = File.bool_read(fileh);
            Whg.sysmain.sys_snd.whg_notify(39, this.whg_reg[39] & 0xC0);
            int i = 0;
            while (i < 3) {
                Whg.sysmain.sys_snd.whg_notify(40, i);
                this.whg_key[i] = false;
                ++i;
            }
            Whg.sysmain.sys_snd.whg_notify(8, 0);
            Whg.sysmain.sys_snd.whg_notify(9, 0);
            Whg.sysmain.sys_snd.whg_notify(10, 0);
            i = 0;
            while (i < 13) {
                if (i < 8 || i > 10) {
                    Whg.sysmain.sys_snd.whg_notify(i, this.whg_reg[i]);
                }
                ++i;
            }
            i = 48;
            while (i < 180) {
                Whg.sysmain.sys_snd.whg_notify(i, this.whg_reg[i]);
                ++i;
            }
            schedule.handle(10, this, 1);
            schedule.handle(11, this, 2);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }
}

