/*
 * Decompiled with CFR 0.152.
 */
package ui.joysticksettings;

import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TableView;
import javafx.util.Duration;
import libsidplay.common.OS;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.java.games.input.ControllerEnvironment;
import sidplay.Player;
import ui.common.C64Window;
import ui.common.TypeTextField;
import ui.entities.config.JoystickSection;
import ui.joysticksettings.JoystickReader;

public class JoystickSettings
extends C64Window {
    @FXML
    protected CheckBox activateJoy1;
    @FXML
    protected CheckBox activateJoy2;
    @FXML
    private ComboBox<Controller> device1;
    @FXML
    private ComboBox<Controller> device2;
    @FXML
    private ComboBox<Component> up1;
    @FXML
    private ComboBox<Component> down1;
    @FXML
    private ComboBox<Component> left1;
    @FXML
    private ComboBox<Component> right1;
    @FXML
    private ComboBox<Component> fire1;
    @FXML
    private TypeTextField up1Value;
    @FXML
    private TypeTextField down1Value;
    @FXML
    private TypeTextField left1Value;
    @FXML
    private TypeTextField right1Value;
    @FXML
    private TypeTextField fire1Value;
    @FXML
    private ComboBox<Component> up2;
    @FXML
    private ComboBox<Component> down2;
    @FXML
    private ComboBox<Component> left2;
    @FXML
    private ComboBox<Component> right2;
    @FXML
    private ComboBox<Component> fire2;
    @FXML
    private TypeTextField up2Value;
    @FXML
    private TypeTextField down2Value;
    @FXML
    private TypeTextField left2Value;
    @FXML
    private TypeTextField right2Value;
    @FXML
    private TypeTextField fire2Value;
    @FXML
    protected TableView<Component> testTable1;
    @FXML
    protected TableView<Component> testTable2;
    private ObservableList<Controller> devices;
    private ObservableList<Component> components1;
    private ObservableList<Component> components2;
    private Timeline timer;

    public JoystickSettings() {
    }

    public JoystickSettings(Player player) {
        super(player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.components1 = FXCollections.observableArrayList();
        SortedList sortedList1 = new SortedList(this.components1);
        sortedList1.comparatorProperty().bind((ObservableValue)this.testTable1.comparatorProperty());
        this.testTable1.setItems((ObservableList)sortedList1);
        this.devices = FXCollections.observableArrayList();
        this.device1.setItems(this.devices);
        this.up1.setItems(this.components1);
        this.down1.setItems(this.components1);
        this.left1.setItems(this.components1);
        this.right1.setItems(this.components1);
        this.fire1.setItems(this.components1);
        this.components2 = FXCollections.observableArrayList();
        SortedList sortedList2 = new SortedList(this.components2);
        sortedList2.comparatorProperty().bind((ObservableValue)this.testTable2.comparatorProperty());
        this.testTable2.setItems((ObservableList)sortedList2);
        this.up2.setItems(this.components2);
        this.down2.setItems(this.components2);
        this.left2.setItems(this.components2);
        this.right2.setItems(this.components2);
        this.fire2.setItems(this.components2);
        this.device2.setItems(this.devices);
        ControllerEnvironment controllerEnv = ControllerEnvironment.getDefaultEnvironment();
        Object[] controllers = controllerEnv.getControllers();
        if (controllers.length == 0 && OS.get() == OS.LINUX) {
            System.err.println("If you can use sudo, try the following command and start JSIDPlay2 again:");
            System.err.println("sudo chmod go+r /dev/input/*");
        }
        this.devices.addAll(controllers);
        JoystickSection joystickSettings = this.util.getConfig().getJoystickSection();
        this.activateJoy1.setSelected(this.util.getPlayer().getC64().isJoystickConnected(0));
        this.select((Controller[])controllers, joystickSettings.getDeviceName1(), this.device1);
        this.chooseDevice1();
        Controller controller1 = (Controller)this.device1.getSelectionModel().getSelectedItem();
        this.select(controller1, joystickSettings.getComponentNameUp1(), this.up1);
        this.select(controller1, joystickSettings.getComponentNameDown1(), this.down1);
        this.select(controller1, joystickSettings.getComponentNameLeft1(), this.left1);
        this.select(controller1, joystickSettings.getComponentNameRight1(), this.right1);
        this.select(controller1, joystickSettings.getComponentNameBtn1(), this.fire1);
        this.up1Value.setValue(Float.valueOf(joystickSettings.getComponentValueUp1()));
        this.down1Value.setValue(Float.valueOf(joystickSettings.getComponentValueDown1()));
        this.left1Value.setValue(Float.valueOf(joystickSettings.getComponentValueLeft1()));
        this.right1Value.setValue(Float.valueOf(joystickSettings.getComponentValueRight1()));
        this.fire1Value.setValue(Float.valueOf(joystickSettings.getComponentValueBtn1()));
        this.activateJoy2.setSelected(this.util.getPlayer().getC64().isJoystickConnected(1));
        this.select((Controller[])controllers, joystickSettings.getDeviceName2(), this.device2);
        this.chooseDevice2();
        Controller controller2 = (Controller)this.device2.getSelectionModel().getSelectedItem();
        this.select(controller2, joystickSettings.getComponentNameUp2(), this.up2);
        this.select(controller2, joystickSettings.getComponentNameDown2(), this.down2);
        this.select(controller2, joystickSettings.getComponentNameLeft2(), this.left2);
        this.select(controller2, joystickSettings.getComponentNameRight2(), this.right2);
        this.select(controller2, joystickSettings.getComponentNameBtn2(), this.fire2);
        this.up2Value.setValue(Float.valueOf(joystickSettings.getComponentValueUp2()));
        this.down2Value.setValue(Float.valueOf(joystickSettings.getComponentValueDown2()));
        this.left2Value.setValue(Float.valueOf(joystickSettings.getComponentValueLeft2()));
        this.right2Value.setValue(Float.valueOf(joystickSettings.getComponentValueRight2()));
        this.fire2Value.setValue(Float.valueOf(joystickSettings.getComponentValueBtn2()));
        Duration oneFrameAmt = Duration.millis((double)500.0);
        KeyFrame oneFrame = new KeyFrame(oneFrameAmt, evt -> {
            if (this.activateJoy1.isSelected()) {
                this.testTable1.refresh();
            }
            if (this.activateJoy2.isSelected()) {
                this.testTable2.refresh();
            }
        }, new KeyValue[0]);
        this.timer = new Timeline(new KeyFrame[]{oneFrame});
        this.timer.setCycleCount(-1);
        this.timer.playFromStart();
    }

    @Override
    public void doClose() {
        this.timer.stop();
    }

    private void select(Controller[] controllers, String controllerName, ComboBox<Controller> comboBox) {
        if (controllerName != null) {
            for (Controller controller : controllers) {
                if (!controller.getName().equals(controllerName)) continue;
                comboBox.getSelectionModel().select((Object)controller);
                break;
            }
        }
    }

    private void select(Controller controller, String componentName, ComboBox<Component> combobox) {
        if (componentName != null && controller != null) {
            for (Component component : controller.getComponents()) {
                if (!component.getName().equals(componentName)) continue;
                combobox.getSelectionModel().select((Object)component);
                break;
            }
        }
    }

    @FXML
    private void doActivateJoy1() {
        this.util.getPlayer().getC64().setJoystick(0, this.activateJoy1.isSelected() ? new JoystickReader((Controller)this.device1.getSelectionModel().getSelectedItem(), (Component)this.up1.getSelectionModel().getSelectedItem(), (Component)this.down1.getSelectionModel().getSelectedItem(), (Component)this.left1.getSelectionModel().getSelectedItem(), (Component)this.right1.getSelectionModel().getSelectedItem(), (Component)this.fire1.getSelectionModel().getSelectedItem(), ((Float)this.up1Value.getValue()).floatValue(), ((Float)this.down1Value.getValue()).floatValue(), ((Float)this.left1Value.getValue()).floatValue(), ((Float)this.right1Value.getValue()).floatValue(), ((Float)this.fire1Value.getValue()).floatValue()) : null);
    }

    @FXML
    private void chooseDevice1() {
        Controller controller1 = (Controller)this.device1.getSelectionModel().getSelectedItem();
        if (controller1 != null) {
            this.components1.setAll((Object[])controller1.getComponents());
            this.util.getConfig().getJoystickSection().setDeviceName1(controller1.getName());
            this.doActivateJoy1();
        }
    }

    @FXML
    private void chooseUp1() {
        this.util.getConfig().getJoystickSection().setComponentNameUp1(((Component)this.up1.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseUp1Value() {
        this.util.getConfig().getJoystickSection().setComponentValueUp1(((Float)this.up1Value.getValue()).floatValue());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseDown1() {
        this.util.getConfig().getJoystickSection().setComponentNameDown1(((Component)this.down1.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseDown1Value() {
        this.util.getConfig().getJoystickSection().setComponentValueDown1(((Float)this.down1Value.getValue()).floatValue());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseLeft1() {
        this.util.getConfig().getJoystickSection().setComponentNameLeft1(((Component)this.left1.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseLeft1Value() {
        this.util.getConfig().getJoystickSection().setComponentValueLeft1(((Float)this.left1Value.getValue()).floatValue());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseRight1() {
        this.util.getConfig().getJoystickSection().setComponentNameRight1(((Component)this.right1.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseRight1Value() {
        this.util.getConfig().getJoystickSection().setComponentValueRight1(((Float)this.right1Value.getValue()).floatValue());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseFire1() {
        this.util.getConfig().getJoystickSection().setComponentNameBtn1(((Component)this.fire1.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy1();
    }

    @FXML
    private void chooseFire1Value() {
        this.util.getConfig().getJoystickSection().setComponentValueBtn1(((Float)this.fire1Value.getValue()).floatValue());
        this.doActivateJoy1();
    }

    @FXML
    private void doActivateJoy2() {
        this.util.getPlayer().getC64().setJoystick(1, this.activateJoy2.isSelected() ? new JoystickReader((Controller)this.device2.getSelectionModel().getSelectedItem(), (Component)this.up2.getSelectionModel().getSelectedItem(), (Component)this.down2.getSelectionModel().getSelectedItem(), (Component)this.left2.getSelectionModel().getSelectedItem(), (Component)this.right2.getSelectionModel().getSelectedItem(), (Component)this.fire2.getSelectionModel().getSelectedItem(), ((Float)this.up2Value.getValue()).floatValue(), ((Float)this.down2Value.getValue()).floatValue(), ((Float)this.left2Value.getValue()).floatValue(), ((Float)this.right2Value.getValue()).floatValue(), ((Float)this.fire2Value.getValue()).floatValue()) : null);
    }

    @FXML
    private void chooseDevice2() {
        Controller controller2 = (Controller)this.device2.getSelectionModel().getSelectedItem();
        if (controller2 != null) {
            this.components2.setAll((Object[])controller2.getComponents());
            this.util.getConfig().getJoystickSection().setDeviceName2(controller2.getName());
            this.doActivateJoy2();
        }
    }

    @FXML
    private void chooseUp2() {
        this.util.getConfig().getJoystickSection().setComponentNameUp2(((Component)this.up2.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseUp2Value() {
        this.util.getConfig().getJoystickSection().setComponentValueUp2(((Float)this.up2Value.getValue()).floatValue());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseDown2() {
        this.util.getConfig().getJoystickSection().setComponentNameDown2(((Component)this.down2.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseDown2Value() {
        this.util.getConfig().getJoystickSection().setComponentValueDown2(((Float)this.down2Value.getValue()).floatValue());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseLeft2() {
        this.util.getConfig().getJoystickSection().setComponentNameLeft2(((Component)this.left2.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseLeft2Value() {
        this.util.getConfig().getJoystickSection().setComponentValueLeft2(((Float)this.left2Value.getValue()).floatValue());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseRight2() {
        this.util.getConfig().getJoystickSection().setComponentNameRight2(((Component)this.right2.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseRight2Value() {
        this.util.getConfig().getJoystickSection().setComponentValueRight2(((Float)this.right2Value.getValue()).floatValue());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseFire2() {
        this.util.getConfig().getJoystickSection().setComponentNameBtn2(((Component)this.fire2.getSelectionModel().getSelectedItem()).getIdentifier().getName());
        this.doActivateJoy2();
    }

    @FXML
    private void chooseFire2Value() {
        this.util.getConfig().getJoystickSection().setComponentValueBtn2(((Float)this.fire2Value.getValue()).floatValue());
        this.doActivateJoy2();
    }
}

