/*
 * Decompiled with CFR 0.152.
 */
package sidplay;

import builder.jexsid.JExSIDBuilder;
import builder.jhardsid.JHardSIDBuilder;
import builder.jsidblaster.JSIDBlasterBuilder;
import builder.jsidblaster.SIDType;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javax.sound.sampled.Mixer;
import libsidplay.common.EventScheduler;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos656x.PALEmulation;
import libsidplay.config.IWhatsSidSection;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.debug.MOS6510Debug;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import libsidutils.siddatabase.SidDatabase;
import sidplay.Player;
import sidplay.audio.JavaSound;
import sidplay.consoleplayer.ConsoleIO;
import sidplay.filefilter.AudioTuneFileFilter;
import sidplay.filefilter.VideoTuneFileFilter;
import sidplay.fingerprinting.FingerprintJsonClient;
import sidplay.ini.IniConfig;
import sidplay.ini.converter.FileToStringConverter;
import sidplay.ini.validator.FilesAndFoldersValidator;
import sidplay.ini.validator.VerboseValidator;
import sidplay.player.DebugUtil;
import sidplay.player.State;

@Parameters(resourceBundle="sidplay.ConsolePlayer")
public final class ConsolePlayer {
    private static final ResourceBundle BUNDLE;
    private static final AudioTuneFileFilter AUDIO_TUNE_FILE_FILTER;
    private static final VideoTuneFileFilter VIDEO_TUNE_FILE_FILTER;
    @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true, order=10000)
    private Boolean help = Boolean.FALSE;
    @Parameter(names={"--cpuDebug"}, hidden=true, descriptionKey="DEBUG", order=10001)
    private Boolean cpuDebug = Boolean.FALSE;
    @Parameter(names={"--startSong", "-o"}, descriptionKey="START_SONG", order=10002)
    private Integer song = null;
    @Parameter(names={"--sfxSoundExpander"}, arity=1, descriptionKey="SFX_SOUND_EXPANDER", order=10003)
    private Boolean sfxSoundExpander = Boolean.FALSE;
    @Parameter(names={"--sfxSoundExpanderType"}, descriptionKey="SFX_SOUND_EXPANDER_TYPE", order=10004)
    private Integer sfxSoundExpanderType = 0;
    @Parameter(names={"--verbose", "-v"}, descriptionKey="VERBOSE", validateWith={VerboseValidator.class}, order=10005)
    private Integer verbose = 0;
    @Parameter(names={"--quiet", "-q"}, descriptionKey="QUIET", order=10006)
    private Boolean quiet = Boolean.FALSE;
    @Parameter(descriptionKey="FILES_AND_FOLDERS", converter=FileToStringConverter.class, validateWith={FilesAndFoldersValidator.class})
    private List<File> filesAndFolders = new ArrayList<File>();
    @ParametersDelegate
    private IniConfig config = new IniConfig(true);

    private void execute(String[] args) {
        try {
            JCommander commander = JCommander.newBuilder().addObject((Object)this).programName(this.getClass().getName()).build();
            commander.parse(args);
            if (this.help.booleanValue() || this.filesAndFolders.isEmpty()) {
                commander.usage();
                this.printSoundcardDevices();
                this.printHardwareDevices();
                this.exit(1);
            }
            for (File file : this.filesAndFolders) {
                if (file.isDirectory()) {
                    this.processDirectory(file);
                    continue;
                }
                if (!file.isFile()) continue;
                this.processFile(file);
            }
        }
        catch (ParameterException | IOException | SidTuneError e) {
            System.err.println(e.getMessage());
            this.exit(1);
        }
    }

    private void processDirectory(File dir) throws IOException, SidTuneError {
        File[] listFiles;
        for (File file2 : listFiles = Optional.ofNullable(dir.listFiles(file -> AUDIO_TUNE_FILE_FILTER.accept(file) || VIDEO_TUNE_FILE_FILTER.accept(file))).orElse(new File[0])) {
            if (file2.isDirectory()) {
                this.processDirectory(file2);
                continue;
            }
            if (!file2.isFile()) continue;
            this.processFile(file2);
        }
    }

    private void processFile(File file) throws IOException, SidTuneError {
        IWhatsSidSection whatsSidSection = this.config.getWhatsSidSection();
        whatsSidSection.setEnable(false);
        String url = whatsSidSection.getUrl();
        String username = whatsSidSection.getUsername();
        String password = whatsSidSection.getPassword();
        int connectionTimeout = whatsSidSection.getConnectionTimeout();
        SidTune tune = SidTune.load(file);
        tune.getInfo().setSelectedSong(this.song);
        Player player = new Player(this.config, context -> this.cpuDebug != false ? new MOS6510Debug((EventScheduler)context) : new MOS6510((EventScheduler)context));
        player.getC64().getVIC().setPalEmulation(PALEmulation.NONE);
        player.setTune(tune);
        ConsoleIO consoleIO = new ConsoleIO(this.config, file.getName(), BUNDLE::getString);
        player.setMenuHook(obj -> consoleIO.menu(obj.getTune(), obj.getPlayList(), obj.getTimer(), this.verbose, this.quiet, true, System.out));
        player.setInteractivityHook(obj -> consoleIO.decodeKeys((Player)obj, System.in));
        player.setWhatsSidHook(obj -> consoleIO.whatsSid((MusicInfoWithConfidenceBean)obj, this.quiet, System.out));
        player.setFingerPrintMatcher(new FingerprintJsonClient(url, username, password, connectionTimeout));
        if (this.sfxSoundExpander.booleanValue()) {
            player.insertCartridge(CartridgeType.SOUNDEXPANDER, this.sfxSoundExpanderType);
        }
        if (this.config.getSidplay2Section().isEnableDatabase()) {
            this.setSIDDatabase(player);
        }
        player.setRecordingFilenameProvider(theTune -> {
            String basename = new File(file.getParentFile(), IOUtils.getFilenameWithoutSuffix(file.getName())).getAbsolutePath();
            if (theTune.getInfo().getSongs() > 1) {
                basename = basename + String.format("-%02d", theTune.getInfo().getCurrentSong());
            }
            return basename;
        });
        player.startC64();
        player.stopC64(false);
        if (player.stateProperty().get() == State.QUIT) {
            throw new IOException("QUIT by user");
        }
    }

    private void setSIDDatabase(Player player) {
        File hvscRoot = player.getConfig().getSidplay2Section().getHvsc();
        if (hvscRoot != null) {
            try {
                player.setSidDatabase(new SidDatabase(hvscRoot));
            }
            catch (IOException e) {
                System.err.println("WARNING: song length database can not be read: " + e.getMessage());
            }
        }
    }

    private void printSoundcardDevices() {
        int deviceIdx = 0;
        for (Mixer.Info deviceInfo : JavaSound.getDeviceInfos()) {
            System.out.printf("    --deviceIndex %d -> %s (%s)\n", deviceIdx++, deviceInfo.getName(), deviceInfo.getDescription());
        }
    }

    private void printHardwareDevices() {
        int n;
        try {
            new JSIDBlasterBuilder(null, this.config, null);
            String[] serialNumbers = JSIDBlasterBuilder.getSerialNumbers();
            if (serialNumbers.length > 0) {
                System.out.println("\nDetected SIDBlaster devices: (please add to INI file: " + IniConfig.getINIPath() + ")");
                System.out.printf("    SIDBlasterMapping_N=%d\n", serialNumbers.length);
                int deviceIdx = 0;
                String[] stringArray = serialNumbers;
                n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String serialNumber = stringArray[i];
                    SIDType sidType = JSIDBlasterBuilder.getSidType(deviceIdx);
                    System.out.printf("    SIDBlasterMapping_%d=%s=%s\n", deviceIdx++, serialNumber, sidType.name());
                }
            }
        }
        catch (UnsatisfiedLinkError serialNumbers) {
            // empty catch block
        }
        try {
            new JExSIDBuilder(null, this.config, null);
            String[] exSidDeviceNames = JExSIDBuilder.getDeviceNames();
            if (exSidDeviceNames.length > 0) {
                System.out.println("\nDetected ExSID devices:");
                String[] stringArray = exSidDeviceNames;
                int n2 = stringArray.length;
                for (n = 0; n < n2; ++n) {
                    String deviceName = stringArray[n];
                    System.out.println("    " + deviceName);
                }
            }
        }
        catch (UnsatisfiedLinkError exSidDeviceNames) {
            // empty catch block
        }
        try {
            new JHardSIDBuilder(null, this.config, null);
            String[] hardSidDeviceNames = JHardSIDBuilder.getDeviceNames();
            if (hardSidDeviceNames.length > 0) {
                System.out.println("\nDetected HardSID devices:");
                for (String deviceName : hardSidDeviceNames) {
                    System.out.println("    " + deviceName);
                }
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    private void exit(int rc) {
        try {
            System.out.println("Press <enter> to exit the player!");
            System.in.read();
            System.exit(rc);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        new ConsolePlayer().execute(args);
    }

    static {
        DebugUtil.init();
        BUNDLE = ResourceBundle.getBundle("sidplay.consoleplayer.ConsoleIO");
        AUDIO_TUNE_FILE_FILTER = new AudioTuneFileFilter();
        VIDEO_TUNE_FILE_FILTER = new VideoTuneFileFilter();
    }
}

