/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler;

import com.xuggle.ferry.IBuffer;
import com.xuggle.ferry.JNIReference;
import com.xuggle.xuggler.IAudioSamples;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.ITimeValue;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.image.BufferedImage;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Utils {
    private static final Logger log = LoggerFactory.getLogger(Utils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IVideoPicture getBlankFrame(int w, int h, int yColor, int uColor, int vColor, long pts, int crossHatchW, int crossHatchH, int crossHatchYColor, int crossHatchUColor, int crossHatchVColor) {
        IVideoPicture frame = IVideoPicture.make(IPixelFormat.Type.YUV420P, w, h);
        if (frame == null) {
            throw new OutOfMemoryError("could not allocate frame");
        }
        if (frame != null) {
            AtomicReference<Object> ref = new AtomicReference<Object>(null);
            IBuffer data = null;
            try {
                data = frame.getData();
                int bufSize = frame.getSize();
                ByteBuffer buffer = data.getByteBuffer(0, bufSize, ref);
                if (buffer != null) {
                    int color;
                    int j;
                    int finalColor;
                    int[] yCoords;
                    int[] xCoords;
                    int y;
                    int x;
                    int i;
                    int lineLength = 0;
                    int offset = 0;
                    offset = 0;
                    lineLength = frame.getDataLineSize(0);
                    int sliceLen = lineLength * h;
                    for (i = offset; i < offset + sliceLen; ++i) {
                        x = (i - offset) % lineLength;
                        y = (i - offset) / lineLength;
                        if (crossHatchH > 0 && crossHatchW > 0 && (x / crossHatchW % 2 == 1 && y / crossHatchH % 2 == 0 || x / crossHatchW % 2 == 0 && y / crossHatchH % 2 == 1)) {
                            buffer.put(i, (byte)crossHatchYColor);
                            continue;
                        }
                        buffer.put(i, (byte)yColor);
                    }
                    offset = frame.getDataLineSize(0) * h;
                    lineLength = frame.getDataLineSize(1);
                    sliceLen = lineLength * ((h + 1) / 2);
                    for (i = offset; i < offset + sliceLen; ++i) {
                        if (crossHatchH > 0 && crossHatchW > 0) {
                            x = (i - offset) % lineLength * 2;
                            y = (i - offset) / lineLength * 2;
                            xCoords = new int[]{x, x + 1, x, x + 1};
                            yCoords = new int[]{y, y, y + 1, y + 1};
                            finalColor = 0;
                            for (j = 0; j < xCoords.length; ++j) {
                                color = uColor;
                                x = xCoords[j];
                                y = yCoords[j];
                                if (x / crossHatchW % 2 == 1 && y / crossHatchH % 2 == 0 || x / crossHatchW % 2 == 0 && y / crossHatchH % 2 == 1) {
                                    color = crossHatchUColor;
                                }
                                finalColor += color;
                            }
                            buffer.put(i, (byte)(finalColor /= xCoords.length));
                            continue;
                        }
                        buffer.put(i, (byte)uColor);
                    }
                    offset = frame.getDataLineSize(0) * h + frame.getDataLineSize(1) * ((h + 1) / 2);
                    lineLength = frame.getDataLineSize(2);
                    sliceLen = lineLength * ((h + 1) / 2);
                    for (i = offset; i < offset + sliceLen; ++i) {
                        if (crossHatchH > 0 && crossHatchW > 0) {
                            x = (i - offset) % lineLength * 2;
                            y = (i - offset) / lineLength * 2;
                            xCoords = new int[]{x, x + 1, x, x + 1};
                            yCoords = new int[]{y, y, y + 1, y + 1};
                            finalColor = 0;
                            for (j = 0; j < xCoords.length; ++j) {
                                color = vColor;
                                x = xCoords[j];
                                y = yCoords[j];
                                if (x / crossHatchW % 2 == 1 && y / crossHatchH % 2 == 0 || x / crossHatchW % 2 == 0 && y / crossHatchH % 2 == 1) {
                                    color = crossHatchVColor;
                                }
                                finalColor += color;
                            }
                            buffer.put(i, (byte)(finalColor /= xCoords.length));
                            continue;
                        }
                        buffer.put(i, (byte)vColor);
                    }
                }
                frame.setComplete(true, IPixelFormat.Type.YUV420P, w, h, pts);
            }
            finally {
                if (data != null) {
                    data.delete();
                }
                if (ref.get() != null) {
                    ((JNIReference)ref.get()).delete();
                }
            }
        }
        return frame;
    }

    public static IVideoPicture getBlankFrame(int w, int h, int y, int u, int v, long pts) {
        return Utils.getBlankFrame(w, h, y, u, v, pts, 0, 0, 0, 0, 0);
    }

    public static IVideoPicture getBlankFrame(int w, int h, int pts) {
        return Utils.getBlankFrame(w, h, 0, 0, 0, pts);
    }

    public static ITimeValue samplesToTimeValue(long numSamples, int sampleRate) {
        if (sampleRate <= 0) {
            throw new IllegalArgumentException("sampleRate must be greater than zero");
        }
        return ITimeValue.make(IAudioSamples.samplesToDefaultPts(numSamples, sampleRate), ITimeValue.Unit.MICROSECONDS);
    }

    public static long timeValueToSamples(ITimeValue duration, int sampleRate) {
        if (duration == null) {
            throw new IllegalArgumentException("must pass in a valid duration");
        }
        if (sampleRate <= 0) {
            throw new IllegalArgumentException("sampleRate must be greater than zero");
        }
        return IAudioSamples.defaultPtsToSamples(duration.get(ITimeValue.Unit.MICROSECONDS), sampleRate);
    }

    @Deprecated
    public static BufferedImage videoPictureToImage(IVideoPicture picture) {
        if (picture == null) {
            throw new IllegalArgumentException("The video picture is NULL.");
        }
        IConverter converter = ConverterFactory.createConverter("XUGGLER-BGR-24", picture);
        return converter.toImage(picture);
    }

    @Deprecated
    public static IVideoPicture imageToVideoPicture(BufferedImage image, long pts) {
        if (image == null) {
            throw new IllegalArgumentException("The image is NULL.");
        }
        if (image.getType() != 5) {
            throw new IllegalArgumentException("The image is of type #" + image.getType() + " but is required to be BufferedImage.TYPE_3BYTE_BGR of type #" + 5 + ".");
        }
        IConverter converter = ConverterFactory.createConverter(image, IPixelFormat.Type.BGR24);
        return converter.toPicture(image, pts);
    }

    static {
        log.trace("Utils loaded");
    }
}

