/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class SoftMemoryBlock
extends AsmDirective {
    private ExprNode nameExpr;

    public SoftMemoryBlock(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.nameExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.nameExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        boolean bl;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.nameExpr.evaluate(evaluationState);
        boolean bl2 = bl = value.isInvalid() || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation();
        if (bl) {
            throw new AsmErrorException("Name must be evaluated in first pass", this.nameExpr.getSourceRange());
        }
        String string = value.getString(this.range);
        evaluationState.segmentMgr.startSoftMemoryBlock(string, this.range);
        return SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

