/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.map.BaseHashMap;

public class OrderedLongHashSet
extends BaseHashMap {
    public OrderedLongHashSet() {
        this(8);
    }

    public OrderedLongHashSet(int n) throws IllegalArgumentException {
        super(n, 2, 0, false);
        this.isList = true;
    }

    public boolean contains(long l) {
        return super.containsKey(l);
    }

    public boolean add(long l) {
        int n = this.size();
        super.addOrUpdate(l, 0L, null, null);
        return n != this.size();
    }

    public boolean insert(int n, long l) throws IndexOutOfBoundsException {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.contains(l)) {
            return false;
        }
        if (n < this.size()) {
            super.insertRow(n);
        }
        return this.add(l);
    }

    public boolean remove(long l) {
        return (Boolean)super.remove(l, 0L, null, null, false, true);
    }

    public void removeEntry(int n) throws IndexOutOfBoundsException {
        this.checkRange(n);
        long l = this.longKeyTable[n];
        super.remove(l, 0L, null, null, false, true);
    }

    public long get(int n) {
        this.checkRange(n);
        return this.longKeyTable[n];
    }

    public int getIndex(long l) {
        return this.getLookup(l);
    }

    public int getStartMatchCount(long[] lArray) {
        int n;
        for (n = 0; n < lArray.length && super.containsKey(lArray[n]); ++n) {
        }
        return n;
    }

    public int getOrderedStartMatchCount(long[] lArray) {
        int n;
        for (n = 0; n < lArray.length && n < this.size() && this.get(n) == lArray[n]; ++n) {
        }
        return n;
    }

    public boolean addAll(OrderedLongHashSet orderedLongHashSet) {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            long l = orderedLongHashSet.longValueTable[i];
            this.add(l);
        }
        return n != this.size();
    }

    public long[] toArray() {
        int n = -1;
        long[] lArray = new long[this.size()];
        for (int i = 0; i < lArray.length; ++i) {
            long l;
            n = super.nextLookup(n);
            lArray[i] = l = (long)this.intKeyTable[n];
        }
        return lArray;
    }

    private void checkRange(int n) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

