/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import kickass.common.diagnostics.AsmError;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class ImportTailParser
implements ITailParser<AsmNode> {
    private Map<String, BiFunction<List<ExprNode>, SourceRange, AsmNode>> nodeCreatorMap = new HashMap<String, BiFunction<List<ExprNode>, SourceRange, AsmNode>>();

    public ImportTailParser addType(String string, BiFunction<List<ExprNode>, SourceRange, AsmNode> biFunction) {
        this.nodeCreatorMap.put(string, biFunction);
        return this;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        IToken iToken2 = tokenStreamList.expectType(TokenType.Id, evaluationState);
        if (iToken2 == null) {
            return null;
        }
        String string = iToken2.getStringValue();
        BiFunction<List<ExprNode>, SourceRange, AsmNode> biFunction = this.nodeCreatorMap.get(string);
        if (biFunction == null) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid argument", iToken2.getSourceRange()));
            return null;
        }
        List<ExprNode> list = ExprParser.parseOptExprList(tokenStreamList, evaluationState);
        if (list == null) {
            return null;
        }
        return biFunction.apply(list, sourceRange);
    }
}

