/*
 * Decompiled with CFR 0.152.
 */
package sidplay;

import builder.hardsid.HardSIDBuilder;
import builder.jexsid.ExSIDEmu;
import builder.jexsid.JExSIDBuilder;
import builder.jhardsid.JHardSIDBuilder;
import builder.jhardsid.JHardSIDEmu;
import builder.jsidblaster.JSIDBlasterBuilder;
import builder.jsidblaster.SIDBlasterEmu;
import builder.jusbsid.JUSBSIDBuilder;
import builder.netsiddev.NetSIDDev;
import builder.netsiddev.NetSIDDevBuilder;
import builder.resid.ReSIDBuilder;
import builder.resid.SIDMixer;
import builder.resid.resid.ReSID;
import builder.resid.residfp.ReSIDfp;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.HardwareEnsemble;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Engine;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.OS;
import libsidplay.common.SIDBuilder;
import libsidplay.common.SIDEmu;
import libsidplay.common.SIDListener;
import libsidplay.common.Ultimate64Mode;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.mos6510.IMOS6510Extension;
import libsidplay.components.mos6510.MOS6510;
import libsidplay.components.mos6526.MOS6526;
import libsidplay.components.mos656x.VIC;
import libsidplay.config.IAudioSection;
import libsidplay.config.IConfig;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2Section;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.CBMCodeUtils;
import libsidutils.fingerprinting.IFingerprintMatcher;
import libsidutils.fingerprinting.rest.beans.MusicInfoWithConfidenceBean;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import sidplay.AllRoms;
import sidplay.audio.Audio;
import sidplay.audio.AudioDriver;
import sidplay.audio.SIDDumpDriver;
import sidplay.audio.VideoDriver;
import sidplay.audio.exceptions.IniConfigException;
import sidplay.audio.exceptions.SongEndException;
import sidplay.ini.IniConfig;
import sidplay.ini.IniDefaults;
import sidplay.player.ObjectProperty;
import sidplay.player.PSid64DetectedTuneInfo;
import sidplay.player.PSid64Detection;
import sidplay.player.PlayList;
import sidplay.player.State;
import sidplay.player.Timer;
import sidplay.player.WhatsSidEvent;

public class Player
extends HardwareEnsemble
implements VideoDriver,
SIDListener,
IMOS6510Extension {
    private static final Logger LOG = Logger.getLogger(Player.class.getName());
    @SuppressFBWarnings(value={"STCAL_STATIC_CALENDAR_INSTANCE"}, justification="Last modified date of this class to get a build date")
    public static final Calendar LAST_MODIFIED;
    private static final int PAUSE_SLEEP_TIME = 250;
    private static final int QUIT_MAX_WAIT_TIME = 1000;
    private static final int PREV_SONG_TIMEOUT = 4;
    private static final int RAM_COMMAND_SCREEN_ADDRESS = 1264;
    private static final int RAM_COMMAND = 631;
    private static final int RAM_COMMAND_LEN = 198;
    private static final int MAX_COMMAND_LEN = 16;
    private static final String RUN = "RUN\r";
    private static final String SYS = "SYS%d\r";
    private static final String LOAD = "LOAD\r";
    private ObjectProperty<State> stateProperty;
    private Timer timer;
    private PlayList playList;
    private SidTune tune;
    private String command;
    private Thread playerThread;
    private Consumer<Player> menuHook = player -> {};
    private Consumer<Player> interactivityHook = player -> {};
    private Consumer<MusicInfoWithConfidenceBean> whatsSidHook = musicInfoWithConfidence -> {};
    private Function<Integer, Integer> playAddrHook = Function.identity();
    private AbstractMap.SimpleImmutableEntry<Audio, AudioDriver> audioAndDriver;
    private Thread.UncaughtExceptionHandler uncaughtExceptionHandler;
    private boolean checkDefaultLengthInRecordMode;
    private boolean checkLoopOffInRecordMode;
    private boolean forceCheckSongLength;
    private boolean psid64Detected;
    private boolean firstPlayListEntryIsOne;
    private SIDBuilder sidBuilder;
    private STIL stil;
    private SidDatabase sidDatabase;
    private Function<SidTune, String> recordingFilenameProvider;
    private BiFunction<Integer, SIDEmu, SIDEmu> requiredSIDs = (sidNum, sidEmu) -> {
        if (SidTune.isSIDUsed(this.config.getEmulationSection(), this.tune, sidNum)) {
            return this.sidBuilder.lock((SIDEmu)sidEmu, (int)sidNum, this.tune);
        }
        if (sidEmu != SIDEmu.NONE) {
            this.sidBuilder.unlock((SIDEmu)sidEmu);
        }
        return SIDEmu.NONE;
    };
    private BiFunction<Integer, SIDEmu, SIDEmu> noSIDs = (sidNum, sidEmu) -> {
        if (sidEmu != SIDEmu.NONE) {
            this.sidBuilder.unlock((SIDEmu)sidEmu);
        }
        return SIDEmu.NONE;
    };
    private IntFunction<Integer> sidLocator = sidNum -> SidTune.getSIDAddress(this.config.getEmulationSection(), this.tune, sidNum);
    private PropertyChangeListener pauseListener = event -> {
        if (event.getNewValue() == State.PAUSE) {
            this.getAudioDriver().pause();
            this.configureMixer(Mixer::pause);
        }
    };
    private List<VideoDriver> videoDrivers = new CopyOnWriteArrayList<VideoDriver>();
    private List<SIDListener> sidListeners = new CopyOnWriteArrayList<SIDListener>();
    private List<IMOS6510Extension> mos6510Extensions = new CopyOnWriteArrayList<IMOS6510Extension>();
    private int fastForwardVICFrames;
    private IFingerprintMatcher fingerPrintMatcher;
    private WhatsSidEvent whatsSidEvent;
    private Runnable playerRunnable = () -> {
        this.playList = new PlayList(this.config.getSidplay2Section(), this.tune, this.firstPlayListEntryIsOne);
        do {
            try {
                this.stateProperty.set(State.OPEN);
                this.open();
                this.stateProperty.set(State.START);
                this.menuHook.accept(this);
                this.stateProperty.set(State.PLAY);
                while (this.play()) {
                    this.interactivityHook.accept(this);
                }
            }
            catch (SongEndException e) {
                this.timer.end();
            }
            catch (IniConfigException e) {
                System.err.println(e.getMessage());
                this.stateProperty.set(State.RESTART);
                e.getConfigRepairer().run();
            }
            catch (IOException | InterruptedException | RuntimeException | UnsatisfiedLinkError | LineUnavailableException e) {
                this.stateProperty.set(State.QUIT);
                throw new RuntimeException(e.getMessage(), e);
            }
            finally {
                this.close();
            }
        } while (this.stateProperty.get() == State.RESTART);
    };

    public Player(IConfig config) {
        this(config, context -> new MOS6510((EventScheduler)context));
    }

    public Player(final IConfig config, Function<EventScheduler, MOS6510> cpuCreator) {
        super(config, cpuCreator, AllRoms.CHAR, AllRoms.BASIC, AllRoms.KERNAL, AllRoms.JIFFYDOS_C64, AllRoms.JIFFYDOS_C1541, AllRoms.C1541, AllRoms.C1541_II, AllRoms.MPS803_CHAR);
        Player.initializeTmpDir(config);
        this.stateProperty = new ObjectProperty<State>(State.class.getSimpleName(), State.QUIT);
        this.audioAndDriver = new AbstractMap.SimpleImmutableEntry<Audio, AudioDriver>(IniDefaults.DEFAULT_AUDIO, IniDefaults.DEFAULT_AUDIO.getAudioDriver());
        this.checkDefaultLengthInRecordMode = true;
        this.checkLoopOffInRecordMode = true;
        this.forceCheckSongLength = false;
        this.firstPlayListEntryIsOne = false;
        this.recordingFilenameProvider = tune -> new File(config.getSidplay2Section().getTmpDir(), "jsidplay2").getAbsolutePath();
        this.playList = new PlayList(config.getSidplay2Section(), SidTune.RESET, this.firstPlayListEntryIsOne);
        this.timer = new Timer(config.getSidplay2Section(), this.c64.getEventScheduler(), () -> this.getSidDatabaseInfo(db -> db.getSongLength(this.tune), 0.0)){

            @Override
            public void start() {
                Player.this.c64.insertSIDChips(Player.this.requiredSIDs, Player.this.sidLocator);
                Player.this.c64.configureVICs(vic -> vic.setVideoDriver(Player.this));
                Player.this.c64.setSIDListener(Player.this);
                Player.this.c64.setPlayRoutineObserver(Player.this);
                Player.this.configureMixer(Mixer::start);
                if (Player.this.whatsSidEvent != null) {
                    Player.this.whatsSidEvent.start();
                }
            }

            @Override
            public void end() {
                ISidPlay2Section sidplay2Section = config.getSidplay2Section();
                if (Player.this.tune != SidTune.RESET || Player.this.forceCheckSongLength) {
                    if (!sidplay2Section.isSingle() && Player.this.playList.hasNext()) {
                        Player.this.nextSong();
                    } else if (sidplay2Section.isLoop()) {
                        if (Player.this.checkLoopOffInRecordMode && Player.this.getAudioDriver().isRecording()) {
                            Player.this.stateProperty.set(State.END);
                            System.out.println("Warning: Loop has been disabled during recording!");
                        } else {
                            Player.this.stateProperty.set(State.RESTART);
                        }
                    } else {
                        Player.this.stateProperty.set(State.END);
                    }
                }
            }

            @Override
            public void fadeInStart(double fadeIn) {
                if (Player.this.tune != SidTune.RESET) {
                    Player.this.configureMixer(mixer -> mixer.fadeIn(fadeIn));
                }
            }

            @Override
            public void fadeOutStart(double fadeOut) {
                if (Player.this.tune != SidTune.RESET) {
                    Player.this.configureMixer(mixer -> mixer.fadeOut(fadeOut));
                }
            }
        };
    }

    public static void initializeTmpDir(IConfig config) {
        File tmpDir = config.getSidplay2Section().getTmpDir();
        if (tmpDir == null) {
            tmpDir = IniDefaults.DEFAULT_TMP_DIR;
            config.getSidplay2Section().setTmpDir(tmpDir);
        }
        if (!tmpDir.exists()) {
            tmpDir.mkdirs();
        }
    }

    public IFingerprintMatcher getFingerPrintMatcher() {
        return this.fingerPrintMatcher;
    }

    public void setFingerPrintMatcher(IFingerprintMatcher fingerPrintMatcher) {
        this.fingerPrintMatcher = fingerPrintMatcher;
    }

    public final void updateSIDChipConfiguration() {
        this.executeInPlayerThread("Update SID Chip Configuration", () -> this.c64.insertSIDChips(this.requiredSIDs, this.sidLocator));
    }

    public final void configureVICs(Consumer<VIC> action) {
        this.executeInPlayerThread("Configure VICs", () -> this.c64.configureVICs(action));
    }

    public final void configureSIDs(BiConsumer<Integer, SIDEmu> action) {
        this.executeInPlayerThread("Configure SIDs", () -> this.c64.configureSIDs(action));
    }

    public final void configureSID(int chipNum, Consumer<SIDEmu> action) {
        this.executeInPlayerThread("Configure SID", () -> this.c64.configureSID(chipNum, action));
    }

    public final void configureMixer(Consumer<Mixer> action) {
        this.executeInPlayerThread("Configure Mixer", () -> {
            if (this.sidBuilder instanceof Mixer) {
                action.accept((Mixer)((Object)this.sidBuilder));
            }
        });
    }

    private void executeInPlayerThread(String eventName, Runnable runnable) {
        if (Thread.currentThread().equals(this.playerThread)) {
            runnable.run();
        } else {
            this.c64.getEventScheduler().scheduleThreadSafe(Event.of(eventName, event -> runnable.run()));
        }
    }

    @Override
    public final void reset() {
        IEmulationSection emulationSection = this.config.getEmulationSection();
        super.reset();
        if (emulationSection.getUltimate64Mode() != Ultimate64Mode.OFF && this.tune == SidTune.RESET) {
            this.sendReset(this.config, this.tune);
        }
        this.c64.getEventScheduler().schedule(Event.of("Auto-start", event -> {
            if (this.tune != SidTune.RESET) {
                Integer driverAddress = this.tune.placeProgramInMemory(this.c64.getRAM());
                if (driverAddress != null) {
                    if (emulationSection.getUltimate64Mode() != Ultimate64Mode.OFF) {
                        this.sendRamAndSys(this.config, this.tune, this.c64.getRAM(), driverAddress);
                    }
                    if (emulationSection.getUltimate64Mode() != Ultimate64Mode.STANDALONE) {
                        this.c64.setPlayAddr(this.playAddrHook.apply(this.tune.getInfo().getPlayAddr()));
                        this.c64.getCPU().forcedJump(driverAddress);
                    }
                } else {
                    int loadAddr = this.tune.getInfo().getLoadAddr();
                    if (emulationSection.getUltimate64Mode() != Ultimate64Mode.OFF) {
                        if (loadAddr == 2049) {
                            this.sendRamAndRun(this.config, this.tune, this.c64.getRAM());
                        } else {
                            this.sendRamAndSys(this.config, this.tune, this.c64.getRAM(), loadAddr);
                        }
                    }
                    String string = loadAddr == 2049 ? RUN : (this.command = loadAddr >= 2049 ? String.format(SYS, loadAddr) : null);
                }
            }
            if (this.command != null) {
                if (this.command.startsWith(LOAD)) {
                    this.datasette.control(Datasette.Control.START);
                }
                if (emulationSection.getUltimate64Mode() != Ultimate64Mode.STANDALONE) {
                    this.typeInCommand(this.command);
                }
                if (emulationSection.getUltimate64Mode() != Ultimate64Mode.OFF && this.tune == SidTune.RESET) {
                    this.sendWait(this.config, 300);
                    this.sendCommand(this.config, this.command);
                }
            }
            this.c64.getEventScheduler().schedule(Event.of("PSID64 Detection", event2 -> {
                this.autodetectPSID64();
                this.c64.getEventScheduler().schedule((Event)event2, (long)this.c64.getClock().getCpuFrequency());
            }), (long)this.c64.getClock().getCpuFrequency());
        }), SidTune.getInitDelay(this.tune));
    }

    public final void typeInCommand(String multiLineCommand) {
        String command;
        if (multiLineCommand.length() > 16) {
            int indexOf;
            int n = 0;
            String[] lines = multiLineCommand.split("\r");
            String[] stringArray = lines;
            int n2 = stringArray.length;
            if (n < n2) {
                String line = stringArray[n];
                byte[] screenRam = CBMCodeUtils.petsciiToScreenRam(line);
                System.arraycopy(screenRam, 0, this.c64.getRAM(), 1264, screenRam.length);
            }
            command = (indexOf = multiLineCommand.indexOf(13)) != -1 ? multiLineCommand.substring(indexOf) : "\r";
        } else {
            command = multiLineCommand;
        }
        int length = Math.min(command.length(), 16);
        System.arraycopy(command.getBytes(StandardCharsets.US_ASCII), 0, this.c64.getRAM(), 631, length);
        this.c64.getRAM()[198] = (byte)length;
    }

    private void setCommand(String command) {
        this.command = command;
    }

    public final double time() {
        EventScheduler c = this.c64.getEventScheduler();
        long initDelay = SidTune.getInitDelay(this.tune);
        return (double)(c.getTime(Event.Phase.PHI2) - initDelay) / c.getCyclesPerSecond();
    }

    public final PlayList getPlayList() {
        return this.playList;
    }

    public final Timer getTimer() {
        return this.timer;
    }

    public final SidTune getTune() {
        return this.tune;
    }

    public final void setTune(SidTune tune) {
        this.tune = tune;
    }

    public final synchronized void startC64() {
        if (this.playerThread == null || !this.playerThread.isAlive()) {
            this.playerThread = new Thread(this.playerRunnable, "Player");
            this.playerThread.setPriority(10);
            this.playerThread.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
            this.playerThread.start();
        }
    }

    public final void stopC64() {
        this.stopC64(true);
    }

    public final synchronized void stopC64(boolean quitOrWait) {
        try {
            while (this.playerThread != null && this.playerThread.isAlive()) {
                if (quitOrWait) {
                    this.quit();
                }
                this.playerThread.join(1000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void setMenuHook(Consumer<Player> menuHook) {
        this.menuHook = menuHook;
    }

    public final void setInteractivityHook(Consumer<Player> interactivityHook) {
        this.interactivityHook = interactivityHook;
    }

    public Consumer<MusicInfoWithConfidenceBean> getWhatsSidHook() {
        return this.whatsSidHook;
    }

    public void setWhatsSidHook(Consumer<MusicInfoWithConfidenceBean> whatsSidHook) {
        this.whatsSidHook = whatsSidHook;
    }

    public void setPlayAddrHook(Function<Integer, Integer> playAddrHook) {
        this.playAddrHook = playAddrHook;
    }

    public final ObjectProperty<State> stateProperty() {
        return this.stateProperty;
    }

    private void open() throws IOException, LineUnavailableException, InterruptedException {
        ISidPlay2Section sidplay2Section = this.config.getSidplay2Section();
        IEmulationSection emulationSection = this.config.getEmulationSection();
        IAudioSection audioSection = this.config.getAudioSection();
        this.fastForwardVICFrames = 0;
        this.playList.prepare();
        this.stateProperty.addListener(this.pauseListener);
        this.setClock(CPUClock.getCPUClock(emulationSection, this.tune));
        this.reset();
        if (this.getAudio() != null) {
            this.setAudioAndDriver(audioSection.getAudio(), audioSection.getAudio().getAudioDriver(audioSection, this.tune));
        }
        this.timer.setStart(sidplay2Section.getStartTime());
        this.timer.setDefaultLength(this.config.getSidplay2Section().getDefaultPlayLength());
        this.verifyConfiguration();
        this.timer.reset(this.tune);
        if (this.getAudioDriver() instanceof VideoDriver) {
            this.addVideoDriver((VideoDriver)((Object)this.getAudioDriver()));
        }
        if (this.getAudioDriver() instanceof SIDListener) {
            this.addSidListener((SIDListener)((Object)this.getAudioDriver()));
        }
        if (this.getAudioDriver() instanceof IMOS6510Extension) {
            this.addMOS6510Extension((IMOS6510Extension)((Object)this.getAudioDriver()));
        }
        this.getAudioDriver().open(audioSection, this.getRecordingFilename(), this.c64.getClock(), this.c64.getEventScheduler());
        this.sidBuilder = this.createSIDBuilder(this.c64.getClock());
        if (this.sidBuilder instanceof SIDMixer) {
            SIDMixer sidMixer = (SIDMixer)((Object)this.sidBuilder);
            sidMixer.setAudioDriver(this.getAudioDriver());
            this.whatsSidEvent = new WhatsSidEvent(this, sidMixer.getWhatsSidSupport());
        }
    }

    private SIDBuilder createSIDBuilder(CPUClock cpuClock) {
        switch (Engine.getEngine(this.config.getEmulationSection(), this.tune)) {
            case EMULATION: {
                return new ReSIDBuilder(this.c64.getEventScheduler(), this.config, cpuClock, this.c64.getCartridge());
            }
            case NETSID: {
                return new NetSIDDevBuilder(this.c64.getEventScheduler(), this.config, cpuClock);
            }
            case HARDSID: {
                return new JHardSIDBuilder(this.c64.getEventScheduler(), this.config, cpuClock);
            }
            case USBSID: {
                return new JUSBSIDBuilder(this.c64.getEventScheduler(), this.config, cpuClock);
            }
            case SIDBLASTER: {
                return new JSIDBlasterBuilder(this.c64.getEventScheduler(), this.config, cpuClock);
            }
            case EXSID: {
                return new JExSIDBuilder(this.c64.getEventScheduler(), this.config, cpuClock);
            }
            case HARDSID_DLL: {
                return new HardSIDBuilder(this.c64.getEventScheduler(), this.config, cpuClock);
            }
        }
        throw new RuntimeException("Unknown engine type: " + (Object)((Object)this.config.getEmulationSection().getEngine()));
    }

    public SIDBuilder getSidBuilder() {
        return this.sidBuilder;
    }

    private void verifyConfiguration() {
        if (this.checkDefaultLengthInRecordMode && this.getAudioDriver().isRecording() && this.getSidDatabaseInfo(db -> db.getSongLength(this.tune), 0.0) == 0.0 && this.config.getSidplay2Section().getDefaultPlayLength() == 0.0) {
            this.timer.setDefaultLength(ISidPlay2SystemProperties.MAX_SONG_LENGTH);
            System.out.println(String.format("Unknown song length in record mode, using %ds", ISidPlay2SystemProperties.MAX_SONG_LENGTH));
        }
        if (this.getAudioDriver().lookup(SIDDumpDriver.class).isPresent() && (this.tune == SidTune.RESET || this.tune.getInfo().getPlayAddr() == 0)) {
            throw new RuntimeException("SIDDump audio driver requires a well-known player address of the tune");
        }
    }

    public Audio getAudio() {
        return this.audioAndDriver.getKey();
    }

    public AudioDriver getAudioDriver() {
        return this.audioAndDriver.getValue();
    }

    public final void setAudioDriver(AudioDriver audioDriver) throws IOException {
        this.setAudioAndDriver(null, audioDriver);
    }

    private void setAudioAndDriver(Audio audio, AudioDriver audioDriver) throws IOException {
        this.audioAndDriver = new AbstractMap.SimpleImmutableEntry<Audio, AudioDriver>(audio, audioDriver);
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.uncaughtExceptionHandler = uncaughtExceptionHandler;
    }

    public void setCheckDefaultLengthInRecordMode(boolean checkDefaultLengthInRecordMode) {
        this.checkDefaultLengthInRecordMode = checkDefaultLengthInRecordMode;
    }

    public void setCheckLoopOffInRecordMode(boolean checkLoopOffInRecordMode) {
        this.checkLoopOffInRecordMode = checkLoopOffInRecordMode;
    }

    public void setForceCheckSongLength(boolean forceCheckSongLength) {
        this.forceCheckSongLength = forceCheckSongLength;
    }

    public void setFirstPlayListEntryIsOne(boolean firstPlayListEntryIsOne) {
        this.firstPlayListEntryIsOne = firstPlayListEntryIsOne;
    }

    private boolean play() throws InterruptedException {
        int bufferSize = this.config.getAudioSection().getBufferSize();
        for (int i = 0; i < bufferSize; ++i) {
            if (this.stateProperty.get() != State.PLAY) continue;
            this.c64.getEventScheduler().clock();
        }
        if (this.stateProperty.get() == State.PAUSE) {
            this.c64.getEventScheduler().clockThreadSafeEvents();
            Thread.sleep(250L);
        }
        return this.stateProperty.get() == State.PLAY || this.stateProperty.get() == State.PAUSE;
    }

    private void close() {
        try {
            this.stateProperty.removeListener(this.pauseListener);
            this.c64.insertSIDChips(this.noSIDs, this.sidLocator);
            if (this.getAudioDriver() instanceof VideoDriver) {
                this.removeVideoDriver((VideoDriver)((Object)this.getAudioDriver()));
            }
            if (this.getAudioDriver() instanceof SIDListener) {
                this.removeSidListener((SIDListener)((Object)this.getAudioDriver()));
            }
            if (this.getAudioDriver() instanceof IMOS6510Extension) {
                this.removeMOS6510Extension((IMOS6510Extension)((Object)this.getAudioDriver()));
            }
            if (this.getAudioDriver() != null && this.getAudioDriver().buffer() != null && (this.getAudioDriver().isRecording() || this.stateProperty.get() != State.QUIT)) {
                try {
                    this.getAudioDriver().write();
                }
                catch (SongEndException songEndException) {
                    // empty catch block
                }
            }
        }
        catch (Throwable e) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, String.format("Exception near close: fn=%s", this.getRecordingFilename()), e);
            } else if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, String.format("Exception near close: %s", e.getMessage()));
            }
        }
        finally {
            if (this.sidBuilder != null) {
                this.sidBuilder.destroy();
            }
            if (this.whatsSidEvent != null) {
                this.whatsSidEvent.setAbort(true);
            }
            if (this.getAudioDriver() != null) {
                this.getAudioDriver().close();
            }
        }
    }

    public final void play(SidTune tune) {
        this.play(tune, null);
    }

    public final void resetC64(String command) {
        this.play(SidTune.RESET, command);
    }

    private void play(SidTune tune, String command) {
        if (this.stateProperty().get() != State.OPEN) {
            this.stopC64();
            this.setTune(tune);
            this.setCommand(command);
            this.startC64();
        }
    }

    public final void pauseContinue() {
        if (this.stateProperty.get() == State.QUIT || this.stateProperty.get() == State.END) {
            this.play(this.tune);
        } else {
            this.executeInPlayerThread("PauseContinue", () -> {
                if (this.stateProperty.get() == State.PAUSE) {
                    this.stateProperty.set(State.PLAY);
                } else {
                    this.stateProperty.set(State.PAUSE);
                }
            });
        }
    }

    public final void nextSong() {
        this.executeInPlayerThread("Play next song", () -> {
            this.playList.next();
            this.stateProperty.set(State.RESTART);
        });
    }

    public final void previousSong() {
        this.executeInPlayerThread("Play previous song", () -> {
            if (this.time() < 4.0) {
                this.playList.previous();
            }
            this.stateProperty.set(State.RESTART);
        });
    }

    public final void firstSong() {
        this.executeInPlayerThread("Play first song", () -> {
            this.playList.first();
            this.stateProperty.set(State.RESTART);
        });
    }

    public final void lastSong() {
        this.executeInPlayerThread("Play last song", () -> {
            this.playList.last();
            this.stateProperty.set(State.RESTART);
        });
    }

    public final <T> T getMixerInfo(Function<Mixer, T> function, T defaultValue) {
        return this.sidBuilder instanceof Mixer ? function.apply((Mixer)((Object)this.sidBuilder)) : defaultValue;
    }

    public final void quit() {
        this.executeInPlayerThread("Quit", () -> this.stateProperty.set(State.QUIT));
        if (this.config.getEmulationSection().getUltimate64Mode() != Ultimate64Mode.OFF) {
            this.sendReset(this.config, this.tune);
        }
    }

    public final void setSidDatabase(SidDatabase sidDatabase) {
        this.sidDatabase = sidDatabase;
    }

    public final <T> T getSidDatabaseInfo(Function<SidDatabase, T> function, T defaultValue) {
        return this.sidDatabase != null ? function.apply(this.sidDatabase) : defaultValue;
    }

    public final void setSTIL(STIL stil) {
        this.stil = stil;
    }

    public final STIL.STILEntry getStilEntry(String collectionName) {
        return this.stil != null && collectionName != null ? this.stil.getSTILEntry(collectionName) : null;
    }

    public String getRecordingFilename() {
        AudioDriver audioDriver = this.getAudioDriver();
        if (audioDriver.getExtension() != null) {
            return this.recordingFilenameProvider.apply(this.tune) + audioDriver.getExtension();
        }
        return this.recordingFilenameProvider.apply(this.tune);
    }

    public final void setRecordingFilenameProvider(Function<SidTune, String> recordingFilenameProvider) {
        this.recordingFilenameProvider = recordingFilenameProvider;
    }

    public void addVideoDriver(VideoDriver consumer) {
        if (!this.videoDrivers.contains(consumer)) {
            this.videoDrivers.add(consumer);
        }
    }

    public void removeVideoDriver(VideoDriver consumer) {
        this.videoDrivers.remove(consumer);
    }

    public void addSidListener(SIDListener consumer) {
        if (!this.sidListeners.contains(consumer)) {
            this.sidListeners.add(consumer);
        }
    }

    public void removeSidListener(SIDListener consumer) {
        this.sidListeners.remove(consumer);
    }

    public void addMOS6510Extension(IMOS6510Extension mos6510Extension) {
        if (!this.mos6510Extensions.contains(mos6510Extension)) {
            this.mos6510Extensions.add(mos6510Extension);
        }
    }

    public void removeMOS6510Extension(IMOS6510Extension mos6510Extension) {
        this.mos6510Extensions.remove(mos6510Extension);
    }

    @Override
    public void accept(VIC vic) {
        int fastForwardBitMask = this.getMixerInfo(m -> m.getFastForwardBitMask(), 0);
        if ((this.fastForwardVICFrames++ & fastForwardBitMask) == fastForwardBitMask) {
            Iterator<VideoDriver> iterator = this.videoDrivers.iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(vic);
            }
        }
    }

    @Override
    public void write(int addr, byte data) {
        Iterator<SIDListener> iterator = this.sidListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().write(addr, data);
        }
    }

    @Override
    public void jmpJsr() {
        Iterator<IMOS6510Extension> iterator = this.mos6510Extensions.iterator();
        while (iterator.hasNext()) {
            iterator.next().jmpJsr();
        }
    }

    private void autodetectPSID64() {
        PSid64DetectedTuneInfo psid64TuneInfo;
        IEmulationSection emulationSection = this.config.getEmulationSection();
        if (emulationSection.isDetectPSID64ChipModel() && (psid64TuneInfo = PSid64Detection.detectPSid64TuneInfo(this.c64.getRAM(), this.c64.getVicMemBase() + this.c64.getVIC().getVideoMatrixBase())).isDetected()) {
            this.psid64Detected = true;
            boolean update = false;
            if (psid64TuneInfo.hasDifferentUserChipModel(ChipModel.getChipModel(emulationSection, this.tune, 0))) {
                emulationSection.getOverrideSection().getSidModel()[0] = psid64TuneInfo.getUserChipModel();
                update = true;
            }
            if (psid64TuneInfo.hasDifferentStereoChipModel(ChipModel.getChipModel(emulationSection, this.tune, 1))) {
                emulationSection.getOverrideSection().getSidModel()[1] = psid64TuneInfo.getStereoChipModel();
                update = true;
            }
            if (psid64TuneInfo.hasDifferentStereoAddress(SidTune.getSIDAddress(emulationSection, this.tune, 1))) {
                emulationSection.getOverrideSection().getSidBase()[1] = psid64TuneInfo.getStereoAddress();
                update = true;
            }
            if (update) {
                this.updateSIDChipConfiguration();
            }
        }
    }

    public boolean isPsid64Detected() {
        return this.psid64Detected;
    }

    public final String getCredits(String version) {
        StringBuffer credits = new StringBuffer();
        credits.append("Operating System:\n");
        credits.append((Object)((Object)OS.get()) + "\n");
        credits.append("\nJava version:\n");
        credits.append(System.getProperty("java.runtime.version"));
        credits.append("\n" + System.getProperty("sun.arch.data.model") + " bits");
        credits.append("\n\nJava Version and User Interface v");
        credits.append(version);
        credits.append(":\n");
        credits.append("\tCopyright (\u00a9) 2007-" + LAST_MODIFIED.get(1) + " Ken H\u00e4ndel\n");
        credits.append("\thttp://sourceforge.net/projects/jsidplay2/\n");
        credits.append("Distortion Simulation and development: Antti S. Lankila\n");
        credits.append("\thttp://bel.fi/~alankila/c64-sw/\n");
        credits.append("Testing and Feedback: Nata, founder of proNoise\n");
        credits.append("\thttp://www.nata.netau.net/\n");
        credits.append("Source code originally based on libsidplay v2.1.1 and ReSID v0.0.2 engine:\n");
        credits.append("\tCopyright (\u00a9) 1999-2002 Simon White <sidplay2@yahoo.com>\n");
        credits.append("\thttp://sidplay2.sourceforge.net\n");
        credits.append("SIDv4E (proprietary SID file format+ used for multi-SID tunes)\n");
        credits.append("\tCopyright (\u00a9) 2019 J\u00fcrgen Wothke\n");
        credits.append("Icon used from Wikimedia\n");
        credits.append("\tCreative Commons License Attribution-ShareAlike 3.0 Unported (CC BY-SA 3.0)\n");
        credits.append("\thttps://creativecommons.org/licenses/by-sa/3.0/legalcode\n");
        credits.append("Network SID Device:\n");
        credits.append("\tCopyright (\u00a9) 2011 Antti S. Lankila <alankila@bel.fi>\n");
        credits.append("\tSupported by Wilfred Bos, The Netherlands\n");
        credits.append("\thttp://www.acid64.com\n");
        credits.append("WhatsSID? (tune recognition)\n");
        credits.append("\tCopyright (\u00a9) 2020 Ken H\u00e4ndel\n");
        credits.append("Based on Audio Fingerprinting\n");
        credits.append("\tCopyright (\u00a9) 2015-2019 J. Pery\n");
        credits.append("\thttps://github.com/JPery/Audio-Fingerprinting\n");
        credits.append("Forked from Audio-Fingerprinting:\n");
        credits.append("\tCopyright (\u00a9) 2015 hsyecheng <hsyecheng@hotmail.com>\n");
        credits.append("\thttps://github.com/hsyecheng/Audio-Fingerprinting\n");
        credits.append("jump3r (MP3 encoder/decoder)\n");
        credits.append("\tCopyright (\u00a9) 2010-2011 Ken H\u00e4ndel\n");
        credits.append("\thttp://sourceforge.net/projects/jsidplay2/\n");
        credits.append("Based on Lame (Lame Aint an MP3 Encoder v3.98.4)\n");
        credits.append("\thttps://sourceforge.net/projects/lame/\n");
        credits.append("Assembly64:\n");
        credits.append("\tCopyright (\u00a9) " + LAST_MODIFIED.get(1) + " Fredrik \u00c5berg\n");
        credits.append("\thttps://hackerswithstyle.se/assembly/\n");
        credits.append("GB64 (We use the database of Game Base 64)\n");
        credits.append("\thttp://www.gb64.com/\n");
        credits.append("JCommander (Command Line Parser):\n");
        credits.append("\tCopyright (\u00a9) 2010-2014 C\u00e9dric Beust\n");
        credits.append("\thttp://jcommander.org/\n");
        credits.append("Xuggler (Audio/Video Encoder):\n");
        credits.append("\tCopyright (\u00a9) 2011 and All Rights Reserved by ConnectSolutions, LLC.\n");
        credits.append("\thttp://www.xuggle.com/xuggler/\n");
        credits.append("MP3 downloads from Stone Oakvalley's Authentic SID MusicCollection (SOASC=):\n");
        credits.append("\thttp://www.6581-8580.com/\n");
        credits.append("Kickassembler (6510 cross assembler):\n");
        credits.append("\tCopyright (\u00a9) 2006-" + LAST_MODIFIED.get(1) + " Mads Nielsen\n");
        credits.append("\thttp://www.theweb.dk/KickAssembler/\n");
        credits.append("PSID64 (PSID to PRG converter v0.9):\n");
        credits.append("\tCopyright (\u00a9) 2001-2007 Roland Hermans\n");
        credits.append("\thttp://sourceforge.net/projects/psid64/\n");
        credits.append("Pucrunch (An Optimizing Hybrid LZ77 RLE Data Compression Program):\n");
        credits.append("\tCopyright (\u00a9) 1997-2008 Pasi 'Albert' Ojala\n");
        credits.append("\thttp://www.cs.tut.fi/~albert/Dev/pucrunch/\n");
        credits.append("SIDDump (SID dump file v1.04):\n");
        credits.append("\tCopyright (\u00a9) 2007 Lasse \u00d6\u00f6rni\n");
        credits.append("SIDId (HVSC playroutine identity scanner v1.07):\n");
        credits.append("\tCopyright (\u00a9) 2007 Lasse \u00d6\u00f6rni\n");
        credits.append("HVMEC (High Voltage Music Engine Collection v1.0):\n");
        credits.append("\tCopyright (\u00a9) 2011 by Stefano Tognon and Stephan Parth\n");
        credits.append("FMOPL (FM sound generator types OPL and OPL2 v0.72):\n");
        credits.append("\tJava version by Daniel Becker Copyright (\u00a9) 2020\n");
        credits.append("Based on MAME (multi-purpose emulation framework)\n");
        credits.append("\tCopyright (\u00a9) 2020 by Jarek Burczynski and Tatsuyuki Satoh\n");
        credits.append("\thttps://www.mamedev.org/\n");
        credits.append("C1541 Floppy Disk Drive Emulation:\n");
        credits.append("\tCopyright (\u00a9) 2010 VICE (the Versatile Commodore Emulator)\n");
        credits.append("\thttp://www.viceteam.org/\n");
        credits.append("JiffyDOS ROMs:\n");
        credits.append("\tCopyright (\u00a9) by CMD Software\n");
        credits.append("\thttp://cmdweb.com\n");
        credits.append("\tLicense can be obtained at https://restore-store.de\n");
        credits.append(MOS6510.credits());
        credits.append(MOS6526.credits());
        credits.append(VIC.credits());
        credits.append(ReSID.credits());
        credits.append(ReSIDfp.credits());
        credits.append(NetSIDDev.credits());
        credits.append(ExSIDEmu.credits());
        credits.append(SIDBlasterEmu.credits());
        credits.append(JHardSIDEmu.credits());
        return credits.toString();
    }

    public static void main(String[] args) throws IOException, SidTuneError {
        if (args.length < 1) {
            System.err.println("Missing argument: <filename>");
            System.exit(-1);
        }
        SidTune tune = SidTune.load(new File(args[0]));
        Player player = new Player(new IniConfig());
        player.play(tune);
    }

    static {
        try {
            URL us = Player.class.getProtectionDomain().getCodeSource().getLocation();
            LAST_MODIFIED = Calendar.getInstance();
            LAST_MODIFIED.setTime(new Date(us.openConnection().getLastModified()));
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

