/*
 * Decompiled with CFR 0.152.
 */
package com.ftdi;

import com.ftdi.AbstractDataHandler;
import com.ftdi.DeviceStatus;
import com.ftdi.FTD2XXException;
import com.ftdi.FTDevice;
import java.util.EnumSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventNotificationHandler<T>
extends AbstractDataHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractEventNotificationHandler.class);
    protected T eventHandle;

    @Override
    protected int readData(FTDevice ftDevice) throws FTD2XXException {
        int available;
        int len = -1;
        int[] status = ftDevice.getStatus();
        if ((status[2] & 2) == 2) {
            LOGGER.info("Received modem or line status event: {}", (Object)status[2]);
            EnumSet<DeviceStatus> deviceStatusSet = ftDevice.getDeviceStatus();
            if (deviceStatusSet.contains((Object)DeviceStatus.CTS)) {
                LOGGER.info(">>>> CTS is high.");
            } else {
                LOGGER.info(">>>> CTS is low.");
            }
            if (deviceStatusSet.contains((Object)DeviceStatus.DSR)) {
                LOGGER.info(">>>> DSR is high.");
            } else {
                LOGGER.info(">>>> DSR is low.");
            }
        }
        if ((available = status[0]) > 0) {
            len = ftDevice.read(this.inputBuffer, 0, available);
            LOGGER.info("Read len: {}", (Object)len);
        }
        return len;
    }

    protected void setEventHandle(T eventHandle) {
        this.eventHandle = eventHandle;
    }
}

