/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.valueholder;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.expressions.refexpr.ReferenceOperation;
import kickass.pass.sideeffect.SESymbolAssignment;
import kickass.pass.valueholder.IValueHolder;
import kickass.pass.values.InvalidUnlockedSideEffectValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ValueHolder
implements IValueHolder {
    private boolean recordSideEffect;
    private Value value;
    private ReferenceOperation allowedOperations;

    public ValueHolder(Value value, ReferenceOperation referenceOperation, boolean bl) {
        this.value = value;
        this.allowedOperations = referenceOperation;
        this.recordSideEffect = bl;
    }

    @Override
    public Value get(EvaluationState evaluationState, SourceRange sourceRange) {
        if (this.value == null) {
            throw new AsmErrorException("Symbol is not yet initialized", sourceRange);
        }
        return this.value;
    }

    @Override
    public Value getWithoutSideeffect() {
        return this.value;
    }

    @Override
    public void set(Value value, EvaluationState evaluationState, SourceRange sourceRange) {
        if (!this.allowedOperations.write()) {
            throw new AsmErrorException("Cannot write to a constant", sourceRange);
        }
        this.value = value;
        if (value.isInvalidOrInvalidContent()) {
            evaluationState.sideeffectMgr.setInvalidSideEffectsDuringFunctionEvaluation();
        }
        if (this.recordSideEffect) {
            Value value2 = value.isLocked() ? value : new InvalidUnlockedSideEffectValue(sourceRange);
            evaluationState.sideeffectMgr.addSideEffect(new SESymbolAssignment(value2, this));
        }
    }

    @Override
    public void setWithoutSideEffect(Value value) {
        this.value = value;
    }
}

