/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.mainparse.tailparsers;

import java.io.IOException;
import kickass.nonasm.util.functions.Func4;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.ITokenStream;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.mainparse.tailparsers.ITailParser;
import kickass.parsing.script.ExprParser;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.expressions.expr.ExprNode;
import kickass.state.EvaluationState;

public class PcBodyParser
implements ITailParser<AsmNode> {
    private Func4<ExprNode, String, Boolean, SourceRange, AsmNode> nodeCreator;

    public PcBodyParser(Func4<ExprNode, String, Boolean, SourceRange, AsmNode> func4) {
        this.nodeCreator = func4;
    }

    @Override
    public AsmNode parse(IToken iToken, SourceRange sourceRange, ITokenStream iTokenStream, EvaluationState evaluationState) throws IOException {
        TokenStreamList tokenStreamList = iTokenStream.getUntilSemiOrNlSkipWs();
        if (iToken.getType() != TokenType.TimesEqual && tokenStreamList.expectType(TokenType.Assign, evaluationState) == null) {
            return null;
        }
        boolean bl = false;
        int n = tokenStreamList.getReverseIndex();
        IToken iToken2 = tokenStreamList.reverseNext();
        if (iToken2.isId("virtual")) {
            bl = true;
            n = tokenStreamList.getReverseIndex();
        }
        tokenStreamList.setReverseIndexs(n);
        String string = null;
        IToken iToken3 = tokenStreamList.reverseNext();
        if (iToken3.getType() == TokenType.StringQuote) {
            string = iToken3.getStringValue();
            n = tokenStreamList.getReverseIndex();
        }
        tokenStreamList.setReverseIndexs(n);
        ExprNode exprNode = ExprParser.parse(tokenStreamList, evaluationState);
        if (exprNode == null) {
            return null;
        }
        return this.nodeCreator.apply(exprNode, string, bl, sourceRange);
    }
}

