/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.asmnode.metanodes.ScopeNode;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.sideeffect.SideEffect;
import kickass.pass.values.LabelValue;
import kickass.pass.values.ScopeIfSelectorValue;
import kickass.pass.values.ScopeValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.FunctionSideOutput;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.ISymbolTable;

public class IfDirective
extends Directive
implements ILabelConnectorNode {
    private ExprNode conditionExpr;
    private AsmNode trueBody;
    private AsmNode falseBody;
    private SymbolScope trueScope;
    private SymbolScope falseScope;
    private String labelId;
    private boolean conditionDone = false;
    private FunctionSideOutput conditionSideEffects;
    private AsmNode selectedBody = null;
    private ISymbolPageIdx labelPageIdx;

    public IfDirective(ExprNode exprNode, AsmNode asmNode, AsmNode asmNode2, SourceRange sourceRange) {
        super(sourceRange);
        this.conditionExpr = exprNode;
        this.trueBody = asmNode;
        this.falseBody = asmNode2;
    }

    private IfDirective(IfDirective ifDirective) {
        super(ifDirective.range);
        this.conditionExpr = ifDirective.conditionExpr;
        this.trueBody = ifDirective.trueBody.copy();
        this.falseBody = ifDirective.falseBody == null ? null : ifDirective.falseBody.copy();
        this.labelId = ifDirective.labelId;
        this.labelPageIdx = ifDirective.labelPageIdx;
        this.trueScope = ifDirective.trueScope;
        this.falseScope = ifDirective.falseScope;
    }

    @Override
    public AsmNode copy() {
        return new IfDirective(this);
    }

    @Override
    public boolean connectToLabel(ILabelNode iLabelNode) {
        this.labelId = iLabelNode.getName();
        return true;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        SymbolScope symbolScope = evaluationState.scopeMgr.getCurrentScope();
        this.trueScope = new SymbolScope(symbolScope, null);
        this.trueBody = new ScopeNode(this.trueBody, this.trueScope);
        this.trueBody = this.trueBody.executeMetaRegistrations(evaluationState);
        this.falseScope = new SymbolScope(symbolScope, null);
        if (this.falseBody != null) {
            this.falseBody = new ScopeNode(this.falseBody, this.falseScope);
            this.falseBody = this.falseBody.executeMetaRegistrations(evaluationState);
        }
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.scopeMgr.resolveSymbol(this.labelId);
            this.labelPageIdx.replaceInitializer(LabelValue.getInitializer(evaluationState, () -> new ScopeIfSelectorValue()));
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.conditionExpr.executePrepass(evaluationState);
        this.trueBody = this.trueBody.executePrepass(evaluationState);
        if (this.falseBody != null) {
            this.falseBody = this.falseBody.executePrepass(evaluationState);
        }
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        if (this.conditionDone) {
            this.execSideEffects(this.conditionSideEffects, evaluationState);
        } else {
            evaluationState.sideeffectMgr.clearFunctionSideOutput();
            Value value = this.conditionExpr.evaluate(evaluationState);
            if (value.isInvalid()) {
                throw new AsmErrorException("The condition must be able to evaluate in first parse", this.range);
            }
            boolean bl = value.getBoolean(this.range);
            AsmNode asmNode = this.selectedBody = bl ? this.trueBody : this.falseBody;
            if (this.selectedBody == null) {
                this.selectedBody = EmptyOutput.instance;
            }
            if (this.labelPageIdx != null) {
                SymbolScope symbolScope = bl ? this.trueScope : this.falseScope;
                ISymbolTable iSymbolTable = symbolScope.getSymbolTable();
                ScopeValue scopeValue = new ScopeValue(symbolScope, iSymbolTable.getCurrentPage());
                LabelValue labelValue = (LabelValue)this.labelPageIdx.getValueHolder().getWithoutSideeffect();
                ScopeIfSelectorValue scopeIfSelectorValue = (ScopeIfSelectorValue)labelValue.getConnectedValue();
                scopeIfSelectorValue.setIfExecuted(bl, scopeValue);
            }
            if (!evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
                this.conditionDone = true;
                this.conditionSideEffects = evaluationState.sideeffectMgr.getFunctionSideOutput();
            }
        }
        this.selectedBody = this.selectedBody.executePass(evaluationState);
        if (this.conditionDone && this.conditionSideEffects == null) {
            return this.selectedBody;
        }
        return this;
    }

    private void execSideEffects(FunctionSideOutput functionSideOutput, EvaluationState evaluationState) {
        if (functionSideOutput != null) {
            for (SideEffect sideEffect : functionSideOutput.getSideEffects()) {
                sideEffect.evaluate(evaluationState, this.range);
            }
        }
    }

    @Override
    public boolean isFinished() {
        return this.selectedBody != null && this.selectedBody.isFinished();
    }
}

