/*
 * Decompiled with CFR 0.152.
 */
package sidplay.ini;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import libsidplay.config.ISidPlay2Section;
import sidplay.ini.IniDefaults;
import sidplay.ini.IniReader;
import sidplay.ini.IniSection;
import sidplay.ini.converter.BeanToStringConverter;
import sidplay.ini.converter.FileToStringConverter;
import sidplay.ini.converter.ParameterTimeConverter;

@Parameters(resourceBundle="sidplay.ini.IniSidplay2Section")
public class IniSidplay2Section
extends IniSection
implements ISidPlay2Section {
    private static final String SECTION_ID = "SIDPlay2";

    protected IniSidplay2Section(IniReader ini) {
        super(ini);
    }

    @Override
    public final int getVersion() {
        return this.iniReader.getPropertyInt(SECTION_ID, "Version", 25);
    }

    @Override
    public final void setVersion(int version) {
        this.iniReader.setProperty(SECTION_ID, "Version", version);
    }

    @Override
    public final boolean isEnableDatabase() {
        return this.iniReader.getPropertyBool(SECTION_ID, "EnableDatabase", IniDefaults.DEFAULT_ENABLE_DATABASE);
    }

    @Override
    @Parameter(names={"--enableSidDatabase", "-n", "--enableDatabase"}, descriptionKey="ENABLE_SID_DATABASE", arity=1, order=0)
    public final void setEnableDatabase(boolean enable) {
        this.iniReader.setProperty(SECTION_ID, "EnableDatabase", enable);
    }

    @Override
    public final double getStartTime() {
        return this.iniReader.getPropertyTime(SECTION_ID, "Start Time", IniDefaults.DEFAULT_START_TIME);
    }

    @Override
    @Parameter(names={"--startTime", "-t"}, descriptionKey="START_TIME", converter=ParameterTimeConverter.class, order=1)
    public final void setStartTime(double startTime) {
        String time = new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(startTime * 1000.0)));
        this.iniReader.setProperty(SECTION_ID, "Start Time", time);
    }

    @Override
    public final double getDefaultPlayLength() {
        return this.iniReader.getPropertyTime(SECTION_ID, "Default Play Length", IniDefaults.DEFAULT_PLAY_LENGTH);
    }

    @Override
    @Parameter(names={"--defaultLength", "-g", "--defaultPlayLength"}, descriptionKey="DEFAULT_LENGTH", converter=ParameterTimeConverter.class, order=2)
    public final void setDefaultPlayLength(double playLength) {
        String time = new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(playLength * 1000.0)));
        this.iniReader.setProperty(SECTION_ID, "Default Play Length", time);
    }

    @Override
    public final double getFadeInTime() {
        return this.iniReader.getPropertyTime(SECTION_ID, "Fade In Time", IniDefaults.DEFAULT_FADE_IN_TIME);
    }

    @Override
    @Parameter(names={"--fadeIn", "--fadeInTime"}, descriptionKey="FADE_IN", converter=ParameterTimeConverter.class, order=3)
    public final void setFadeInTime(double fadeInTime) {
        String time = new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(fadeInTime * 1000.0)));
        this.iniReader.setProperty(SECTION_ID, "Fade In Time", time);
    }

    @Override
    public final double getFadeOutTime() {
        return this.iniReader.getPropertyTime(SECTION_ID, "Fade Out Time", IniDefaults.DEFAULT_FADE_OUT_TIME);
    }

    @Override
    @Parameter(names={"--fadeOut", "--fadeOutTime"}, descriptionKey="FADE_OUT", converter=ParameterTimeConverter.class, order=4)
    public final void setFadeOutTime(double fadeOutTime) {
        String time = new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(fadeOutTime * 1000.0)));
        this.iniReader.setProperty(SECTION_ID, "Fade Out Time", time);
    }

    @Override
    public final boolean isLoop() {
        return this.iniReader.getPropertyBool(SECTION_ID, "Loop", IniDefaults.DEFAULT_LOOP);
    }

    @Override
    @Parameter(names={"--loop", "-l"}, descriptionKey="LOOP", arity=1, order=5)
    public final void setLoop(boolean loop) {
        this.iniReader.setProperty(SECTION_ID, "Loop", loop);
    }

    @Override
    public final boolean isSingle() {
        return this.iniReader.getPropertyBool(SECTION_ID, "SingleTrack", IniDefaults.DEFAULT_SINGLE_TRACK);
    }

    @Override
    @Parameter(names={"--single", "-s"}, descriptionKey="SINGLE", arity=1, order=6)
    public final void setSingle(boolean singleSong) {
        this.iniReader.setProperty(SECTION_ID, "SingleTrack", singleSong);
    }

    @Override
    public final File getHvsc() {
        return this.iniReader.getPropertyFile(SECTION_ID, "HVSC Dir", IniDefaults.DEFAULT_HVSC_DIR);
    }

    @Override
    @Parameter(names={"--hvsc"}, descriptionKey="HVSC_DIR", converter=FileToStringConverter.class, order=7)
    public final void setHvsc(File hvsc) {
        this.iniReader.setProperty(SECTION_ID, "HVSC Dir", hvsc);
    }

    @Override
    public final File getLastDirectory() {
        return this.iniReader.getPropertyFile(SECTION_ID, "Last Directory", IniDefaults.DEFAULT_LAST_DIR);
    }

    @Override
    public final void setLastDirectory(File lastDir) {
        this.iniReader.setProperty(SECTION_ID, "Last Directory", lastDir);
    }

    @Override
    public final File getTmpDir() {
        return this.iniReader.getPropertyFile(SECTION_ID, "Temp Dir", IniDefaults.DEFAULT_TMP_DIR);
    }

    @Override
    public final void setTmpDir(File tmpDir) {
        this.iniReader.setProperty(SECTION_ID, "Temp Dir", tmpDir);
    }

    @Override
    public final boolean isPalEmulation() {
        return this.iniReader.getPropertyBool(SECTION_ID, "PAL Emulation", IniDefaults.DEFAULT_PAL_EMULATION);
    }

    @Override
    @Parameter(names={"--palEmulation"}, descriptionKey="PAL_EMULATION", arity=1, order=8)
    public final void setPalEmulation(boolean palEmulation) {
        this.iniReader.setProperty(SECTION_ID, "PAL Emulation", palEmulation);
    }

    @Override
    public final float getBrightness() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Brightness", IniDefaults.DEFAULT_BRIGHTNESS);
    }

    @Override
    public final void setBrightness(float brightness) {
        this.iniReader.setProperty(SECTION_ID, "Brightness", Float.valueOf(brightness));
    }

    @Override
    public final float getContrast() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Contrast", IniDefaults.DEFAULT_CONTRAST);
    }

    @Override
    public final void setContrast(float contrast) {
        this.iniReader.setProperty(SECTION_ID, "Contrast", Float.valueOf(contrast));
    }

    @Override
    public final float getGamma() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Gamma", IniDefaults.DEFAULT_GAMMA);
    }

    @Override
    public final void setGamma(float gamma) {
        this.iniReader.setProperty(SECTION_ID, "Gamma", Float.valueOf(gamma));
    }

    @Override
    public final float getSaturation() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Saturation", IniDefaults.DEFAULT_SATURATION);
    }

    @Override
    public final void setSaturation(float saturation) {
        this.iniReader.setProperty(SECTION_ID, "Saturation", Float.valueOf(saturation));
    }

    @Override
    public final float getPhaseShift() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Phase Shift", IniDefaults.DEFAULT_PHASE_SHIFT);
    }

    @Override
    public final void setPhaseShift(float phaseShift) {
        this.iniReader.setProperty(SECTION_ID, "Phase Shift", Float.valueOf(phaseShift));
    }

    @Override
    public final float getOffset() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Offset", IniDefaults.DEFAULT_OFFSET);
    }

    @Override
    public final void setOffset(float offset) {
        this.iniReader.setProperty(SECTION_ID, "Offset", Float.valueOf(offset));
    }

    @Override
    public final float getTint() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Tint", IniDefaults.DEFAULT_TINT);
    }

    @Override
    public final void setTint(float tint) {
        this.iniReader.setProperty(SECTION_ID, "Tint", Float.valueOf(tint));
    }

    @Override
    public final float getBlur() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Blur", IniDefaults.DEFAULT_BLUR);
    }

    @Override
    public final void setBlur(float blur) {
        this.iniReader.setProperty(SECTION_ID, "Blur", Float.valueOf(blur));
    }

    @Override
    public final float getBleed() {
        return this.iniReader.getPropertyFloat(SECTION_ID, "Bleed", IniDefaults.DEFAULT_BLEED);
    }

    @Override
    public final void setBleed(float bleed) {
        this.iniReader.setProperty(SECTION_ID, "Bleed", Float.valueOf(bleed));
    }

    @Override
    public final boolean isTurboTape() {
        return this.iniReader.getPropertyBool(SECTION_ID, "TurboTape", IniDefaults.DEFAULT_TURBO_TAPE);
    }

    @Override
    @Parameter(names={"--turboTape"}, descriptionKey="TURBO_TAPE", arity=1, order=9)
    public final void setTurboTape(boolean turboTape) {
        this.iniReader.setProperty(SECTION_ID, "TurboTape", turboTape);
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

