/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.Relationship;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.RelationshipCreator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RelationshipBuilder {
    private static final int JOIN_FLAGS = 0x3000000;
    private int _flags = 2;
    private String _fromTable;
    private String _toTable;
    private List<String> _fromCols = new ArrayList<String>();
    private List<String> _toCols = new ArrayList<String>();
    private String _name = null;

    public RelationshipBuilder(Table fromTable, Table toTable) {
        this(fromTable.getName(), toTable.getName());
    }

    public RelationshipBuilder(String fromTable, String toTable) {
        this._fromTable = fromTable;
        this._toTable = toTable;
    }

    public RelationshipBuilder addColumns(String fromCol, String toCol) {
        this._fromCols.add(fromCol);
        this._toCols.add(toCol);
        return this;
    }

    public RelationshipBuilder addColumns(Column fromCol, Column toCol) {
        return this.addColumns(fromCol.getName(), toCol.getName());
    }

    public RelationshipBuilder setReferentialIntegrity() {
        return this.clearFlag(2);
    }

    public RelationshipBuilder setCascadeDeletes() {
        return this.setFlag(4096);
    }

    public RelationshipBuilder setCascadeUpdates() {
        return this.setFlag(256);
    }

    public RelationshipBuilder setCascadeNullOnDelete() {
        return this.setFlag(8192);
    }

    public RelationshipBuilder setJoinType(Relationship.JoinType joinType) {
        this.clearFlag(0x3000000);
        switch (joinType) {
            case INNER: {
                break;
            }
            case LEFT_OUTER: {
                this._flags |= 0x1000000;
                break;
            }
            case RIGHT_OUTER: {
                this._flags |= 0x2000000;
                break;
            }
            default: {
                throw new RuntimeException("unexpected join type " + (Object)((Object)joinType));
            }
        }
        return this;
    }

    public RelationshipBuilder setName(String relationshipName) {
        this._name = relationshipName;
        return this;
    }

    public boolean hasReferentialIntegrity() {
        return !this.hasFlag(2);
    }

    public int getFlags() {
        return this._flags;
    }

    public String getFromTable() {
        return this._fromTable;
    }

    public String getToTable() {
        return this._toTable;
    }

    public List<String> getFromColumns() {
        return this._fromCols;
    }

    public List<String> getToColumns() {
        return this._toCols;
    }

    public String getName() {
        return this._name;
    }

    public Relationship toRelationship(Database db) throws IOException {
        return new RelationshipCreator((DatabaseImpl)db).createRelationship(this);
    }

    private RelationshipBuilder setFlag(int flagMask) {
        this._flags |= flagMask;
        return this;
    }

    private RelationshipBuilder clearFlag(int flagMask) {
        this._flags &= ~flagMask;
        return this;
    }

    private boolean hasFlag(int flagMask) {
        return (this._flags & flagMask) != 0;
    }
}

