/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.stringsearch;

import libsidutils.stringsearch.CharIntMap;
import libsidutils.stringsearch.StringSearch;

public class BNDM
extends StringSearch {
    @Override
    public Object processBytes(byte[] pattern) {
        int end = pattern.length < 32 ? pattern.length : 32;
        int[] b = new int[256];
        int j = 1;
        int i = end - 1;
        while (i >= 0) {
            int n = this.index(pattern[i]);
            b[n] = b[n] | j;
            --i;
            j <<= 1;
        }
        return b;
    }

    @Override
    public Object processChars(char[] pattern) {
        int end = pattern.length < 32 ? pattern.length : 32;
        CharIntMap b = this.createCharIntMap(pattern);
        int j = 1;
        int i = end - 1;
        while (i >= 0) {
            b.set(pattern[i], b.get(pattern[i]) | j);
            --i;
            j <<= 1;
        }
        return b;
    }

    @Override
    public int searchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed) {
        return this.javaSearchBytes(text, textStart, textEnd, pattern, processed);
    }

    private int javaSearchBytes(byte[] text, int textStart, int textEnd, byte[] pattern, Object processed) {
        int last;
        int[] b = (int[])processed;
        for (int pos = textStart; pos <= textEnd - pattern.length; pos += last) {
            int j = pattern.length - 1;
            last = pattern.length;
            for (int d = -1; d != 0; d <<= 1) {
                if ((d &= b[this.index(text[pos + j])]) != 0) {
                    if (j == 0) {
                        return pos;
                    }
                    last = j;
                }
                --j;
            }
        }
        return -1;
    }

    @Override
    public int searchChars(char[] text, int textStart, int textEnd, char[] pattern, Object processed) {
        int last;
        CharIntMap b = (CharIntMap)processed;
        for (int pos = textStart; pos <= textEnd - pattern.length; pos += last) {
            int j = pattern.length - 1;
            last = pattern.length;
            for (int d = -1; d != 0; d <<= 1) {
                if ((d &= b.get(text[pos + j])) != 0) {
                    if (j == 0) {
                        return pos;
                    }
                    last = j;
                }
                --j;
            }
        }
        return -1;
    }
}

