/*
 * Decompiled with CFR 0.152.
 */
package sidblaster.async;

import com.ftdi.FTD2XXException;
import java.util.ArrayList;
import java.util.List;
import sidblaster.Command;
import sidblaster.ISIDBlaster;
import sidblaster.d2xx.SIDBlasterEnumerator;

public class CommandReceiver {
    private final List<ISIDBlaster> devices = new ArrayList<ISIDBlaster>();
    private volatile boolean isReadResultReady;
    private volatile int readResult;
    protected volatile boolean abortSIDWriteThread;

    public CommandReceiver() throws FTD2XXException {
        int deviceCount = SIDBlasterEnumerator.getInstance().deviceCount();
        for (int i = 0; i < deviceCount; ++i) {
            this.devices.add(SIDBlasterEnumerator.getInstance().createInterface(i));
        }
    }

    public void setWriteBufferSize(int bufferSize) {
        for (ISIDBlaster sidBlasterInterface : this.devices) {
            sidBlasterInterface.setWriteBufferSize(bufferSize);
        }
    }

    public void setLatencyTimer(short ms) throws FTD2XXException {
        for (ISIDBlaster sidBlasterInterface : this.devices) {
            sidBlasterInterface.setLatencyTimer(ms);
        }
    }

    public void setAbortSIDWriteThread() {
        this.abortSIDWriteThread = true;
    }

    public int deviceCount() {
        return this.devices.size();
    }

    public boolean isReadResultReady() {
        return this.isReadResultReady;
    }

    public int readResult() {
        this.isReadResultReady = false;
        return this.readResult;
    }

    protected int executeCommand(Command command) throws FTD2XXException, InterruptedException {
        if (command == null || this.devices.isEmpty()) {
            return 0;
        }
        long nanos = command.getDelay();
        if (nanos > 0L) {
            long millis = nanos / 1000000L;
            if (millis > 2L) {
                long toWait = millis - 2L;
                Thread.sleep(toWait);
                nanos -= toWait * 1000000L;
            }
            this.nsleep(nanos);
        }
        boolean bufferedWrites = this.devices.get(0).getWriteBufferSize() > 0;
        int retval = 0;
        int device = command.getDevice();
        if (device >= 0 && device < this.devices.size()) {
            ISIDBlaster sidblaster = this.devices.get(device);
            switch (command.getCommand()) {
                case OpenDevice: {
                    sidblaster.open();
                    break;
                }
                case CloseDevice: {
                    sidblaster.close();
                    break;
                }
                case Write: {
                    if (bufferedWrites) {
                        sidblaster.bufferWrite(command.getReg(), command.getData());
                        break;
                    }
                    sidblaster.write(command.getReg(), command.getData());
                    break;
                }
                case Read: {
                    byte data = sidblaster.read(command.getReg());
                    this.readResult = data & 0xFF | data << 8 & 0xFF00;
                    this.isReadResultReady = true;
                    break;
                }
                case Mute: {
                    sidblaster.mute(command.getReg());
                    break;
                }
                case MuteAll: {
                    sidblaster.muteAll();
                    break;
                }
                case Sync: {
                    sidblaster.sync();
                    break;
                }
                case SoftFlush: {
                    sidblaster.softFlush();
                    break;
                }
                case Flush: {
                    sidblaster.flush();
                    break;
                }
                case Reset: {
                    sidblaster.reset();
                    break;
                }
            }
        }
        return retval;
    }

    private void nsleep(long delayNs) {
        long start = System.nanoTime();
        while (start + delayNs >= System.nanoTime()) {
        }
    }

    public void uninitialize() {
        for (ISIDBlaster sidBlasterInterface : this.devices) {
            SIDBlasterEnumerator.getInstance().releaseInterface(sidBlasterInterface);
        }
        this.devices.clear();
    }
}

