/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum Cmd {
    WRITE(0),
    READ(1),
    CYCLED_WRITE(2),
    COMMAND(3),
    PAUSE(10),
    UNPAUSE(11),
    MUTE(12),
    UNMUTE(13),
    RESET_SID(14),
    DISABLE_SID(15),
    ENABLE_SID(16),
    CLEAR_BUS(17),
    CONFIG(18),
    RESET_MCU(19),
    BOOTLOADER(20);

    private byte cmd;
    private static final Map<Byte, Cmd> lookup;

    private Cmd(byte cmd) {
        this.cmd = cmd;
    }

    public byte get() {
        return this.cmd;
    }

    public static Cmd getCommand(byte cmd) {
        return lookup.get(cmd);
    }

    static {
        lookup = Collections.unmodifiableMap(Arrays.asList(Cmd.values()).stream().collect(Collectors.toMap(Cmd::get, Function.identity())));
    }
}

