/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.compiletime;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import libsidplay.common.VICChipModel;
import libsidplay.components.mos656x.Palette;
import org.teavm.metaprogramming.CompileTime;
import org.teavm.metaprogramming.Meta;
import org.teavm.metaprogramming.Metaprogramming;
import org.teavm.metaprogramming.Value;
import sidplay.ini.IniDefaults;

@CompileTime
public class PaletteTeaVM {
    protected static final String COMBINED_LINES_EVEN = "COMBINED_LINES_EVEN";
    protected static final String COMBINED_LINES_ODD = "COMBINED_LINES_ODD";
    protected static final String LINE_PALETTE_EVEN = "LINE_PALETTE_EVEN";
    protected static final String LINE_PALETTE_ODD = "LINE_PALETTE_ODD";

    @Meta
    public static native Map<String, String> getPalette(boolean var0);

    private static void getPalette(Value<Boolean> b) {
        Palette palette = new Palette();
        palette.setBrightness(IniDefaults.DEFAULT_BRIGHTNESS);
        palette.setContrast(IniDefaults.DEFAULT_CONTRAST);
        palette.setGamma(IniDefaults.DEFAULT_GAMMA);
        palette.setSaturation(IniDefaults.DEFAULT_SATURATION);
        palette.setPhaseShift(IniDefaults.DEFAULT_PHASE_SHIFT);
        palette.setOffset(IniDefaults.DEFAULT_OFFSET);
        palette.setTint(IniDefaults.DEFAULT_TINT);
        palette.setLuminanceC(IniDefaults.DEFAULT_BLUR);
        palette.setDotCreep(IniDefaults.DEFAULT_BLEED);
        palette.calculatePalette(Palette.buildPaletteVariant(VICChipModel.MOS6567R8));
        String combinedLinesEven = IntStream.of(palette.getEvenLines()).mapToObj(i -> String.format("%X", i)).collect(Collectors.joining(","));
        String combinedLinesOdd = IntStream.of(palette.getOddLines()).mapToObj(i -> String.format("%X", i)).collect(Collectors.joining(","));
        String linePaletteEven = new String(Base64.getEncoder().encode(palette.getEvenFiltered()), StandardCharsets.US_ASCII);
        String linePaletteOdd = new String(Base64.getEncoder().encode(palette.getOddFiltered()), StandardCharsets.US_ASCII);
        Value result = Metaprogramming.emit(() -> new HashMap());
        Value combinedLinesEvenValue = Metaprogramming.emit(() -> combinedLinesEven);
        Value combinedLinesOddValue = Metaprogramming.emit(() -> combinedLinesOdd);
        Value linePaletteEvenValue = Metaprogramming.emit(() -> linePaletteEven);
        Value linePaletteOddValue = Metaprogramming.emit(() -> linePaletteOdd);
        Metaprogramming.emit(() -> ((Map)result.get()).put(COMBINED_LINES_EVEN, (String)combinedLinesEvenValue.get()));
        Metaprogramming.emit(() -> ((Map)result.get()).put(COMBINED_LINES_ODD, (String)combinedLinesOddValue.get()));
        Metaprogramming.emit(() -> ((Map)result.get()).put(LINE_PALETTE_EVEN, (String)linePaletteEvenValue.get()));
        Metaprogramming.emit(() -> ((Map)result.get()).put(LINE_PALETTE_ODD, (String)linePaletteOddValue.get()));
        Metaprogramming.exit(() -> result.get());
    }
}

