/*
 * Decompiled with CFR 0.152.
 */
package ui.favorites;

import java.util.Objects;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import sidplay.Player;
import ui.JSidPlay2Main;
import ui.entities.collection.HVSCEntry;
import ui.musiccollection.SearchCriteria;

public class FavoritesCellFactory
implements Callback<TableColumn<HVSCEntry, ?>, TableCell<HVSCEntry, ?>> {
    private static final Image STIL_ICON = new Image(JSidPlay2Main.class.getResource("icons/stil.png").toString());
    private static final Image NO_STIL_ICON = new Image(JSidPlay2Main.class.getResource("icons/stil_no.png").toString());
    private static final String CURRENTLY_PLAYED_FILE_ROW = "currentlyPlayedRow";
    private Player player;
    private ObjectProperty<HVSCEntry> currentlyPlayedHVSCEntryProperty;

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void setCurrentlyPlayedHVSCEntryProperty(ObjectProperty<HVSCEntry> currentlyPlayedHVSCEntryProperty) {
        this.currentlyPlayedHVSCEntryProperty = currentlyPlayedHVSCEntryProperty;
    }

    public TableCell<HVSCEntry, ?> call(TableColumn<HVSCEntry, ?> column) {
        return new TableCellImpl();
    }

    protected final class TableCellImpl
    extends TableCell<HVSCEntry, Object> {
        private ChangeListener<HVSCEntry> listener = (observable, oldValue, newValue) -> this.setCellStyle();

        public TableCellImpl() {
            FavoritesCellFactory.this.currentlyPlayedHVSCEntryProperty.addListener((ChangeListener)new WeakChangeListener(this.listener));
        }

        protected void updateItem(Object value, boolean empty) {
            super.updateItem(value, empty);
            if (!empty && value != null) {
                this.setText(SearchCriteria.getText(value));
                if (this.getTableView().getColumns().indexOf((Object)this.getTableColumn()) == 0) {
                    if (FavoritesCellFactory.this.player.getStilEntry(this.getPath()) != null) {
                        this.setGraphic((Node)new ImageView(STIL_ICON));
                    } else {
                        this.setGraphic((Node)new ImageView(NO_STIL_ICON));
                    }
                }
            } else {
                this.setText(null);
                this.setGraphic(null);
            }
            this.setCellStyle();
        }

        private String getPath() {
            HVSCEntry hvscEntry = this.getHVSCEntry();
            return hvscEntry != null ? hvscEntry.getPath() : null;
        }

        private HVSCEntry getHVSCEntry() {
            if (this.getTableRow() != null && this.getTableRow().getItem() instanceof HVSCEntry) {
                return (HVSCEntry)this.getTableRow().getItem();
            }
            return null;
        }

        private void setCellStyle() {
            this.getStyleClass().remove((Object)FavoritesCellFactory.CURRENTLY_PLAYED_FILE_ROW);
            if (!this.isEmpty() && Objects.equals(FavoritesCellFactory.this.currentlyPlayedHVSCEntryProperty.get(), this.getHVSCEntry())) {
                this.getStyleClass().add((Object)FavoritesCellFactory.CURRENTLY_PLAYED_FILE_ROW);
            }
        }
    }
}

