/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio.xuggle;

import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IError;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.video.ArgbConverter;
import com.xuggle.xuggler.video.ConverterFactory;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;

public class XuggleBase {
    private static final int FONT_SIZE = 8;
    protected static final Font c64Font;

    protected final int throwExceptionOnError(int rc, String message) {
        if (rc < 0) {
            System.err.println(message);
        }
        return this.throwExceptionOnError(rc);
    }

    protected final int throwExceptionOnError(int rc) {
        if (rc < 0) {
            throw new RuntimeException(IError.make((int)rc).getDescription());
        }
        return rc;
    }

    static {
        try {
            InputStream fontStream = XuggleBase.class.getResourceAsStream("/libsidutils/C64_Elite_Mono_v1.0-STYLE.ttf");
            if (fontStream == null) {
                throw new IOException("Font not found: /libsidutils/C64_Elite_Mono_v1.0-STYLE.ttf");
            }
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            c64Font = Font.createFont(0, fontStream).deriveFont(8.0f);
            graphicsEnvironment.registerFont(c64Font);
            ConverterFactory.registerConverter((ConverterFactory.Type)new ConverterFactory.Type("XUGGLER-ARGB-32", ArgbConverter.class, IPixelFormat.Type.ARGB, 2));
        }
        catch (FontFormatException | IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public static class VideoInfo {
        private long duration;
        private int sampleRate;
        private int channels;
        private int width;
        private int height;
        private double frameRate;

        public VideoInfo(IContainer container, IStreamCoder audioCoder, IStreamCoder videoCoder) {
            this.duration = container.getDuration();
            if (audioCoder != null) {
                this.sampleRate = audioCoder.getSampleRate();
                this.channels = audioCoder.getChannels();
            }
            if (videoCoder != null) {
                this.width = videoCoder.getWidth();
                this.height = videoCoder.getHeight();
                this.frameRate = videoCoder.getFrameRate().getValue();
            }
        }

        public long getDuration() {
            return this.duration;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public int getChannels() {
            return this.channels;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public double getFrameRate() {
            return this.frameRate;
        }
    }
}

