/*
 * Decompiled with CFR 0.152.
 */
package jsidplay2.dirs;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SidDirs {
    private static Map<String, byte[]> dirs2imageData = new HashMap<String, byte[]>();
    private static final Properties SID_DIRS = new Properties();
    private static final String UNKNOWN = "UNKNOWN";

    public static final byte[] getDirectoryImageData(String string) {
        return dirs2imageData.get(string);
    }

    public static final byte[] getUnknownImageData() {
        return dirs2imageData.get(UNKNOWN);
    }

    static {
        try (InputStream inputStream = SidDirs.class.getResourceAsStream("photodirs.properties");){
            SID_DIRS.load(inputStream);
            for (String string : SID_DIRS.keySet()) {
                String string2 = SID_DIRS.getProperty(string);
                if (string2 == null) continue;
                URL uRL = SidDirs.class.getResource(string2);
                byte[] byArray = new byte[uRL.openConnection().getContentLength()];
                DataInputStream dataInputStream = new DataInputStream(SidDirs.class.getResourceAsStream(string2));
                Throwable throwable = null;
                try {
                    dataInputStream.readFully(byArray);
                    dirs2imageData.put(string, byArray);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dataInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dataInputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            throw new ExceptionInInitializerError(iOException);
        }
    }
}

