/*
 * Decompiled with CFR 0.152.
 */
package kickass.state.scope.symboltable;

import java.util.ArrayList;
import java.util.List;
import kickass.pass.valueholder.IValueHolder;
import kickass.state.ScopePosition;
import kickass.state.scope.symboltable.ISymbolInitializer;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.ISymbolTable;
import kickass.state.scope.symboltable.SymbolStatus;

public class SymbolTable
implements ISymbolTable {
    private List<ISymbolInitializer> symbolInitializers = new ArrayList<ISymbolInitializer>();
    private IValueHolder[] currentPage;

    @Override
    public ISymbolPageIdx addValue(ISymbolInitializer iSymbolInitializer, ScopePosition scopePosition) {
        this.symbolInitializers.add(iSymbolInitializer);
        return new SymbolPageIndex(this.symbolInitializers.size() - 1, scopePosition);
    }

    @Override
    public IValueHolder[] createPage() {
        IValueHolder[] iValueHolderArray = new IValueHolder[this.symbolInitializers.size()];
        int n = this.symbolInitializers.size();
        for (int i = 0; i < n; ++i) {
            iValueHolderArray[i] = this.symbolInitializers.get(i).init(iValueHolderArray);
        }
        return iValueHolderArray;
    }

    @Override
    public void setCurrentPage(IValueHolder[] iValueHolderArray) {
        if (iValueHolderArray != null && iValueHolderArray.length != this.symbolInitializers.size()) {
            throw new RuntimeException("invalid symbolpagelenght!");
        }
        this.currentPage = iValueHolderArray;
    }

    @Override
    public IValueHolder[] getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public IValueHolder[] replaceCurrentPage(IValueHolder[] iValueHolderArray) {
        IValueHolder[] iValueHolderArray2 = this.currentPage;
        this.currentPage = iValueHolderArray;
        return iValueHolderArray2;
    }

    private class SymbolPageIndex
    implements ISymbolPageIdx {
        private int idx;
        private SymbolStatus symbolStatus = SymbolStatus.undefined;
        private ScopePosition scopePosition;
        private boolean isScopeExposed;

        public SymbolPageIndex(int n, ScopePosition scopePosition) {
            this.idx = n;
            this.scopePosition = scopePosition;
        }

        @Override
        public ISymbolTable getSymbolTable() {
            return SymbolTable.this;
        }

        @Override
        public SymbolStatus getStatus() {
            return this.symbolStatus;
        }

        @Override
        public ISymbolPageIdx setStatus(SymbolStatus symbolStatus) {
            this.symbolStatus = symbolStatus;
            return this;
        }

        @Override
        public ScopePosition getScopePosition() {
            return this.scopePosition;
        }

        @Override
        public ISymbolPageIdx replaceInitializer(ISymbolInitializer iSymbolInitializer) {
            SymbolTable.this.symbolInitializers.set(this.idx, iSymbolInitializer);
            return this;
        }

        @Override
        public ISymbolPageIdx setIsScopeExposed(boolean bl) {
            this.isScopeExposed = bl;
            return this;
        }

        @Override
        public boolean isScopeExposed() {
            return this.isScopeExposed;
        }

        @Override
        public IValueHolder getValueHolder() {
            return SymbolTable.this.currentPage[this.idx];
        }

        @Override
        public IValueHolder getValueHolder(IValueHolder[] iValueHolderArray) {
            return iValueHolderArray[this.idx];
        }
    }
}

