/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.cio.Entry;
import net.java.truecommons.shed.BitField;
import net.java.truevfs.kernel.spec.FsAbstractNode;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsArchiveEntry;

@NotThreadSafe
public final class FsCovariantNode<E extends FsArchiveEntry>
extends FsAbstractNode
implements Cloneable {
    private final String name;
    private EnumMap<Entry.Type, E> map = new EnumMap(Entry.Type.class);
    @Nullable
    private Entry.Type key;
    @Nullable
    private LinkedHashSet<String> members;

    public FsCovariantNode(String path) {
        this.name = path.toString();
    }

    public FsCovariantNode<E> clone(FsArchiveDriver<E> driver) {
        FsCovariantNode clone;
        try {
            clone = (FsCovariantNode)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
        clone.map = new EnumMap<Entry.Type, E>(Entry.Type.class);
        EnumMap<Entry.Type, E> cloneMap = clone.map;
        for (Map.Entry<Entry.Type, E> mapping : this.map.entrySet()) {
            FsArchiveEntry entry = (FsArchiveEntry)mapping.getValue();
            cloneMap.put(mapping.getKey(), driver.newEntry(entry.getName(), entry.getType(), (Entry)entry));
        }
        LinkedHashSet<String> members = this.members;
        if (null != members) {
            clone.members = (LinkedHashSet)members.clone();
        }
        return clone;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public boolean isRoot() {
        return this.name.isEmpty();
    }

    @Nullable
    public Entry.Type getKey() {
        return this.key;
    }

    public void setKey(@Nullable Entry.Type key) {
        this.key = key;
    }

    @Nullable
    public E put(Entry.Type type, E entry) {
        this.key = type;
        return (E)((FsArchiveEntry)this.map.put(this.key, entry));
    }

    @Nullable
    public E remove(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.remove(type));
    }

    @Nullable
    public E get(Entry.Type type) {
        return (E)((FsArchiveEntry)this.map.get(type));
    }

    @Nullable
    public E getEntry() {
        return (E)((FsArchiveEntry)this.map.get(this.key));
    }

    public Collection<E> getEntries() {
        return this.map.values();
    }

    @Override
    public BitField<Entry.Type> getTypes() {
        return BitField.copyOf(this.map.keySet());
    }

    @Override
    public boolean isType(Entry.Type type) {
        return this.map.containsKey(type);
    }

    public long getSize(Entry.Size type) {
        return Entry.Type.DIRECTORY == this.key ? -1L : ((FsArchiveEntry)this.map.get(this.key)).getSize(type);
    }

    public long getTime(Entry.Access type) {
        return ((FsArchiveEntry)this.map.get(this.key)).getTime(type);
    }

    public Boolean isPermitted(Entry.Access type, Entry.Entity entity) {
        return ((FsArchiveEntry)this.map.get(this.key)).isPermitted(type, entity);
    }

    @Override
    @Nullable
    public Set<String> getMembers() {
        if (!this.isType(Entry.Type.DIRECTORY)) {
            this.members = null;
            return null;
        }
        LinkedHashSet<String> m = this.members;
        return null != m ? m : (this.members = new LinkedHashSet());
    }

    public boolean add(String member) {
        return this.getMembers().add(member);
    }

    public boolean remove(String member) {
        return this.getMembers().remove(member);
    }
}

